/*****************************************************************************
*   "Gif-Lib" - Yet another gif library.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.1, Jun. 1991   *
******************************************************************************
*****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <allegro.h>

#include "libgif/gif_lib.h"







/******************************************************************************
* Interpret the command line and scan the given GIF file.		      *
******************************************************************************/
int main(int argc, char **argv)
{
    int              Width, Height;
    GifFileType     *gif;
    int             ExpNumOfColors = 8,  ColorMapSize = 256;
    BITMAP          *pspr1,*pspr2,*pspr3,*pspr4,*pspr5;
    PALETTE         palette;



    allegro_init();
    install_keyboard();
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320,200, 0, 0) != 0) {
        allegro_message("Unable to set graphic mode\n%s\n", allegro_error);
        exit(-1);
    }



    ExpNumOfColors = 8;
    ColorMapSize = 256;
    pspr2 = load_bitmap( "cat2.pcx", (RGB *)&palette );    if(pspr2==NULL) exit(-1);
    pspr3 = load_bitmap( "cat3.pcx", (RGB *)&palette );    if(pspr3==NULL) exit(-1);
    pspr4 = load_bitmap( "cat4.pcx", (RGB *)&palette );    if(pspr4==NULL) exit(-1);
    pspr5 = load_bitmap( "cat5.pcx", (RGB *)&palette );    if(pspr5==NULL) exit(-1);
    pspr1 = load_bitmap( "cat1.pcx", (RGB *)&palette );    if(pspr1==NULL) exit(-1);
    Width  = pspr1->w;
    Height = pspr1->h;
    gif = gif_opensave("test.gif", ExpNumOfColors, Width, Height, ColorMapSize, (RGB *)&palette );
    gif_save( gif,  Width, Height, pspr1 );
    gif_save( gif,  Width, Height, pspr2 );
    gif_save( gif,  Width, Height, pspr3 );
    gif_save( gif,  Width, Height, pspr4 );
    gif_save( gif,  Width, Height, pspr5 );
    gif_saveclose( gif );
    return 0;





    gif = gif_openload("test.gif");
    for(;;){
    pspr1 = gif_load( gif, (RGB *)&palette );
    if( pspr1==NULL ) break;
    set_palette( (RGB *)&palette );
    blit( pspr1, screen, 0,0,0,0, pspr1->w, pspr1->h );
readkey();
    }
    gif_loadclose( gif );



    return 0;
}


END_OF_MAIN();





