/*
STANDARD.H  Custom header file that provides commonly used equates
*/
#ifndef _STANDARD_DEFSGBM_HH_
#define _STANDARD_DEFSGBM_HH_



/** system defines **/
#ifndef BOOLEAN
typedef int BOOLEAN;
#endif
#ifndef TRUE
#define TRUE -1
#define FALSE 0
#endif
/** system defines **/

#include "gbmerr.h"


#ifndef min
 #define min(a,b)    (((a)<(b))?(a):(b))
#endif
#ifndef low_byte
 #define low_byte(w) ((byte)  ((w)&0x00ff)    )
#endif
#ifndef high_byte
 #define high_byte(w)    ((byte) (((w)&0xff00)>>8))
#endif
#ifndef make_word
 #define make_word(a,b)  (((word)a) + (((word)b) << 8))
#endif
#ifndef make_short
 #define make_short(b1,b2) ( ((short)(b1)<<8) | (short)(b2) )
#endif
#ifndef make_long
 #define make_long(b1,b2,b3,b4) ( ((long)(b1)<<24) | ((long)(b2)<<16) | ((long)(b3)<<8) | (long)(b4) )
#endif
#ifndef MAX_STRING
 #define MAX_STRING  32       /* Just to prevent huge strings */
 #define MAX_STRINGS 32768    /* Small enough for 16 bit */
 #define MAX_HASH    8192     /* Prime, and much > 4096 */
#endif
#ifndef SEEK_SET
 #define SEEK_SET 0
 #define SEEK_CUR 1
 #define SEEK_END 2
#endif









#endif
