/*

GBMPPM.C  Poskanzers PPM format

Reads and writes 24 bit RGB.

*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "standard.h"
#include "dxegbm.h"
#define GBM_ERR_PPM_BAD_M   ((GBM_ERR) 200)

static GBMFT dxe_gbmft =
	{
	"Pixmap",
	"Portable Pixel-map (binary P6 type)",
	"PPM",
	GBM_FT_R24|
	GBM_FT_W24,
	};

/* helper functions */
/* helper functions */


typedef struct HDRtag {
unsigned char t1,t2;    /* Px type, P1,P4 */
int w;              /* width    */
int h;              /* height */
int m;              /* palette offsets */
int offset;         /* file offset after header */
}HDR;
HDR HEADER;







static byte read_byte(int fd)
	{
	byte	b = 0;
    u_read(fd, (byte *)&b, 1);
    return ( b );
	}
static char read_char(int fd)
	{
	char	c;
    while ( (c = read_byte(fd)) == '#' )      /* Discard to end of line */
        while ( (c = read_byte(fd)) != '\n' )   {;}
	return ( c );
	}
static int read_num(int fd)
	{
    char  c;
	int	num;
    while ( isspace(c = read_char(fd)) )    {}
	num = c - '0';
    while ( isdigit(c = read_char(fd)) )    num = num * 10 + (c - '0');
	return ( num );
	}
static void read_posk_header( int fd )
	{
    u_lseek(fd, 0L, SEEK_SET);
    HEADER.t1 = read_byte(fd);
    HEADER.t2 = read_byte(fd);
    HEADER.w  = read_num(fd);
    HEADER.h  = read_num(fd);
    HEADER.m  = read_num(fd);
    HEADER.offset = u_lseek(fd, 0L, SEEK_CUR);
    }

static void rgb_bgr(byte *p, byte *q, int n)
	{
	while ( n-- )
		{
		byte	r = *p++;
		byte	g = *p++;
		byte	b = *p++;
        *q++ = b;
		*q++ = g;
		*q++ = r;
		}
	}

DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft)
	{
    *gbmft = dxe_gbmft;
	return ( GBM_ERR_OK );
	}

static  char flag=0;
                           /* read unbuffered */
DLLEXPORT GBM_ERR dxe_rhdr(char *fn, int fd, GBM *gbm, char *opt)
	{
    fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */
    read_posk_header(fd);
    if ( HEADER.t1 == 'P' && HEADER.t2 == '6' ) flag=1;  /* binary */
    if ( HEADER.t1 == 'P' && HEADER.t2 == '3' ) flag=2;  /* ascii */
    if(flag==0)  return ( GBM_ERR_BAD_MAGIC );
    if ( HEADER.w <= 0 || HEADER.h <= 0 ) return ( GBM_ERR_BAD_SIZE );
    if ( HEADER.m <= 1 || HEADER.m >= 0x100 ) return ( GBM_ERR_PPM_BAD_M );
    gbm -> w   = HEADER.w;
    gbm -> h   = HEADER.h;
	gbm -> bpp = 24;
    return ( GBM_ERR_OK );
	}

DLLEXPORT GBM_ERR dxe_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
	{
	fd=fd; gbm=gbm; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */
    return ( GBM_ERR_OK );
	}

DLLEXPORT char *dxe_err(GBM_ERR rc)
	{
	switch ( (int) rc )
		{
		case GBM_ERR_PPM_BAD_M:
			return ( "bad maximum pixel intensity" );
		}
	return ( NULL );
	}






DLLEXPORT GBM_ERR dxe_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
	{
	char	s [100+1];
	int	i, stride;
	byte	*p, *linebuf;
    fn=fn; gbmrgb=gbmrgb; opt=opt; /* Suppress 'unref arg' compiler warnings */
    if ( gbm -> bpp != 24 ) return ( GBM_ERR_NOT_SUPP );
    if ( (linebuf = (byte *) u_malloc(gbm->w * 3)) == NULL ) return ( GBM_ERR_MEM );
    u_lseek(fd, 0L, SEEK_SET);
    sprintf(s,"P6\n# Written by Generalised Bitmap Module\n%d %d 255\n",
		gbm -> w, gbm -> h);
    u_write(fd, s, strlen(s));

    stride = ((gbm->w * 3 + 3) & ~3);
    p = data;

    for ( i = 0; i < ((gbm->h)-1) ; i++ )
		{
        rgb_bgr(p, linebuf, gbm->w );
        u_write(fd, linebuf, gbm->w * 3);
        p += stride;
		}

    u_free(linebuf);
    return ( GBM_ERR_OK );
	}


DLLEXPORT GBM_ERR dxe_rdata(int fd, GBM *gbm, byte *data)
	{
    int     i,j,k,x,y, stride;
    byte    *p, *t, c, ru,gu,bu;


    stride = ((gbm->w * 3 + 3) & ~3);
    p = t = data;
    if(flag==0) return ( GBM_ERR_BAD_MAGIC );
    u_lseek( fd, (long) HEADER.offset, SEEK_SET );





    if(flag==2){  // ascii
        for ( y = j = 0 ; y < gbm->h ; y++ ){
        for ( x = 0     ; x < gbm->w*3 ; x +=3 ){
        k = read_num( fd ); ru = k & 255;
        k = read_num( fd ); gu = k & 255;
        k = read_num( fd ); bu = k & 255;
        p[ y * stride + x+0 ] = bu;
        p[ y * stride + x+1 ] = gu;
        p[ y * stride + x+2 ] = ru;
        }
        }
    }




    if(flag==1){  // binary
    for ( i = 0; i < ((gbm->h)-1) ; i++ )
		{
        u_read(fd, p, stride);
        rgb_bgr(p, p, gbm->w );
        p += stride;
		}
    }



    return ( GBM_ERR_OK );
	}

