/*

GBMPGM.C  Poskanzers PGM format

Reads as 8 bit grey image.
Writes grey equivelent of passed in 8 bit colour data (no palette written).
Output options: r,g,b,k (default: k)



*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "standard.h"
#include "dxegbm.h"


#define SW4(a,b,c,d)    ((a)*8+(b)*4+(c)*2+(d))
#define GBM_ERR_PGM_BAD_M   ((GBM_ERR) 100)

static GBMFT dxe_gbmft =
	{
	"Greymap",
	"Portable Greyscale-map (binary P5 type)",
	"PGM",
	GBM_FT_R8|
	GBM_FT_W8,
	};

/* helper functions */
/* helper functions */

typedef struct HDRtag {
unsigned char t1,t2;    /* Px type, P1,P4 */
int w;              /* width    */
int h;              /* height */
int m;              /* palette offsets */
int offset;         /* file offset after header */
}HDR;
HDR HEADER;




static BOOLEAN make_output_palette(GBMRGB gbmrgb [], byte grey [], char *opt)
	{
    BOOLEAN k = ( u_find_word(opt, "k") != NULL );
    BOOLEAN r = ( u_find_word(opt, "r") != NULL );
    BOOLEAN g = ( u_find_word(opt, "g") != NULL );
    BOOLEAN b = ( u_find_word(opt, "b") != NULL );
	int	i;
    switch ( SW4(k,r,g,b) )
		{
		case SW4(0,0,0,0):
			/* Default is the same as "k" */
		case SW4(1,0,0,0):
			for ( i = 0; i < 0x100; i++ )
				grey [i] = (byte) ( ((word) gbmrgb [i].r *  77 +
						     (word) gbmrgb [i].g * 151 +
						     (word) gbmrgb [i].b *  28) >> 8 );
			return ( TRUE );
		case SW4(0,1,0,0):
			for ( i = 0; i < 0x100; i++ )
				grey [i] = gbmrgb [i].r;
			return ( TRUE );
		case SW4(0,0,1,0):
			for ( i = 0; i < 0x100; i++ )
				grey [i] = gbmrgb [i].g;
			return ( TRUE );
		case SW4(0,0,0,1):
			for ( i = 0; i < 0x100; i++ )
				grey [i] = gbmrgb [i].b;
			return ( TRUE );
		}
	return ( FALSE );
	}


static byte read_byte(int fd)
	{
	byte	b = 0;
    u_read(fd, (byte *) &b, 1);
	return ( b );
	}
static char read_char(int fd)
	{
	char	c;
    while ( (c = read_byte(fd)) == '#' )      /* Discard to end of line */
        while ( (c = read_byte(fd)) != '\n' )   {;}
	return ( c );
	}
static int read_num(int fd)
	{
    char  c=0;
    int   num=0;

    while ( isspace(c = read_char(fd)) )    {}
	num = c - '0';
    while ( isdigit(c = read_char(fd)) )    num = num * 10 + (c - '0');
	return ( num );
	}
static void read_posk_header( int fd )
	{
    u_lseek(fd, 0L, SEEK_SET); // printf("1. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.t1 = read_byte(fd); // printf("2. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.t2 = read_byte(fd); // printf("3. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.w  = read_num(fd);  // printf("4. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.h  = read_num(fd);  // printf("5. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.m  = read_num(fd);  // printf("6. offset: %d\n", u_lseek(fd, 0L, SEEK_CUR) );
    HEADER.offset = u_lseek(fd, 0L, SEEK_CUR);
    }


DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft)
	{
    *gbmft = dxe_gbmft;
	return ( GBM_ERR_OK );
	}

static  char flag = 0;

DLLEXPORT GBM_ERR dxe_rhdr(char *fn, int fd, GBM *gbm, char *opt)
	{

    read_posk_header(fd);
    flag = 0;
    if ( HEADER.t1 == 'P' && HEADER.t2 == '5' ) flag=1;  /* binary */
    if ( HEADER.t1 == 'P' && HEADER.t2 == '2' ) flag=2;  /* ascii */
    if(flag==0) return ( GBM_ERR_BAD_MAGIC );
    if ( HEADER.w <= 0 || HEADER.h <= 0 ) return ( GBM_ERR_BAD_SIZE );
    if ( HEADER.m <= 1 || HEADER.m >= 0x100 ) return ( GBM_ERR_PGM_BAD_M );
    gbm -> w   = HEADER.w;
    gbm -> h   = HEADER.h;
	gbm -> bpp = 8;
    return ( GBM_ERR_OK );
	}

DLLEXPORT GBM_ERR dxe_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
	{
    int  i;
    gbm=gbm; /* Suppress 'unref arg' compiler warning */

    for ( i = 0; i < HEADER.m; i++ )
        gbmrgb [i].r = \
        gbmrgb [i].g = \
        gbmrgb [i].b = (byte) (i * 0xff / (HEADER.m - 1));
    return ( GBM_ERR_OK );
	}

DLLEXPORT GBM_ERR dxe_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
	{
	char	s [100+1];
	int	i, j, stride;
	byte	grey [0x100];
	byte	*p, *linebuf;
    fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */
    if ( gbm -> bpp != 8 ) return ( GBM_ERR_NOT_SUPP );
    if ( !make_output_palette(gbmrgb, grey, opt) ) return ( GBM_ERR_BAD_OPTION );
    if ( (linebuf = (byte *) u_malloc(gbm -> w)) == NULL ) return ( GBM_ERR_MEM );
    u_lseek(fd, 0L, SEEK_SET);
    sprintf(s,"P5\n# Written by Generalised Bitmap Module\n%d %d 255\n",
		gbm -> w, gbm -> h);
    u_write(fd, s, strlen(s));
    stride = ((gbm -> w + 3) & ~3);
    p = data;
    for ( i = 0 ; i< ((gbm->h)-1) ; i++ )
		{
        for ( j = 0; j < gbm->w; j++ ) linebuf [j] = grey [p [j]];
        u_write(fd, linebuf, gbm->w);
        p += stride;
		}
    u_free(linebuf);
    return ( GBM_ERR_OK );
	}
DLLEXPORT char *dxe_err(GBM_ERR rc)
	{
	switch ( (int) rc )
		{
		case GBM_ERR_PGM_BAD_M:
			return ( "bad maximum pixel intensity" );
		}
	return ( NULL );
	}

DLLEXPORT GBM_ERR dxe_rdata(int fd, GBM *gbm, byte *data)
	{
    int     i,j,k,x,y, stride;
    byte    *p, c;


    stride = ((gbm->w + 3) & ~3);
    p      = data;
    if(flag==0) return ( GBM_ERR_BAD_MAGIC );


    u_lseek( fd, (long) HEADER.offset, SEEK_SET );


    if(flag==2){  // ascii

        for ( y = j = 0 ; y < gbm->h ; y++ ){
        for ( x = 0     ; x < gbm->w ; x++ ){
        k = read_num( fd );
        c = k & 255;
        p[ y * stride + x ] = c;
        }
        }
    }



    if(flag==1){  // binary
    for ( i = 0; i < ((gbm->h)-1) ; i++ )
		{
        u_read(fd, p, gbm->w);
        p += stride;
		}
    }






    return ( GBM_ERR_OK );
	}


