/*

GBM.H  General Bitmap Code

Data is stored as an array of lines.
Lines are stored with top line first, moving downwards.
Each line is an array of pixels, leftmost first.
Lines are padded to be a multiple of a dword long.
Palettised pixels are either a 1 bit, 4 bit, or 8 bit indexes.
Alternately a  B, G, R triple in that order is stored.

One notable point: a 1 in a 1bpp image denotes colour 1, as found by
looking at palette entry 1. Data is not inverse when passed to and from GBM.
*/



#include "standard.h"

#ifndef _GBMINIT_HH_
#define _GBMINIT_HH_

GBM_ERR gbm_init(void);
GBM_ERR gbm_deinit(void);
GBM_ERR gbm_query_n_filetypes(int *n_ft);
GBM_ERR gbm_query_filetype(int ft, GBMFT *gbmft);
GBM_ERR gbm_guess_filetype(char *fn, int *ft);
GBM_ERR gbm_read_header(char *fn, int fd, int ft, GBM *gbm, char *opt);
GBM_ERR gbm_read_palette(int fd, int ft, GBM *gbm, GBMRGB *gbmrgb);
GBM_ERR gbm_read_data(int fd, int ft, GBM *gbm, byte *data);
GBM_ERR gbm_write(char *fn, int fd, int ft, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
char    *gbm_err(GBM_ERR rc);

#endif
