
#ifndef _DXEGBM_HH_
#define _DXEGBM_HH_


#include "standard.h"


/*
 BMP.H  OS/2 1.1, 1.2, 2.0 and Windows 3.0 support
 CEL.H  Kisekae cel 16 colors.
 GIF.H  Graphics Interchange Format support
 LBM.H  Amiga IFF / ILBM file format
 PCX.H  ZSoft PC Paintbrush support
 PBM.H  Poskanzers PBM format
 PGM.H  Poskancers PGM format
 PPM.H  Poskancers PPM format, Reads and writes 24 bit RGB.
 TGA.H  Truevision Targa/Vista support
 XBM.H  X Windows bitmap support
*/

#define DLLEXPORT __declspec(dllexport)


DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft);
DLLEXPORT GBM_ERR dxe_rhdr(char *fn, int fd, GBM *gbm, char *opt);
DLLEXPORT GBM_ERR dxe_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb);
DLLEXPORT GBM_ERR dxe_rdata(int fd, GBM *gbm, byte *data);
DLLEXPORT GBM_ERR dxe_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
DLLEXPORT char *dxe_err(GBM_ERR rc);
DLLEXPORT void dxe_fixaddress();




AHEAD *(* u_create_ahead)(int fd);
void (* u_destroy_ahead)(AHEAD *ahead);
byte (* u_next)(AHEAD *ahead);

int (* u_open)(char *filename, char *type);
int (* u_read)(int fd, void *_ptr, int size);
int (* u_write)(int fd, void *_ptr, int size);
int  (* u_lseek)(int fd, long offset, int origin);
void (* u_close)(int fd);
void *(* u_malloc)(int size);
void (* u_free)(void *ptr);
BOOLEAN (* u_same)(char *s1, char *s2, int n);
char *(* u_find_word)(char *str, char *substr);
char *(* u_find_word_prefix)(char *str, char *substr);


DLLEXPORT void dxe_import1(
    void *i_create_ahead,
    void *i_destroy_ahead,
    void *i_next,
    void *i_open,
    void *i_read,
    void *i_write,
    void *i_lseek,
    void *i_close,
    void *i_malloc,
    void *i_free,
    void *i_same,
    void *i_find_word,
    void *i_find_word_prefix )
{
    u_create_ahead     = i_create_ahead;
    u_destroy_ahead    = i_destroy_ahead;
    u_next             = i_next;
    u_open             = i_open;
    u_read             = i_read;
    u_write            = i_write;
    u_lseek            = i_lseek;
    u_close            = i_close;
    u_malloc           = i_malloc;
    u_free             = i_free;
    u_same             = i_same;
    u_find_word        = i_find_word;
    u_find_word_prefix = i_find_word_prefix;
}


#endif
