/*

GBMCEL.C Kisekae cel 16 colors.

*/

/* for NULL  */
#include <stdio.h>
#include "standard.h"
#include "dxegbm.h"


typedef struct HDRtag {
int w;              /* width    */
int h;              /* height */
char type;          /* 0=old CEL type, 1=new CEL type */
int bpp;            /* bits per pixel, 4 or 8. */
}HDR;
HDR HEADER;
/*
    CEL FILE (.CEL) FORMAT

    offset  contents
	------	--------
	+0	width  (16 bits, little endian, <= 640)
	+2	height (16 bits, little endian, <= 400)
	+4~	image data

	image data format:
	Each nibble(4 bits) represents one pixel.
	If the width is an odd number an additional pixel of color #0 is 
	appended at the rightmost.
*/

static GBMFT dxe_gbmft =
	{
    "Kiss CEL",
    "Kisekae CEL by K.O.S.",
    "CEL",
    GBM_FT_R4 | GBM_FT_R8|\
    GBM_FT_W4 | GBM_FT_W8,
	};

DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft)
	{
    *gbmft = dxe_gbmft;
	return ( GBM_ERR_OK );
	}


DLLEXPORT GBM_ERR dxe_rhdr(char *fn, int fd, GBM *gbm, char *opt)
	{
    int   id,id1,id2; /* int must be 32 bits here */
    unsigned char  mark;
    unsigned short trash;

    fn=fn; opt=opt; /* Suppress 'unref arg' compiler warnings */

/*
    CEL FILE (.CEL) FORMAT
    offset  contents
	------	--------
	+0	width  (16 bits, little endian, <= 640)
	+2	height (16 bits, little endian, <= 400)
	+4~	image data

	image data format:
	Each nibble(4 bits) represents one pixel.
	If the width is an odd number an additional pixel of color #0 is 
	appended at the rightmost.

*NEW*
       Cel files have a 32-byte header.
offset  size    contents
+0      4B      Identifier 'KiSS' ( 4Bh 69h 53h 53h )
+4      B       Cel file mark ( 20h )
+5      B       bits per pixel ( 4 or 8 )
+6      W       Reserved
+8      W(L,H)  Width ( 1 ... XMAX )
+10     W(L,H)  Height ( 1 ... YMAX )
+12     W(L,H)  x-offset ( 0 ... XMAX-1 )
+14     W(L,H)  y-offset ( 0 ... YMAX-1 )
+16     16B     Reserved
   Caution: the reserved field must be filled with 0.
*/

    u_lseek(fd, 0L, SEEK_SET);
    HEADER.type=0;  /* assuming old CEL type */
    HEADER.bpp=4;   /* assuming old CEL type */
    u_read(fd, (unsigned short *)&trash, 2);  HEADER.w = trash;
    u_read(fd, (unsigned short *)&trash, 2);  HEADER.h = trash;

    /* check for newer CEL type, id must be 'KiSS' */
    id1 = HEADER.w & 0xffff;
    id2 = HEADER.h & 0xffff;
    id = (id2<<16) | id1;
    if( id==0x5353694b ){    /* probably new CEL, read mark */
    u_read(fd, (unsigned char  *)&mark, 1);   /* it must be number 20 hex */
    }
    if( id==0x5353694b && mark==0x20 ){    /* new type cel */
    HEADER.type=1;
    u_read(fd, (unsigned char  *)&HEADER.bpp, 1);
    u_read(fd, (unsigned short *)&trash, 2);
    u_read(fd, (unsigned short *)&trash, 2);  HEADER.w = trash;
    u_read(fd, (unsigned short *)&trash, 2);  HEADER.h = trash;
    u_lseek(fd, 32L, SEEK_SET);
    }else{ u_lseek(fd, 4L, SEEK_SET);}

    gbm -> w   = HEADER.w;
    gbm -> h   = HEADER.h;
    gbm -> bpp = HEADER.bpp;
/*
printf("GBM.size x <%d>\n",gbm->w);
printf("GBM.size y <%d>\n",gbm->h);
printf("GBM.bpp    <%d>\n",gbm->bpp);
*/
    return ( GBM_ERR_OK );
	}

DLLEXPORT GBM_ERR dxe_rpal(int fd, GBM *gbm, GBMRGB *gbmrgb)
	{
	fd=fd; gbm=gbm; gbmrgb=gbmrgb; /* Suppress 'unref arg' compiler warnings */
    return ( GBM_ERR_OK );
	}


DLLEXPORT char *dxe_err(GBM_ERR rc)
	{
    switch ( (int) rc )
		{
        case GBM_ERR_READ:
            return ( "read error" );
        case GBM_ERR_WRITE:
            return ( "write error" );
		}
	return ( NULL );
}



DLLEXPORT GBM_ERR dxe_w( char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt )
{
    int     i,j,w,stride;
    byte    *p, a;
    byte    idc[5]="KiSS";
    byte    mark;
    unsigned short trash, trash16[17];

    if(gbm->bpp==8){    /* write depth 8 bpp */
    u_lseek(fd, 0L, SEEK_SET);

    for(i=0;i<17;i++) trash16[i]=0;
                        u_write( fd, (unsigned char *)&idc, 4 );
    mark=0x20;          u_write( fd, (unsigned char *)&mark,1 );
    a = gbm->bpp;       u_write( fd, (unsigned char *)&a, 1 );
    trash=0;            u_write( fd, (unsigned short *)&trash, 2 );
    trash=gbm->w;       u_write( fd, (unsigned short *)&trash, 2 );
    trash=gbm->h;       u_write( fd, (unsigned short *)&trash, 2 );
    trash=0;            u_write( fd, (unsigned short *)&trash, 2 );
    trash=0;            u_write( fd, (unsigned short *)&trash, 2 );
                        u_write( fd, (unsigned short *)&trash16, 16 );
/*
offset  size    contents
+0      4B      Identifier 'KiSS' ( 4Bh 69h 53h 53h )
+4      B       Cel file mark ( 20h )
+5      B       bits per pixel ( 4 or 8 )
+6      W       Reserved
+8      W(L,H)  Width ( 1 ... XMAX )
+10     W(L,H)  Height ( 1 ... YMAX )
+12     W(L,H)  x-offset ( 0 ... XMAX-1 )
+14     W(L,H)  y-offset ( 0 ... YMAX-1 )
+16     16B     Reserved
*/
    w = j = gbm->w;
    p = data;
    stride = ((w+3)&~3);        /* dword boundary */
    for ( i = 0 ; i<gbm->h ; i++ )
		{
        u_write( fd, p, w );      /* write scanline */
        p +=stride;
        }
    }


    if(gbm->bpp==4){    /* write depth 4 bpp */
    u_lseek(fd, 0L, SEEK_SET);
    w = j = gbm->w;
    j &= 1;
    w = (w/2) + j;
    u_write( fd, (unsigned short *)&gbm->w, 2 );
    u_write( fd, (unsigned short *)&gbm->h, 2 );
    p = data;
    stride = ((w+3)&~3);        /* dword boundary */
    for ( i = 0 ; i<gbm->h ; i++ )
		{
        u_write( fd, p, w );      /* write scanline */
        p +=stride;
        }
    }


    return ( GBM_ERR_OK );
}


DLLEXPORT GBM_ERR dxe_rdata(int fd, GBM *gbm, byte *data)
{
    int     i, j, w, stride;
    byte    *p;


    if(gbm->bpp==8){
    u_lseek(fd, 32L, SEEK_SET);   /* seek past header */
    w = gbm->w;
    p = data;
    stride = ((w+3)&~3);
    for ( i = 0 ; i < gbm->h ; i++ )
		{
        u_read( fd, p, w );      /* read scanline */
        p += stride;
        }
    }

    if(gbm->bpp==4){
    if(HEADER.type==0)  /* 0=old CEL type, 1=new CEL type */
        u_lseek(fd, 4L, SEEK_SET);    /* seek past header */
    if(HEADER.type==1)  /* 0=old CEL type, 1=new CEL type */
        u_lseek(fd, 32L, SEEK_SET);    /* seek past header */

    w = j = gbm->w;
    j &= 1;
    w = (w/2) + j;
    p = data;
    stride = ((w+3)&~3);
    for ( i = 0 ; i < gbm->h ; i++ )
		{
        u_read( fd, p, w );      /* read scanline */
        p += stride;
        }
    }/* bpp==4 */

    return ( GBM_ERR_OK );
}


