/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"GREY",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"8 level grey",
"reduce range 0-255 source, to 8 levels",
"Turn a grey level image into a 8 range grey level image.",
"                              "
"                              "
"                              "
"                              "
"   *********                  "
"   *********                  "
"   **     **                  "
"   **     **                  "
"   **     **                  "
"   *********       ****       "
"   *********      ******      "
"   **     **     **    **     "
"   **     **     **    **     "
"   **     **     **    **     "
"   *********      **  ***     "
"   *********       ****       "
"   **     **       ****       "
"   **     **      **  **      "
"   **     **     **    **     "
"   *********     **    **     "
"   *********     **    **     "
"   **     **     ***  ***     "
"   **     **      ******      "
"   **     **                  "
"   *********                  "
"   *********                  "
"                              "
"                              "
"                              "
"                              ",
"******************************"
"******************************"
"******************************"
"******************************"
"***         ******************"
"***         ******************"
"***  *****  ******************"
"***  *****  ******************"
"***  *****  ******************"
"***         *******    *******"
"***         ******      ******"
"***  *****  *****  ****  *****"
"***  *****  *****  ****  *****"
"***  *****  *****  ****  *****"
"***         ******  **   *****"
"***         *******    *******"
"***  *****  *******    *******"
"***  *****  ******  **  ******"
"***  *****  *****  ****  *****"
"***         *****  ****  *****"
"***         *****  ****  *****"
"***  *****  *****   **   *****"
"***  *****  ******      ******"
"***  *****  ******************"
"***         ******************"
"***         ******************"
"******************************"
"******************************"
"******************************"
"******************************",
1,2,0,1,0
};


static int  lim0,lim1,lim2,lim3,lim4,lim5,lim6,lim7,lim8;
static int  ran0,ran1,ran2,ran3,ran4,ran5,ran6,ran7,ran8;


static int approximate8( int color );




/* approximate grayscale to 8 levels greyscale, on source
 */
static int approximate8( int color )
{
    if( lim0 <= color && color <= lim1 ) return ran0;
    if( lim1 <= color && color <= lim2 ) return ran1;
    if( lim2 <= color && color <= lim3 ) return ran2;
    if( lim3 <= color && color <= lim4 ) return ran3;
    if( lim4 <= color && color <= lim5 ) return ran4;
    if( lim5 <= color && color <= lim6 ) return ran5;
    if( lim6 <= color && color <= lim7 ) return ran6;
    if( lim7 <= color && color <= lim8 ) return ran7;
    if( lim0 > color ) return 0;    // underflow
    return 255;                     // overflow
}

DLLEXPORT void dxemod_init(){}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x,y, i, j;

    if( src==NULL ) return -1;
    i = 255 / 8;    j = i / 2;
    lim0 =          i * 0;      ran0 = lim0 + j;
    lim1 =          i * 1;      ran1 = lim1 + j;
    lim2 =          i * 2;      ran2 = lim2 + j;
    lim3 =          i * 3;      ran3 = lim3 + j;
    lim4 =          i * 4;      ran4 = lim4 + j;
    lim5 =          i * 5;      ran5 = lim5 + j;
    lim6 =          i * 6;      ran6 = lim6 + j;
    lim7 =          i * 7;      ran7 = lim7 + j;
    lim8 =          i * 8;      ran8 = lim8 + j;
    for(y=y1;y<(y1+sy);y++){
    for(x=x1;x<(x1+sx);x++){
    v_putpixel(src,x,y, approximate8(  v_getpixel(src,x,y)  ));
    }}
    return 0;
}

