/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"EDGE",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"edged object",
"Horizontal, Vertical edge detection object (old)",
"Testing->",
"                              "
"                              "
"  **************************  "
"  ***********************  *  "
"  **********************   *  "
"  ************  *******    *  "
"  *****       **      *    *  "
"  *****      ****          *  "
"  *****     ******    *    *  "
"  *****       **           *  "
"  *****       **      *    *  "
"  ****        **           *  "
"  *** **     *  *     **   *  "
"  ** ***    *    *    ***  *  "
"  * ********      ******** *  "
"  * ********      ******** *  "
"  ** ***    *    *    ***  *  "
"  *** **     *  *     **   *  "
"  ****        **           *  "
"  *****       **      *    *  "
"  *****       **           *  "
"  *****     ******    *    *  "
"  *****      ****          *  "
"  *****       **      *    *  "
"  ****** * * * * * * **    *  "
"  ***                      *  "
"  **                       *  "
"  **************************  "
"                              "
"                              ",
"******************************"
"******************************"
"**                          **"
"**                       ** **"
"**                      *** **"
"**            **       **** **"
"**     *******  ****** **** **"
"**     ******    ********** **"
"**     *****      **** **** **"
"**     *******  *********** **"
"**     *******  ****** **** **"
"**    ********  *********** **"
"**   *  ***** ** *****  *** **"
"**  *   **** **** ****   ** **"
"** *        ******        * **"
"** *        ******        * **"
"**  *   **** **** ****   ** **"
"**   *  ***** ** *****  *** **"
"**    ********  *********** **"
"**     *******  ****** **** **"
"**     *******  *********** **"
"**     *****      **** **** **"
"**     ******    ********** **"
"**     *******  ****** **** **"
"**      * * * * * * *  **** **"
"**   ********************** **"
"**  *********************** **"
"**                          **"
"******************************"
"******************************",
1,0,1,1,0
};     

static    int     threshold = 40, retval = -1;


DLLEXPORT void dxemod_init()
{
    if( g->dxe_bitmap==NULL )
        g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2 );
    retval = v_dlg_request_uchar(" Threshold ",1,threshold,254 );
    if( retval >= 0 ) threshold = retval;
}
DLLEXPORT void dxemod_deinit(){}


#define EVENT_UNDEF 0
#define EVENT_UP   11
#define EVENT_DOWN 22

/*
 * Changes greater than threshold mark an edge.
 * Should be used after EMBOSS method, to detect edges
 * return -1 on error
 */
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x=0, y=0, xlim, ylim;
    int     dx, idx, dx1, dx2, x2,x3;
    int     eventx_type = EVENT_UNDEF, eventx_count=0, event_x=0, event_y=0;
    int     dy, idy, dy1, dy2, y2,y3;
    int     eventy_type = EVENT_UNDEF, eventy_count=0;
    int     black, white;

    black = 0;
    white = 255;
    if( src==NULL || g->dxe_bitmap==NULL ) return -1;
    if( retval < 0 ) return -1;
    v_clear_to_color(  g->dxe_bitmap, black );

    ylim = y1+sy;
    xlim = x1+sx;

    for(y=y1;y<ylim;y++){
    for(x=x1;x<xlim;x++){
    x2 = x-1;   if( x2 < x1 ) x2 = x1;      // don't go negative
    x3 = x;
    dx1 = v_getpixel( src, x2, y ) & 255;
    dx2 = v_getpixel( src, x3, y ) & 255;
    dx  = dx1 - dx2;    idx = dx2 - dx1;
    eventx_count++;
    if ( dx >= 0 && dx >=  threshold ){        // low to high intensity (UP)
        if( eventx_type == EVENT_DOWN  )
            v_line(  g->dxe_bitmap, x, y, event_x,event_y, white );
        // store x,y coordinate, and mark start until end is found
            eventx_type = EVENT_UP;
            event_x = x;
            event_y = y;
            eventx_count = 0;
    }
    if ( idx >= 0 && idx >= threshold ){        // high to low intensity (DOWN)
            // store x,y coordinate, and mark start until end is found
            eventx_type = EVENT_DOWN;
            event_x = x;
            event_y = y;
            eventx_count = 0;
    }
    }
        eventx_type = EVENT_UNDEF;        eventx_count = 0;
    }


    for(x=x1;x<xlim;x++){
    for(y=y1;y<ylim;y++){
    y2 = y-1;   if( y2 < y1 ) y2 = y1;      // don't go negative
    y3 = y;
    dy1 = v_getpixel( src, x, y2 ) & 255;
    dy2 = v_getpixel( src, x, y3 ) & 255;
    dy  = dy1 - dy2;    idy = dy2 - dy1;
    eventy_count++;
    if ( dy >= 0 && dy >=  threshold ){        // low to high intensity (UP)
        if( eventy_type == EVENT_DOWN  )
            v_line(  g->dxe_bitmap, x, y, event_x,event_y, white );
        // store x,y coordinate, and mark start until end is found
            eventy_type = EVENT_UP;
            event_x = x;
            event_y = y;
            eventy_count = 0;
    }
    if ( idy >= 0 && idy >= threshold ){        // high to low intensity (DOWN)
            // store x,y coordinate, and mark start until end is found
            eventy_type = EVENT_DOWN;
            event_x = x;
            event_y = y;
            eventy_count = 0;
    }
    }
        eventy_type = EVENT_UNDEF;        eventy_count = 0;
    }










    v_blit( g->dxe_bitmap, src, x1,y1,x1,y1,sx,sy );
    return 0;
}




