/*
 *
 * TODO: x1,y2,sx,sy ...make sure methods work in a box
 *       Allocation of graphic block should be done globally
 *
 * Make Linked lists to store hlines and vlines in them
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../global.h"
#include "../types.h"
#define FOREVER for(;;){
#define ENDFOR  }


DLLEXPORT MTDS dxemod_params = {
"PATTERN",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"hvlines",
"Binary image to hvlines. Linked list type.",
"Join cutted hvlines, isolated by small spaces, remove small hvdots",
"                              "
"                              "
"           ***  ***           "
"           ***  ***           "
"    **********  **********    "
"    *      ***  ***      *    "
"    *      ***  ***      *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"  **************************  "
"  **************************  "
"  ***  **  ****  ****  *****  "
"  ***  **  ****  ****  *****  "
"  ***      *****  **  ******  "
"  ***  **  ******    *******  "
"  ***  **  *******  ********  "
"  **************************  "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *                    *    "
"    *      ***  ***      *    "
"    *      ***  ***      *    "
"    **********  **********    "
"           ***  ***           "
"           ***  ***           "
"                              "
"                              ",
"******************************"
"******************************"
"***********   **   ***********"
"***********   **   ***********"
"****          **          ****"
"**** ******   **   ****** ****"
"**** ******   **   ****** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**                          **"
"**                          **"
"**   **  **    **    **     **"
"**   **  **    **    **     **"
"**   ******     **  **      **"
"**   **  **      ****       **"
"**   **  **       **        **"
"**                          **"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******************** ****"
"**** ******   **   ****** ****"
"**** ******   **   ****** ****"
"****          **          ****"
"***********   **   ***********"
"***********   **   ***********"
"******************************"
"******************************",
1,0,0,1,0
};     


// Linked list stuffs --------------------------------------
/*
One allocated array of pointers for all X of type HV_LINK.
One allocated array of pointers for all Y of type HV_LINK.
every array contains arbitrary number of single linked items of type HV_LINK.

It's done like this for easier access to x,y elements.
For implementing hlines:
     y_lines[0]  -> hline(0), hline(1), ... hline(n)
     y_lines[1]  -> hline(0), hline(1), ... hline(n)
        ...
     y_lines[sy] -> hline(0), hline(1), ... hline( sx )

and similar for x_lines.
*/


typedef struct HV_LINK {
    void    *prev;          // prev in link
    void    *next;          // next in link
    int     flag_type;      // TYPE_UP, TYPE_DOWN, TYPE_LEFT, TYPE_RIGHT
    int     pos, len;       // line position( x,y ) and size ( dx2,dy2 )
    int     flag_hv;        // 0 = Horizontal line, 1 = Vertical line
//    int     flag_box;       // 0 = line definition ,1 = box definition
//    int     box_x1, box_y1, box_x2, box_y2; // undefined when line is defined
} HV_LINK;



HV_LINK   *x_lines[8192], *y_lines[8192];   // global data for x and y
int        hv_sx = 0,  hv_sy = 0;


// Linked list stuffs --------------------------------------








static unsigned char puxil( BITMAP *, int, int);
static int scan_bitmap_into_links( BITMAP *, int x1, int y1, int sx, int sy, int hvtype );
static void clean_hlines();
static int join_hlines( int hvtype, int type );
static HV_LINK *alloc_hvlink( int pos, int len, int hvtype, int type );
static void free_hvlines();
static int add_hvlink( int _pos, int _col, int _len, int hvtype, int type );
static int add_hvlink_inlink( HV_LINK **first, HV_LINK **last, int _pos, int _col, int _len, int hvtype, int type );
static HV_LINK *remove_this_link( HV_LINK *ha, int col );
static HV_LINK *traverse_last_link( HV_LINK *first );
static int remove_isolated_hlines( int hvtype );
static int remove_diffed_hlines( int hvtype );
static HV_LINK *getlinksizes( HV_LINK *hv, int *linesize, int *newlinesize, int *breaksize, int type );
static HV_LINK *next_lines( HV_LINK *hv, int type );
static HV_LINK *prev_lines( HV_LINK *hv, int type );
static int adjust_overlapped_hlines( int hvtype );
static int check_outside_limits( int lix1, int lix2, int x1, int x2 );
static void dump_hlines( int type );
static void weld_lines( HV_LINK *ha, int threshold );
static void addto_hvlinkedlist( int hvtype, HV_LINK *hv, int col );
static void paste_into_bitmap( BITMAP *, int hvtype );
static int remove_bridged_hlines( int hvtype, int type );
static int rectify_hlines( int hvtype );
static int get_nextspace( HV_LINK *hv, int type );
static int get_prevspace( HV_LINK *hv, int type );
static void validate_space_of_pair( HV_LINK *ha, HV_LINK *hb, int *space1, int *space2, int hvtype );

static void dump_hlines( int type )
{
    HV_LINK *hv;
    int     y;

//    printf("type = %d\n", type );
    for( y=0 ; y < hv_sy ; y++ ) {
    hv = y_lines[ y ];
        printf("y = %d ",  y );    if( hv == NULL ){ puts("[NULL]");}
        if( hv != NULL ){
//        if( hv->flag_type == type ){
            for(;;){
            printf("[x=%d linesize=%d] ",  hv->pos, hv->len );
            hv = (HV_LINK *) hv->next;    if( hv == NULL ){puts(""); break;}
//            }else{}
        }
        }
    }
}

// return TRUE if (x1,x2) is outside limits (lix1, lix2)
// else returns FALSE
static int check_outside_limits( int lix1, int lix2, int x1, int x2 )
{
    int    flag_out = FALSE;

    if( lix1 > x1  && lix1 > x2 )   flag_out = TRUE; // out-of-range, out-of-bound
    if( lix2 < x1  && lix2 < x2 )   flag_out = TRUE; // out-of-range, out-of-bound
    return flag_out;
}



// return a pixel, 0=background color, 1=foreground color
static unsigned char puxil( BITMAP *src, int x, int y )
{
    int     a;
    unsigned char retval = 0;

    a = v_getpixel( src,x,y ) & 255;
    if( a <= 44 )  retval = 0;
    if( a >  44 )  retval = 1;
    return  retval;
}





#define HVTYPE_UNDEF      99
#define HVTYPE_HORIZONTAL 0
#define HVTYPE_VERTICAL   1

#define TYPE_ANY      0
#define TYPE_NOTHING  1
#define TYPE_UP       254
#define TYPE_DOWN     253
#define TYPE_LEFT     252
#define TYPE_RIGHT    251

#define ANCHOR_UNDEF  0
#define ANCHOR_UP     11
#define ANCHOR_DOWN   22



static HV_LINK *alloc_hvlink( int pos, int len, int hvtype, int type )
{
    HV_LINK     *hv;

    hv = (HV_LINK *) malloc ( sizeof(HV_LINK) + 32  );    if( hv == NULL ) return NULL;
    hv->prev      = NULL;
    hv->next      = NULL;
    hv->flag_type = type;
    hv->pos         = pos;
    hv->len         = len;
    hv->flag_hv     = hvtype;
//    hv->flag_box  = 0;
//    hv->box_x1 = hv->box_y1 = hv->box_x2 = hv->box_y2 = 0;
    return hv;
}


// free both x,y arrays of linked items
static void free_hvlines()
{
    int         x,  y;
    HV_LINK    *n, *p;

    if( hv_sx < 2 || hv_sy < 2 ) return;
    for( y = 0; y < hv_sy; y++ ){
    p = y_lines[ y ];
        if( p != NULL ){
            y_lines[y] = NULL;
            FOREVER    //  follow linked list and free the whole list
            n = p;            if( n == NULL ) break;
            p = (HV_LINK *) p->next;
            if( p == NULL ){
                if(n!=NULL) free( n );
                break;
            }else{
                if(n!=NULL) free( n );
            }
            ENDFOR
        }
    }
    for( x = 0; x < hv_sx; x++ ){
    p = x_lines[x];
        if( p != NULL ){
            x_lines[x] = NULL;
            FOREVER    //  follow linked list and free the whole list
            n = p;
            p = (HV_LINK *) p->next;
            if( p == NULL ){
                if(n!=NULL) free( n );
                break;
            }else{
                if(n!=NULL) free( n );
            }
            ENDFOR
        }
    }

}

// add a link last in link
static int add_hvlink( int _pos, int _col, int _len, int hvtype, int type )
{
    int     pos = _pos,  col = _col,  len = _len;
    HV_LINK  *hv = NULL,  *hz = NULL,  *ht = NULL;


    if( hvtype == HVTYPE_HORIZONTAL ){
        if( col > hv_sy )  col = hv_sy;
        if( pos > hv_sx )  pos = hv_sx;
        if( len > hv_sx )  len = hv_sx;
        hv = y_lines[ col ];
    }
    if( hvtype == HVTYPE_VERTICAL ){
        if( col > hv_sx )  col = hv_sx;
        if( pos > hv_sy )  pos = hv_sy;
        if( len > hv_sy )  len = hv_sy;
        hv = x_lines[ col ];
    }
    hz = traverse_last_link( hv );
    ht = alloc_hvlink( pos, len, hvtype, type );   if( ht==NULL ) return -1;
    if( hz == NULL ){
        if( hvtype == HVTYPE_HORIZONTAL )   y_lines[ col ] = ht;
        if( hvtype == HVTYPE_VERTICAL )     x_lines[ col ] = ht;
        }else{
        ht->prev = (HV_LINK *) hz;
        hz->next = (HV_LINK *) ht;
        }
    return 0;
}
// add a link into a linked list
static int add_hvlink_inlink( HV_LINK **first, HV_LINK **last, int _pos, int _col, int _len, int hvtype, int type )
{
    int     pos = _pos,  col = _col,  len = _len;
    HV_LINK  *ha = NULL,  *hb = NULL;

    if( hvtype == HVTYPE_HORIZONTAL ){
        if( col > hv_sy )  col = hv_sy;
        if( pos > hv_sx )  pos = hv_sx;
        if( len > hv_sx )  len = hv_sx;
    }
    if( hvtype == HVTYPE_VERTICAL ){
        if( col > hv_sx )  col = hv_sx;
        if( pos > hv_sy )  pos = hv_sy;
        if( len > hv_sy )  len = hv_sy;
    }
    if( *first==NULL && *last==NULL){   // no links yet
        ha = alloc_hvlink( pos, len, hvtype, type );   if( ha==NULL ) return -1;
        *first = ha;
        *last  = ha;
        return 0;
    }
    if( *first == *last ){   // one single link
        ha = *first;
        hb = alloc_hvlink( pos, len, hvtype, type );   if( hb==NULL ) return -1;
        //... connection
        ha->next = hb;  // connect to next
        hb->prev = ha;  // connect to previous
        //... connection
        *last = hb;
        return 0;
    }
    // more than two links, attach to last link.
    ha = *last;
    hb = alloc_hvlink( pos, len, hvtype, type );   if( hb==NULL ) return -1;
    //... connection
    ha->next = hb;  // connect to next
    hb->prev = ha;  // connect to previous
    //... connection
    *last = hb;
    return 0;
}

static void weld_lines( HV_LINK *ha, int threshold )
{
    int     linesize=0, newlinesize=0, breaksize=0;
    HV_LINK *hv = NULL, *hw = NULL, *hz = NULL;
    int     col=0;

    if( ha == NULL ) return;
    hv = ha;
    FOREVER
    hz = hv;
    linesize = newlinesize = breaksize = 0;
    hv = getlinksizes( hv, &linesize, &newlinesize, &breaksize, TYPE_ANY );
    if( hv==NULL ) break;
        if( breaksize <= threshold ){
        hz->len =  newlinesize;
        hw = remove_this_link( hv, col );   if( hw == NULL ) break;
        hv = hz;
        }
    ENDFOR
    return;
}

static HV_LINK *traverse_last_link( HV_LINK *first )
{
    HV_LINK     *a = NULL, *b = NULL;

    if( first == NULL ) return NULL;
    a = first;
    FOREVER
        b = a;    if( b == NULL ) return NULL;
        a = (HV_LINK *) a->next;
        if( a == NULL ) return b;
    ENDFOR
}
// todo: remove links of same type only.
// remove a single link in double linked list
static HV_LINK *remove_this_link( HV_LINK *ha, int col )
{
    HV_LINK     *hprev, *hnext;
    int         hvtype = HVTYPE_UNDEF;

    if( ha == NULL ) return NULL;
    hvtype = ha->flag_hv;
    hprev = (HV_LINK *) ha->prev;
    hnext = (HV_LINK *) ha->next;
    if( hprev==NULL && hnext==NULL ){    // single in link, return NULL
       if( hvtype == HVTYPE_HORIZONTAL )  y_lines[ col ] = NULL;
       if( hvtype == HVTYPE_VERTICAL )    x_lines[ col ] = NULL;
       return NULL;
    }
    free( ha );
    if(hprev==NULL){    // first in link
        hnext->prev = NULL;
        if( hvtype == HVTYPE_HORIZONTAL )  y_lines[ col ] = (HV_LINK *)  hnext;
        if( hvtype == HVTYPE_VERTICAL )    x_lines[ col ] = (HV_LINK *)  hnext;
        return hnext;
    }
    if(hnext==NULL){    // last in link
        hprev->next = NULL;
        return hprev;
    }
    // normal case
    hprev->next = (HV_LINK *) hnext;     // link forward
    hnext->prev = (HV_LINK *) hprev;     // link backward
    return hprev;
}




// get size(distance) in pixels from two links
static HV_LINK *getlinksizes( HV_LINK *hv, int *linesize, int *newlinesize, int *breaksize, int type )
{
    HV_LINK *hw = hv;
    int     prev_x,    prev_size;
    int     next_x,    next_size;
    int     size = 0;

    if( linesize!=NULL  )  *linesize    = 0;
    if( breaksize!=NULL )  *breaksize   = 9999;
    if( newlinesize!=NULL) *newlinesize = 0;

    if( hv==NULL ) return NULL;
    prev_x    =  hv->pos;
    prev_size =  hv->len;
    if( hv->flag_hv ==  HVTYPE_HORIZONTAL ) size = hv_sx;
    if( hv->flag_hv ==  HVTYPE_VERTICAL )   size = hv_sy;

    FOREVER    // make sure hw->pos is bigger than hv->pos
    if( type == TYPE_ANY )
        hw = (HV_LINK *) hv->next;
    else
        hw = next_lines( hv, type );
    if( hw==NULL ) break;
    if( hw->pos > hv->pos ) break;
    hv = hw;
    ENDFOR
/*
    if( type == TYPE_ANY )
        hw = (HV_LINK *) hv->next;
    else
        hw = next_lines( hv, type );
*/

    if( hw == NULL ){
        if( linesize!=NULL  )  *linesize    = prev_size;
        if( breaksize!=NULL )  *breaksize   = size - (prev_x + prev_size);
        if( newlinesize!=NULL) *newlinesize = size - (prev_x + prev_size);
        return NULL;    // next link is grounded, return NULL
    }
    next_x    =  hw->pos;
    next_size =  hw->len;
    if( linesize!=NULL  )  *linesize    = prev_size;
    if( breaksize!=NULL ){
        *breaksize   = next_x - (prev_x + prev_size);
        if( *breaksize < 0 ) *breaksize = 0;    // this may actually happen
    }
    if( newlinesize!=NULL){
        *newlinesize = prev_size + next_x - (prev_x+prev_size) + next_size;
        if( *newlinesize < 0 ) *newlinesize = 1;    // most unlikely
    }
    return hw;
}

// return space between current link and next link
static int get_nextspace( HV_LINK *hv, int type )
{
    HV_LINK *hw = hv;
    int     prev_x,    prev_size;
    int     next_x,    next_size;
    int     size = 0;

    if( hv==NULL ) return 0;
    prev_x    =  hv->pos;
    prev_size =  hv->len;
    if( hv->flag_hv ==  HVTYPE_HORIZONTAL ) size = hv_sx;
    if( hv->flag_hv ==  HVTYPE_VERTICAL )   size = hv_sy;
    FOREVER         // make sure hw->pos is bigger than hv->pos
    if( type == TYPE_ANY )
        hw = (HV_LINK *) hv->next;
    else
        hw = next_lines( hv, type );
    if( hw==NULL ) break;
    if( hw->pos > hv->pos ) break;
    hv = hw;
    ENDFOR
    if( hw == NULL ){
        return ( size - (prev_x + prev_size));
    }
    next_x    =  hw->pos;
    next_size =  hw->len;
    return ( next_x - (prev_x + prev_size));
}

// return space between current link and previous link
static int get_prevspace( HV_LINK *hv, int type )
{
    HV_LINK *hw = hv;
    int     prev_x,    prev_size;

    if( hv==NULL ) return 0;
    prev_x    =  hv->pos;
    prev_size =  hv->len;
    FOREVER
    if( type == TYPE_ANY )
        hw = (HV_LINK *) hv->prev;
    else
        hw = prev_lines( hv, type );
    if( hw==NULL ) break;
    if( hw->pos < hv->pos ) break;
    hv = hw;
    ENDFOR
    if( hw == NULL ){
        return prev_x;
    }
    return ( prev_x - ( hw->pos + hw->len ));
}


static HV_LINK *next_lines( HV_LINK *hv, int type )
{
    HV_LINK *zv = hv;

    if( hv == NULL ) return NULL;
    FOREVER
        zv = (HV_LINK *) zv->next;
        if( zv == NULL ) return NULL;
        if( (zv->flag_type == type) || (type == TYPE_ANY) ) break;
    ENDFOR
    return (HV_LINK *) zv;
}
static HV_LINK *prev_lines( HV_LINK *hv, int type )
{
    HV_LINK *zv = hv;

    if( hv == NULL ) return NULL;
    FOREVER
        zv = (HV_LINK *) zv->prev;
        if( zv==NULL ) return NULL;
        if( (zv->flag_type == type) || (type == TYPE_ANY) ) break;
    ENDFOR
    return (HV_LINK *) zv;
}
// add a single linked list into the global linked list
static void addto_hvlinkedlist( int hvtype, HV_LINK *hv, int col )
{
    HV_LINK     *ha=NULL, *hz=NULL;

    if( hv==NULL ) return;

    if( hvtype ==  HVTYPE_HORIZONTAL ){
    ha = y_lines[ col ];
    if( ha == NULL ){       // simple add to
        y_lines[ col ] = hv;
        return;
        }
    // Add to last in link
    hz = traverse_last_link( ha );
        if( hz == NULL ){
        y_lines[ col ] = hv;
        return;
        }
    hz->next = hv;
    hv->prev = hz;

    }else{
            //    if( hvtype ==  HVTYPE_VERTICAL ){
    ha = x_lines[ col ];
    if( ha == NULL ){       // simple add to
        x_lines[ col ] = hv;
        return;
        }
    // Add to last in link
    hz = traverse_last_link( ha );
        if( hz == NULL ){
        x_lines[ col ] = hv;
        return;
        }
    hz->next = hv;
    hv->prev = hz;
    }
}





//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************
//        *************************************************





DLLEXPORT void dxemod_init()
{
    int     i;

    for( i=0 ; i < 8191 ; i++ ){
        x_lines[ i ] = NULL;
        y_lines[ i ] = NULL;
    }
    if( g->dxe_bitmap == NULL ){
        if( g->sx < 3 || g->sy < 3 ) return;
        g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2  );
    }
}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method ( BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     i;

    dxemod_init();    if( g->dxe_bitmap==NULL){ return -1; }
    v_clear_bitmap( g->dxe_bitmap  );
    hv_sx = sx;    if( hv_sx > 8189 ) hv_sx = 8189;
    hv_sy = sy;    if( hv_sy > 8189 ) hv_sy = 8189;
    //...
    for( i=0 ; i < hv_sx+3 ; i++ )  x_lines[ i ] = NULL;   // empty
    for( i=0 ; i < hv_sy+3 ; i++ )  y_lines[ i ] = NULL;   // empty
    //...
    i = scan_bitmap_into_links( src, x1, y1, sx, sy, HVTYPE_HORIZONTAL );  if( i ==-1 ){free_hvlines();return -1;}
    i = scan_bitmap_into_links( src, x1, y1, sx, sy, HVTYPE_VERTICAL   );  if( i ==-1 ){free_hvlines();return -1;}

    clean_hlines();

    // ---------------------------------------------
    paste_into_bitmap( g->dxe_bitmap, HVTYPE_HORIZONTAL );        // extract data from linked list into TMP bitmap
    paste_into_bitmap( g->dxe_bitmap, HVTYPE_VERTICAL   );        // extract data from linked list into TMP bitmap
    // ---------------------------------------------

    v_blit(  g->dxe_bitmap, src, 0,0,x1,y1, sx,sy );
//    blit( g->dxe_bitmap, src, x1,y1,x1,y1, sx,sy );
    free_hvlines();
    return 0;
}

//        *************************************************
//        *************************************************
//        *************************************************


static void clean_hlines()
{
//    puts("***");
//    dump_hlines( TYPE_ANY );
//    puts("***");

    remove_isolated_hlines(   HVTYPE_HORIZONTAL );
    remove_diffed_hlines(     HVTYPE_HORIZONTAL );
    adjust_overlapped_hlines( HVTYPE_HORIZONTAL );
    remove_bridged_hlines(    HVTYPE_HORIZONTAL, TYPE_UP    );
    remove_bridged_hlines(    HVTYPE_HORIZONTAL, TYPE_DOWN  );
    rectify_hlines(           HVTYPE_HORIZONTAL    );
//    join_hlines(              HVTYPE_HORIZONTAL, TYPE_UP    );
//    join_hlines(              HVTYPE_HORIZONTAL, TYPE_DOWN  );


    remove_isolated_hlines(   HVTYPE_VERTICAL );
    remove_diffed_hlines(     HVTYPE_VERTICAL   );
    adjust_overlapped_hlines( HVTYPE_VERTICAL   );
    remove_bridged_hlines(    HVTYPE_VERTICAL, TYPE_LEFT  );
    remove_bridged_hlines(    HVTYPE_VERTICAL, TYPE_RIGHT );
    rectify_hlines(           HVTYPE_HORIZONTAL    );
//    join_hlines(              HVTYPE_VERTICAL,   TYPE_LEFT   );
//    join_hlines(              HVTYPE_VERTICAL,   TYPE_RIGHT  );
    return;
}



#define WELD_THRESHOLD 8


static int scan_bitmap_into_links( BITMAP *src, int x1, int y1, int sx, int sy, int hvtype )
{
    int     anchor_a_k   = ANCHOR_UNDEF;      // UP,   LEFT
    int     anchor_a_pos = 0;
    int     anchor_b_k   = ANCHOR_UNDEF;      // DOWN, RIGHT
    int     anchor_b_pos = 0;
    int     i, x = 0, y, tx,ty, ylim,xlim;
    unsigned char    c1,c2,c3,c4,c5,c6,c7,c8,c9;
    int     type = TYPE_NOTHING;
    HV_LINK *up_first=NULL, *up_last=NULL, *down_first=NULL, *down_last=NULL;
    HV_LINK *left_first=NULL, *left_last=NULL, *right_first=NULL, *right_last=NULL;


    if( hvtype != HVTYPE_HORIZONTAL && hvtype != HVTYPE_VERTICAL ) return -1;

    ylim = y1+sy;
    xlim = x1+sx;
    if( hvtype == HVTYPE_HORIZONTAL ){
    for(y = y1,ty=0; y < ylim ; y++,ty++) {
    anchor_a_k = ANCHOR_UNDEF;
    anchor_b_k = ANCHOR_UNDEF;
    up_first = down_first = NULL;
    up_last  = down_last  = NULL;
    for(x = x1,tx=0; x < xlim ; x++,tx++) {
    c1=puxil(src,x+0,y+0);    c2=puxil(src,x+1,y+0);    c3=puxil(src,x+2,y+0);
    c4=puxil(src,x+0,y+1);    c5=puxil(src,x+1,y+1);    c6=puxil(src,x+2,y+1);
    c7=puxil(src,x+0,y+2);    c8=puxil(src,x+1,y+2);    c9=puxil(src,x+2,y+2);

    if( c1==1 && c2==1 && c3==1 &&
        c4==0 && c5==0 && c6==0 &&
        c7==0 && c8==0 && c9==0 ){        type = TYPE_DOWN;  }
    if( c1==1 && c2==1 && c3==1 &&
        c4==0 && c5==1 && c6==0 &&
        c7==0 && c8==0 && c9==0 ){        type = TYPE_DOWN;  } // noisy
    if( c1==1 && c2==1 && c3==1 &&
        c4==1 && c5==0 && c6==0 &&
        c7==0 && c8==0 && c9==0 ){        type = TYPE_DOWN;  } // noisy
    if( c1==1 && c2==1 && c3==1 &&
        c4==0 && c5==0 && c6==1 &&
        c7==0 && c8==0 && c9==0 ){        type = TYPE_DOWN;  } // noisy
    if( c1==1 && c2==1 && c3==1 &&
        c4==1 && c5==0 && c6==1 &&
        c7==0 && c8==0 && c9==0 ){        type = TYPE_DOWN;  } // noisy

    if( c1==0 && c2==0 && c3==0 &&
        c4==0 && c5==0 && c6==0 &&
        c7==1 && c8==1 && c9==1 ){        type = TYPE_UP;    }
    if( c1==0 && c2==0 && c3==0 &&
        c4==0 && c5==1 && c6==0 &&
        c7==1 && c8==1 && c9==1 ){        type = TYPE_UP;    } // noisy
    if( c1==0 && c2==0 && c3==0 &&
        c4==1 && c5==0 && c6==0 &&
        c7==1 && c8==1 && c9==1 ){        type = TYPE_UP;    } // noisy
    if( c1==0 && c2==0 && c3==0 &&
        c4==0 && c5==0 && c6==1 &&
        c7==1 && c8==1 && c9==1 ){        type = TYPE_UP;    } // noisy
    if( c1==0 && c2==0 && c3==0 &&
        c4==1 && c5==0 && c6==1 &&
        c7==1 && c8==1 && c9==1 ){        type = TYPE_UP;    } // noisy


    if( x >= (xlim-1) ) type = TYPE_NOTHING;  // force a end-of-line


    // TYPE_UP ---------------------------
    if( type == TYPE_UP ){
        if( anchor_a_k == ANCHOR_UNDEF ){   // this is first catch
            anchor_a_k  = ANCHOR_DOWN;
            anchor_a_pos = tx;
        }
        if( anchor_a_k == ANCHOR_UP ){      // start new catch
            anchor_a_k  = ANCHOR_DOWN;
            anchor_a_pos = tx;
        }
    }
    // TYPE_UP ---------------------------
    // TYPE_DOWN ---------------------------
    if( type == TYPE_DOWN ){
        if( anchor_b_k == ANCHOR_UNDEF ){   // this is first catch
            anchor_b_k  = ANCHOR_DOWN;
            anchor_b_pos = tx;
        }
        if( anchor_b_k == ANCHOR_UP ){      // start new catch
            anchor_b_k  = ANCHOR_DOWN;
            anchor_b_pos = tx;
        }
    }
    // TYPE_DOWN ---------------------------

    // TYPE_NOTHING ---------------------------
    if( type == TYPE_NOTHING ){
    //...
        // see if we already had a catch before, if true then catch.
        if( anchor_a_k  == ANCHOR_DOWN){   // we had previous catch
        i = ( tx - anchor_a_pos + 1 );  // min val is 2
        if( i==2 ) i=3;
        if( add_hvlink_inlink( &up_first, &up_last,  anchor_a_pos, ty+2, i, HVTYPE_HORIZONTAL, TYPE_UP ) == -1 ) return -1;
        anchor_a_k  = ANCHOR_UP;
        }
    //...
        // see if we already had a catch before, if true then catch.
        if( anchor_b_k  == ANCHOR_DOWN){   // we had previous catch
        i = ( tx - anchor_b_pos + 1 );  // min val is 2
        if( i==2 ) i=3;
        if( add_hvlink_inlink( &down_first, &down_last,  anchor_b_pos, ty, i, HVTYPE_HORIZONTAL, TYPE_DOWN ) == -1) return -1;
        anchor_b_k  = ANCHOR_UP;
        }
    //...
    }
    // TYPE_NOTHING ---------------------------
    type = TYPE_NOTHING;
    }
    // concatenate linked lists
    weld_lines( up_first,   WELD_THRESHOLD );
    weld_lines( down_first, WELD_THRESHOLD );
    addto_hvlinkedlist( HVTYPE_HORIZONTAL, down_first, ty     );
    addto_hvlinkedlist( HVTYPE_HORIZONTAL, up_first,   ty + 2 );
    // concatenate linked lists
    }
    }


    if( hvtype == HVTYPE_VERTICAL ){
    for(x = x1,tx=0; x < xlim ; x++,tx++) {
    anchor_a_k = ANCHOR_UNDEF;
    anchor_b_k = ANCHOR_UNDEF;
    left_first = right_first = NULL;
    left_last  = right_last  = NULL;
    for(y = y1,ty=0; y < ylim ; y++,ty++) {
    c1=puxil(src,x+0,y+0);    c2=puxil(src,x+1,y+0);    c3=puxil(src,x+2,y+0);
    c4=puxil(src,x+0,y+1);    c5=puxil(src,x+1,y+1);    c6=puxil(src,x+2,y+1);
    c7=puxil(src,x+0,y+2);    c8=puxil(src,x+1,y+2);    c9=puxil(src,x+2,y+2);
    if( c1==1 && c2==0 && c3==0 &&
        c4==1 && c5==0 && c6==0 &&
        c7==1 && c8==0 && c9==0 ){        type = TYPE_LEFT; }
    if( c1==1 && c2==0 && c3==0 &&
        c4==1 && c5==1 && c6==0 &&
        c7==1 && c8==0 && c9==0 ){        type = TYPE_LEFT; }  // noisy
    if( c1==1 && c2==0 && c3==0 &&
        c4==1 && c5==0 && c6==0 &&
        c7==1 && c8==1 && c9==0 ){        type = TYPE_LEFT; }  // noisy
    if( c1==1 && c2==1 && c3==0 &&
        c4==1 && c5==0 && c6==0 &&
        c7==1 && c8==0 && c9==0 ){        type = TYPE_LEFT; }  // noisy
    if( c1==1 && c2==1 && c3==0 &&
        c4==1 && c5==0 && c6==0 &&
        c7==1 && c8==1 && c9==0 ){        type = TYPE_LEFT; }  // noisy
    if( c1==0 && c2==0 && c3==1 &&
        c4==0 && c5==0 && c6==1 &&
        c7==0 && c8==0 && c9==1 ){        type = TYPE_RIGHT; }
    if( c1==0 && c2==0 && c3==1 &&
        c4==0 && c5==1 && c6==1 &&
        c7==0 && c8==0 && c9==1 ){        type = TYPE_RIGHT; } // noisy
    if( c1==0 && c2==0 && c3==1 &&
        c4==0 && c5==0 && c6==1 &&
        c7==0 && c8==1 && c9==1 ){        type = TYPE_RIGHT; } // noisy
    if( c1==0 && c2==1 && c3==1 &&
        c4==0 && c5==0 && c6==1 &&
        c7==0 && c8==0 && c9==1 ){        type = TYPE_RIGHT; } // noisy
    if( c1==0 && c2==1 && c3==1 &&
        c4==0 && c5==0 && c6==1 &&
        c7==0 && c8==1 && c9==1 ){        type = TYPE_RIGHT; } // noisy

    if( y >= (ylim-1) ) type = TYPE_NOTHING;  // force a end-of-line

    // TYPE_LEFT ---------------------------
    if( type == TYPE_LEFT ){
        if( anchor_a_k == ANCHOR_UNDEF ){   // this is first catch
            anchor_a_k  = ANCHOR_DOWN;
            anchor_a_pos = ty;
        }
        if( anchor_a_k == ANCHOR_UP ){      // start new catch
            anchor_a_k  = ANCHOR_DOWN;
            anchor_a_pos = ty;
        }
    }
    // TYPE_LEFT ---------------------------
    // TYPE_RIGHT ---------------------------
    if( type == TYPE_RIGHT ){
        if( anchor_b_k == ANCHOR_UNDEF ){   // this is first catch
            anchor_b_k  = ANCHOR_DOWN;
            anchor_b_pos = ty;
        }
        if( anchor_b_k == ANCHOR_UP ){      // start new catch
            anchor_b_k  = ANCHOR_DOWN;
            anchor_b_pos = ty;
        }
    }
    // TYPE_RIGHT ---------------------------

    // TYPE_NOTHING ---------------------------
    if( type == TYPE_NOTHING ){
    //...
        // see if we already had a catch before, if true then catch.
        if( anchor_a_k  == ANCHOR_DOWN){   // we had previous catch
        i = ( ty - anchor_a_pos + 1 );  // min val is 2
        if( i==2 ) i=3;
        if( add_hvlink_inlink( &left_first, &left_last,  anchor_a_pos, tx, i, HVTYPE_VERTICAL, TYPE_LEFT ) == -1) return -1;
        anchor_a_k  = ANCHOR_UP;
        }
    //...
        // see if we already had a catch before, if true then catch.
        if( anchor_b_k  == ANCHOR_DOWN){   // we had previous catch
        i = ( ty - anchor_b_pos + 1 );  // min val is 2
        if( i==2 ) i=3;
        if( add_hvlink_inlink( &right_first, &right_last,  anchor_b_pos, tx+2, i, HVTYPE_VERTICAL, TYPE_RIGHT ) == -1) return -1;
        anchor_b_k  = ANCHOR_UP;
        }
    //...
    }
    // TYPE_NOTHING ---------------------------


    type = TYPE_NOTHING;
    }
    // concatenate linked lists
    weld_lines( left_first,   WELD_THRESHOLD );
    weld_lines( right_first,  WELD_THRESHOLD );
    addto_hvlinkedlist( HVTYPE_VERTICAL, left_first,   tx   );
    addto_hvlinkedlist( HVTYPE_VERTICAL, right_first,  tx+2 );
    // concatenate linked lists
    }


    }
    return 0;
}





static void paste_into_bitmap( BITMAP *zmp, int hvtype )
{
    HV_LINK *hv = NULL;
    int     fg;
    int     pos,len,col, howmuch=0;


    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx;
    for( col=0 ; col < howmuch ; col++ ) {
        if( hvtype == HVTYPE_HORIZONTAL )   hv = y_lines[ col ];
        if( hvtype == HVTYPE_VERTICAL )     hv = x_lines[ col ];
        if( hv != NULL ){
            FOREVER
            pos    =  hv->pos;
            len    =  hv->len;


/*
            x++;
            x &= 1;
//            x &= 3;
            fg = 251;
//fg = fg + x;
            if( hv->flag_type == TYPE_DOWN )    fg = fg + x;
            if( hv->flag_type == TYPE_UP )      fg = fg + x + 2;
            if( hv->flag_type == TYPE_LEFT )    fg = fg + x;
            if( hv->flag_type == TYPE_RIGHT )   fg = fg + x + 2;
*/
            fg = 255;

            if( hvtype == HVTYPE_HORIZONTAL )
                v_hline( zmp, pos, col, pos+len, fg );
            if( hvtype == HVTYPE_VERTICAL )
                v_vline( zmp, col, pos, pos+len, fg );
            // go to next link
            hv = (HV_LINK *) hv->next; if( hv == NULL ) break;
            ENDFOR
        }
    }
}









// join short segments into larger segments,  REPAIR clipped lines
static int join_hlines( int hvtype, int type )
{
    int     linesize=0, newlinesize=0, breaksize=0;
    HV_LINK *hv = NULL, *hw = NULL, *hz = NULL;
    int     col, howmuch = 0;

    if( hvtype != HVTYPE_HORIZONTAL && hvtype != HVTYPE_VERTICAL ) return -1;
    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx;
    for( col=0 ; col < howmuch ; col++ ) {      // HORIZONTAL
    if( hvtype == HVTYPE_HORIZONTAL )   hv = y_lines[ col ];
    if( hvtype == HVTYPE_VERTICAL )     hv = x_lines[ col ];
        if( hv != NULL ){
        if( (hv->flag_type == type) || (type == TYPE_ANY) ){
            FOREVER
            hz = hv;
            linesize = newlinesize = breaksize = 0;
            hv = getlinksizes( hv, &linesize, &newlinesize, &breaksize, type );
            if( hv==NULL ) break;
                if( breaksize <= WELD_THRESHOLD ){       // maximum breaksize THRESHOLD
                hz->len =  newlinesize;
                hw = remove_this_link( hv, col );   if( hw == NULL ) break;
                hv = hz;
                }
            ENDFOR
        }
        }
    }
    return 0;
}









// Adjust line sizes, so overlapping is avoided
static int adjust_overlapped_hlines( int hvtype )
{
    int     a_x=0;
    int     a_x2=0;
    int     a_sx=0;
    int     b_x=0;
    int     b_x2=0;
    int     b_sx=0;
    HV_LINK *ha = NULL, *hb = NULL;
    int     overlap = 0, overlap2=0, dot=0;
    int     col, howmuch=0;

    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy-1;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx-1;
    for( col=0 ; col < howmuch ; col++ ) {
    if( hvtype == HVTYPE_HORIZONTAL ){
        ha = y_lines[ col ];
        hb = y_lines[ col+1 ];
    }
    if( hvtype == HVTYPE_VERTICAL ){
        ha = x_lines[ col ];
        hb = x_lines[ col+1 ];
    }

    if( (ha != NULL) && (hb != NULL) ){
        FOREVER    // scan top
        FOREVER    // scan bottom
        a_x    =  ha->pos;            // top line
        a_sx   =  ha->len;
        a_x2   =  a_x + a_sx ;

        b_x    =  hb->pos;            // bottom line
        b_sx   =  hb->len;
        b_x2   =  b_x + b_sx ;

        if( ha->flag_type == hb->flag_type ){   // same type
        overlap = a_x2 - b_x;
        if( ( a_x < b_x ) && ( a_x2 < b_x2 ) && (overlap >= 0) ){  // type A
            overlap2 = overlap  / 2;            dot = ((overlap)&1);
            ha->len  = a_sx -  overlap2;
            hb->len  = b_sx - (overlap2 + dot);
            hb->pos  = b_x  + (overlap2 + dot);
//                ha->len--;        // one pixel less overlap
        }else{
        overlap = b_x2 - a_x;
        if( ( b_x < a_x ) && ( b_x2 < a_x2 ) && (overlap >= 0) ){  // type B
            overlap2 = overlap  / 2;            dot = ((overlap)&1);
            hb->len  = b_sx - overlap2;
            ha->len  = a_sx - (overlap2 + dot);
            ha->pos  = a_x  + (overlap2 + dot);
//                hb->len--;        // one pixel less overlap
        }}
        }       // same type


        hb = (HV_LINK *) hb->next;        if( hb == NULL )  break;
        ENDFOR
        if( hvtype == HVTYPE_HORIZONTAL )  hb = y_lines[ col+1 ];
        if( hvtype == HVTYPE_VERTICAL )    hb = x_lines[ col+1 ];
        if( ha == NULL || hb == NULL )  break;
        ha = (HV_LINK *) ha->next;
        if( ha == NULL )  break;
        ENDFOR
    }
    }
    return 0;
}















// minimum space allowed for unconnected lines, and between lines
#define THRESHOLD_SPACE    4
// minimum size of line to be removed
#define THRESHOLD_MIN_SX 4


// Remove isolated lines, not touching other lines
static int remove_isolated_hlines( int hvtype )
{
    int     a_x=0;
    int     a_x2=0;
    int     a_sx=0;
    int     b_x=0;
    int     b_x2=0;
    int     b_sx=0;
    int     c_x=0;
    int     c_x2=0;
    int     c_sx=0;
    int     lim_x1=0, lim_x2=0;
    HV_LINK *ha = NULL, *hb = NULL, *hc = NULL;
    int     col, howmuch=0, max_x=0, flag_unmoved = FALSE;


    if( hvtype == HVTYPE_HORIZONTAL ){ howmuch = hv_sy - 2; max_x = hv_sx; }
    if( hvtype == HVTYPE_VERTICAL ){   howmuch = hv_sx - 2; max_x = hv_sy; }
    for( col=0 ; col < howmuch ; col++ ) {
    if( hvtype == HVTYPE_HORIZONTAL ){
        ha = y_lines[ col ];
        hb = y_lines[ col+1 ];
        hc = y_lines[ col+2 ];
    }
    if( hvtype == HVTYPE_VERTICAL ){
        ha = x_lines[ col ];
        hb = x_lines[ col+1 ];
        hc = x_lines[ col+2 ];
    }
        FOREVER    // scan middle
            if( hb == NULL ) break;
            b_x    =  hb->pos;            // Fetch middle line
            b_sx   =  hb->len;
            b_x2   =  b_x + b_sx + 0;
            lim_x1 = b_x  - THRESHOLD_SPACE; if( lim_x1 < 0 )     lim_x1 = 0;
            lim_x2 = b_x2 + THRESHOLD_SPACE; if( lim_x2 > max_x ) lim_x2 = max_x;
            flag_unmoved = FALSE;

        // ... -------------- TOP LINE -------------- ...
            if( ha != NULL ){
            FOREVER    // scan top
            a_x    =  ha->pos;            // top line
            a_sx   =  ha->len;
            a_x2   =  a_x + a_sx + 0;
            if( check_outside_limits( lim_x1, lim_x2, a_x, a_x2 ) == FALSE ){
                flag_unmoved = TRUE;    //  inside or partially overlapping the bounds.
                break;
            }
            ha = (HV_LINK *) ha->next;            if( ha == NULL )  break;
            ENDFOR   // for
            }else{                      // top line don't exist, so set flag
            flag_unmoved = FALSE;
            }
        // ... -------------- -------- -------------- ...

        // ... -------------- BOTTOM LINE -------------- ...
            if( flag_unmoved == FALSE){
            if( hc != NULL ){
            FOREVER             // scan bottom
            c_x    =  hc->pos;            // bottom line
            c_sx   =  hc->len;
            c_x2   =  c_x + c_sx + 0;
            if( check_outside_limits( lim_x1, lim_x2, c_x, c_x2 ) == FALSE ){	
                flag_unmoved = TRUE;    //  inside or partially overlapping the bounds.
                break;
            }
            hc = (HV_LINK *) hc->next;            if( hc == NULL )  break;
            ENDFOR
            }else{                  // bottom line don't exist, so set flag
            flag_unmoved = FALSE;
            }
            }   // if
        // ... -------------- ----------- -------------- ...


            if( flag_unmoved == FALSE ){    // set for removal of this line.
                // if line size is below threshold, then remove.
                if( b_sx <= THRESHOLD_MIN_SX ){     // short, isolated line
                hb = remove_this_link( hb, col+1 );
                // after a remove, rewind
                if( hvtype == HVTYPE_HORIZONTAL )        hb = y_lines[ col+1 ];
                if( hvtype == HVTYPE_VERTICAL )          hb = x_lines[ col+1 ];
                }else{                              // normal, isolated line
                hb = (HV_LINK *) hb->next;  if( hb == NULL )  break;
                }
            }else{                          // cancel further scanning->
                break;
            }
        ENDFOR
    }
    return 0;
}



// remove a short line, touching a larger line
// the short line must be within the limits of the larger line.
static int remove_diffed_hlines( int hvtype )
{
    int     a_x;
    int     a_x2;
    int     a_sx;
    int     b_x;
    int     b_x2;
    int     b_sx;
    HV_LINK *ha = NULL, *hb = NULL;
    int     col, howmuch=0;

    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy-1;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx-1;
    for( col=0 ; col < howmuch ; col++ ) {
rdh:
    if( hvtype == HVTYPE_HORIZONTAL ){
        ha = y_lines[ col ];
        hb = y_lines[ col+1 ];
    }
    if( hvtype == HVTYPE_VERTICAL ){
        ha = x_lines[ col ];
        hb = x_lines[ col+1 ];
    }
        if( (ha != NULL) && (hb != NULL) ){
            FOREVER    // scan top
            FOREVER    // scan bottom
rdh2:
            a_x    =  ha->pos;            // top line
            a_sx   =  ha->len;
            a_x2   =  a_x + a_sx;

            b_x    =  hb->pos;            // bottom line
            b_sx   =  hb->len;
            b_x2   =  b_x + b_sx;

            // small line (a) on top of big line (b)
            if( ( a_x > b_x ) && ( a_x2 < b_x2 ) ){   // remove small line (a)
            if( ha->flag_type == hb->flag_type ){     // remove of same type
            ha = remove_this_link( ha, col );
            if( ha == NULL )  break;
            if( ha->prev == NULL )  goto rdh2;        // first in link
            }}

            // big line (a) on top of small line (b)
            if( ( a_x < b_x ) && ( a_x2 > b_x2 ) ){   // remove small line (b)
            if( ha->flag_type == hb->flag_type ){     // remove of same type
            hb = remove_this_link( hb, col+1 );
            if( hb == NULL )  break;
//            if( hb->prev == NULL )  goto rdh2;        // first in link
            goto    rdh;
            }}

            hb = (HV_LINK *) hb->next;   if( hb == NULL )  break;
            ENDFOR
            if( hvtype == HVTYPE_HORIZONTAL )  hb = y_lines[ col+1 ];
            if( hvtype == HVTYPE_VERTICAL )    hb = x_lines[ col+1 ];
            if( hb == NULL )  break;
            if( ha == NULL )  break;            // single in line
            ha = (HV_LINK *) ha->next;   if( ha == NULL )  break;
            ENDFOR
        }
    }
    return 0;
}

static int remove_bridge( int hvtype, int type, int _flag_updown );


// two types of bridges
// type A is when ltwo larger lines are joined by a small line
// small line is at Y position while two bigger lines are at Y+1 position.
// Type B is inversed that
static int remove_bridged_hlines( int hvtype, int type )
{
    remove_bridge( hvtype, type, 0 );   // type A
    remove_bridge( hvtype, type, 1 );   // type B
    return 0;
}



// two types of bridges
// type A is when ltwo larger lines are joined by a small line
// small line is at Y position while two bigger lines are at Y+1 position.
// Type B is inversed that
static int remove_bridge( int hvtype, int type, int _flag_updown )
{
    int     a_x;
    int     a_x2;
    int     a_sx;
    int     b_x;
    int     b_x2;
    int     b_sx;
    int     c_x;
    int     c_x2;
    int     c_sx;
    HV_LINK *ha = NULL, *hb = NULL, *hc = NULL;     // ha is bridge
    int     col, coi, howmuch=0, flag_updown = _flag_updown;
    int     up=0, down = 0;

    flag_updown &= 1;
    if( flag_updown ){
        up   = 0;
        down = 1;
    }else{
        up   = 1;
        down = 0;
    }
    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy-1;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx-1;

    for( coi=0 ; coi < howmuch ; coi++ ){

    col = coi;
/*
    if( down ){
    col = howmuch - coi;
        //if(col<0) puts("(***)");
        //return -1;
    }
*/

zrdh:
    if( hvtype == HVTYPE_HORIZONTAL )   ha = y_lines[ col+up ];
    if( hvtype == HVTYPE_VERTICAL )     ha = x_lines[ col+up ];

    if( ha != NULL ){
    FOREVER    // scan top
    a_x    =  ha->pos;            // top line
    a_sx   =  ha->len;
    a_x2   =  a_x + a_sx;
    if( hvtype == HVTYPE_HORIZONTAL )   hb = y_lines[ col+down ];
    if( hvtype == HVTYPE_VERTICAL )     hb = x_lines[ col+down ];
    hc = next_lines( hb, type );
    if( hb == NULL || hc == NULL ) break;

    FOREVER    // scan bottom
    b_x    =  hb->pos;            // bottom line
    b_sx   =  hb->len;
    b_x2   =  b_x + b_sx;
    c_x    =  hc->pos;            // bottom line
    c_sx   =  hc->len;
    c_x2   =  c_x + c_sx;

// todo: must make a threshold, a space before hb and after hc, so
//       lines composed differently don't get eaten up


    //... Type A/B
    if( ha->flag_type == hb->flag_type && ha->flag_type == hc->flag_type ){
    if(
    ( a_sx < b_sx ) && ( a_sx < c_sx ) &&  // match size, bridge is smallest
    ( a_x  > b_x  ) && ( a_x  < c_x  ) &&  // match ha x
    ( a_x2 > b_x2 ) && ( a_x2 < c_x2 ) &&  // match ha x2
//    ( a_x <= b_x2 ) && ( a_x2 >= c_x )     // match ha endpoints to hb, hc points
    ( (a_x-1) <= b_x2 ) && ( (a_x2+1) >= c_x )     // match ha endpoints to hb, hc points
    ){
    hb->len =  ( c_x2 - b_x );
    remove_this_link( ha, col+up   );  // zap away small bridge
    remove_this_link( hc, col+down );  // zap away next line
    goto    zrdh;
    }}
    //... Type A/B
    hb = next_lines( hb, type );   if( hb == NULL )  break;
    hc = next_lines( hb, type );   if( hc == NULL )  break;
    ENDFOR
    ha = next_lines( ha, type );   if( ha == NULL )  break;
    ENDFOR
    }
    }
    return 0;
}


// return spaces(x) of pair of links, if greater than threshold then it's
// valid, else invalid.
// ha is at y
// hb is at y+1
// return -1 if invalid, else return 0
static void validate_space_of_pair( HV_LINK *ha, HV_LINK *hb, int *space1, int *space2, int hvtype )
{
    int     res1=0, res2=0, minpos, maxpos;
    int     sp1=0, sp2=0, sp3=0, sp4=0;
    int     pos1=0, pos2=0, pos3=0, pos4=0;
    int     a_x=0;
    int     a_x2=0;
    int     a_sx=0;
    int     b_x=0;
    int     b_x2=0;
    int     b_sx=0;

    a_x    =  ha->pos;            // top line
    a_sx   =  ha->len;
    a_x2   =  a_x + a_sx ;

    b_x    =  hb->pos;            // bottom line
    b_sx   =  hb->len;
    b_x2   =  b_x + b_sx ;

    minpos = a_x  - THRESHOLD_SPACE;      // threshold
    maxpos = b_x2 + THRESHOLD_SPACE;      // threshold

    // previous space
    sp1 = get_prevspace( ha, ha->flag_type );
    sp2 = get_prevspace( hb, ha->flag_type );
    sp3 = get_nextspace( ha, ha->flag_type );
    sp4 = get_nextspace( hb, ha->flag_type );

    pos1 = a_x - sp1;
    pos2 = b_x - sp2;
    pos3 = a_x2 + sp3;
    pos4 = b_x2 + sp4;

    if( pos3 < maxpos || pos4 < maxpos )
        res2 = -1;      // invalid space
    else
        res2 = 0;     // MIN( sp3, sp4 );

    if( pos1 > minpos || pos2 > minpos )
        res1 = -1;      // invalid space
    else
        res1 = 0;     // MIN( sp1, sp2 );

    *space1 = (res1);
    *space2 = (res2);
}


// Adjust line sizes, so overlapping is avoided
static int rectify_hlines( int hvtype )
{
    int     a_x=0;
    int     a_x2=0;
    int     a_sx=0;
    int     b_x=0;
    int     b_x2=0;
    int     b_sx=0;
    HV_LINK *ha = NULL, *hb = NULL;
    int     overlap = 0;
    int     col, howmuch=0;
    int     sp1=0, sp2=0;

    if( hvtype == HVTYPE_HORIZONTAL ) howmuch = hv_sy-1;
    if( hvtype == HVTYPE_VERTICAL )   howmuch = hv_sx-1;
    for( col=0 ; col < howmuch ; col++ ) {
zo:

    if( hvtype == HVTYPE_HORIZONTAL ){
        ha = y_lines[ col ];
        hb = y_lines[ col+1 ];
    }
    if( hvtype == HVTYPE_VERTICAL ){
        ha = x_lines[ col ];
        hb = x_lines[ col+1 ];
    }

    if( (ha != NULL) && (hb != NULL) ){
        FOREVER    // scan top
        FOREVER    // scan bottom
        a_x    =  ha->pos;            // top line
        a_sx   =  ha->len;
        a_x2   =  a_x + a_sx ;
        b_x    =  hb->pos;            // bottom line
        b_sx   =  hb->len;
        b_x2   =  b_x + b_sx ;

        if( ha->flag_type == hb->flag_type ){   // same type
        overlap = a_x2 - b_x;
        if( ( a_x < b_x ) && ( a_x2 < b_x2 ) && (overlap >= 0) ){  // type A

        validate_space_of_pair( ha, hb, &sp1, &sp2, hvtype );       //printf("sp1=%d sp2=%d \n", sp1, sp2);
            if( sp1 == 0 && sp2 == 0 ){   // space threshold is valid
            if( a_sx > b_sx ){
                ha->len = b_x2 - a_x;
                remove_this_link( hb, col+1   );
            }else{
                hb->len = b_x2 - a_x;
                hb->pos = ha->pos;
                remove_this_link( ha, col   );
            }
            goto    zo;
            }


        }else{

        overlap = b_x2 - a_x;
        if( ( b_x < a_x ) && ( b_x2 < a_x2 ) && (overlap >= 0) ){  // type B

        validate_space_of_pair( hb, ha, &sp1, &sp2, hvtype );
            if( sp1 == 0 && sp2 == 0 ){   // space threshold is valid
            if( a_sx > b_sx ){
                ha->len = a_x2 - b_x;
                ha->pos = hb->pos;
                remove_this_link( hb, col+1   );
            }else{
                hb->len = a_x2 - b_x;
                remove_this_link( ha, col   );
            }
            goto    zo;
            }

        }}

        }       // same type

        hb = (HV_LINK *) hb->next;        if( hb == NULL )  break;
        ENDFOR
        if( hvtype == HVTYPE_HORIZONTAL )  hb = y_lines[ col+1 ];
        if( hvtype == HVTYPE_VERTICAL )    hb = x_lines[ col+1 ];
        if( ha == NULL || hb == NULL )  break;
        ha = (HV_LINK *) ha->next;
        if( ha == NULL )  break;
        ENDFOR
    }
    }
    return 0;
}

