/*
 *  DLL loading, all buttons
 *
 *  Somewhere here, there i will have to include 'windows.h'
 *
 *
 * (dxe loading)
 *
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>        // FA_ARCH
#include <ctype.h>
#include <allegro.h>
#include "types.h"
#include "data.h"
#include "btn.h"
#include "dlg.h"
#include "clip.h"
#include "ll.h"
#include "tb.h"
#include "ed.h"
#include "subs.h"
#include "butil.h"
#include "lod.h"   // dxe2

#include "dll2.h"



    void    (*dxegrey_init)   (void);
    void    (*dxegrey_deinit) (void);
    int     (*dxegrey_method) (BITMAP *,int,int,int,int);
    MTDS    *mtds;             // dxemodule variables
    void    (*dll_init1)( void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *);
    void    (*dll_init2)( void *, void *, void *, void *,
 void *, void *, void *, void *, void *);







// *******************************************
// *******************************************
// *******************************************


static char *dxefilenames[256]; //storage filenames
int number_of_dxe = 0;

struct al_ffblk info;
static char this_is_firstnext=0;
static void prep_findfirstnext()
{
    this_is_firstnext=0;
}
static int do_findfirstnext( byte *mask )
{
    int i;

    if( this_is_firstnext==0 ){
    this_is_firstnext=1;
    i = al_findfirst( mask, (struct al_ffblk *)&info, FA_ARCH );  // return?: 0=ok, else non-zero
    return i;
    }
    if( this_is_firstnext==1 ){
    i = al_findnext(  (struct al_ffblk *)&info );
    return i;
    }
    return -1;
}
static void do_findclose()
{
    al_findclose( (struct al_ffblk *)&info );
}

































/*

  DXE_EXPORT_TABLE (export_code_symbols)
    // ll.h
      DXE_EXPORT ( ll_get_sprite )
    // data.h
      DXE_EXPORT ( g )
    // dlg.h
      DXE_EXPORT (ask_for_filename )
      DXE_EXPORT (dlg_request_uchar)
      DXE_EXPORT (dlg_request_short)
      DXE_EXPORT (dlg_request_int  )
      DXE_EXPORT (dlg_request_float)
  DXE_EXPORT_END


  DXE_EXPORT_TABLE (export_h_symbols)
    //math.h
      DXE_EXPORT (ceil)
      DXE_EXPORT (pow)
    // string.h
      DXE_EXPORT (strrchr)
      DXE_EXPORT (strcat)
      DXE_EXPORT (strncat)
      DXE_EXPORT (strcpy)
      DXE_EXPORT (strncpy)
    // ctype.h
      DXE_EXPORT (toupper)
    // stdio.h
      DXE_EXPORT (exit)
      DXE_EXPORT (fopen)
      DXE_EXPORT (printf)
      DXE_EXPORT (fprintf)
      DXE_EXPORT (sprintf)
      DXE_EXPORT (fread)
      DXE_EXPORT (fwrite)
      DXE_EXPORT (fclose)
      DXE_EXPORT (fgets)
      DXE_EXPORT (puts)
      DXE_EXPORT (putchar)
      DXE_EXPORT (gets)
    // stdlib.h
      DXE_EXPORT (realloc)
      DXE_EXPORT (malloc)
      DXE_EXPORT (errno)
      DXE_EXPORT (free)
    // allegro.h
      DXE_EXPORT (create_bitmap)
      DXE_EXPORT (create_bitmap_ex)
      DXE_EXPORT (destroy_bitmap)
      DXE_EXPORT (drawing_mode)
      DXE_EXPORT (gui_mouse_b)
      DXE_EXPORT (gui_mouse_x)
      DXE_EXPORT (gui_mouse_y)
      DXE_EXPORT (gui_mg_color)
      DXE_EXPORT (mouse_x)
      DXE_EXPORT (mouse_y)
      DXE_EXPORT (mouse_b)
      DXE_EXPORT (scare_mouse)
      DXE_EXPORT (unscare_mouse)
      DXE_EXPORT (font)
      DXE_EXPORT (screen)
      DXE_EXPORT (rect)
      DXE_EXPORT (rectfill)
      DXE_EXPORT (blit)
      DXE_EXPORT (circle)
      DXE_EXPORT (do_line)
      DXE_EXPORT (do_arc)
      DXE_EXPORT (drawing_mode)
      DXE_EXPORT (textout_centre)
      DXE_EXPORT (text_height)
      DXE_EXPORT (text_mode)
      DXE_EXPORT (textout)
      DXE_EXPORT (text_length)
      DXE_EXPORT (broadcast_dialog_message)
      DXE_EXPORT (getpixel)
      DXE_EXPORT (putpixel)
      DXE_EXPORT (set_palette)
      DXE_EXPORT (set_pallete)
      DXE_EXPORT (get_palette)
      DXE_EXPORT (clear_to_color)
      DXE_EXPORT (hline)
      DXE_EXPORT (vline)
      DXE_EXPORT (line)
      DXE_EXPORT (getr)
      DXE_EXPORT (getg)
      DXE_EXPORT (getb)
      DXE_EXPORT (makecol)
      DXE_EXPORT (clear)
  DXE_EXPORT_END

*/

void dump_mtds( MTDS *mt )
{
    if( mt == NULL ){puts("ERROR: MTDS structure is NULL !!!\n"); return; }
    puts("------------ MTDS structure inside DXE module ---------------");
    printf("class             : '%s'\n", mt->class              );
    printf("author            : '%s'\n", mt->author             );
    printf("compiled date     : '%s'\n", mt->compiled_date      );
    printf("version           : '%s'\n", mt->version            );
    printf("tooltips          : '%s'\n", mt->tooltips           );
    printf("description       : '%s'\n", mt->description        );
    printf("help              : '%s'\n", mt->help               );
    printf("pre_callback_type :  %d \n", mt->pre_callback_type  );
    printf("post_callback_type:  %d \n", mt->post_callback_type );
    printf("invoke_dialog     :  %d \n", mt->invoke_dialog      );
    printf("obey_loop_flag    :  %d \n", mt->obey_loop_flag     );
    printf("type              :  %d \n", mt->type               );
    puts("");
}


void *errhandler (const char *input)
{
    printf("* unresolved symbol: '%s'\n", input );
    return NULL;
}






void initialize_dxemodules()
{
    LODUSERDATA     *lod = NULL;
    int     i,j;
    int         error_happened = FALSE;
    char        *errstr  = NULL;
    //...
    char        *strfile = NULL;
    char        *strdxedir=NULL;
    char        *strmask  =NULL;
    //...
    BITMAP      *bm = NULL;

//alert("_________","*000*", "_______", "OK",NULL,1,2);


    lod_initsys();





    // ************* load all dxe filenames *************
    strfile     = alloc_string( NULL, FILENAME_MAX + 22 );
    strdxedir   = "dllbtn/";
    strmask     = "*.dll";
    strncpy( strfile, strdxedir, FILENAME_MAX );
    strncat( strfile, strmask,   FILENAME_MAX );//    printf("dxe dir mask: '%s'\n", strfile );

    prep_findfirstnext();
    for(i=0;i<255;i++) dxefilenames[i] = NULL;
    j=0;

    for(;;){
    i = do_findfirstnext( strfile );
        if(i<0) break;
            strncpy( strfile, strdxedir,    FILENAME_MAX );
            strncat( strfile, info.name,    FILENAME_MAX );//  printf("file: <%s>  <%s>\n",info.name ,strfile );
            dxefilenames[j] = alloc_string( strfile, -1 );
//msgbox_("!!!<%s>!!! i=%d j=%d",dxefilenames[j], i, j);
        j++;
        if( j > 255 ) break;
    }
    do_findclose();



    free_string( strfile );
    dxefilenames[j] = NULL;         // last filename
    number_of_dxe = j;
    // ************* load all dxe filenames *************

//    if( handle > 0 ) _findclose(handle);
    lod_rewind();

//msgbox_(" *** 1 *** " );




    // ****************************************************************
    // Now try to load the modules and resolve all unresolved symbols

    for(i=0;;i++){
    if( dxefilenames[ i ]==NULL) break;
    dxegrey_init   = NULL;
    dxegrey_deinit = NULL;
    dxegrey_method = NULL;
    mtds           = NULL;
    // ---------------------------------------------------------------

    if( dll_load(  dxefilenames[i] ) == 1){    // error ocurred
msgbox_(" ERROR:  <%s> ", dxefilenames[i] );
        lod_store( dxefilenames[i], NULL,NULL,NULL,NULL, errstr );
        lod_rewind();
    }else{              // load ok.
//alert("_________","*INIT*", dxefilenames[i], "OK",NULL,1,2);
//msgbox_(" INIT <%s> ", dxefilenames[i] );
    dll_init1(
        &create_bitmap, &create_bitmap_ex, &create_sub_bitmap, &destroy_bitmap,
        &bitmap_color_depth, &bitmap_mask_color, &set_clip, &load_bitmap,
        &save_bitmap, &register_bitmap_file_type, &set_color_conversion,
        &set_color, &set_palette, &get_color, &get_palette, &makecol8, &makecol15,
        &makecol16, &makecol24, &makecol32, &makecol, &makecol_depth, &getr, &getg,
        &getb, &geta, &getr_depth, &getg_depth, &getb_depth, &geta_depth,
        &getpixel, &putpixel, &vline, &hline, &do_line, &line, &triangle, &polygon,
        &rect, &rectfill, &do_circle, &circle, &circlefill, &do_ellipse, &ellipse,
        &ellipsefill, &floodfill, &clear_bitmap, &clear, &clear_to_color, &blit,
        &masked_blit, &stretch_blit, &masked_stretch_blit, &draw_sprite,
        &draw_sprite_v_flip, &draw_sprite_h_flip, &draw_sprite_vh_flip,
        &draw_character, &rotate_sprite, &stretch_sprite, &text_mode, &textout,
        &textout_centre, &textout_right, &textout_justify, &textprintf,
        &textprintf_centre, &textprintf_right, &textprintf_justify, &text_length,
        &text_height, &destroy_font, &bestfit_color, &hsv_to_rgb, &rgb_to_hsv,
        &scare_mouse, &unscare_mouse );
    dll_init2(
        &ask_for_filename,
        &dlg_request_uchar,
        &dlg_request_short,
        &dlg_request_int,
        &dlg_request_float,
        &ll_get_sprite,
        &ceil,
        &pow,
        &g        );

        lod_store( dxefilenames[i], dxegrey_init, dxegrey_deinit, dxegrey_method, mtds, NULL );
        lod_next();
    }

    // ---------------------------------------------------------------


    }

    // ****************************************************************



//alert("_________","*2*", "_________", "OK",NULL,1,2);
//exit(1);

//msgbox_(" *** 2 *** " );


    lod_rewind();
    lod_sort_criteria2();
    lod_sort_criteria1();


    if( g.flag_verbose==TRUE )  puts("DXE files ");

    for( i=0,j=0 ;  ; i++ ){
    if( main_tb[ i ].description==NULL ) break;



    if( main_tb[ i ].is_dxe==1 ){
        if( dxefilenames[ j++ ]==NULL ){
            main_tb[ i ].is_dxe = 0;
            main_tb[ i ].description = NULL;    // make end
            break;
        }



    lod = lod_get_loduserdata();
    if(lod==NULL){ error_("lod-> link failure"); }
    dxegrey_init    = lod->dxe_init;
    dxegrey_deinit  = lod->dxe_deinit;
    dxegrey_method  = lod->dxe_method;
    mtds            = lod->mtds;


    if( g.flag_verbose==TRUE ){
        printf("File: '%s' ",    lod->dxefilename );
        printf("status: '%d' ",  lod->status );
        printf("errstr: '%s'\n", lod->error  );
    }


        if( lod->status == 1 ){     // only working dxe's are used
        if( dxegrey_method == NULL){ error_("dxegrey_method == NULL" );}
        if( mtds == NULL){ error_("mtds == NULL" );}

        main_tb[ i ].dialog         = mtds->invoke_dialog;
        main_tb[ i ].mouse_number   = 0;
        main_tb[ i ].stickyflag     = 0;
        main_tb[ i ].loop_flag      = mtds->obey_loop_flag;
        main_tb[ i ].method_index   = 0;

        main_tb[ i ].pre_callback   = NULL;
        if( mtds->pre_callback_type == 1) main_tb[ i ].pre_callback = precall_1;
        if( mtds->pre_callback_type == 2) main_tb[ i ].pre_callback = precall_2;

        main_tb[ i ].callback          = NULL;

        main_tb[ i ].pre_dxecallback   = dxegrey_init;
        main_tb[ i ].dxecallback       = dxegrey_method;
        main_tb[ i ].post_dxecallback  = dxegrey_deinit;

        main_tb[ i ].post_callback  = NULL;
        if( mtds->post_callback_type == 1) main_tb[ i ].post_callback = postcall_1;
        if( mtds->post_callback_type == 2) main_tb[ i ].post_callback = postcall_2;
        if( mtds->post_callback_type == 3) main_tb[ i ].post_callback = refix_all_display;

//        main_tb[ i ].clickedbmp     = make_30x30icon( mtds->icon_pressed    );
//        main_tb[ i ].unclickedbmp   = make_30x30icon( mtds->icon_unpressed  );

        bm = create_bitmap( tb_esx, tb_esy );
        stretch_blit( make_30x30icon( mtds->icon_pressed ), bm, 0, 0, 30, 30,0, 0, tb_esx, tb_esy );
        main_tb[ i ].clickedbmp = bm;
        bm = create_bitmap( tb_esx, tb_esy );
        stretch_blit( make_30x30icon( mtds->icon_unpressed ), bm, 0, 0, 30, 30,0, 0, tb_esx, tb_esy );
        main_tb[ i ].unclickedbmp = bm;



if( mtds->icon_pressed == NULL || mtds->icon_unpressed   == NULL ){
    puts("ERROR: button icons are NULL...");
}
if(main_tb[ i ].clickedbmp == NULL || main_tb[ i ].unclickedbmp == NULL ){
    puts("ERROR: button bitmaps are NULL...");
}


        main_tb[ i ].description    = alloc_string(   mtds->description, -1 );
        }else{ error_happened = TRUE; }
        lod_next();
    }
    }
    if( error_happened == TRUE ){
        puts("\nDXE LOAD ERROR:   (dxefile will not be loaded/accessed)");
        puts("      On unresolved symbols use");
        puts("      LD -v dxe.o");
        puts("      to view all unresolved symbols in the dxe.");
        puts("      also make sure functions are exported like this:");
        puts("      DXE_EXPORT (create_bitmap_ex)");
        puts("      in callers code, so the dxe can reach the function.\n");
    }
//    printf("g.buttoncolor=%d\n", g.buttoncolor );
    lod_rewind();
}


