/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\



  dialogs



 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <allegro.h>
#include "global.h"
#include "data.h"
#include "zoom.h"
#include "ll.h"
#include "ed.h"
#include "comdlg.h"
#include "btn.h"
#include "dlg.h"
#include "subs.h"
#include "butil.h"
#include "dlg.h"
#include "libfli/fli.h"
#include "libgif/gif_lib.h"



char *filemasks = "All files (*.*)\0*.*\0\
Windows Bitmap (*.bmp)\0*.BMP\0\
unisys Graphic interchange (*.gif)\0*.GIF\0\
Amiga IFF (*.lbm:*.iff)\0*.lbm;*.iff\0\
Zsoft Paintbrush (*.pcx)\0*.PCX\0\
Portable Bitmap 1-bit (*.pbm)\0*.pbm\0\
Portable Graymap 8-bit (*.pgm)\0*.pgm\0\
Portable Pixmap 24-bit (*.ppm)\0*.ppm\0\
Truevision Targa (*.tga)\0*.TGA\0\
Xwindows Bitmap (*.xbm)\0*.XBM\0\
Kisekae,16 colors (*.cel)\0*.CEL\0\
Tagged Image Format (*.tif)\0*.TIF;*.tiff\0\
Jpeg Jfif compliant (*.jpg;*.jpeg)\0*.JPG;*.jif;*.jpeg\0\
FLI/FLC file (*.fli;*.flc)\0*.fla;*.flb;*.fli;*.flc;*.flh;*.flt\0\0";












//static char *filemasks2 = "BMP;GIF;IFF;LBM;PBM;PCX;PGM;PNM;PPM;TGA;XBM;CEL;FLA;FLB;FLI;FLC;FLH;FLT";









/***          Prototypes for helper functions           ***/
/***                                                    ***/
static void init_userwindow_colors(int color);
static void deinit_userwindow_colors(void);
static int aalert( void );
static int s_popupbox_nonsticky(int msg, DIALOG *d, int c);
static void set_color_onpal(int index, RGB *p, RGB *pal);
unsigned char *ask_for_filename( unsigned char *str );
/***                                                    ***/
/***          Prototypes for helper functions           ***/


/**** Common Data for all dialog functions ****/
static  PALETTE opal;
static  int file_gui1,   file_gui2;
        int file_color1, file_color2, file_color3;

static  RGB file_rgb1 = {20,30,34};
static  RGB file_rgb2 = {40,50,60};
static  RGB file_rgb3 = {50,50,20};


static unsigned char nums1[30];
static char *pathptr=NULL;

    static char stmp1[522];
    static char stmp2[522];

/*
    static char *stickypath=NULL, *stickypathbkmap=NULL;
*/
static char string0[40], string1[40], string2[40], string3[40];

/**** Common Data initialization for all dialog functions ****/





// ---------------------------------------------------------------------------
// common thingys for all dialogs
static int  dlg_ret_val=0;              // used by all dialogs,return values for dlgs,0=cancel,1=ok
static void s_btn_ok(DIALOG *d);        // used by all dialogs
static void s_btn_cancel(DIALOG *d);    // used by all dialogs

static void s_btn_ok(DIALOG *d)
{
    wait_for_mousebutton_release();
    dlg_ret_val=1;
}
static void s_btn_cancel(DIALOG *d)
{
    wait_for_mousebutton_release();
    dlg_ret_val=0;
}



// ---------------------------------------------------------------------------


/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                       RESIZE ALL BLOCKS INTO NEW SIZES

        void dlg_resize_canvas(void)

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/
/*             "old size is: 99999 x 99999 "*/

/** helper functions **/
static int rs_edit1(int msg, DIALOG *d, int c); /* label+edit */
static int rs_editcomp1(int msg, DIALOG *d, int c);
static int rs_editcomp2(int msg, DIALOG *d, int c);
static int dlg_subwindow_sub( char * );
static void dlg_res3x_canvas( char *, char *, char );
static void report_error();
/** helper functions **/

static int resize_flag = FALSE;

//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_resizecanvas[]={
{ ed_win        ,0,0,230,200,0,0,  0,0,1,1, NULL,NULL,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,0,0,0, (char *)&string1,NULL ,NULL},
{ ed_check      ,0,0, 12, 12,0,0,  0,0,0,0, "", (int *)&resize_flag,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,0,0,0, "Mantain aspect ratio",NULL,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,0,0,0, (char *)&string0,NULL ,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,0,0,0, "New sizes:",NULL ,NULL},
{ rs_editcomp1  ,0,0, 40, 24,0,0,  0,0,4,0, (char *)&string2, "sx:",NULL},
{ rs_editcomp2  ,0,0, 40, 24,0,0,  0,0,4,0, (char *)&string3, "sy:",NULL},
{ ed_button_exit,0,0, 80, 22,0,0,'o',0,0,0, "OK",s_btn_ok,NULL},
{ ed_button_exit,0,0, 80, 22,0,0, 27,0,0,0, "CANCEL",s_btn_cancel,NULL},
{ NULL }};
#define RS_EDITCOMP1 6
#define RS_EDITCOMP2 7
#define MSG_ED_GET  MSG_USER+1
#define MSG_ED_PUT  MSG_USER+2

DIALOGXYCOORDS dlg_resizecanvas2[]={
{   0,  0  },
{  20, 35  },
{  20, 60  },
{  40, 60  },
{  40, 70  },
{  20, 95  },
{  60, 110 },
{ 150, 110 },
{  20, 160 },
{ 130, 160 },
{   0,  0  }};


static int      dlgsx, dlgsy;
static float    ratio, iratio;
static int      rsed1, rsed2;



void dlg_resize_canvas(void) /********************************************/
{
    dlg_res3x_canvas( "Resize canvas","resizing...",0 );
}                            /********************************************/
void dlg_rescale_canvas(void) /********************************************/
{
    dlg_res3x_canvas( "Rescale canvas","rescaling...",1 );
}                            /********************************************/


/*
 * caption  : main window caption
 * scaption : small window caption
 * method   : 0=resize, 1=rescale, 2=resample greyscale, 3=resample color
 *            resample not implemented yet.
 */
/* UPDATE:
 * fails sometimes ...
 * 537 x 768 -> 537 x 600 - failure...why?...don't know...
 *
 */
static void dlg_res3x_canvas( char *caption, char *scaption, char method )
{
    BITMAP  *pspr1=NULL, *pspr2=NULL;
    int         i,n;
    LINKS   *link1=NULL, *link2=NULL;
    INFOWIN *inf = NULL;
    int     ret;

    method &= 1;
    ret = dlg_subwindow_sub( caption );

//readkey();

    if( ret==FALSE || dlgsx<=0 || dlgsy<=0 ){
        wait_for_mousebutton_release();
        return;
        }
    /* check sizes, if the same as previous then no change. */
    if( g.sx==dlgsx && g.sy==dlgsy ){ /* equals, no change */
        wait_for_mousebutton_release();
        return;
        }



    if( dlgsx <= 0 ) dlgsx = 1;
    if( dlgsy <= 0 ) dlgsy = 1;


//readkey();




    if( g.dxe_bitmap != NULL ) destroy_bitmap( g.dxe_bitmap ); g.dxe_bitmap = NULL;



    // **** reallocate chains... ****
    inf = infowin_on( scaption, file_color3, file_color1 );



    pspr2 = create_bitmap(dlgsx, dlgsy); // transitional destination bitmap
    if(pspr2==NULL){
        infowin_off( inf );
        report_error();
        return;
        }
    clear_bitmap( pspr2 );








    /* new sizes, reallocate base bitmaps */
    g.bkmap.sx = dlgsx;
    g.bkmap.sy = dlgsy;
    if( g.flag_bkmap == TRUE ){        // background map is active

        if( g.bkmap.map != NULL ) destroy_bitmap( g.bkmap.map );
        g.bkmap.map = create_bitmap( g.bkmap.sx, g.bkmap.sy );
        if( g.bkmap.map==NULL ){
            g.flag_bkmap = FALSE;
            infowin_off( inf );
            report_error();
            return;
        }
    }






    n     = ll_return_spr_count();
    link1 = ll_get_nodesystem_ptr();    // old


    ll_init( dlgsx, dlgsy, g.bpp );
    link2 = ll_get_nodesystem_ptr();    // new

    if(link1==NULL||link2==NULL){ report_error(); return; }






    for(i=0; i<n ;i++){
        ll_set_nodesystem_ptr( link1 ); //old
        pspr1 = ll_get_sprite( 0 );                 if(pspr1==NULL) { report_error(); return; }
    if(method==0)                               /* resize */
        blit(pspr1, pspr2,0,0,0,0,dlgsx,dlgsy);
    if(method==1)                               /* rescale */
        stretch_blit(pspr1, pspr2,0,0,g.sx,g.sy,0,0,dlgsx,dlgsy);

        ll_set_nodesystem_ptr( link2 ); // new
        ll_append_tail( pspr2 );
        ll_set_nodesystem_ptr( link1 ); // old
        ll_remove( 0 );
    }






    ll_set_nodesystem_ptr( link2 );   // new
    ll_kill_nodesystem( link1 ); link1=NULL;     // old
    g.sx = dlgsx;
    g.sy = dlgsy;
    destroy_bitmap( pspr2 );    pspr2=NULL;
    ll_set_nodesystem_ptr( link2 );   // new



        /* fix range for slider bars */
        main_dialog[IDX_SLIDEX].flags = D_HIDDEN | D_DISABLED;
        main_dialog[IDX_SLIDEY].flags = D_HIDDEN | D_DISABLED;
        main_dialog[IDX_SLIDEX].d1 = g.sx-1;
        main_dialog[IDX_SLIDEX].d2 = 0;
        main_dialog[IDX_SLIDEY].d1 = g.sy-1;
        main_dialog[IDX_SLIDEY].d2 = g.sy-1;
        main_dialog[IDX_SLIDEX].flags = 0;
        main_dialog[IDX_SLIDEY].flags = 0;
        g.ox = g.oy = 0;

    // TESTing...
    if(g.bmp0 !=NULL){ destroy_bitmap(g.bmp0);  g.bmp0= NULL;}
    if(g.bmp1 !=NULL){ destroy_bitmap(g.bmp1);  g.bmp1= NULL;}
    if(g.bmp2 !=NULL){ destroy_bitmap(g.bmp2);  g.bmp2= NULL;}
    if(g.bmp3 !=NULL){ destroy_bitmap(g.bmp3);  g.bmp3= NULL;}
    if(g.bmp4 !=NULL){ destroy_bitmap(g.bmp4);  g.bmp4= NULL;}
    // TESTing...


    if( g.layer0 != NULL ){
            destroy_bitmap( g.layer0 );
            g.layer0 = create_bitmap_clear( g.sx, g.sy );
            }
//    md_zoom=0;
//    md_unzoom_sx=0;
//    md_unzoom_sy=0;

    infowin_off( inf );
    in_display();
    refresh_screen();
    wait_for_mousebutton_release();
}                            /********************************************/








static void report_error()
{
    INFOWIN *inf=NULL;

    inf = infowin_on( "ERROR!", file_color3, file_color1 );
    readkey();
    infowin_off( inf );
    wait_for_mousebutton_release();
}


/* perform "resize,rescale,resample" generic window popup.
 *
 * return TRUE if OK was pressed, else FALSE
 * returns the new sizes in dlgsx and dlgsy.
 */
static int dlgpresskeystat; /* used to detect button "ok" */

static int dlg_subwindow_sub( char *main_caption )
{
    float fa, fb;


    dlgpresskeystat = FALSE;
    dlgsx = g.sx;
    dlgsy = g.sy;

    dlg_resizecanvas[0].dp = main_caption;

    /* init */
    resize_flag = FALSE;
    fa = g.sx;
    fb = g.sy;
    ratio  = fa/fb;
    iratio = fb/fa;
    sprintf(string0, "of 1 to %4.4f", ratio );
    sprintf(string1, "Old sizes: %d x %d", g.sx, g.sy);
    sprintf(string2, "%d", g.sx);
    sprintf(string3, "%d", g.sy);

    prepare_prefix_dlgs( dlg_resizecanvas, dlg_resizecanvas2,-1,-1,128 );
    do_dialog(dlg_resizecanvas, -1);
    prepare_suffix_dlgs( dlg_resizecanvas, dlg_resizecanvas2 );

    if(dlg_ret_val==1){    // ok is pressed
    /* read strings and convert */
    dlgsx = atoi( (char *)&string2 );
    dlgsy = atoi( (char *)&string3 );
    dlgpresskeystat = TRUE;
    }

    return (dlgpresskeystat);
}

/* label + edit box */
static int rs_edit1(int msg, DIALOG *d, int c)
{
    int ret;
    switch( msg ){
    case MSG_DRAW:
    text_mode(0);
    textout(screen, font, d->dp2, d->x - (text_length(font, d->dp2)+9) , d->y , d->fg );
    ret = d_edit_proc(msg, d,  c);
    default:
    ret = d_edit_proc(msg, d,  c);
    break;
    }
    return ret;
}
static int rs_editcomp1(int msg, DIALOG *d, int c)  /* sx: _____ */
{
    float f1,f2;

    switch( msg ){

    case MSG_ED_GET:    /* get */
    rsed1 = atoi ( d->dp );
    msg=D_O_K;
    break;

    case MSG_ED_PUT:    /* put */
    sprintf(d->dp, "%d",rsed1);
    msg=D_O_K;
    break;

    case MSG_GOTFOCUS:
    if( resize_flag==TRUE ){
    rsed1 = atoi ( d->dp );
    object_message( &dlg_resizecanvas[RS_EDITCOMP1], MSG_ED_GET, 0 );
    object_message( &dlg_resizecanvas[RS_EDITCOMP2], MSG_ED_GET, 0 );


    f1= rsed1;
    f2= rsed2;
    f1 = f2 * ratio;
    rsed1 = f1;
    object_message( &dlg_resizecanvas[RS_EDITCOMP1], MSG_ED_PUT, 0 );
    object_message( &dlg_resizecanvas[RS_EDITCOMP1], MSG_DRAW, 0 );
    }
    msg = D_O_K;
    break;

    default:
    msg = rs_edit1(msg, d,  c);
    break;
    }
    return msg;
}
static int rs_editcomp2(int msg, DIALOG *d, int c)  /* sy: _____ */
{
    float f1,f2;

    switch( msg ){

    case MSG_ED_GET:    /* get */
    rsed2 = atoi ( d->dp );
    msg=D_O_K;
    break;

    case MSG_ED_PUT:    /* put */
    sprintf(d->dp, "%d",rsed2);
    msg=D_O_K;
    break;

    case MSG_GOTFOCUS:
    if( resize_flag==TRUE ){
    rsed1 = atoi ( d->dp );
    object_message( &dlg_resizecanvas[RS_EDITCOMP1], MSG_ED_GET, 0 );
    object_message( &dlg_resizecanvas[RS_EDITCOMP2], MSG_ED_GET, 0 );
    f1= rsed1;
    f2= rsed2;
    f2 = f1 * iratio;
    rsed2 = f2;
    object_message( &dlg_resizecanvas[RS_EDITCOMP2], MSG_ED_PUT, 0 );
    object_message( &dlg_resizecanvas[RS_EDITCOMP2], MSG_DRAW, 0 );
    }
    msg = D_O_K;
    break;

    default:
    msg = rs_edit1(msg, d,  c);
    break;
    }
    return msg;
}









/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                        POPUP BKMAP DIALOG WINDOW

    void dlg_select_bkmap( int mx, int my )

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/

/** helper functions **/
static int s_radio_op(int,DIALOG *,int); /*generic radio button handler*/
static void s_btn_type5(DIALOG *d);
static int _ed_check1(int, DIALOG *, int);
static int _ed_check2(int, DIALOG *, int);
static int _ed_check3(int, DIALOG *, int);
static int _ed_check4(int, DIALOG *, int);
/** helper functions **/

int     flag1,flag2,flag3,flag4,flgbkmap1;
static  char numstring1[22];
#define EDCHECK1 7
#define EDCHECK2 8
#define EDCHECK3 9
#define EDCHECK4 10

//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_bkmap[]={
{ ed_win        ,0,0,230,200,0,0,  0,     0, 1,  1, "Select Backgroundmap",NULL,NULL},
{ ed_framecheck ,0,0,190, 12,0,0,  0,D_USER,-1,105, "ENABLED",(int *)&flgbkmap1,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,     0, 0,  0, "Backgroundmap is:",NULL,NULL},
{ _ed_check1    ,0,0, 12, 12,0,0,  0,     0,-1,  0, "", (int *)&flag1,NULL},
{ _ed_check2    ,0,0, 12, 12,0,0,  0,     0,-1,  0, "", (int *)&flag2,NULL},
{ _ed_check3    ,0,0, 12, 12,0,0,  0,     0,-1,  0, "", (int *)&flag3,NULL},
{ _ed_check4    ,0,0, 12, 12,0,0,  0,     0,-1,  0, "", (int *)&flag4,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,     0, 0,  0, "Number",NULL,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,     0, 0,  0, "-1",NULL,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,     0, 0,  0, "+1",NULL,NULL},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,     0, 0,  0, "File"  ,NULL,NULL},
{ d_edit_proc   ,0,0, 60, 18,0,0,  0,     0, 6,  0, numstring1,NULL,NULL},
{ ed_button     ,0,0, 60, 18,0,0,  0,     0, 0,  0, "File...",s_btn_type5,NULL},
{ ed_button_exit,0,0, 80, 22,0,0,'o',     0, 0,  0, "OK",s_btn_ok,NULL},
{ ed_button_exit,0,0, 80, 22,0,0, 27,     0, 0,  0, "CANCEL",s_btn_cancel,NULL},
{ NULL }};
#define EDCHK1 3
#define EDCHK2 4
#define EDCHK3 5
#define EDCHK4 6
DIALOGXYCOORDS dlg_bkmap2[]={
{   0,    0 },
{  20,  140 },
{  40,   26 },
{  30,   50 },
{  30,   70 },
{  30,   90 },
{  30,  110 },
{  50,   50 },
{  50,   70 },
{  50,   90 },
{  50,  110 },
{ 120,   50 }, //
{ 120,  110 },
{  20,  165 },
{ 130,  165 },
{   0,    0 }};


static int brushsize, brushtype;
/********************************************/
/**                                        **/
/**                                        **/
/**    Popup Bkmap selection               **/
/**                                        **/
/**                                        **/
void dlg_select_bkmap( int mx, int my )    /* input: mouse x,y */
{
    int i;
    brushsize = g.brush.size;
    brushtype = g.brush.type & 3;

    flag1=flag2=flag3=flag4=FALSE;
    for(i=0;i<sizeof(numstring1);i++) numstring1[i]=0;

    flag1=flag2=flag3=flag4=FALSE;
    g.bkmap.type &= 3;
    if( g.bkmap.type==0 ) flag1=TRUE;
    if( g.bkmap.type==1 ) flag2=TRUE;
    if( g.bkmap.type==2 ) flag3=TRUE;
    if( g.bkmap.type==3 ) flag4=TRUE;
    flgbkmap1 = g.flag_bkmap;
    sprintf( numstring1, "%d",g.bkmap.nr);

    prepare_prefix_dlgs( dlg_bkmap, dlg_bkmap2,-1,-1,128 );
    do_dialog( dlg_bkmap, -1 );
    prepare_suffix_dlgs( dlg_bkmap, dlg_bkmap2 );

    if( dlg_ret_val==1 ){
    g.flag_bkmap = flgbkmap1;
    if( flgbkmap1 == TRUE){    /* click ok, enabled */
        /* if any of 3 flags is set, then allocate if needed... */
        if(flag1==TRUE || flag2==TRUE || flag3==TRUE){
            if( g.bkmap.map == NULL){
                g.bkmap.map = create_bitmap( g.bkmap.sx, g.bkmap.sy );
                if( g.bkmap.map==NULL ){
                    error_("allocating bitmap %d x %d",g.bkmap.sx, g.bkmap.sy );
                }else{
                    clear_bitmap( g.bkmap.map );
                }
            }
            if( g.bkmap.sMD == NULL){
                g.bkmap.sMD = create_bitmap( md_sx+12, md_sy+12 );
                if( g.bkmap.sMD==NULL ){
                    error_("allocating bitmap %d x %d",md_sx+12, md_sy+12);
                }else{
                    clear_bitmap( g.bkmap.sMD );
                }
            }
        }

    if(flag1==TRUE){    g.bkmap.type = 0;  // number
                        g.bkmap.nr   = atoi( numstring1 );
                   }
    if(flag2==TRUE)     g.bkmap.type = 1;  // -1
    if(flag3==TRUE)     g.bkmap.type = 2;  // +1
    if(flag4==TRUE)     g.bkmap.type = 3;  // file

    }
    }
    scare_mouse();
    display_zoomed_md();
    unscare_mouse();
}


//DIALOG dlg_ie3[];
//DIALOGXYCOORDS dlg_ie4[];
//static int map_to_current;





static void s_btn_type5(DIALOG *d)   /* load map from file */
{
    INFOWIN *inf;
    int i1,i2,i;
    char *filename;

    if( flgbkmap1==FALSE) return;
        /* ... */
        /* ... */
        /* ... */
//    if(stickypathbkmap==NULL)  stmp2[0]=0;
//    stickypathbkmap = (char *)&stmp2;

    i1 = gui_bg_color;
    i2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color2;
    pathptr = commdlg_load( "Load Background map", NULL, filemasks,NULL,(int *)&i );
    gui_bg_color = i1;
    gui_fg_color = i2;

    if(i!=-1||pathptr!=NULL){  /* if cancel wasn't pressed... */
//        strncpy( stickypathbkmap, pathptr, 512 );
//        st = strrchr( stickypathbkmap, '\\');
//        *st++='\\';
//        *st++=0;
    }



        /* ... */
        /* ... */
        /* ... */
    if( pathptr    != NULL ) {
    if( pathptr[0] != 0    ) {
            filename = fix_filename_case( pathptr );
            filename = fix_filename_slashes( filename );

            inf = infowin_on("Loading...", file_color3, file_color1 );
            if( g.bkmap.map != NULL) destroy_bitmap( g.bkmap.map );
            g.bkmap.map = load_bitmap( filename, (RGB *)&g.palette_remap );
            infowin_off( inf );
                if( g.bkmap.map != NULL){
                    i = dialog_popup_import_graphic( FALSE );
                    if(i==TRUE)
                        remap_bitmap_to_gpalette(g.bkmap.map, (RGB *)&g.palette_remap );
                }
    }}
        /* ... */
        /* ... */
        /* ... */
}

/* on MSG_USER, set flag oto FALSE */
static int s_radio_op(int msg, DIALOG *d, int c) /*fill op radio btns, base*/
{
    int *flagptr;
    flagptr = (int *)d->dp2;
    switch( msg ){
    case MSG_USER:    *flagptr = FALSE;    scare_mouse();
    msg = ed_set(MSG_DRAW,d,c);    unscare_mouse();    msg=D_O_K;    break;
    default:
    msg = ed_set(msg,d,c);    break;
    }
    return msg;
}
static int _ed_check1(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_bkmap[EDCHK2] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK3] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK4] , MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int _ed_check2(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_bkmap[EDCHK1] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK3] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK4] , MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int _ed_check3(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_bkmap[EDCHK1] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK2] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK4] , MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}
static int _ed_check4(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    object_message( &dlg_bkmap[EDCHK1] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK2] , MSG_USER, 0 );
    object_message( &dlg_bkmap[EDCHK3] , MSG_USER, 0 );
    }
    return s_radio_op(msg,d,c);
}














/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                SELECT PALETTE RGB COLOR

    dlg_select_rgb_bpp8( unsigned char c )

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/

#define DRAWNUMBOX \
    rect(screen, x, y, x+ 3*8*1+2 , y + d->h, g.syscolor1 );\
    map1 = create_bitmap(3*8*2+8, 1*8*2+8); if(map1==NULL) error_("cant allocate bitmap");\
    clear_bitmap(map1);\
    sprintf( (char *)&nums1, "%3u", d->d2 );\
    text_mode(-1);\
    textout(map1, font, (char *)&nums1,1,1, g.syscolor1 );\
    scare_mouse();     \
    acquire_screen();   \
    stretch_blit(map1,screen, 0,0,3*8+1,1*8+2, x+1,y+1, 3*8*1+1, d->h-1);\
    release_screen();    \
    unscare_mouse();     \
    destroy_bitmap(map1);

#define DRAWNUMBOX2(z) \
    rect(screen, x, y, x+ 3*8*2+2 , y + 1*8*2+3 , g.syscolor1);\
    map1 = create_bitmap(3*8*2+8, 1*8*2+8); if(map1==NULL) error_("cant allocate bitmap");\
    clear_bitmap(map1);\
    sprintf( (char *)&nums1, "%3u", z);\
    text_mode(-1);\
    textout(map1, font, (char *)&nums1,1,1, g.syscolor1 );\
    scare_mouse();     \
    acquire_screen();     \
    stretch_blit(map1,screen, 0,0,3*8+1,1*8+2, x+1,y+1, 3*8*2+1, 1*8*2+2);\
    release_screen();     \
    unscare_mouse();     \
    destroy_bitmap(map1);

/*** Prototypes for helper functions ***/
static int s_slidex(int msg, DIALOG *d, int c);
static int s_slide1(void *dp3, int d2);
static int s_slide2(void *dp3, int d2);
static int s_slide3(void *dp3, int d2);
static int s_last(int msg, DIALOG *d, int c);   /* draw colorbox */
static int s_btn_imp(int msg, DIALOG *d, int c);
static int s_btn_exp(int msg, DIALOG *d, int c);
/*** Prototypes for helper functions ***/

static RGB popup_rgb1 = {0,0,0},  popup_rgb2 = {0,0,0};


//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_rgb[]={
{ ed_win        ,0,0,320,200,0,0,  0,0,  1,1, "Change Color", NULL, NULL },
{ s_slidex      ,0,0,200, 20,0,0,'r',0,255,0, NULL, s_slide1, NULL },
{ s_slidex      ,0,0,200, 20,0,0,'g',0,255,0, NULL, s_slide2, NULL },
{ s_slidex      ,0,0,200, 20,0,0,'b',0,255,0, NULL, s_slide3, NULL },
{ ed_button_exit,0,0, 80, 22,0,0,'o',0,  0,0, "OK", s_btn_ok, NULL },
{ ed_button_exit,0,0, 80, 22,0,0, 27,0,  0,0, "CANCEL", s_btn_cancel, NULL },
{ s_last        ,0,0, 50, 90,0,0,  0,0,  0,0, NULL, NULL, NULL },
{ NULL}};
DIALOGXYCOORDS dlg_rgb2[]={
{   0,   0 },
{  15,  35 },
{  15,  65 },
{  15,  95 },
{  15, 155 },
{ 225, 155 },
{ 250,  25 },
{   0,  0  }};

/*
    { 0,   0,   0   },      // black
    { 0,   0,   170 },      // blue
    { 0,   170, 0   },      // green
    { 0,   170, 170 },      // cyan
    { 170, 0,   0   },      // red
    { 170, 0,   170 },      // magenta
    { 170, 85,  0   },      // brown
    { 170, 170, 170 },      // light gray
    { 85,  85,  85  },      // dark gray
    { 85,  85,  255 },      // light blue
    { 85,  255, 85  },      // light green
    { 85,  255, 255 },      // light cyan
    { 255, 85,  85  },      // light red
    { 255, 85,  255 },      // light magenta
    { 255, 255, 85  },      // yellow
    { 255, 255, 255 }       // white
*/





/********************************************/
/* popup rgb changer - called from btn.c    */
/* input: current color                     */

static int popup_color;


void dlg_select_rgb_bpp8( unsigned char c )
{
    unsigned char ru=0,gu=0,bu=0, c1=c, c2=c, c3=c ;
    int     color;

    color = 128;    // starting index
    c1 &= 1;
    c2 &= 4;
    c3 &= 2;
    popup_color = c;
    if(popup_color==128||popup_color==129||popup_color==130) color = 133;
    get_color(  popup_color, (RGB *)&popup_rgb2  );
    ru = popup_rgb1.r = popup_rgb2.r;
    gu = popup_rgb1.g = popup_rgb2.g;
    bu = popup_rgb1.b = popup_rgb2.b;
    ru <<= 2;
    gu <<= 2;
    bu <<= 2;
    dlg_rgb[1].d2 = ru;
    dlg_rgb[2].d2 = gu;
    dlg_rgb[3].d2 = bu;
    prepare_prefix_dlgs( dlg_rgb, dlg_rgb2,-1,-1, color );
    do_dialog(dlg_rgb, -1);
    prepare_suffix_dlgs( dlg_rgb, dlg_rgb2 );
    if(dlg_ret_val==1){     // OK button pressed
        set_color(  popup_color, (RGB *)&popup_rgb1);   /* use new color */
    }
    if(dlg_ret_val==0){     // CANCEL button pressed
        set_color(  popup_color, (RGB *)&popup_rgb2);   /* put back rgb */
    }
}

static int s_slidex(int msg, DIALOG *d, int c)
{
    int x,y;
    BITMAP *map1;

    if(msg==MSG_IDLE) return D_O_K;
    if(msg==MSG_DRAW){
    x = d->x + d->w + 1;
    y = d->y;
    DRAWNUMBOX;
    }
    return ed_slider(msg,d,c);
}
static int s_slide1(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.r = cl >> 2;
    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb[6], MSG_DRAW, 0);

    return D_USER;
}
static int s_slide2(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.g = cl >> 2;
    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb[6], MSG_DRAW, 0);
    return D_USER;
}
static int s_slide3(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.b = cl >> 2;
    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb[6], MSG_DRAW, 0);
    return D_USER;
}
static int s_last(int msg, DIALOG *d, int c)
{
    int  ret = msg;
    int  x, y, i;
    BITMAP *map1;

//    if(msg==MSG_DRAW||msg==MSG_IDLE){
    if(msg==MSG_DRAW){
//        ret = d_box_proc(msg, d, c);
        x = d->x;
        y = d->y;
//        scare_mouse();
//        acquire_screen();
        rect(screen, x, y, x+d->w, y+d->h,  g.syscolor1 );
        rectfill(screen, x+1, y+1, x+d->w-1, y+d->h-1, popup_color );
//        release_screen();
//        unscare_mouse();
        y = y + d->h;
        DRAWNUMBOX2( popup_color );
//        ret = D_O_K;
    }
//    ret = d_box_proc(msg, d, c);
//    if (ret == D_CLOSE) ret = D_REDRAW;
    return D_O_K;
}



/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                SELECT RGB COLOR

    dlg_select_rgb_bpp24( int )

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/

#define DRAWNUMBOX24 \
    rect(screen, x, y, x+ 3*8*1+2 , y + d->h, g.syscolor1 );\
    map1 = create_bitmap(3*8*2+8, 1*8*2+8); if(map1==NULL) error_("cant allocate bitmap");\
    clear_bitmap(map1);\
    sprintf( (char *)&nums1, "%3u", d->d2 );\
    text_mode(-1);\
    textout(map1, font, (char *)&nums1,1,1, g.syscolor1 );\
    scare_mouse();     \
    acquire_screen();   \
    stretch_blit(map1,screen, 0,0,3*8+1,1*8+2, x+1,y+1, 3*8*1+1, d->h-1);\
    release_screen();    \
    unscare_mouse();     \
    destroy_bitmap(map1);

#define DRAWNUMBOX242(z) \
    rect(screen, x, y, x+ 3*8*2+2 , y + 1*8*2+3 , g.syscolor1);\
    map1 = create_bitmap(3*8*2+8, 1*8*2+8); if(map1==NULL) error_("cant allocate bitmap");\
    clear_bitmap(map1);\
    sprintf( (char *)&nums1, "%3u", z);\
    text_mode(-1);\
    textout(map1, font, (char *)&nums1,1,1, g.syscolor1 );\
    scare_mouse();     \
    acquire_screen();     \
    stretch_blit(map1,screen, 0,0,3*8+1,1*8+2, x+1,y+1, 3*8*2+1, 1*8*2+2);\
    release_screen();     \
    unscare_mouse();     \
    destroy_bitmap(map1);

/*** Prototypes for helper functions ***/
static int s24_slidex(int msg, DIALOG *d, int c);
static int s24_slide1(void *dp3, int d2);
static int s24_slide2(void *dp3, int d2);
static int s24_slide3(void *dp3, int d2);
static int s24_last(int msg, DIALOG *d, int c);   /* draw colorbox */
/*** Prototypes for helper functions ***/

// static RGB popup_rgb1 = {0,0,0},  popup_rgb2 = {0,0,0};


//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_rgb24[]={
{ ed_win        ,0,0,320,200,0,0,  0,0,  1,1, "Change Color", NULL, NULL },
{ s24_slidex      ,0,0,200, 20,0,0,'r',0,255,0, NULL, s24_slide1, NULL },
{ s24_slidex      ,0,0,200, 20,0,0,'g',0,255,0, NULL, s24_slide2, NULL },
{ s24_slidex      ,0,0,200, 20,0,0,'b',0,255,0, NULL, s24_slide3, NULL },
{ ed_button_exit,0,0, 80, 22,0,0,'o',0,  0,0, "OK", s_btn_ok, NULL },
{ ed_button_exit,0,0, 80, 22,0,0, 27,0,  0,0, "CANCEL", s_btn_cancel, NULL },
{ s24_last        ,0,0, 50, 90,0,0,  0,0,  0,0, NULL, NULL, NULL },
{ NULL}};
DIALOGXYCOORDS dlg_rgb242[]={
{   0,   0 },
{  15,  35 },
{  15,  65 },
{  15,  95 },
{  15, 155 },
{ 225, 155 },
{ 250,  25 },
{   0,  0  }};

/*
    { 0,   0,   0   },      // black
    { 0,   0,   170 },      // blue
    { 0,   170, 0   },      // green
    { 0,   170, 170 },      // cyan
    { 170, 0,   0   },      // red
    { 170, 0,   170 },      // magenta
    { 170, 85,  0   },      // brown
    { 170, 170, 170 },      // light gray
    { 85,  85,  85  },      // dark gray
    { 85,  85,  255 },      // light blue
    { 85,  255, 85  },      // light green
    { 85,  255, 255 },      // light cyan
    { 255, 85,  85  },      // light red
    { 255, 85,  255 },      // light magenta
    { 255, 255, 85  },      // yellow
    { 255, 255, 255 }       // white
*/





/********************************************/
/* popup rgb changer - called from btn.c    */
/* input: current color                     */

static int  newcolor = 0;



int dlg_select_rgb_bpp24( int inputcolor )
{
    int     ru=0,gu=0,bu=0;
    int     color;


    newcolor = inputcolor;

    popup_rgb1.r = getr( inputcolor );
    popup_rgb1.g = getg( inputcolor );
    popup_rgb1.b = getb( inputcolor );

    dlg_rgb24[1].d2 = popup_rgb1.r;
    dlg_rgb24[2].d2 = popup_rgb1.g;
    dlg_rgb24[3].d2 = popup_rgb1.b;


    prepare_prefix_dlgs( dlg_rgb24, dlg_rgb242,-1,-1, makecol(128,128,128) );
    do_dialog(dlg_rgb24, -1);
    prepare_suffix_dlgs( dlg_rgb24, dlg_rgb242 );



    if(dlg_ret_val==1){     // OK button pressed
        return makecol( popup_rgb1.r,popup_rgb1.g,popup_rgb1.b );
    }
    if(dlg_ret_val==0){     // CANCEL button pressed
        return  inputcolor;
    }
}













static int s24_slidex(int msg, DIALOG *d, int c)
{
    int     x,y;
    BITMAP  *map1;

    if(msg==MSG_IDLE) return D_O_K;
    if(msg==MSG_DRAW){
    x = d->x + d->w + 1;
    y = d->y;
    DRAWNUMBOX24;
    }
    return ed_slider(msg,d,c);
}
static int s24_slide1(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.r = cl;
//    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
//    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb24[6], MSG_DRAW, 0);
    return D_USER;
}
static int s24_slide2(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.g = cl;
//    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
//    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb24[6], MSG_DRAW, 0);
    return D_USER;
}
static int s24_slide3(void *dp3, int d2)
{
    int cl = d2;

    popup_rgb1.b = cl;
//    set_color_onpal( popup_color, (RGB *)&popup_rgb1, (RGB *)&g.palette);
//    set_color(       popup_color, (RGB *)&popup_rgb1);
    object_message( &dlg_rgb24[6], MSG_DRAW, 0);
    return D_USER;
}
static int s24_last(int msg, DIALOG *d, int c)
{
    int  ret = msg;
    int  x, y, i;
    BITMAP *map1;

    if(msg==MSG_DRAW){
        i = makecol( popup_rgb1.r, popup_rgb1.g, popup_rgb1.b );
        x = d->x;
        y = d->y;
        rect(screen, x, y, x+d->w, y+d->h,  g.syscolor1 );
        rectfill(screen, x+1, y+1, x+d->w-1, y+d->h-1, i );
        ret = D_O_K;
    }
    return D_O_K;
}



/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                        POPUP ROTATE INTEGER

    int dlg_rotate_integer();

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/


static int s_edit1(int,DIALOG *,int);
static int s_rotedmix(int,DIALOG *,int);


//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_rot[]={
{ ed_win        ,0,0,250,200,0,0,'0',0,1,1, "Rotate integer", NULL,NULL },
{ s_edit1       ,0,0, 32, 24,0,0,'r',0,4,0, (char *)&string1, NULL,NULL },
{ ed_button_exit,0,0, 80, 22,0,0,'o',0,0,0, "OK",    s_btn_ok,     NULL },
{ ed_button_exit,0,0, 80, 22,0,0, 27,0,0,0, "CANCEL",s_btn_cancel, NULL },
{ s_rotedmix    ,0,0,100, 100,0,0,  0,0,0,0, NULL,NULL,NULL  },
{ NULL }};
#define ROT_EDIT1 1
#define ROT_ROTMIX 4
DIALOGXYCOORDS dlg_rot2[]={
{   0,   0 },
{  75,  30 },

{  15, 160 },
{ 155, 160 },

{  80,  45 },

{   0,  0  }};

static int retval=0;
static float retvalf=0.0;
static const double divratio = 1.41176470588; /*    360/255  (angle/fixed 16.16) */

/*************************************************/
/*                                               */
/* popup Rotation changer - called from btn_m.c  */
/*                                               */
int dlg_rotate_integer()
{
    double f1,f2;

    prepare_prefix_dlgs( dlg_rot, dlg_rot2,-1,-1,128 );
    do_dialog(dlg_rot, -1);
    prepare_suffix_dlgs( dlg_rot, dlg_rot2 );

    if(dlg_ret_val==1){
    retval = atoi(string1);
    f1 = retval;
    f2 = f1 / divratio;
    retval = f2;
    }

    if(dlg_ret_val==0){
    retval = -1;
    }

    string1[0] = string1[3] = string1[4]=0;

    if( retval != -1 ){
    retval = retval;    // testing 255-retval
    }
    return retval;
}
static int s_edit1(int msg, DIALOG *d, int c)
{
    double f1,f2;
    unsigned int ui;
    signed int si;

    switch( msg ){
    case MSG_DRAW:
    text_mode(0);
    textout(screen, font, "Angle:", d->x - 7*8 , d->y       , g.syscolor1);
    textout(screen, font, "degree", d->x + d->w + 1*8 , d->y, g.syscolor1);

    msg = d_edit_proc(msg, d,  c);
    break;

    case MSG_KEY:
    ui = atoi( (char *)&string1 );
    if(string1[0]=='-' || string1[1]=='-'){
    si = 360 + atoi( (char *)&string1 );
    ui = si;
    }
    f1 = ui;
    f2 = f1 / divratio;
    ui = f2;
    if(ui>255) ui=255;
    dlg_rot[ROT_ROTMIX].d1 = ui;
    object_message( &dlg_rot[ROT_ROTMIX], MSG_DRAW, 0 );
    msg = d_edit_proc(msg, d,  c);
    break;

    default:
       msg = d_edit_proc(msg, d,  c);
    break;
    }
    return msg;
}
static int s_rotedmix(int msg, DIALOG *d, int c)
{
    double f1,f2;
    unsigned int ui;
    switch( msg ){

    case MSG_CLICK:

    msg = ed_rotatebox2(msg,d,c);
    ui = d->d1;
    f1 = ui;
    f2 = f1 * divratio;
    ui = f2;
    sprintf( (char *)&string1,"%d", ui );
    object_message( &dlg_rot[ROT_EDIT1], MSG_DRAW, 0 ); // tell edit box to redraw

    msg = ed_rotatebox2(msg,d,c);
    break;

    default:
        msg = ed_rotatebox2(msg,d,c);
    break;
    }
    return msg;
}











/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                        IMPORT / EXPORT FILE

    void dlg_importexportbmp(void);

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/

static int s_btn_imp_anime(int msg, DIALOG *d, int c);
static int s_btn_exp_anime(int msg, DIALOG *d, int c);

//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_ie[]={
{ s_popupbox_nonsticky,0,0,170,200,0,0,0,D_EXIT,0,0,NULL,NULL,NULL },
{ s_btn_imp           ,0,0,130, 25,0,0,0,D_EXIT,0,0,"IMPORT",NULL,NULL },
{ s_btn_exp           ,0,0,130, 25,0,0,0,D_EXIT,0,0,"EXPORT",NULL,NULL },
{ s_btn_imp_anime     ,0,0,130, 25,0,0,0,D_EXIT,0,0,"(unused)",NULL,NULL },
{ s_btn_exp_anime     ,0,0,130, 25,0,0,0,D_EXIT,0,0,"(unused)",NULL,NULL },
{ NULL }};
DIALOGXYCOORDS dlg_ie2[]={
{   0,   0 },
{  20,  20 },
{  20,  65 },
{  20, 110 },
{  20, 155 },
{   0,  0  }};

/*
DIALOG dlg_ie3[]={
{ s_popupbox_nonsticky,0,0,170,200,0,0,0,D_EXIT,0,0,NULL,NULL,NULL },
{ s_btn_map           ,0,0,130, 25,0,0,0,D_EXIT,0,0,"Map to current",NULL,NULL },
{ s_btn_asis          ,0,0,130, 25,0,0,0,D_EXIT,0,0,"As-Is",NULL,NULL },
{ NULL }};

DIALOGXYCOORDS dlg_ie4[]={
{   0,   0 },
{  20,  20 },
{  20,  65 },
{   0,  0  }};

*/
/****************************************************/
/*                                                  */
/* popup Import Export Dialog -called from btn_m.c  */
/*                                                  */
void dlg_importexportbmp(void)
{
    prepare_prefix_dlgs( dlg_ie, dlg_ie2,-1,-1,128 );
    popup_dialog(dlg_ie, -1);
    prepare_suffix_dlgs( dlg_ie, dlg_ie2 );
}
static int s_btn_imp(int msg, DIALOG *d, int c) // IMPORT button
{
    INFOWIN *inf, *info;
    int     i1,i2,i,j,k,amount;
    char    *filename;
    BITMAP  *pspr1, *pspr2;
    PALETTE pal_tmp;
    int     map_to_current = FALSE, flag_type=0, startblock=0;
    FLI     *fli,*tf;
    GifFileType  *gif= NULL;


    switch( msg ){

    case MSG_CLICK:
    map_to_current = FALSE;
        /* ... */
        /* ... */
        /* ... */
//    if(stickypath==NULL) stmp1[0]=0;
//    stickypath = (char *)&stmp1;
    i1 = gui_bg_color;  gui_bg_color = file_color1;
    i2 = gui_fg_color;  gui_fg_color = file_color2;
    pathptr = commdlg_load( "IMPORT File Into Current block", NULL, filemasks,NULL,(int *)&i );
    gui_bg_color = i1;
    gui_fg_color = i2;



/*
    if(i!=-1||pathptr!=NULL){   // if cancel wasn't pressed...
        strcpy( (char *)&stmp1, pathptr );
        st = strrchr( stickypath, '\\');
        *st++='\\';
        *st++=0;
    }
*/



        /* ... */
        /* ... */
        /* ... */



    if( pathptr    != NULL ) {
    if( pathptr[0] != 0    ) {
        filename = fix_filename_case( pathptr );
        filename = fix_filename_slashes( filename );
        pspr1 = ll_get_sprite( g.block_current );
        /* copy from original to temp palette */
        for(i=0;i<256;i++) {
            pal_tmp[i].r = g.palette[i].r;
            pal_tmp[i].g = g.palette[i].g;
            pal_tmp[i].b = g.palette[i].b;
        }

        flag_type = 0;
        if(find_flx_extension( get_extension(filename))==TRUE) flag_type=1;
        if(find_gif_extension( get_extension(filename))==TRUE) flag_type=2;
        if(strlen(get_extension(filename)) == 0 )              flag_type=3; //invalid file

  

        if(flag_type==2){    // we found GIF animation in filename
map_to_current = dialog_popup_import_graphic( FALSE );
        info = infowin_on( "Loading...____", file_color1, file_color3 );

        gif = gif_openload( filename );   if( gif==NULL ) error_("allocating memory" );
        for(j=0;;j++){
        pspr2 = gif_load( gif, (RGB *)&pal_tmp );
        if( pspr2==NULL ) break;

        infowin_textout( info, "loading...%.4d", j  );

        if(map_to_current==TRUE){
            remap_bitmap_to_gpalette( pspr2, (RGB *)&pal_tmp );  // in subs.c
        }


        if( g.flag_all == TRUE ) startblock = 0; else startblock = g.block_current;
        pspr1 = ll_get_sprite( startblock + j );

        if( (g.block_current+j+0) >= g.block_count ){
            ll_append_tail( create_bitmap_clear(g.sx,g.sy) ); g.block_count++;
            pspr1 = ll_get_sprite( g.block_current+j );
            }
            if(pspr1!=NULL){
            if( g.flag_src ==TRUE && clips.flag==TRUE){
                if( g.flag_all == TRUE ) k=j; else k = clips.block;
                pspr1 = ll_get_sprite( k );
                masked_blit ( pspr2, pspr1, 0,0,clips.x1, clips.y1,clips.sx,clips.sy);
            }
            if( g.flag_dst ==TRUE && clipd.flag==TRUE){
                if( g.flag_all == TRUE ) k=j; else k = clipd.block;
                pspr1 = ll_get_sprite( k );
                masked_blit ( pspr2, pspr1, 0,0,clipd.x1, clipd.y1,clipd.sx,clipd.sy);
            }
            if( g.flag_src==FALSE && g.flag_dst==FALSE)
                masked_blit ( pspr2, pspr1, 0,0,0,0, g.sx, g.sy );
            }
        destroy_bitmap( pspr2 );
        }
        gif_loadclose( gif );
        g.block_count = ll_return_spr_count();
        infowin_off( info );
        }


        if(flag_type==1){    // we found FLx animation in filename
map_to_current = dialog_popup_import_graphic( FALSE );
        info = infowin_on( "Loading...____/____",  file_color1, file_color3 );
            // load all using FLI LIbrary
        fli = fli_open_file_read( filename, 0, 0 ); if( fli==NULL ) error_("opening FLx file: %s",filename );
        amount = k = fli->frames;
            for(j=0;j< amount ;j++){
            tf = fli_read_frame( fli );   if(tf==NULL){ msgbox_("Error reading FLx frame"); break; }
            pspr2 = create_bitmap( g.sx, g.sy );    if( pspr2 == NULL ){ msgbox_("creating bitmap for block copy/paste"); break;}
            fli_compose_image( pspr2, fli->image, fli->img_begin,fli->img_end, fli->width, fli->depth );
            fli_copy_pal( fli, (RGB *)&pal_tmp );

        infowin_textout( info, "loading...%.4d/%.4d", j, amount-1  );

            if(map_to_current==TRUE)
                remap_bitmap_to_gpalette( pspr2, (RGB *)&pal_tmp );  // in subs.c


        if( g.flag_all == TRUE ) startblock = 0; else startblock = g.block_current;
            pspr1 = ll_get_sprite( startblock + j );

            if( (g.block_current+j+0) >= g.block_count ){
            ll_append_tail( create_bitmap_clear(g.sx,g.sy) ); g.block_count++;
            pspr1 = ll_get_sprite( g.block_current+j );
            }
                if(pspr1!=NULL){
                if( g.flag_src ==TRUE && clips.flag==TRUE){
                if( g.flag_all == TRUE ) k=j; else k = clips.block;
                    pspr1 = ll_get_sprite( k );
                    masked_blit ( pspr2, pspr1, 0,0,clips.x1, clips.y1,clips.sx,clips.sy);
                }
                if( g.flag_dst ==TRUE && clipd.flag==TRUE){
                if( g.flag_all == TRUE ) k=j; else k = clipd.block;
                    pspr1 = ll_get_sprite( k );
                    masked_blit ( pspr2, pspr1, 0,0,clipd.x1, clipd.y1,clipd.sx,clipd.sy);
                }
                if( g.flag_src==FALSE && g.flag_dst==FALSE){
                    masked_blit ( pspr2, pspr1, 0,0,0,0, g.sx, g.sy );
                }
            }

            if( fli->images_to_go == 0 ){ fli_rewind( fli ); break;}
            }
            fli_close( fli );
        infowin_off( info );
        }


    inf = infowin_on("Loading...", file_color3, file_color1 );
    pspr2 = load_bitmap( filename, (RGB *)&pal_tmp );
    infowin_off( inf );


    if( pspr2 != NULL ){

map_to_current = dialog_popup_import_graphic( FALSE );

        if(map_to_current==TRUE)
            remap_bitmap_to_gpalette( pspr2, (RGB *)&pal_tmp );  // in subs.c

        inf = infowin_on("copying in place...", file_color3, file_color1 );
        scare_mouse();

        if( g.flag_src ==TRUE && clips.flag==TRUE){
            pspr1 = ll_get_sprite( clips.block );
            masked_blit ( pspr2, pspr1, 0,0,clips.x1, clips.y1,clips.sx,clips.sy);
        }
        if( g.flag_dst ==TRUE && clipd.flag==TRUE){
            pspr1 = ll_get_sprite( clipd.block );
            masked_blit ( pspr2, pspr1, 0,0,clipd.x1, clipd.y1,clipd.sx,clipd.sy);
        }
        if( g.flag_src==FALSE && g.flag_dst==FALSE){

            if( bitmap_color_depth(pspr2) > 8 && bitmap_color_depth(pspr1) == 8 ){
            // color reduction is about to happen
            set_color_conversion( COLORCONV_REDUCE_TO_256  );
            }

            blit ( pspr2, pspr1, 0,0,0,0, g.sx, g.sy ); // testing
//            masked_blit ( pspr2, pspr1, 0,0,0,0, g.sx, g.sy );





        }
        destroy_bitmap( pspr2 );
        unscare_mouse();
        infowin_off( inf );
    }}



    }
    msg = D_CLOSE;
    break;
    default:
    msg = d_button_proc( msg, d, c );
    break;
    }
    return msg;
}














static int s_btn_exp(int msg, DIALOG *d, int c) // EXPORT button
{
    INFOWIN *inf;
    int     ret,i1,i2,i,j=0,k=0,m=0, flag_type=0;
    BITMAP  *pspr1=NULL, *pspr3=NULL, *tmp1=NULL;
    GifFileType  *gif = NULL;
    FLI          *fli = NULL;


       switch( msg ){
       case MSG_CLICK:

        /* ... */
        /* ... */
        /* ... */
//    if(stickypath==NULL) stmp1[0]=0;
//    stickypath = (char *)&stmp1;

    i1 = gui_bg_color;
    i2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color2;
    pathptr = commdlg_save( "EXPORT File from Current block", NULL, filemasks, NULL,(int *)&i );
    gui_bg_color = i1;
    gui_fg_color = i2;

    if(i!=-1||pathptr!=NULL){  /* if cancel wasn't pressed... */
/*
        strcpy( (char *)&stmp1, pathptr );
        st = strrchr( stickypath, '\\');
        *st++='\\';
        *st++=0;
*/

    }


        /* ... */
        /* ... */
        /* ... */

    if( pathptr != NULL ) {
    if( pathptr[0] != 0 ) {
            pathptr = fix_filename_case( pathptr );
            pathptr = fix_filename_slashes( pathptr );

            /* should ask for permission to overwrite */
            /* overwrite */
            if( exists( pathptr ) != 0 )
                {
                i=aalert();
                if(i==1) unlink( pathptr );
                if(i==2) return D_CLOSE;
                }

    flag_type = 0;
    if(find_flx_extension( get_extension(pathptr))==TRUE) flag_type=1;
    if(find_gif_extension( get_extension(pathptr))==TRUE) flag_type=2;
    if(strlen(get_extension(pathptr)) == 0 )              flag_type=3; //invalid file




    if( flag_type != 3 )
        inf = infowin_on("Saving...    ", file_color3, file_color1);



    // *********** SRC

    if( g.flag_src ==TRUE && clips.flag==TRUE ){

    if(flag_type==1){    // we found FLx animation in filename
        fli = fli_open_file_write( pathptr, g.bpp, clips.sx, clips.sy, 0, 0 );
        if(fli==NULL){
        msgbox_("Memory allocation error");
        return D_CLOSE;
        }
        if( fli->errnumber != FERR_OK ){
        msgbox_("error: %s", fli_return_errstring( fli ) );
        return D_CLOSE;
        }
    }
    if(flag_type==2){    // we found GIF animation in filename
        gif = gif_opensave( pathptr, 8, clips.sx, clips.sy, 256, (RGB *)&g.palette );
    }

    if( g.flag_all == TRUE ) tmp1 = create_bitmap( clips.sx, clips.sy * g.block_count ); else tmp1 = NULL;
    if( g.flag_all == TRUE ) m = g.block_count;  else  m = 1;
    for(j=0;j< m ;j++){
    if( g.flag_all == TRUE ) k=j; else k = clips.block;
    pspr1 = ll_get_sprite( k );


    if( g.flag_all == FALSE ){
        pspr3 = create_bitmap( clips.sx, clips.sy );
        blit ( pspr1, pspr3, clips.x1, clips.y1,0,0,clips.sx,clips.sy);
        if(flag_type==0)    // save single frame
            save_bitmap( pathptr, pspr3, (RGB *)&g.palette);
        if(flag_type==1){
            fli_reverse_copy_pal( fli, (RGB *)&g.palette );
            fli_reverse_compose_image( fli, pspr3 ); // there's still bugs here
            fli_write_frame( fli );                // there's still bugs here
            }
        if(flag_type==2) gif_save( gif, clips.sx, clips.sy, pspr3 );
        destroy_bitmap( pspr3 );
    }

    if( g.flag_all == TRUE ){ // save multiple frames
        if(flag_type==0){if(tmp1 != NULL) blit(pspr1, tmp1, clips.x1, clips.y1, 0, clips.sy * j, clips.sx, clips.sy);}
        if(flag_type==1){
            pspr3 = create_bitmap( clips.sx, clips.sy );
            blit ( pspr1, pspr3, clips.x1, clips.y1,0,0,clips.sx,clips.sy);
            fli_reverse_copy_pal( fli, (RGB *)&g.palette );
            fli_reverse_compose_image( fli, pspr3 ); // there's still bugs here
            fli_write_frame( fli );                // there's still bugs here
            destroy_bitmap( pspr3 );
            }
        if(flag_type==2){
            pspr3 = create_bitmap( clips.sx, clips.sy );
            blit ( pspr1, pspr3, clips.x1, clips.y1,0,0,clips.sx,clips.sy);
            gif_save( gif, clips.sx, clips.sy, pspr3 );
            destroy_bitmap( pspr3 );
            }
        infowin_textout( inf, "Saving...%.4d", j );
    }

    }// for j
        if( g.flag_all == TRUE ){
            if(flag_type==0){
            if(tmp1 != NULL) save_bitmap( pathptr, tmp1, (RGB *)&g.palette);
            if(tmp1 != NULL) destroy_bitmap( tmp1 );        tmp1 = NULL;
            }
            if(flag_type==1){
            fli_close( fli );
            }
            if(flag_type==2){
            gif_saveclose( gif );
            }
        }
    }
    // *********** SRC





    // *********** DST
    if( g.flag_dst ==TRUE && clipd.flag==TRUE && i==0 ){
    if(flag_type==1){    // we found FLx animation in filename
        fli = fli_open_file_write( pathptr, g.bpp, clipd.sx, clipd.sy, 0, 0 );
        if(fli==NULL){
        msgbox_("Memory allocation error");
        return D_CLOSE;
        }
        if( fli->errnumber != FERR_OK ){
        msgbox_("error: %s", fli_return_errstring( fli ) );
        return D_CLOSE;
        }
    }
    if(flag_type==2){    // we found GIF animation in filename
        gif = gif_opensave( pathptr, 8, clipd.sx, clipd.sy, 256, (RGB *)&g.palette );
    }

    if( g.flag_all == TRUE ) tmp1 = create_bitmap( clipd.sx, clipd.sy * g.block_count ); else tmp1 = NULL;
    if( g.flag_all == TRUE ) m = g.block_count;  else  m = 1;
    for(j=0;j< m ;j++){
    if( g.flag_all == TRUE ) k=j; else k = clipd.block;
    pspr1 = ll_get_sprite( k );


    if( g.flag_all == FALSE ){
        pspr3 = create_bitmap( clipd.sx, clipd.sy );
        blit ( pspr1, pspr3, clipd.x1, clipd.y1,0,0,clipd.sx,clipd.sy);
        if(flag_type==0)    // save single frame
            save_bitmap( pathptr, pspr3, (RGB *)&g.palette);
        if(flag_type==1){
            fli_reverse_copy_pal( fli, (RGB *)&g.palette );
            fli_reverse_compose_image( fli, pspr3 ); // there's still bugs here
            fli_write_frame( fli );                // there's still bugs here
            }
        if(flag_type==2) gif_save( gif, clipd.sx, clipd.sy, pspr3 );
        destroy_bitmap( pspr3 );
    }

    if( g.flag_all == TRUE ){ // save multiple frames
        if(flag_type==0){if(tmp1 != NULL) blit(pspr1, tmp1, clipd.x1, clipd.y1, 0, clipd.sy * j, clipd.sx, clipd.sy);}
        if(flag_type==1){
            pspr3 = create_bitmap( clipd.sx, clipd.sy );
            blit ( pspr1, pspr3, clipd.x1, clipd.y1,0,0,clipd.sx,clipd.sy);
            fli_reverse_copy_pal( fli, (RGB *)&g.palette );
            fli_reverse_compose_image( fli, pspr3 ); // there's still bugs here
            fli_write_frame( fli );                // there's still bugs here
            destroy_bitmap( pspr3 );
            }
        if(flag_type==2){
            pspr3 = create_bitmap( clipd.sx, clipd.sy );
            blit ( pspr1, pspr3, clipd.x1, clipd.y1,0,0,clipd.sx,clipd.sy);
            gif_save( gif, clipd.sx, clipd.sy, pspr3 );
            destroy_bitmap( pspr3 );
            }
        infowin_textout( inf, "Saving...%.4d", j );
    }

    }// for j
        if( g.flag_all == TRUE ){
            if(flag_type==0){
            if(tmp1 != NULL) save_bitmap( pathptr, tmp1, (RGB *)&g.palette);
            if(tmp1 != NULL) destroy_bitmap( tmp1 );        tmp1 = NULL;
            }
            if(flag_type==1){
            fli_close( fli );
            }
            if(flag_type==2){
            gif_saveclose( gif );
            }
        }
    }
    // *********** DST






        if( g.flag_src==FALSE && g.flag_dst==FALSE){ // we don't obey the all flag, since it's rather pointless.
        pspr1 = ll_get_sprite( g.block_current );
        if(flag_type==0)
            save_bitmap( pathptr, pspr1, (RGB *)&g.palette);

            if(flag_type==1){    // save single FLx image, one frame.
            fli = fli_open_file_write( pathptr, g.bpp, g.sx, g.sy, 0, 0 );
                if(fli==NULL){
                msgbox_("Memory allocation error");
                return D_CLOSE;
                }
                if( fli->errnumber != FERR_OK ){
                msgbox_("error: %s", fli_return_errstring( fli ) );
                return D_CLOSE;
                }
            fli_reverse_copy_pal(fli, (RGB *)&g.palette );
            fli_reverse_compose_image( fli, pspr1 );
            fli_write_frame( fli );
            fli_close( fli );
            }

            if(flag_type==2){    // save single GIF image, one frame.
            gif = gif_opensave( pathptr, 8, g.sx, g.sy, 256, (RGB *)&g.palette );
            gif_save( gif, g.sx, g.sy, pspr1 );
            gif_saveclose( gif );
            }
        }

    infowin_off( inf );
    }}



    ret = D_CLOSE;
    break;
    default:
    ret = d_button_proc(msg,d,c);
    break;
    }
    return ret;
}









/* To do: Import Animated GIF & FLI
*/

static int s_btn_imp_anime(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_CLICK:


    msg = D_CLOSE;
    break;
    default:
    msg = d_button_proc( msg, d, c );
    break;
    }
    return msg;
}


static int s_btn_exp_anime(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_CLICK:


    msg = D_CLOSE;
    break;
    default:
    msg = d_button_proc( msg, d, c );
    break;
    }
    return msg;
}




















/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                        POPUP SELECT BRUSH

    void dlg_select_brush(int, int);
 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/


/** helper functions **/
static void s_btn_arrw_l(DIALOG *d);
static void s_btn_arrw_r(DIALOG *d);
static int s_disp_size(int msg, DIALOG *d, int c);
static int s_btn_type1(int msg, DIALOG *d, int c);
static int s_btn_type2(int msg, DIALOG *d, int c);
static int s_btn_type3(int msg, DIALOG *d, int c);
static void ss_btn_type1(DIALOG *d);
static void ss_btn_type2(DIALOG *d);
static void ss_btn_type3(DIALOG *d);
/** helper functions **/

static char str_brushsize[8];


//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_brush[]={
{ ed_win        ,0,0,230,160,0,0,  0,      0, 1, 1, "Select Brush",NULL },
{ ed_framecheck ,0,0,190, 12,0,0,  0, D_USER,-1,70, "ENABLED", (int *)&g.flag_brush},
{ d_text_proc   ,0,0, 32, 12,0,0,  0,      0, 0, 0, "Type:" },
{ s_btn_type1   ,0,0, 20, 14,0,0,  0,      0, 0, 0, "#", ss_btn_type1 },
{ s_btn_type2   ,0,0, 20, 14,0,0,  0,      0, 0, 0, "O", ss_btn_type2 },
{ s_btn_type3   ,0,0, 20, 14,0,0,  0,      0, 0, 0, "B", ss_btn_type3 },
{ d_text_proc   ,0,0, 32, 12,0,0,  0,      0, 0, 0, "Size:" },
{ s_disp_size   ,0,0, 30, 12,0,0,  0,      0, 0, 0, (char *)&str_brushsize },
{ ed_button     ,0,0, 20, 12,0,0,  0,      0, 0, 0, "<",s_btn_arrw_l  },
{ ed_button     ,0,0, 20, 12,0,0,  0,      0, 0, 0, ">",s_btn_arrw_r  },
{ ed_button_exit,0,0, 80, 22,0,0,'o',      0, 0, 0, "OK",s_btn_ok},
{ ed_button_exit,0,0, 80, 22,0,0, 27,      0, 0, 0, "CANCEL",s_btn_cancel},
{ NULL }
};
#define BRSHTYPE1 3
#define BRSHTYPE2 4
#define BRSHTYPE3 5
#define BRSHSIZE  7
DIALOGXYCOORDS dlg_brush2[]={
 {   0,   0 },
 {  20,  92 },
 {  30,  40 },
 {  35,  56 },
 {  58,  56 },
 {  81,  56 },
 { 130,  40 },
 { 130,  50 },
 { 130,  66 },
 { 162,  66 },
 {  20, 120 },
 { 130, 120 },
 {   0,  0  }
};

static int brushsize, brushtype;

/********************************************/
/**                                        **/
/**                                        **/
/**    Popup Brush selection               **/
/**                                        **/
/**                                        **/
void dlg_select_brush( int mx, int my )    /* input: mouse x,y */
{
    brushsize = g.brush.size;
    brushtype = g.brush.type & 3;
    prepare_prefix_dlgs( dlg_brush, dlg_brush2,-1,-1,128 );
    do_dialog(dlg_brush, -1);
    prepare_suffix_dlgs( dlg_brush, dlg_brush2 );
    if(dlg_ret_val==1){
        if( g.flag_brush == TRUE){
        g.brush.type = brushtype;
        g.brush.size = brushsize;
        }
    }
}
static void s_btn_arrw_l(DIALOG *d)
{
    if( g.flag_brush==FALSE) return;
    if( brushsize != 0 )  brushsize--;
    object_message( &dlg_brush[BRSHSIZE] , MSG_DRAW,0);
}
static void s_btn_arrw_r(DIALOG *d)
{
    if( g.flag_brush==FALSE) return;
    if( brushsize < 50 )  brushsize++;
    object_message( &dlg_brush[BRSHSIZE] , MSG_DRAW,0);
}
static int s_disp_size(int msg, DIALOG *d, int c)   /* display 3 digits */
{
    switch( msg ){
    case MSG_DRAW:
        sprintf( d->dp,"% 3d", brushsize );
        ed_label(msg,d,c);
    msg = D_O_K;
    break;
    default:
        ed_label(msg,d,c);
    msg = D_O_K;
    break;
    }
    return msg;
}
static void ss_btn_type1(DIALOG *d)
{
    if( g.flag_brush==FALSE) return;
    brushtype = 0;
    object_message( &dlg_brush[BRSHTYPE2], MSG_USER,0);
    object_message( &dlg_brush[BRSHTYPE3], MSG_USER,0);
    scare_mouse();
    rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
    unscare_mouse();
}
static int s_btn_type1(int msg, DIALOG *d, int c)
{
    switch( msg ){

    case MSG_START:
        object_message( &dlg_brush[BRSHTYPE2], MSG_USER,0);
        object_message( &dlg_brush[BRSHTYPE3], MSG_USER,0);
        msg = ed_button(msg,d,c);   /* call parent */
        msg = D_O_K;
    break;

    case MSG_DRAW:
        msg = ed_button(msg,d,c);   /* call parent */
        if( (g.brush.type&3)==0 ){  /* 0=square, 1=circle, 2=bitmap, 3=undef */
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
        unscare_mouse();
        }
        msg = D_O_K;
    break;
    case MSG_USER:
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->bg);
        unscare_mouse();
        msg = D_O_K;
    break;
    default:
        ed_button(msg,d,c);
        msg = D_O_K;
    break;
    }
    return msg;
}
static void ss_btn_type2(DIALOG *d)
{
    if( g.flag_brush==FALSE) return;
    brushtype = 1;
    object_message( &dlg_brush[BRSHTYPE1], MSG_USER,0);
    object_message( &dlg_brush[BRSHTYPE3], MSG_USER,0);
    scare_mouse();
    rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
    unscare_mouse();
}
static int s_btn_type2(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_START:
        object_message( &dlg_brush[BRSHTYPE1], MSG_USER,0);
        object_message( &dlg_brush[BRSHTYPE3], MSG_USER,0);
        msg = D_O_K;
    break;
    case MSG_DRAW:
        msg = ed_button(msg,d,c);   /* call parent */
        if( (g.brush.type&3)==1 ){  /* 0=square, 1=circle, 2=bitmap, 3=undef */
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
        unscare_mouse();
        }
        msg = D_O_K;
    break;
    case MSG_USER:
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->bg);
        unscare_mouse();
        msg = D_O_K;
    break;
    default:
    msg = ed_button(msg,d,c);
        msg = D_O_K;
    break;
    }
    return msg;
}

static void ss_btn_type3(DIALOG *d)
{
    if( g.flag_brush==FALSE) return;
    brushtype = 2;
    object_message( &dlg_brush[BRSHTYPE1], MSG_USER,0);
    object_message( &dlg_brush[BRSHTYPE2], MSG_USER,0);
    scare_mouse();
    rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
    unscare_mouse();
}

static int s_btn_type3(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_START:
        object_message( &dlg_brush[BRSHTYPE1], MSG_USER,0);
        object_message( &dlg_brush[BRSHTYPE2], MSG_USER,0);
        msg = D_O_K;
    break;
    case MSG_DRAW:
        msg = ed_button(msg,d,c);   /* call parent */
        if( (g.brush.type&3)==2 ){  /* 0=square, 1=circle, 2=bitmap, 3=undef */
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->fg);
        unscare_mouse();
        }
        msg = D_O_K;
    break;
    case MSG_USER:
        scare_mouse();
        rect( screen,d->x-1,d->y-1,d->x+d->w+1,d->y+d->h+1,  d->bg);
        unscare_mouse();
        msg = D_O_K;
    break;
    default:
    msg = ed_button(msg,d,c);
        msg = D_O_K;
    break;
    }
    return msg;
}












       

/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                        Popup dialog for returning values

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/

/** helper functions **/
static int  dlg_request_fnumber(char *, float,float,float );
static int  dlg_request_number( char *,  int,int,int );
static int  s_edit2(int msg, DIALOG *d, int c);
/** helper functions **/

static int setinteger;  /* flag, use integer(TRUE) or floating point(FALSE) */
char *dlg_req_caption="Input number";

/*** Dialog for Brush Selection ***/
//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_req[]={
 { ed_win        ,0,0,200,100,0,0,  0,0, 1,1, "Input number",NULL,NULL },
 { ed_label      ,0,0,160, 12,0,0,  0,0, 0,0, (char *)&stmp1,NULL,NULL },
 { s_edit2       ,0,0, 90, 12,0,0,  0,0,10,0, (char *)&stmp2,NULL,NULL },
 { ed_button_exit,0,0, 60, 22,0,0,'o',0, 0,0, "OK",    s_btn_ok,    NULL},
 { ed_button_exit,0,0, 60, 22,0,0, 27,0, 0,0, "CANCEL",s_btn_cancel,NULL},
 { NULL }
};
#define REQWINDO 0
#define REQLABEL 1
#define REQEDIT1 2
#define REQT_INTEGER 1
#define REQT_FLOAT   2
#define REQT_STRING  3

DIALOGXYCOORDS dlg_req2[]={
 {   0,  0 },
 {  20, 25 },
 {  50, 40 },
 {  20, 60 },
 { 120, 60 },
 {   0,  0 }
};

static int lim_min, lim_max;
static double lim_minf, lim_maxf;




/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * Caption is the selected text to display, if caption is NULL "Input number"
 * is displayed instead.
 * maximum range is 0 to 255
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * returns -1 if cancel button is pressed else returns value selected.
 *
 */
int dlg_request_uchar(char *caption, int lmin, int number, int lmax)
{
    int i;

    dlg_req[REQEDIT1].d1=3; /* limit to 8 bit size */
    i = dlg_request_number(caption,lmin,number,lmax);
    return retval;
}

/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * Caption is the selected text to display, if caption is NULL "Input number"
 * is displayed instead.
 * maximum range is 0 to 65536
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * returns -1 if cancel button is pressed else returns value selected.
 *
 */
int dlg_request_short(char *caption,int lmin, int number, int lmax)
{
    int i;

    dlg_req[REQEDIT1].d1=5; /* limit to 16 bit size */
    i = dlg_request_number(caption,lmin,number,lmax);
/*    if(retval>0xffff) retval = 0xffff;*/
    return retval;
}

/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * Caption is the selected text to display, if caption is NULL "Input number"
 * is displayed instead.
 * maximum range is 0 to 4294967296
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * returns -1 if cancel button is pressed else returns value selected.
 *
 */
int dlg_request_int(char *caption,int lmin, int number, int lmax)
{
    int i;

    dlg_req[REQEDIT1].d1=10; /* limit to 32 bit size */
    i = dlg_request_number(caption,lmin,number,lmax);
    return retval;
}

/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * Caption is the selected text to display, if caption is NULL "Input number"
 * is displayed instead.
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * returns -1 if cancel button is pressed   else returns value selected.
 *
 */
double dlg_request_float(char *caption,float lmin, float number, float lmax)
{
    int i;

    dlg_req[REQEDIT1].d1 = 10; /* limit to 10 characters */
    dlg_req[REQEDIT1].d2 = 0;
    i = dlg_request_fnumber( caption, lmin, number, lmax );
    if(i == -1 ) retvalf = -1.0;
    return retvalf;
}




/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * returns -1 if cancel button is pressed else returns value selected.
 *
 */
static int dlg_request_number( char *caption, int lmin, int number, int lmax)
{

    dlg_req[REQWINDO].dp = dlg_req_caption;    // default caption
    if(caption!=NULL)
        dlg_req[REQWINDO].dp = caption;        // set new caption
    lim_min = lmin;
    retval = number;
    lim_max = lmax;
    stmp1[0] = stmp2[0] = 0;
    sprintf((char *)&stmp1,"range %d-%d",lmin,lmax);
    sprintf((char *)&stmp2,"%d",number);
    retval = -1;
    setinteger = REQT_INTEGER;
    prepare_prefix_dlgs( dlg_req, dlg_req2,-1,-1,128 );
    do_dialog(dlg_req, -1);
    prepare_suffix_dlgs( dlg_req, dlg_req2 );
    if(dlg_ret_val==0) return -1;           // CANCEL pressed
    retval = atoi( (char *)&stmp2 );        /* read string and convert */
    if(retval<lmin) retval=lmin;
    if(retval>lmax) retval=lmax;
    return retval;
}

/*
 * popup a selector dialog. Requesting a number in range lmin to lmax.
 * starts displaying 'number'.
 * together with  ok and cancel  buttons.
 * return -1 if cancel button was pressed, else 0.
 * Floating point value is returned in variable retvalf.
 *
 */
static int dlg_request_fnumber(char *caption, float lmin, float number, float lmax)
{
    dlg_req[REQWINDO].dp = dlg_req_caption;    // default caption
    if(caption!=NULL)
        dlg_req[REQWINDO].dp = caption;        // set new caption
    lim_minf = lmin;
    retvalf  = number;
    lim_maxf = lmax;
    stmp1[0] = stmp2[0] = 0;
    sprintf((char *)&stmp1,"range % 3.3f -% 3.3f", (double) lmin, (double) lmax);
    sprintf((char *)&stmp2,"% 3.3f", (double) number );
    setinteger = REQT_FLOAT;
    prepare_prefix_dlgs( dlg_req, dlg_req2,-1,-1,128 );
    do_dialog( dlg_req, -1 );
    prepare_suffix_dlgs( dlg_req, dlg_req2 );
    if(dlg_ret_val==0) return -1;               // CANCEL pressed
    retvalf = (float) atof( (char *)&stmp2 );   /* read number */
        if( retvalf < lmin ) retvalf = lmin;
        if( retvalf > lmax ) retvalf = lmax;
    return 0;   // okey
}



/* edit box, only numbers */
static int s_edit2(int msg, DIALOG *d, int c)
{
    int ui=0,cc;
    double uif=0.0;

    cc = c & 255;
    switch( msg ){
    case MSG_CHAR:
    if(cc=='\n'||cc==13){

    if(setinteger==REQT_INTEGER){   /* integer input string */
    ui = atoi( d->dp );
    if(ui<lim_min){ ui=lim_min; sprintf(d->dp,"%d",ui);
        scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
        return d_edit_proc(msg, d,  c);
        }
    if(ui>lim_max){ ui=lim_max; sprintf(d->dp,"%d",ui);
        scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
        return d_edit_proc(msg, d,  c);
        }
    scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
    retval = ui;
    return D_EXIT;
    }/* endif */
    if(setinteger==REQT_FLOAT){     /* floating point input string */
    uif = atof( d->dp );
    if(uif<lim_minf){ uif = lim_minf; sprintf(d->dp,"%f",uif);
        scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
        return d_edit_proc(msg, d,  c);
        }
    if(uif>lim_maxf){ uif = lim_maxf; sprintf(d->dp,"%f",uif);
        scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
        return d_edit_proc(msg, d,  c);
        }
    scare_mouse();msg=d_edit_proc(MSG_DRAW, d, c);unscare_mouse();
    retval  = 0;
    retvalf = uif;
    return D_EXIT;
    }/* endif */
    if(setinteger==REQT_STRING){    /* string input */
    dlg_ret_val=1;  // force OK button pressed
    return D_EXIT;
    }

    }
    if( c > ':' && c<255 ){ c=0; return D_O_K; }
    return  d_edit_proc(msg, d,  c);
    break;

    default:
       return d_edit_proc(msg, d,  c);
    break;
    }
    return msg;
}

/****************/
// common dialog for requesting strings....not ready yet

static int dlg_request_stringy();


/*
 * popup a selector dialog. Requesting a string with a maximum number of chars
 * Caption is the selected text to display, if caption is NULL "Input string"
 * is displayed instead.
 * Returns allocated string. When user is finished with string,
 * deallocate with function free_string()
 * returns NULL if cancel button is pressed.
 */
unsigned char *dlg_request_string( unsigned char *_caption, int maxchar )
{
/*
    int i,t1,t2;
    unsigned char *string, *tmp1, *tmp2, *tmp3, *caption = _caption;

    if( maxchar < 0 ) return NULL;
    if( caption==NULL ){ caption=" "; dlg_req[REQLABEL].flags = D_HIDDEN; }
    string = alloc_string( NULL, maxchar );    if(string==NULL) return NULL;
    dlg_req[REQEDIT1].d1 = maxchar;     // limit string input
    tmp1 = dlg_req[REQWINDO].dp;        // push...
    tmp2 = dlg_req[REQLABEL].dp;        // push...
    tmp3 = dlg_req[REQEDIT1].dp;        // push...
    dlg_req[REQWINDO].dp = "input string";
    dlg_req[REQLABEL].dp = caption;
    dlg_req[REQEDIT1].dp = string;
    t1  =  dlg_req2[REQEDIT1].x;        // push...
    t2  =  dlg_req [REQEDIT1].w;        // push...
    dlg_req2[REQEDIT1].x = 20;
    dlg_req [REQEDIT1].w = 160;
    i = dlg_request_stringy( string, maxchar );
    dlg_req2[REQEDIT1].x = t1;          // pop...
    dlg_req [REQEDIT1].w = t2;          // pop...
    dlg_req [REQWINDO].dp=tmp1;         // pop...
    dlg_req [REQLABEL].dp=tmp2;         // pop...
    dlg_req [REQEDIT1].dp=tmp3;         // pop...
    dlg_req[REQLABEL].flags = 0;
    if(i==-1) return NULL;
    return string;
*/
    return  dlg_request_string2( _caption, NULL, maxchar );
}

/*
 * popup a selector dialog. Requesting a string with a maximum number of chars
 * Caption is the selected text to display, if caption is NULL "Input string"
 * is displayed instead.
 * Returns allocated string. When user is finished with string,
 * deallocate with function free_string()
 * returns NULL if cancel button is pressed.
 */
unsigned char *dlg_request_string2( unsigned char *_caption, unsigned char *data, int maxchar )
{
    int i,t1,t2;
    unsigned char *string, *tmp1, *tmp2, *tmp3, *caption = _caption;

    if( maxchar < 0 ) return NULL;
    if( caption==NULL ){ caption=" "; dlg_req[REQLABEL].flags = D_HIDDEN; }
    string = alloc_string( data, maxchar );    if(string==NULL) return NULL;
    dlg_req[REQEDIT1].d1 = maxchar;     // limit string input
    tmp1 = dlg_req[REQWINDO].dp;        // push...
    tmp2 = dlg_req[REQLABEL].dp;        // push...
    tmp3 = dlg_req[REQEDIT1].dp;        // push...
    dlg_req[REQWINDO].dp = "input string";
    dlg_req[REQLABEL].dp = caption;
    dlg_req[REQEDIT1].dp = string;
    t1  =  dlg_req2[REQEDIT1].x;        // push...
    t2  =  dlg_req [REQEDIT1].w;        // push...
    dlg_req2[REQEDIT1].x = 20;
    dlg_req [REQEDIT1].w = 160;
    i = dlg_request_stringy( string, maxchar );
    dlg_req2[REQEDIT1].x = t1;          // pop...
    dlg_req [REQEDIT1].w = t2;          // pop...
    dlg_req [REQWINDO].dp=tmp1;         // pop...
    dlg_req [REQLABEL].dp=tmp2;         // pop...
    dlg_req [REQEDIT1].dp=tmp3;         // pop...
    dlg_req[REQLABEL].flags = 0;
    if(i==-1) return NULL;
    return string;
}


/*
 * run dialog.
 * returns -1 if cancel button is pressed else returns 0 selected.
 */
static int dlg_request_stringy()
{
    setinteger = REQT_STRING;
    prepare_prefix_dlgs( dlg_req, dlg_req2,-1,-1,128 );
    do_dialog(dlg_req, -1);
    prepare_suffix_dlgs( dlg_req, dlg_req2 );
    if(dlg_ret_val==0) return -1;           // CANCEL pressed
    return 0;   // ok.
}

















/*****************************************************************************
 *****************************************************************************
 *****************************************************************************

                    Dilaog for save all,save as, save config, cancel

 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/


static void es_btn_sall(DIALOG *d);
static void es_btn_saas(DIALOG *d);
static void es_btn_saco(DIALOG *d);

//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
DIALOG dlg_save[]={
{ ed_win,        0,0,170,210,0,0,0,0,1,0,"save all blocks", NULL, NULL},
{ ed_button_exit,0,0,130, 25,0,0,0,0,0,0,"SAVE ALL",    es_btn_sall, NULL},
{ ed_button_exit,0,0,130, 25,0,0,0,0,0,0,"SAVE AS",     es_btn_saas, NULL},
{ ed_button_exit,0,0,130, 25,0,0,0,0,0,0,"SAVE CONFIG", es_btn_saco, NULL},
{ ed_button_exit,0,0,130, 25,0,0,0,0,0,0,"CANCEL", NULL, NULL},
{ NULL }
};
DIALOGXYCOORDS dlg_save2[]={
 {   0,   0 },
 {  20,  30 },
 {  20,  75 },
 {  20, 120 },
 {  20, 165 },
 {   0,  0  }
};


/****************************************************/
/*                                                  */
/*                      popup                       */
/*                                                  */
void dlg_saveall(void)
{
    prepare_prefix_dlgs( dlg_save, dlg_save2,-1,-1,128 );
    popup_dialog(dlg_save, -1);
    prepare_suffix_dlgs( dlg_save, dlg_save2 );
}
static void es_btn_sall(DIALOG *d)
{



    save_config_data(1);


        /* ... */
        /* ... */
        /* ... */
}





/* button: save as */
static void es_btn_saas(DIALOG *d)
{
    int             i, i1, i2;
    unsigned char   *itmpstr1 = NULL;
    unsigned char   *itmpstr2 = NULL;
    INFOWIN         *inf=NULL;

        /* ... */
        /* ... */
        /* ... */
    // ---------------------------------------------------------------
    // copy filename to temporary space
    itmpstr1 = alloc_string( g.graphic_name, FILENAME_MAX );    if( itmpstr1==NULL ) { return; }

    /* popup a dialog asking for a filename */
    /* return a new and allocated string    */
    /* use free_string() to free returned string */

    itmpstr2 = ask_for_filename( itmpstr1 );    if( itmpstr2==NULL ) { free_string( itmpstr1 ); return; }
    strncpy( g.graphic_name, itmpstr2, FILENAME_MAX );
    free_string( itmpstr1 ); itmpstr1=NULL;
    free_string( itmpstr2 ); itmpstr2=NULL;

        /* ... */
        /* ... */
        /* ... */

        /* should ask for permission to overwrite */
        /* overwrite */
    if ( exists( g.graphic_name ) != 0 ) {
        i1 = gui_bg_color;  i2 = gui_fg_color;
        gui_bg_color = g.syscolor1;    gui_fg_color = g.syscolor3;
        i = aalert();
        gui_bg_color = i1;  gui_fg_color = i2;
        if(i==1) unlink( g.graphic_name );  // ok
        if(i==2) return;                    // cancel
    }

    inf = infowin_on("Saving...", file_color3, file_color1 );
    save_config_data(1);       // save configuration and graphic blocks
    infowin_off( inf );
}






/*
 *
 */
static void es_btn_saco(DIALOG *d)
{
    save_config_data(0);        // save configuration only
}





/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **********************    popup dialog ask filename    ******************* *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */

static unsigned char *tmpstr = NULL;

DIALOG dlg_askfilename[]={
{ ed_win,         0, 0, 250, 110, 0, 0, 0, D_EXIT, 1, 0, "enter filename",NULL,NULL},
{ d_edit_proc,    0, 0, 200, 25,  0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "OK",     s_btn_ok, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "CANCEL", s_btn_cancel, NULL},
{ NULL }
};
#define ASKFNEDIT 1
DIALOGXYCOORDS dlg_askfilename2[]={
 {   0,  0 },
 {  20, 30 },
 {  20, 70 },
 { 150, 70 },
 {   0, 0  }
};

/*
 * popup a dialog asking for a filename
 * input:  filename string
 * return: newly allocated filename string
 *         returns NULL if user pressed cancel
 */
unsigned char *ask_for_filename( unsigned char *name )
{
    int len=0;

    if( name==NULL ){ name=" "; }

    tmpstr = alloc_string( name, FILENAME_MAX );    if(tmpstr==NULL) return NULL;
    len = strlen(tmpstr);
    // tmpstr now contains the filename

    dlg_askfilename[ ASKFNEDIT ].dp = tmpstr;
    dlg_askfilename[ ASKFNEDIT ].d1 = FILENAME_MAX - 1;
    dlg_askfilename[ ASKFNEDIT ].d2 = len;
    prepare_prefix_dlgs( dlg_askfilename,dlg_askfilename2,-1,-1,128 );
    popup_dialog( dlg_askfilename, ASKFNEDIT );
    prepare_suffix_dlgs( dlg_askfilename,dlg_askfilename2 );

    if(dlg_ret_val==0){     // cancel
        free_string( tmpstr );
        tmpstr = NULL;
        return NULL;
    }
    if(dlg_ret_val==1)      // ok
        return tmpstr;

    free_string( tmpstr );  // error
    tmpstr = NULL;
    return NULL;
}

/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **********************                                 ******************* *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */

































/*****************************************************************************
 *****************************************************************************
 *****************************************************************************
                             Common Code
 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/


/* set color on current palette buffer.
 * copy color from source RGB to destination palette entry.
 */
static void set_color_onpal(int index, RGB *src, RGB *pal )
{
        int i;
        RGB *p1, *p2;
        p1 = src;
        p2 = pal;
        for( i=0 ; i < index ; i++ ) p2++;
        p2->r = p1->r;
        p2->g = p1->g;
        p2->b = p1->b;
        return;
}
static int s_popupbox_nonsticky(int msg, DIALOG *d, int c)
{
    int ret;
    switch( msg ){
    case MSG_DRAW:
        ret = d_shadow_box_proc(msg, d, c);
        drawing_mode(DRAW_MODE_COPY_PATTERN, g.fillmap1, 0, 0);
        rectfill(screen, d->x+3, d->y+3, d->x+d->w-3, d->y+d->h-3, g.syscolor1);
        drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
        rect(screen, d->x+2, d->y+2, d->x+d->w-2, d->y+d->h-2, g.syscolor1);
    msg = D_O_K;
    break;
    default:
            msg = d_shadow_box_proc(msg, d, c);
    break;
    }
    return msg;
}


/*
 * Popup a dialog asking for overwite of file
 * return values:
 * 1 = ok
 * 2 = cancel
 *
 */
static int aalert( void )
{
    int i,i1,i2;

    i1 = gui_bg_color;  i2 = gui_fg_color;
    gui_bg_color = g.syscolor1;    gui_fg_color = g.syscolor3;
    i = alert("!!! warning !!!", "file exists!", "overwrite?", "OK", "CANCEL",0,0);
    gui_bg_color = i1;  gui_fg_color = i2;
    return i;
}


/* ******************************************************* */
static int userwinit_ctrl=0;
static void init_userwindow_colors( int color )
{
    if(userwinit_ctrl==0){
    get_palette((RGB *)&opal);

    file_color1 = color+0;
    file_color2 = color+1;
    file_color3 = color+2;

    set_color( file_color1, (RGB *)&file_rgb1 );
    set_color( file_color2, (RGB *)&file_rgb2 );
    set_color( file_color3, (RGB *)&file_rgb3 );
    file_gui1 = gui_bg_color;
    file_gui2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color3;
    userwinit_ctrl=1;
    }
}

static void init_userwindow_colors24( int color )
{
    if(userwinit_ctrl==0){
    get_palette((RGB *)&opal);

    file_color1 = makecol( file_rgb1.r,file_rgb1.g, file_rgb1.b);
    file_color2 = makecol( file_rgb2.r,file_rgb2.g, file_rgb2.b);
    file_color3 = makecol( file_rgb3.r,file_rgb3.g, file_rgb3.b);
//    set_color( file_color1, (RGB *)&file_rgb1 );
//    set_color( file_color2, (RGB *)&file_rgb2 );
//    set_color( file_color3, (RGB *)&file_rgb3 );
    file_gui1    = gui_bg_color;
    file_gui2    = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color3;
    userwinit_ctrl=1;
    }
}

static void deinit_userwindow_colors(void)
{
    if(userwinit_ctrl==1){
    set_palette((RGB *)&opal);
    gui_bg_color = file_gui1;
    gui_fg_color = file_gui2;
    userwinit_ctrl=0;
    }
}
/* standard setup for many popup dialogs */
void prepare_prefix_dlgs( DIALOG *d1_, DIALOGXYCOORDS *d2, int x, int y, int color )
{
    int topx=0,topy=0;
    DIALOG *d1;
    unsigned char a1[3]= { 20,30,34 };
    unsigned char a2[3]= { 40,50,60 };
    unsigned char a3[3]= { 50,50,20 };

    if( g.bpp == 8 ){
    file_rgb1.r = a1[0];    file_rgb1.g = a1[1];    file_rgb1.b = a1[2];
    file_rgb2.r = a2[0];    file_rgb2.g = a2[1];    file_rgb2.b = a2[2];
    file_rgb3.r = a3[0];    file_rgb3.g = a3[1];    file_rgb3.b = a3[2];
    }else{
    file_rgb1.r = a1[0]<<2; file_rgb1.g = a1[1]<<2; file_rgb1.b = a1[2]<<2;
    file_rgb2.r = a2[0]<<2; file_rgb2.g = a2[1]<<2; file_rgb2.b = a2[2]<<2;
    file_rgb3.r = a3[0]<<2; file_rgb3.g = a3[1]<<2; file_rgb3.b = a3[2]<<2;
    }
    d1 = d1_;

    if( g.bpp == 8 )
        init_userwindow_colors( color );
    else
        init_userwindow_colors24( color );

    set_dialog_color( d1, file_color2, file_color1 );
    text_mode( -1 );

    if(x != -1 || y != -1 ){
        d1->x = topx = x;
        d1->y = topy = y;
    }else{
        d1->x = topx = g.screen_w/2 - d1->w/2;
        d1->y = topy = g.screen_h/2 - d1->h/2;
    }
    d1->bg = file_color1;
    d1->fg = file_color2;
    for(;;){
        d1++; d2++;
        if( d1->proc==NULL ) break;
        d1->x = topx + d2->x;
        d1->y = topy + d2->y;
        d1->bg = file_color1;
        d1->fg = file_color2;
    }
}
/* standard destroy */
void prepare_suffix_dlgs( DIALOG *d1, DIALOGXYCOORDS *d2 )
{
    int j;
    deinit_userwindow_colors();
    do j=mouse_b; while((j&7)!=0 );
}
/* ******************************************************* */

/*****************************************************************************
 *****************************************************************************
 *****************************************************************************
                             Common Code
 *****************************************************************************
 *****************************************************************************
 *****************************************************************************/







// ****************************************************************************
// ******************                                       *******************
// ******************  popup dialog ask for import options  *******************
// ******************                                       *******************
// ****************************************************************************
static int imex_map_to_current = FALSE;
static int s_imex_btn_map(int msg, DIALOG *d, int c);
static int s_imex_btn_asis(int msg, DIALOG *d, int c);

//  (dialog proc)(x)(y)(w)(h)(fg)(bg)(key)(flags)(d1)(d2)(dp)(dp2)(dp3)
static DIALOG dlg_imexport[]={
{ ed_win              ,0,0,170,140,0,0,0,0     ,2,1,"Import graphic",NULL,NULL },
{ s_imex_btn_map      ,0,0,130, 25,0,0,0,0     ,0,0,"Map to current",NULL,NULL },
{ s_imex_btn_asis     ,0,0,130, 25,0,0,0,0     ,0,0,"no modification",NULL,NULL },
{ NULL }};
static DIALOGXYCOORDS dlg_imexport2[]={
{   0,   0 },
{  20,  30 },
{  20,  75 },
{   0,  0  }};



/*
 * input: If cleanup is TRUE then cleanup is made, colors are restored.
 * return TRUE  if user selected Map to current
 * return FALSE if user selected AS-IS
 */
int dialog_popup_import_graphic(int cleanup )
{

    imex_map_to_current = FALSE;
        prepare_prefix_dlgs( dlg_imexport, dlg_imexport2, -1,-1,128 );
//        popup_dialog(dlg_imexport, -1);
        do_dialog(dlg_imexport, -1);
        if( cleanup == TRUE )
            prepare_suffix_dlgs( dlg_imexport, dlg_imexport2 );
    return imex_map_to_current;
}

static int s_imex_btn_map(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_CLICK:
         imex_map_to_current=TRUE;
    object_message( &dlg_imexport[0], MSG_END, 0 );
    msg = D_CLOSE;
    break;
    default:
    msg = d_button_proc( msg, d, c );
    break;
    }
    return msg;
}
static int s_imex_btn_asis(int msg, DIALOG *d, int c)
{
    switch( msg ){
    case MSG_CLICK:
         imex_map_to_current=FALSE;
    object_message( &dlg_imexport[0], MSG_END, 0 );
    msg = D_CLOSE;
    break;
    default:
    msg = d_button_proc( msg, d, c );
    break;
    }
    return msg;
}

// ****************************************************************************
// ******************                                       *******************
// ******************  popup dialog ask for import options  *******************
// ******************                                       *******************
// ****************************************************************************














/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **************    popup dialog ask for grid diemnsions    **************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */

static unsigned char *tmpstr1 = NULL;
static unsigned char *tmpstr2 = NULL;

DIALOG dlg_askgridsxsy[]={
{ ed_win,         0, 0, 250, 110, 0, 0, 0, D_EXIT, 1, 0, "enter grid sx,sy",NULL,NULL},
{ ed_label,       0, 0, 60,  14,  0, 0, 0, 0, 0, 0, "Grid SX:", NULL, NULL},
{ ed_label,       0, 0, 60,  14,  0, 0, 0, 0, 0, 0, "Grid SY:", NULL, NULL},
{ d_edit_proc,    0, 0, 70,  15,  0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
{ d_edit_proc,    0, 0, 70,  15,  0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "OK",     s_btn_ok, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "CANCEL", s_btn_cancel, NULL},
{ NULL }
};
#define ASKGRIDSX 3
#define ASKGRIDSY 4
DIALOGXYCOORDS dlg_askgridsxsy2[]={
 {   0,  0 },
 {  20, 30 },
 {  20, 45 },
 {  110, 30 },
 {  110, 45 },
 {  20, 70 },
 { 150, 70 },
 {   0, 0  }
};

/*
 * popup a dialog asking for a filename
 * input:  filename string
 * return: newly allocated filename string
 *         returns NULL if user pressed cancel
 */
void dlg_request_gridsxsy()
{
    int len1 = 0, len2 = 0;

    tmpstr1 = alloc_string( " ", 22 );    if(tmpstr1==NULL) return;
    len1 = strlen(tmpstr1);
    tmpstr2 = alloc_string( " ", 22 );    if(tmpstr2==NULL){ free(tmpstr1); return;}
    len2 = strlen(tmpstr2);
    sprintf( tmpstr1, "%d", g.grid_sx );
    sprintf( tmpstr2, "%d", g.grid_sy );

    dlg_askgridsxsy[ ASKGRIDSX ].dp = tmpstr1;
    dlg_askgridsxsy[ ASKGRIDSX ].d1 = 5;
    dlg_askgridsxsy[ ASKGRIDSX ].d2 = len1;
    dlg_askgridsxsy[ ASKGRIDSY ].dp = tmpstr2;
    dlg_askgridsxsy[ ASKGRIDSY ].d1 = 5;
    dlg_askgridsxsy[ ASKGRIDSY ].d2 = len2;
    prepare_prefix_dlgs( dlg_askgridsxsy, dlg_askgridsxsy2,-1,-1,128 );
    do_dialog( dlg_askgridsxsy, ASKGRIDSX );
    prepare_suffix_dlgs( dlg_askgridsxsy, dlg_askgridsxsy2 );
    if(dlg_ret_val==0){     // cancel
    }
    if(dlg_ret_val==1){     // ok
        g.grid_sx = atoi(tmpstr1);
        g.grid_sy = atoi(tmpstr2);
        if( g.grid_sx <= 1 ) g.grid_sx = 2;
        if( g.grid_sy <= 1 ) g.grid_sy = 2;
    }
    free_string( tmpstr1 ); tmpstr1 = NULL;
    free_string( tmpstr2 ); tmpstr2 = NULL;
}

/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **********************                                 ******************* *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */







/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **************    popup dialog ask for animation types    **************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */

//static unsigned char *tmpstr1 = NULL;
//static unsigned char *tmpstr2 = NULL;

DIALOG dlg_asktypes[]={
{ ed_win,         0, 0, 250, 170, 0, 0, 0, D_EXIT, 1, 1, "Enter animation parameters",NULL,NULL},

{ d_radio_proc,   0, 0, 60,  14,  0, 0, 0, D_SELECTED, 0, 0, "Type1, forward",NULL, NULL},
{ d_radio_proc,   0, 0, 60,  14,  0, 0, 0, 0, 0, 0, "Type2, reverse",NULL, NULL},
{ d_radio_proc,   0, 0, 60,  14,  0, 0, 0, 0, 0, 0, "Type3, ping-pong",NULL, NULL},

{ ed_label,       0, 0, 80,  14,  0, 0, 0, 0, 0, 0, "Delay (ms):", NULL, NULL},
{ d_edit_proc,    0, 0, 70,  15,  0, 0, 0, 0, 0, 0, NULL, NULL, NULL},

{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "OK",     s_btn_ok, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "CANCEL", s_btn_cancel, NULL},
{ NULL }
};
#define ASKTYPER1 1
#define ASKTYPER2 2
#define ASKTYPER3 3
#define ASKTYPE 5
DIALOGXYCOORDS dlg_asktypes2[]={
 {   0,  0 },

 {  20, 30 },
 {  20, 50 },
 {  20, 70 },

 {  20, 100 },
 {  110,100 },

 {  20, 130 },
 { 150, 130 },
 {   0, 0  }
};

/*
 * popup a dialog asking for a filename
 * input:  filename string
 * return: newly allocated filename string
 *         returns NULL if user pressed cancel
 */
void dlg_request_animate_types()
{
    int len1 = 0;

    tmpstr1 = alloc_string( " ", 22 );    if(tmpstr1==NULL) return;
    len1 = strlen(tmpstr1);

    sprintf( tmpstr1, "%d", g.animate_delay );

    dlg_asktypes[ ASKTYPE ].dp = tmpstr1;
    dlg_asktypes[ ASKTYPE ].d1 = 4;
    dlg_asktypes[ ASKTYPE ].d2 = len1;
    dlg_asktypes[ ASKTYPER1 ].flags = 0;
    dlg_asktypes[ ASKTYPER2 ].flags = 0;
    dlg_asktypes[ ASKTYPER3 ].flags = 0;
    if( g.animate_type == 0 )
        dlg_asktypes[ ASKTYPER1 ].flags = D_SELECTED;
    if( g.animate_type == 1 )
        dlg_asktypes[ ASKTYPER2 ].flags = D_SELECTED;
    if( g.animate_type == 2 )
        dlg_asktypes[ ASKTYPER3 ].flags = D_SELECTED;

    prepare_prefix_dlgs( dlg_asktypes, dlg_asktypes2,-1,-1,128 );
    do_dialog( dlg_asktypes, ASKTYPE );
    prepare_suffix_dlgs( dlg_asktypes, dlg_asktypes2 );
    if(dlg_ret_val==0){     // cancel
    }
    if(dlg_ret_val==1){     // ok
        g.animate_delay = atoi(tmpstr1);
        if( g.animate_delay <= 0 ) g.animate_delay = 0;


    if( dlg_asktypes[ ASKTYPER1 ].flags & D_SELECTED) g.animate_type = 0;
    if( dlg_asktypes[ ASKTYPER2 ].flags & D_SELECTED) g.animate_type = 1;
    if( dlg_asktypes[ ASKTYPER3 ].flags & D_SELECTED) g.animate_type = 2;

    }
    free_string( tmpstr1 ); tmpstr1 = NULL;
    // free_string( tmpstr2 ); tmpstr2 = NULL;
}

/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **********************                                 ******************* *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */


















/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **************    popup dialog ask for palette range      **************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */

static int check_r=FALSE, check_g=FALSE, check_b=FALSE;
static int  anchor_color = 128;
static char edchecklabel1[32], edchecklabel2[32];

static void askpalrange_cls(DIALOG *d);
static void askpalrange_interpolate(DIALOG *d);
static void askpalrange_invert(DIALOG *d);
static void askpalrange_shiftup(DIALOG *d);
static void askpalrange_shiftdown(DIALOG *d);
static void askpalrange_fill(DIALOG *d);


DIALOG dlg_askpalrange[]={
{ ed_win,         0, 0, 290, 200, 0, 0, 0, D_EXIT, 1, 1, "palette ranges",NULL,NULL},

{ ed_label,       0, 0,130,  12,  0, 0, 0, 0, 0, 0, "Start index:000", NULL, NULL},
{ ed_label,       0, 0,130,  12,  0, 0, 0, 0, 0, 0, "End   index:255", NULL, NULL},

{ ed_frame,       0, 0,205,  12,  0, 0, 0, 0, 0, 90, "Action:",NULL, NULL},

{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "CLS",         &askpalrange_cls        , NULL},
{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "interpolate", &askpalrange_interpolate, NULL},
{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "invert",      &askpalrange_invert     , NULL},
{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "shift up",    &askpalrange_shiftup    , NULL},
{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "shift down",  &askpalrange_shiftdown  , NULL},
{ ed_button,      0, 0, 90,  20,  0, 0, 0, 0, 0, 0, "Fill",        &askpalrange_fill       , NULL},

{ ed_check,      0, 0, 12,  12,  0, 0, 0, 0, 0, 0, "R", (int *)&check_r, NULL},
{ ed_check,      0, 0, 12,  12,  0, 0, 0, 0, 0, 0, "G", (int *)&check_g, NULL},
{ ed_check,      0, 0, 12,  12,  0, 0, 0, 0, 0, 0, "B", (int *)&check_b, NULL},


{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "OK",     s_btn_ok, NULL},
{ ed_button_exit, 0, 0, 80,  25,  0, 0, 0, D_EXIT, 0, 0, "CANCEL", s_btn_cancel, NULL},
{ NULL }
};

#define ED_LABEL1 1
#define ED_LABEL2 2

DIALOGXYCOORDS dlg_askpalrange2[]={
 {   0,  0 },


 {  20, 20 },
 {  20, 32 },

 {  20, 50 },

 {  25,  60 },
 {  25,  90 },
 {  25, 120 },
 {  130, 60 },
 {  130, 90 },
 {  130,120 },

 {  240, 30 },
 {  240, 45 },
 {  240, 60 },

 {  20, 160 },
 { 150, 160 },
 {   0, 0  }
};

/*           (not used yet)
 * popup a dialog asking for a filename
 * input:  filename string
 * return: newly allocated filename string
 *         returns NULL if user pressed cancel
 */
void dlg_select_palette_range()
{


    check_r = check_g = check_b = TRUE;
    sprintf( (char *)&edchecklabel1, "start index:%3d", g.paletterange_start);
    sprintf( (char *)&edchecklabel2, "end   index:%3d", g.paletterange_end);
    dlg_askpalrange[ED_LABEL1].dp = (char *)&edchecklabel1;
    dlg_askpalrange[ED_LABEL2].dp = (char *)&edchecklabel2;

    anchor_color = 128;
    if( g.paletterange_start <128 && g.paletterange_end > 128 ){
        if( g.paletterange_end <= 252 ){
            anchor_color = 253;
        }else{
            if( g.paletterange_start >=3 ) anchor_color = 0;
        }
    }


    prepare_prefix_dlgs( dlg_askpalrange, dlg_askpalrange2,-1,-1,anchor_color );
    do_dialog( dlg_askpalrange, 0 );
    prepare_suffix_dlgs( dlg_askpalrange, dlg_askpalrange2 );
    if(dlg_ret_val==0){     // cancel
    }
    if(dlg_ret_val==1){     // ok
    }
}


static void fix_palette()
{
    set_palette( (RGB *)&g.palette );
    set_user_rgb_on_palette(0);
    set_user_rgb_on_palette(1);
    set_user_rgb_on_palette(2);
    // ...
    userwinit_ctrl=0;
    init_userwindow_colors( anchor_color );
// int bestfit_user_color_from_this_palette(int index, RGB *palette)
    // ...
}
static void askpalrange_cls(DIALOG *d)
{
    int i, r_,g_,b_;

    for(i=g.paletterange_start; i<g.paletterange_end+1;i++){
    r_ = g.palette[i].r;
    g_ = g.palette[i].g;
    b_ = g.palette[i].b;
    if(check_r==TRUE) r_=0;
    if(check_g==TRUE) g_=0;
    if(check_b==TRUE) b_=0;
    g.palette[i].r=r_;
    g.palette[i].g=g_;
    g.palette[i].b=b_;
    }
    fix_palette();
}
static void askpalrange_interpolate(DIALOG *d)  // most difficult to implement
{
    int     i;
    int     r0,g0,b0;
    int     r1,g1,b1;
    double  ra,ga,ba;
    double  r_fraction = 0.0;
    double  g_fraction = 0.0;
    double  b_fraction = 0.0;
    double  range;

    if( g.paletterange_start == g.paletterange_end ) return;

    range = g.paletterange_end - g.paletterange_start;

    r0 = g.palette[g.paletterange_start].r;
    g0 = g.palette[g.paletterange_start].g;
    b0 = g.palette[g.paletterange_start].b;
    r1 = g.palette[g.paletterange_end].r;
    g1 = g.palette[g.paletterange_end].g;
    b1 = g.palette[g.paletterange_end].b;
    r_fraction = (r1-r0)/range;
    g_fraction = (g1-g0)/range;
    b_fraction = (b1-b0)/range;
    ra = r0;
    ga = g0;
    ba = b0;
    for(i=g.paletterange_start; i<g.paletterange_end;i++){
    g.palette[i].r= ra;
    g.palette[i].g= ga;
    g.palette[i].b= ba;
    if(check_r==TRUE) ra += r_fraction;
    if(check_g==TRUE) ga += g_fraction;
    if(check_b==TRUE) ba += b_fraction;
    }

    fix_palette();
}
static void askpalrange_invert(DIALOG *d)
{
    int i, r_,g_,b_;

    for(i=g.paletterange_start; i<g.paletterange_end+1;i++){
    r_ = g.palette[i].r;
    g_ = g.palette[i].g;
    b_ = g.palette[i].b;
    if(check_r==TRUE) r_=63-r_;
    if(check_g==TRUE) g_=63-g_;
    if(check_b==TRUE) b_=63-b_;
    g.palette[i].r=r_;
    g.palette[i].g=g_;
    g.palette[i].b=b_;
    }
    fix_palette();
}
static void askpalrange_shiftdown(DIALOG *d)  // works good
{
    int     i;
    int     r_,g_,b_;
    int     r1,g1,b1;
    int     r0,g0,b0;

    if( g.paletterange_start == g.paletterange_end ) return;
    r0 = g.palette[g.paletterange_start].r;
    g0 = g.palette[g.paletterange_start].g;
    b0 = g.palette[g.paletterange_start].b;
    for(i=g.paletterange_start; i<(g.paletterange_end);i++){
    r_ = g.palette[i].r;
    g_ = g.palette[i].g;
    b_ = g.palette[i].b;
    r1 = g.palette[i+1].r;
    g1 = g.palette[i+1].g;
    b1 = g.palette[i+1].b;
    if(check_r==TRUE) r_=r1;
    if(check_g==TRUE) g_=g1;
    if(check_b==TRUE) b_=b1;
    g.palette[i].r=r_;
    g.palette[i].g=g_;
    g.palette[i].b=b_;
    }
    if(check_r==TRUE) g.palette[g.paletterange_end].r = r0;
    if(check_g==TRUE) g.palette[g.paletterange_end].g = g0;
    if(check_b==TRUE) g.palette[g.paletterange_end].b = b0;
    fix_palette();
}
static void askpalrange_shiftup(DIALOG *d)
{

    int     i;
    int     r_,g_,b_;
    int     r1,g1,b1;
    int     r0,g0,b0;

    if( g.paletterange_start == g.paletterange_end ) return;
    r0 = g.palette[g.paletterange_end].r;
    g0 = g.palette[g.paletterange_end].g;
    b0 = g.palette[g.paletterange_end].b;
    for(i=g.paletterange_end; i>(g.paletterange_start);i--){
    r_ = g.palette[i].r;
    g_ = g.palette[i].g;
    b_ = g.palette[i].b;
    r1 = g.palette[i-1].r;
    g1 = g.palette[i-1].g;
    b1 = g.palette[i-1].b;
    if(check_r==TRUE) r_=r1;
    if(check_g==TRUE) g_=g1;
    if(check_b==TRUE) b_=b1;
    g.palette[i].r=r_;
    g.palette[i].g=g_;
    g.palette[i].b=b_;
    }
    if(check_r==TRUE) g.palette[g.paletterange_start].r = r0;
    if(check_g==TRUE) g.palette[g.paletterange_start].g = g0;
    if(check_b==TRUE) g.palette[g.paletterange_start].b = b0;
    fix_palette();
}
static void askpalrange_fill(DIALOG *d)
{
    int i, r_,g_,b_;
    int    ra,ga,ba;

    if( g.paletterange_start == g.paletterange_end ) return;
    ra = g.palette[g.paletterange_start].r;
    ga = g.palette[g.paletterange_start].g;
    ba = g.palette[g.paletterange_start].b;
    for(i=g.paletterange_start; i<g.paletterange_end+1;i++){
    r_ = g.palette[i].r;
    g_ = g.palette[i].g;
    b_ = g.palette[i].b;
    if(check_r==TRUE) r_=ra;
    if(check_g==TRUE) g_=ga;
    if(check_b==TRUE) b_=ba;
    g.palette[i].r=r_;
    g.palette[i].g=g_;
    g.palette[i].b=b_;
    }
    fix_palette();
}





/* ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * **********************                                 ******************* *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** *
 * ************************************************************************** */


