/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\


Clipboard + extras
void clip_do_command( void )  execute command immediately
     must do fix to obey flag "all" for all non-sticky functions in clip.c

*/

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "method.h"
#include "grey.h"
#include "clip.h"
#include "dlg.h"
#include "fsel.h"
#include "zoom.h"
#include "butil.h"
#include "ll.h"
#include "coord.h"
#include "subs.h"
#include "grey.h"
#include "btn.h"
#include "rect.h"
#include "pal.h"
#include "md2.h"
#include "mtd.h"
#include "tb.h"
#include "md.h"
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)


/*** helpers ***/
static int approximate(int);
void halftone_mask(         BITMAP *source, BITMAP *destination);
void unk_error_diffusion(   BITMAP *source, BITMAP *destination);
void unk2_error_diffusion(  BITMAP *source, BITMAP *destination);
void floyd_steinberg_error_diffusion( BITMAP *source, BITMAP *destination);
static void copyfline(  BITMAP *, float *, float *, int );
static void getfline(   BITMAP *, float *, int, int );
/*** helpers ***/











BITMAP *dxeclip_bmp=NULL;
int     dxeclip_x1=0,dxeclip_y1=0,dxeclip_sx=0,dxeclip_sy=0;

/**** group 1 ****/
static int x1,y1,x2,y2,sx,sy;
static BITMAP *bmp1;
void precall_1(BITMAP *_pp)  /**************************/
{
    bmp1 = _pp;     //  current block sprite

//    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        x1=y1=0;    sx = g.sx;    sy = g.sy;
//    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) bmp1 = ll_get_sprite( clips.block );
        x1=clips.x1;    y1=clips.y1;    sx=clips.sx;    sy=clips.sy;
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) bmp1 = ll_get_sprite( clipd.block );
        x1=clipd.x1;    y1=clipd.y1;    sx=clipd.sx;    sy=clipd.sy;
    }
    dxeclip_bmp = bmp1;
    dxeclip_x1  = x1;
    dxeclip_y1  = y1;
    dxeclip_sx  = sx;
    dxeclip_sy  = sy;
}                                /**************************/


void mtd_gamma_pal(BITMAP *_p)
{
    do_gamma_pal( NULL,0,0,0,0 );   //    do_gamma_pal( bmp1,x1,y1,sx,sy );
}





/**** group 2 ****/
static int destination=0, source=0;
void precall_2(BITMAP *_pp)  /**************************/
{
    if( g.flag_all==TRUE && g.flag_dst==TRUE )
        destination = g.block_current;
    else
        destination = clipd.block;
    if( g.flag_all==TRUE && g.flag_src==TRUE )
        source = g.block_current;
    else
        source = clips.block;
}                                /**************************/
void mtd_copysrc2dst(BITMAP *_p)
{
    copysrc2dst(ll_get_sprite(destination),ll_get_sprite( source ));
}
void mtd_copysrc2dsttr(BITMAP *_p)
{
    copysrc2dsttr(ll_get_sprite(destination),ll_get_sprite( source ));
}
void mtd_copysrc2dstov(BITMAP *_p)
{
    copysrc2dstov(ll_get_sprite(destination),ll_get_sprite( source ));
}
void mtd_copyscale(BITMAP *_p)
{
    copyscale(ll_get_sprite(destination),ll_get_sprite( source ));
}
void mtd_copyscaletr(BITMAP *_p)
{
    copyscaletr(ll_get_sprite(destination),ll_get_sprite( source ));
}
void mtd_copyscaleov(BITMAP *_p)
{
    copyscaleov(ll_get_sprite(destination),ll_get_sprite( source ));
}




/**** group 3 ****/
static int mask[] = { 1,2,4,8,16,32,64,128 };
static int imask[]= { 128,64,32,16,8,4,2,1 };
static int sh[]   = { 128,192,224,240,248,252,254,255 };
void postcall_1(BITMAP *_p)
{
    scare_mouse();
    display_zoomed_md();
    unscare_mouse();

    x1=y1=x2=y2=1; sx=sy=1;  // TEST
}
void postcall_2(BITMAP *_p)
{
    refresh_screen();
}
void mtd_flipprms(BITMAP *_p)
{
    int i;
    if( clips.flag==TRUE && clipd.flag==TRUE){
        x1 = clipd.sx;        y1 = clipd.sy;        x2 = clipd.x1;
        y2 = clipd.y1;        sx = clipd.x2;        sy = clipd.y2;
        clipd.sx = clips.sx;
        clipd.sy = clips.sy;
        clipd.x1 = clips.x1;
        clipd.y1 = clips.y1;
        clipd.x2 = clips.x2;
        clipd.y2 = clips.y2;
        clips.sx = x1;        clips.sy = y1;        clips.x1 = x2;
        clips.y1 = y2;        clips.x2 = sx;        clips.y2 = sy;
        i = clips.block;
        clips.block = clipd.block;
        clipd.block = i;
    }
}
void mtd_adap_size_src(BITMAP *_p)
{
    if( clips.flag==TRUE && clipd.flag==TRUE){
        clips.sx = clipd.sx;
        clips.sy = clipd.sy;
        clips.x2 = clips.x1 + clips.sx-1;
        clips.y2 = clips.y1 + clips.sy-1;
        if( clips.x2 > g.sx ){
            clips.x2 = g.sx;
            clips.sx = clips.x2-clips.x1+1;
            }
        if( clips.y2 > g.sy ){
            clips.y2 = g.sy;
            clips.sy = clips.y2-clips.y1+1;
            }
    }
}
void mtd_adap_pos_src(BITMAP *_p)
{
    if( clips.flag==TRUE && clipd.flag==TRUE){
        clips.x1 = clipd.x1;
        clips.y1 = clipd.y1;
        clips.x2 = clips.x1 + clips.sx-1 ;
        clips.y2 = clips.y1 + clips.sy-1 ;
        if( clips.x2 > g.sx ){
            clips.x2 = g.sx;
            clips.sx = clips.x2-clips.x1+1;
        }
        if( clips.y2 > g.sy ){
            clips.y2 = g.sy;
            clips.sy = clips.y2-clips.y1+1;
        }
    }
}
void mtd_assign_blk_src(BITMAP *_p)
{
    if( clips.flag==TRUE)
        clips.block = g.block_current;
}
void mtd_adap_size_dst(BITMAP *_p)
{
    if( clips.flag==TRUE && clipd.flag==TRUE){
        clipd.sx = clips.sx;
        clipd.sy = clips.sy;
        clipd.x2 = clipd.x1 + clipd.sx-1;
        clipd.y2 = clipd.y1 + clipd.sy-1;
        if( clipd.x2 > g.sx ){
            clipd.x2 = g.sx;
            clipd.sx = clipd.x2-clipd.x1+1;
        }
        if( clipd.y2 > g.sy ){
            clipd.y2 = g.sy;
            clipd.sy = clipd.y2-clipd.y1+1;
        }
    }
}
void mtd_adap_pos_dst(BITMAP *_p)
{
    if( clips.flag==TRUE && clipd.flag==TRUE ){
        clipd.x1 = clips.x1;
        clipd.y1 = clips.y1;
        clipd.x2 = clipd.x1 + clipd.sx-1 ;
        clipd.y2 = clipd.y1 + clipd.sy-1 ;
        if( clipd.x2 > g.sx ){
            clipd.x2 = g.sx;
            clipd.sx = clipd.x2-clipd.x1+1;
        }
        if( clipd.y2 > g.sy ){
            clipd.y2 = g.sy;
            clipd.sy = clipd.y2-clipd.y1+1;
        }
    }
}
void mtd_assign_blk_dst(BITMAP *_p)
{
    if( clipd.flag==TRUE){
        clipd.block = g.block_current;
    }
}
void mtd_destroysrcdst(BITMAP *_p)
{
    clips.flag = FALSE;
    clipd.flag = FALSE;
}
void mtd_getsrcbrush(BITMAP *_p)    // get SRC into BRUSH and FILL
{
    BITMAP *pspr1;
    int     new_sx, new_sy;


    if( clips.flag==TRUE ){
        if( g.brush.bmp!=NULL ) destroy_bitmap( g.brush.bmp ); /* destroy previous */
        g.brush.sx = clips.sx;
        g.brush.sy = clips.sy;
        g.brush.bmp = create_bitmap( g.brush.sx, g.brush.sy );
        pspr1 = ll_get_sprite( clips.block );
        blit( pspr1, g.brush.bmp, clips.x1, clips.y1, 0,0, g.brush.sx, g.brush.sy );
        g.brush.type = 2;
        g.flag_brush = TRUE;


        if(fillstruct.class==1){
        // ------------- get from SRC into FILL bitmap -------------
        // bitmap used for filling operation must be a multiple of two
        //
/*
        new_sx = clips.sx;
        new_sy = clips.sy;
        if( ((new_sx)&1) == 1) new_sx--;
        if( ((new_sy)&1) == 1) new_sy--;
*/
        new_sx = clips.sx;
        new_sy = clips.sy;
        new_sx &= ~1;
        new_sy &= ~1;
        if( fillstruct.bmpfree != NULL) destroy_bitmap( fillstruct.bmpfree );
        if((fillstruct.bmpfree = create_bitmap( new_sx, new_sy ))==NULL )error_("cannot create bitmap");
        blit( ll_get_sprite( clips.block ), fillstruct.bmpfree, clips.x1, clips.y1, 0,0, new_sx, new_sy  );
        // ------------- get from SRC into FILL bitmap -------------
        }
    }

}
void mtd_splitplane(BITMAP *_p)
{
    int i,j,x,y,ch=0;
    BITMAP *pspr1, *pspr2;

    i = g.block_current;
    pspr1 = ll_get_sprite( i );
    for(j=0;j<8;j++)
        {
        pspr2 = create_bitmap(g.sx, g.sy);        if( pspr2==NULL ) return;
        for(y=0;y<g.sy;y++) {
        for(x=0;x<g.sx;x++) {
            ch = getpixel( pspr1,x,y ) & mask[j];
            if( ch!=0 ) ch = 255;
            putpixel( pspr2,x,y, ch );
        }}
        ll_insert( i+1, pspr2 ); destroy_bitmap(pspr2);
        ll_set_tag( i+1, (unsigned char)j + '0' );
        g.block_count = ll_return_spr_count();
        }
}
void mtd_joinplane(BITMAP *_p)
{
    int i,j,x,y,ch=0,cc=0;
    BITMAP *pspr2, *pspr3;


    pspr2 = create_bitmap( g.sx, g.sy );    // must be bpp = 1, but only 8 is available

    if( pspr2==NULL ) return;
    clear_bitmap( pspr2 );

    i = g.block_current;
    for(j=0;j<8;j++)
        {
        if (i>=g.block_count) break;
        pspr3 = ll_get_sprite( i );
        for(y=0;y<g.sy;y++) {
        for(x=0;x<g.sx;x++) {
        ch = getpixel( pspr3,x,y );       /* 0 or n? */
        if( ch!=0 ) ch = imask[j];
        cc = getpixel( pspr2,x,y ) & sh[j] ;
        putpixel( pspr2,x,y,  (cc|ch) );
        }}

        ll_remove( i );

        g.block_count = ll_return_spr_count();
        if( g.block_current == g.block_count )
            if( g.block_current !=0 ) g.block_current--;
        }
        ll_insert( i, pspr2 ); destroy_bitmap( pspr2 );
        g.block_count = ll_return_spr_count();
}

/* select brush */
void mtd_selbrush(BITMAP *_p){    dlg_select_brush(mouse_x, mouse_y);}

/* select background map */
void mtd_selbkmap(BITMAP *_p){    dlg_select_bkmap(mouse_x, mouse_y);}

void mtd_new_test(BITMAP *_p)   /* error diffusion */
{
    int i;
    BITMAP *pspr1, *pspr2;

        i = g.block_current;
        pspr1 = ll_get_sprite( g.block_current );
        pspr2 = create_bitmap_clear( g.sx, g.sy );  if( pspr2==NULL ) return;

//        halftone_mask( pspr1, pspr2 );
//        floyd_steinberg_error_diffusion( pspr1, pspr2 );
//        unk_error_diffusion( pspr1, pspr2 );
        unk2_error_diffusion( pspr1, pspr2 );


        ll_insert( i+1, pspr2 ); destroy_bitmap( pspr2 );
        g.block_count = ll_return_spr_count();
}
void mtd_resizecanvas(BITMAP *_p)
{
    dlg_resize_canvas();
    redraw_slider();
}
void mtd_rescalecanvas(BITMAP *_p)
{
    dlg_rescale_canvas();
    redraw_slider();
}

void mtd_loadpalgraphic( BITMAP *p ){   pal_load_palgraphic();  }
void mtd_loadpal( BITMAP *p ){          pal_load();         }
void mtd_savepal( BITMAP *p ){          pal_save();         }
void mtd_shiftpal1( BITMAP *p )
{
    int     i;
    RGB     color;

    color = g.palette[255];
    for(i=255;i>0;i--){
    g.palette[i] = g.palette[i-1];
    }
    g.palette[0] = color;

    refix_all_display2();
}


void mtd_shiftpal2( BITMAP *p )
{
    int     i;
    RGB     color;


    color = g.palette[0];
    for(i=0;i<255;i++){
    g.palette[i] = g.palette[i+1];
    }
    g.palette[255] = color;


    refix_all_display2();
}



void mtd_binop_or( BITMAP *p ){         md2_binop_or();     }
void mtd_binop_xor( BITMAP *p ){        md2_binop_xor();    }
void mtd_binop_and( BITMAP *p ){        md2_binop_and();    }
void mtd_binop_copymask( BITMAP *p ){   md2_binop_copymask();    }
void mtd_split_into_rgb (BITMAP *p ){   md2_split_rgb();    }
void mtd_join_from_rgb( BITMAP *p ){    md2_join_rgb();     }
void mtd_grey_avg( BITMAP *p ){         md2_grey_avg();     }
void mtd_grey_add( BITMAP *p ){         md2_grey_add();     }
void mtd_grey_sub( BITMAP *p ){         md2_grey_sub();     }
void mtd_sort_light_up( BITMAP *p ){    md2_sort_light_up();    }











/*****************************************************************************
 **                                                                         **
 **                                                                         **
 **                                                                         **
 *****************************************************************************
 */



/*
 * Do a halftone 3x3 mask.
 *
 * 9 threshold values.
 *
 *      -------
 *      |6|8|4|
 *      |1|0|3|
 *      |5|2|7|
 *      -------
 */
void halftone_mask( BITMAP *source, BITMAP *destination )
{
    int sx,sy,x,y;
    float k;
    int level[]={28,56,84,113,141,170,198,226,255};
    sx = source->w;
    sy = source->h;

    clear_bitmap(destination);

    for( y = 2 ; y < (sy/3) - 2 ; y++){
    for( x = 2 ; x < (sx/3) - 2 ; x++){     /* scan left to right */

    x *= 3;
    y *= 3;

    /* average getpixel value */
    k = getpixel( source, x-1,y-1 ) + getpixel( source, x,y-1 ) + getpixel( source, x+1,y-1 )+\
        getpixel( source, x-1,y ) + getpixel( source, x,y ) + getpixel( source, x+1,y )+\
        getpixel( source, x-1,y+1 ) + getpixel( source, x,y+1 ) + getpixel( source, x+1,y+1 );
    k=k/9;

    if(k>level[0]) putpixel( destination, x, y, 255 );
    if(k>level[1]) putpixel( destination, x-1, y, 255 );
    if(k>level[2]) putpixel( destination, x  , y+1, 255);
    if(k>level[3]) putpixel( destination, x+1, y  , 255);
    if(k>level[4]) putpixel( destination, x+1, y+1, 255);
    if(k>level[5]) putpixel( destination, x-1, y-1, 255);
    if(k>level[6]) putpixel( destination, x-1, y+1, 255);
    if(k>level[7]) putpixel( destination, x+1, y+1, 255);
    if(k>level[8]) putpixel( destination, x  , y-1, 255);
    if(k>level[9]) putpixel( destination, x  , y  , 255);
    x /= 3;
    y /= 3;
    }
    }
}



/*
 * Do floyd-steinberg error diffusion.
 *
 * units of 1/16
 *
 *      -------
 *      | |X|7|
 *      |3|5|1|
 *      -------
 */
void floyd_steinberg_error_diffusion( BITMAP *source, BITMAP *destination )
{
    int sx,sy,x,y;
    int i;
    float k;
    float error;
    float *line0, *line1;

    sx = source->w;
    sy = source->h;
    line0 = (float *) malloc(sizeof(float)*(sx+17)); if(line0==NULL) return;
    line1 = (float *) malloc(sizeof(float)*(sx+17)); if(line1==NULL) return;

    getfline( source, line0, 0,3 ); /* y+0 */
    getfline( source, line1, 1,3 ); /* y+1 */

    for( y = 0 ; y<sy ; y++){
    for( x = 1 ; x<(sx+6) ; x++){     /* scan left to right */
    k = approximate( line0[x] );
    i=x-3;
    if( i>=0 )  putpixel( destination, i, y, k );

    error = line0[x] - k;
    /**/
    line0[x+1] += 7*error/16;
    /**/
    line1[x-1] += 3*error/16;
    /**/
    line1[x]   += 5*error/16;
    /**/
    line1[x+1] += error/16;
    }
    /* shift from line2 to line1, from line1 to line0 */
    copyfline( source, line1, line0,7 );
    getfline(  source, line1, y+2,  3 );

    }
    free(line0);
    free(line1);
}




/*
 * Do other kind of error diffusion.
 *
 * units of 1/16
 *
 *   -----------
 *   | | | |X|8|
 *   |1|1|2|4|0|
 *   -----------
 */
void unk_error_diffusion( BITMAP *source, BITMAP *destination )
{
    int sx,sy,x,y;
    int i;
    float k;
    float error;
    float *line0, *line1;
    sx = source->w;
    sy = source->h;

    line0 = (float *) malloc(sizeof(float)*(sx+17)); if(line0==NULL)return;
    line1 = (float *) malloc(sizeof(float)*(sx+17)); if(line1==NULL)return;

    getfline( source, line0, 0,5 ); // y+0
    getfline( source, line1, 1,5 ); // y+1

    for( y = 0 ; y<sy ; y++){
    for( x = 3 ; x<(sx+10) ; x++){     // scan left to right
    k = approximate( line0[x] );
    i=x-5;
    if( i>=0)   putpixel( destination, i, y, k );

    error = line0[x] - k;
    /**/
    /**/
    line0[x+1] += 8*error/16;
    /**/
    line1[x]   += 4*error/16;
    line1[x-1] += 2*error/16;
    line1[x-2] += 1*error/16;
    line1[x-3] += 1*error/16;
    /**/
    }
    /* shift from line2 to line1, from line1 to line0 */
    copyfline( source, line1, line0, 10 );
    getfline(  source, line1, y+2,   5 );
    }
    free(line0);
    free(line1);
}



/*
 * Do other kind of error diffusion.
 *
 * units of 1/16
 * | | | |X|8|
 * |2|0|2|4|0|
 */
void unk2_error_diffusion( BITMAP *source, BITMAP *destination )
{
    int sx,sy,x,y;
    int i;
    float k;
    float error;
    float *line0, *line1;
    sx = source->w;
    sy = source->h;

    line0 = (float *) malloc(sizeof(float)*(sx+17)); if(line0==NULL)return;
    line1 = (float *) malloc(sizeof(float)*(sx+17)); if(line1==NULL)return;

    getfline( source, line0, 0,5 ); /* y+0 */
    getfline( source, line1, 1,5 ); /* y+1 */

    for( y = 0 ; y<sy ; y++){
    for( x = 3 ; x<(sx+10) ; x++){     /* scan left to right */
    k = approximate( line0[x] );
    i=x-5;
    if( i>=0)   putpixel( destination, i, y, k );

    error = line0[x] - k;
    /**/
    /**/
    line0[x+1] += 8*error/16;
    /**/
    line1[x]   += 4*error/16;
    line1[x-1] += 2*error/16;
    line1[x-3] += 2*error/16;
    /**/
    }
    /* shift from line2 to line1, from line1 to line0 */
    copyfline( source, line1, line0,10 );
    getfline(  source, line1, y+2,  5 );
    }
    free(line0);
    free(line1);
}




#define BWLEVEL 128

/* approximate grayscale to nearest bilevel intensity
 * returns 0 or 255
 */
static int approximate(int color)
{
    if( color < BWLEVEL ) return 0;
    return 255;
}

static void getfline( BITMAP *source, float *sline, int y, int addx )
{
    int sx,sy,x,i;

    sx = source->w;
    sy = source->h;
    for( x=0 ; x< addx ; x++) sline[x] = 0;
    if( y>sy ){
        for( x = 0 ; x < sx+(addx*2)+1 ; x++) sline[x+addx] = 0;
        return;
        }
    for( x = 0 ; x < sx ; x++)
        sline[x+addx] = getpixel(source,x,y);
    for( i = 0 ; i < addx ; i++)
        sline[x+addx+i] = 0;
}
static void copyfline( BITMAP *dims, float *source, float *destination,int addx )
{
    int sx,x;
    sx = dims->w;
    for( x = 0 ; x < (sx+addx) ; x++) destination[x] = source[x];
}






//
// do bestfit algorithm
//
//
//
void clip_remap_colors_from_old_to_new(
  COLORMAPPING_TWO *old1, COLORMAPPING_TWO *old2, COLORMAPPING_TWO *old3,
  COLORMAPPING_TWO *new1, COLORMAPPING_TWO *new2, COLORMAPPING_TWO *new3 )
{
    if( g.bpp != 8 ) return;



    old1->r >>= 2;  // from range 0-255 to vga range
    old1->g >>= 2;
    old1->b >>= 2;
    old2->r >>= 2;
    old2->g >>= 2;
    old2->b >>= 2;
    old3->r >>= 2;
    old3->g >>= 2;
    old3->b >>= 2;


    new1->index = bestfit_color( (RGB *)&g.palette, old1->r, old1->g, old1->b );
    new2->index = bestfit_color( (RGB *)&g.palette, old2->r, old2->g, old2->b );
    new3->index = bestfit_color( (RGB *)&g.palette, old3->r, old3->g, old3->b );


    // returned indexes are vga range
    new1->r = g.palette[ new1->index ].r;
    new1->g = g.palette[ new1->index ].g;
    new1->b = g.palette[ new1->index ].b;

    new2->r = g.palette[ new2->index ].r;
    new2->g = g.palette[ new2->index ].g;
    new2->b = g.palette[ new2->index ].b;

    new3->r = g.palette[ new3->index ].r;
    new3->g = g.palette[ new3->index ].g;
    new3->b = g.palette[ new3->index ].b;


    new1->r <<= 2;  // from vga range to 0-255 to range
    new1->g <<= 2;
    new1->b <<= 2;
    new2->r <<= 2;
    new2->g <<= 2;
    new2->b <<= 2;
    new3->r <<= 2;
    new3->g <<= 2;
    new3->b <<= 2;



    return;
}

