/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\

 * Binary / Bitmap utilities
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <allegro.h>
#include "data.h"
#include "butil.h"



static unsigned char fillpatterns[][8][8]={
{   "* * * * ",    " * * * *",    "* * * * ",    " * * * *",    "* * * * ",    " * * * *",    "* * * * ",    " * * * *"},
{   "*      *",    "      **",    "     ** ",    "    **  ",    "   **   ",    "  **    ",    " **     ",    "**      "},
{   "****    ",    "****    ",    "****    ",    "****    ",    "    ****",    "    ****",    "    ****",    "    ****"},
{   "*      *",    "**      ",    " **     ",    "  **    ",    "   **   ",    "    **  ",    "     ** ",    "      **"},
{   "        ",    "     *  ",    "    *** ",    "     *  ",    " *      ",    "***     ",    " *      ",    "        "},
{   "**  **  ",    "**  **  ",    "  **  **",    "  **  **",    "**  **  ",    "**  **  ",    "  **  **",    "  **  **"},
{   "********",    "        ",    "********",    "        ",    "********",    "        ",    "********",    "        "},
{   "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * ",    "* * * * "},
{   "******* ",    "*     * ",    "*  *  * ",    "* *** * ",    "*  *  * ",    "*     * ",    "******* ",    "        "}
};


/* returns a newly allocated bitmap
 * pattern = 0-8
 */
BITMAP *create_fill_map( int pattern, int color1, int color2 )
{
    int     x,y,c;
    BITMAP  *map;

    map = create_bitmap(8,8);   if(map==NULL) return NULL;
    for (y=0; y < map->h ; y++){
    for (x=0; x < map->w ; x++){
    if( fillpatterns[pattern][y][x] == ' ' ) c = color1;
    else c = color2;
    putpixel( map,x,y, c);
    }}
    return ((BITMAP *) map);
}
void destroy_fill_map( BITMAP *fillmap )
{
    if( fillmap!=NULL ) destroy_bitmap( fillmap );
}

/*
 * rotate 90 degrees a bitmap, bmp1 is the reference.
 * if bmp2 is null then create bmp2
 */
void reflip_90( BITMAP *bmp1, BITMAP *bmp2 )
{
    int w,h,c,x,y;

    if( bmp1==NULL ) return;
    w = bmp1->w;
    h = bmp1->h;

    if( bmp2==NULL ) {
        bmp2 = create_bitmap( h,w );
        if( bmp2==NULL ) return;
    }
    for(y=0;y<h;y++){
    for(x=0;x<w;x++){
    c = getpixel(bmp1,x,y);
    putpixel(bmp2,y,x,c);
    }}
    return;
}

/*
 * flip in x axis a bitmap
 *
 */
void reflip_x( BITMAP *bmp1 )
{
    int w,h,i,x,y;
    int c1,c2;

    w = bmp1->w;
    h = bmp1->h;
    i = w/2;

    for(y=0;y<h;y++){
    for(x=0;x< i ;x++){

    c1 = getpixel(bmp1,w-x-1,y);
    c2 = getpixel(bmp1,x,  y);
    putpixel( bmp1, w-x-1, y, c2);
    putpixel( bmp1, x,   y, c1);
    }}
    return;
}




/*
 * Create a 90 degrees rotated bitmap
 * Return new bitmap
 *
 */
BITMAP *rotate_90( BITMAP *in )
{
    int     w,h,x,y;
    BITMAP  *out = NULL;

    if( in==NULL ) return NULL;
    w = in->w;    h = in->h;
    if ( (out=create_bitmap( h,w ))==NULL) return NULL;
    for(y=0;y<h;y++){for(x=0;x<w;x++){putpixel(out,y,x,getpixel(in,x,y));}}
    return out;
}




/*  Dotted rectangle
 *  Draws an outline rectangle with the two points as its opposite corners.
 *  draw dotted line rectangle.
 */
void rect_dot(BITMAP *bmp, int x1, int y1, int x2, int y2, int color)
{
    static BITMAP *bm = NULL;

    if( bm==NULL ){
    bm = create_bitmap( 2, 2 );
    if( bm != NULL ){
        putpixel(bm,0,0, 0);
        putpixel(bm,1,1, 0);
        putpixel(bm,0,1, color);
        putpixel(bm,1,0, color);
    }}
    if( bm==NULL ) return;
    drawing_mode(DRAW_MODE_MASKED_PATTERN, bm, 0, 0);
    rect(bmp,x1,y1,x2,y2,color);
    drawing_mode(DRAW_MODE_SOLID, NULL,0,0);
}



/*
 * allocate a string and copy the data given as input.
 * newly allocated string will be filled with 0 (zeroes).
 * If input string is NULL then no data is copied.
 * if string_size is -1 or 0, then string size is strlen(string+1)
 *
 *
 * returns NULL on error.
 *
 */
unsigned char *alloc_string( unsigned char *string, int _string_size )
{
    unsigned char *tmp = NULL;
    int     string_size = _string_size;
    int     i;

    if( string_size <= 0 ){
        if(string==NULL) return NULL;   //error
        string_size = strlen(string);
    }
    string_size++;
    tmp = (unsigned char *) malloc( string_size+3 ); if(tmp==NULL) return NULL;
    for(i=0;i<string_size+1;i++) tmp[i] = 0;  // fill with zero

    if(string!=NULL){                   // copy
        for(i=0;i<string_size;i++){
        if(string[i]==0){ tmp[i]=0; break; }
        tmp[i] = string[i];
        }
        tmp[i] = 0;
    }
    return tmp;
}
/*
 *
 */
void free_string( unsigned char *string )
{
    if(string!=NULL) free(string);
}

/* found in string.c (viclib)
 * Remove ending spaces in string.
 * return inputstring.
 *
 */
void str_right( unsigned char *in )
{
    unsigned char   c;
    int     len,i;

    if( in == NULL ) return;
    len = strlen( in );    if(len==0||len==1) return;
//    printf("string: <%s> ", in);
    for(i=0;i<len;i++){
    c = in[ len-i-1 ];
    if(c!=' ') break;
    }
    in[ len-i ] = 0;
//    printf("string: <%s> i=%d len-i=%d\n", in, i, len-i);
}


/* ------------------------------------------------------------------------- */

/*
 * 8 bit paletted
 * Find the closest matching color
 * RGB equal to 'color' to be replaced with 'color'.
 *
 * precision:  range 0 to 31,
 *             0 means exact match.
 *             1 means a variance of +- 1  for each RGB
 *            31 means a variance of +- 31 for each RGB
 *
 * if compared ranges are above 255, the limit will be set at 255.
 * if compared ranges are below 0, the limit will be set at 0.
 *
 * example:
 * A source RGB value of 30,30,30 with a precision of 5 will match a
 * RGB of 25,35,33 or a RGB of 31,25,35 but not a RGB of 20,45,10 (out of range).
 *
 * returns palette index, else -1 on "not found".
 *
 */
int find_closest_color( int _r, int _g, int _b, int precision )
{
    int     r0,r1,r2;
    int     g0,g1,g2;
    int     b0,b1,b2;
    unsigned char   ra=0,ga=0,ba=0;
    int     i;

    r0 = r2 = _r;
    g0 = g2 = _g;
    b0 = b2 = _b;
    r0 -= precision; if(r0<0)    r0=0;
    r2 += precision; if(r2>255)  r2=255;
    g0 -= precision; if(g0<0)    g0=0;
    g2 += precision; if(g2>255)  g2=255;
    b0 -= precision; if(b0<0)    b0=0;
    b2 += precision; if(b2>255)  b2=255;
    for( i=0 ; i<256 ; i++){
    r1=g1=b1=0;
    ra = g.palette[i].r;    r1 = ra;
    ga = g.palette[i].g;    g1 = ga;
    ba = g.palette[i].b;    b1 = ba;
    if( (r0 < r1) && (r1 < r2) ){    /* red match */
    if( (g0 < g1) && (g1 < g2) ){    /* green match */
    if( (b0 < b1) && (b1 < b2) ){    /* blue match */
//        printf("prec:%d\n",precision);
        return i;       // match, return palette index
    }}}
    }
    return -1;
}



static PALETTE pai;
void gettxtpalette()
{
    get_palette( (RGB*)&pai );
}
void settxtpalette()
{
    set_palette( (RGB*)&pai );
}

/*
 * Used for creating the DXE icon bitmaps
 * input:  block of unsigned char for making a 30x30 icon
 * return bitmap;
 */
BITMAP *make_30x30icon( unsigned char *icon )
{
    BITMAP          *dst;
    int             x,y, color=0;
    unsigned char   c=0;

    if( icon == NULL ) return NULL;
    dst = create_bitmap_ex( g.bpp, 30, 30 );   if(dst==NULL) return NULL;
    for(y=0;y<30;y++){
    for(x=0;x<30;x++){
        c = icon[ x + y*30  ];
        color = 0;
        if( c==' ' ) color = g.buttoncolor;
        putpixel( dst,x,y, color );
    }}
    return dst;
}

/* Exchange colors 1 & 2 in bitmap */
void xchg_bitmap(BITMAP *bmp, int color1, int color2 )
{
      int x, y, c=0;

      for(y=0; y < bmp->h; y++) {
      for(x=0; x < bmp->w; x++) {
      c = getpixel(bmp,x,y);
      if ( c == color1 ) putpixel(bmp,x,y,color2);
      if ( c == color2 ) putpixel(bmp,x,y,color1);
      }}
}
/* Exchange colors 1 & 2 in bitmap, within a rectangle */
void xchg_bitmap_rect(BITMAP *bmp, int color1, int color2,int x1,int y1,int sx, int sy )
{
    int x, y, c;

    for(y = y1 ; y < (y1+sy) ; y++){
    for(x = x1 ; x < (x1+sx) ; x++){
    c = getpixel(bmp,x,y);
    if ( c == color1 ) putpixel(bmp,x,y,color2);
    if ( c == color2 ) putpixel(bmp,x,y,color1);
    }}
}


static char errstring[100];

void error_( const char *fmt, ... )
{
    va_list args;
// ****************
// windowed!
    errstring[0] = 0;
    va_start(args, fmt);
    _vsnprintf( (char *)&errstring, 99, fmt, args );
    errstring[99] = 0;
    va_end(args);
    alert("*** ERROR ***", (char *)&errstring , "*** ERROR ***", "OK",NULL,1,2);
    allegro_exit();
    exit(-1);
}


void msgbox_( const char *fmt, ... )
{
    va_list args;
// ****************
// windowed!
    errstring[0] = 0;
    va_start(args, fmt);
    _vsnprintf( (char *)&errstring, 99, fmt, args );
    errstring[99] = 0;
    va_end(args);
    alert("----", (char *)&errstring , "----", "OK",NULL,1,2);
}


BITMAP *create_bitmap_clear( int sx, int sy )
{
    BITMAP  *map;

    map = create_bitmap( sx,sy );
    if(map!=NULL){
        // MASK color
        clear_to_color( map, bitmap_mask_color(map) );
//        clear_bitmap( map );

    }
    return map;
}


/*
 * Shift color indexes in bitmap 32 colors, 'position' times
 *
 *
 */
void shift_bitmap_32pos( BITMAP *map, int positions )
{
    int sx,sy,x,y,color;

    sx = map->w;
    sy = map->h;
    for(y=0;y<sy;y++){
    for(x=0;x<sx;x++){
    color = getpixel( map, x,y );
    if( color != 0 ) color += 32 * positions;   // don't affect mask color
    putpixel( map,x,y, color );
    }}
}







//static char errstring[100];

void  debug_display( int color1, int color2, int x, int y,  const char *fmt, ... )
{
    int     i,sx,sy,lx,ly;
    va_list args;

    errstring[0] = ' ';
    errstring[1] = 0;
    va_start(args, fmt);
    _vsnprintf( (char *)&errstring, 99, fmt, args );
    errstring[99] = 0;
    va_end(args);
    strncat( (char *)&errstring, "  ", 99 );
    errstring[99] = 0;
    sx = text_length( font, (char *)&errstring  );
    sy = text_height( font );
    lx = x-1;   if( lx<0 ) lx=0;
    ly = y-1;   if( ly<0 ) ly=0;
    i=text_mode( color1 );
    scare_mouse();
    rectfill( screen, x,y,x+sx,y+sy,       color1 );
    rect(     screen, lx,ly,x+sx+1,y+sy+1, color2 );
    textprintf( screen, font, x,y, color2, "%s ",  (char *)&errstring );
    unscare_mouse();
    text_mode( i );
}


