#ifndef _TOOLBARBTNS_H
#define _TOOLBARBTNS_H

#include "global.h"

typedef struct TBLINK
{
    int  is_dxe;             // 0=no, 1=yes, it's suitable for dxe
    int  dialog;             // 1= invoke dialog, 0=no
    int  mouse_number;       // number of mouse shape, should be 0 for non-sticky
    int  stickyflag;         // 1-sticky (called by md), 0-nonsticky (called normally)
    int  loop_flag;          // do loop and obey the 'all' flag if 1, else(0) ignore.
    int  method_index;       //  MTD_BUTTONS + ...
    void (*pre_callback)(BITMAP *);    // called before callback, if NULL, then not called
    void (*callback)(BITMAP *);        // function callback for non-sticky methods
    void (*post_callback)(BITMAP *);   // called after callback has been called, if NULL, then not called

    void (*pre_dxecallback)(void);                  // DXE, called before "all" is executed
    int  (*dxecallback)( BITMAP *,int,int,int,int);  // DXE, function callback for methods
    void (*post_dxecallback)(void);                 // DXE, called after "all" has been executed

    BITMAP *clickedbmp;
    BITMAP *unclickedbmp;
    char   *description;      // textual description to display
} TBLINK;




#define CLOOP1 \
 { int loopvar1, loopvar2;\
 loopvar1 = g.block_current;\
 for( loopvar2 = 0 ; loopvar2 < g.block_count; loopvar2++ ){\
 if( g.flag_all == TRUE ) g.block_current = loopvar2;

#define CLOOP2 if(g.flag_all==FALSE) break; }\
 g.block_current = loopvar1;}










extern TBLINK main_tb[];

//      ButtonBar Sub Functions
int tb_fix_bitmapbuttons(); // fixes only non-DXE bitmaps

int tb_remap_bitmapbuttons( int oldcolor, int newcolor );   // fixes all bitmaps


void tb_init(void);
void tb_deinit(void);
void tb_draw_outlines(void);
void tb_display_group(int);
void tb_undisplay_group(int);
// button functions
int tb_exchanger(int,DIALOG *,int);
int tb_bar(int,DIALOG *,int);


// display on info bar
void printout_infoblock( char *message );





#endif
