/*
 * load and save various palette formats
 *
 *
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include "data.h"
#include "dlg.h"
#include "comdlg.h"
#include "zoom.h"
#include "subs.h"
#include "tb.h"
#include "md.h"
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)
#include "butil.h"
#include "libfli/fli.h"
#include "libgif/gif_lib.h"


/*
static char *filemasks = "All files (*.*)\0*.*\0\
BMP Windows Bitmap\0*.BMP\0GIF unisys\0*.GIF\0LBM Amiga IFF\0*.lbm;*.iff\0\
PBM Portable Bitmap\0*.PBM\0PCX Zsoft Paintbrush\0*.PCX\0PGM Portable Graymap\0*.PGM\0\
PNG Portable Network Graphics\0*.PNM\0PPM Portable Pixmap\0*.PPM\0TGA Truevision Targa\0*.TGA\0\
XBM Xwindows Bitmap\0*.XBM\0\
CEL Kisekae,16 col\0*.CEL\0\
TIFF Tagged Image Format\0*.TIF;*.tiff\0
FLI/FLC file\0*.fla;*.flb;*.fli;*.flc;*.flh;*.flt\0\0";
*/



static char paltypes[] =
"Autodetect type (*.*)\0*.*\0\
Raw 6bit (*.PAL)\0*.pal\0\
Raw 8bit (*.PAL)\0*.pal\0\
JASC Palette (*.PAL)\0*.pal\0\
Neopaint Palette (*.PAL)\0*.pal\0\
Kisekae palette (*.kcf)\0*.KCF\0\
JASC without header (DTA) (*.map)\0*.MAP\0\
Color palette 6bit (*.col)\0*.COL\0\0";

static char paltypes_save[] =
"Raw 6bit (*.PAL)\0*.pal\0\
Raw 8bit (*.PAL)\0*.pal\0\
JASC Palette (*.PAL)\0*.pal\0\
Neopaint Palette (*.PAL)\0*.pal\0\
Kisekae palette (*.kcf)\0*.KCF\0\
JASC without header (DTA) (*.map)\0*.MAP\0\
Color palette 6bit (*.col)\0*.COL\0\0";


static char *palnames[]={
"Autodetect",
"raw 6 bits",    /* .COL are raw too... */
"raw 8 bits",
"JASC",          /* .MAP's are JASC's without the header, 256 colors only */
"NeoPaint",
"KiSS",
"color MAP",
"color COL",
"???" };

//static  RGB file_rgb1 = {20,30,34};
//static  RGB file_rgb2 = {40,50,60};
//static  RGB file_rgb3 = {50,50,20};


/**** prototypes ****/
static int load_raw6_palette(char *pathptr, RGB *pal );
static int load_raw8_palette(char *pathptr, RGB *pal );
static int load_jasc_palette(char *pathptr, RGB *pal );
static int load_neop_palette(char *pathptr, RGB *pal );
static int load_kiss_palette(char *pathptr, RGB *pal );
static int load_MAP_palette(char *pathptr, RGB *pal);
static int load_COL_palette(char *pathptr, RGB *pal);
static int autodetect_paltype( char *pathptr );
static int save_raw6_palette(char *pathptr, RGB *pal );
static int save_raw8_palette(char *pathptr, RGB *pal );
static int save_jasc_palette(char *pathptr, RGB *pal );
static int save_neop_palette(char *pathptr, RGB *pal );
static int save_kiss_palette(char *pathptr, RGB *pal );
static int save_MAP_palette(char *pathptr, RGB *pal );
static int save_COL_palette(char *pathptr, RGB *pal );
static char stmp1[266];    /* for sticky path */
static char stmp2[266];    /* tmp file name */
static char *stickypathpal=NULL, *st;
/**** prototypes ****/

static PALETTE opal, tmppal;

/*****************************************************************/

void pal_load_palgraphic()
{
    BITMAP *pspr1=NULL, *tmpmap=NULL;
    char *pathptr;
    char *filename;
    INFOWIN *inf;
    int i1,i2, i, flag_type = 0;
    int file_color1, file_color2, file_color3;
    FLI     *fli;
    GifFileType  *gif= NULL;


    get_palette( (RGB *)&opal );
    file_color1 = 128;
    file_color2 = 129;
    file_color3 = 130;
    i1 = gui_bg_color;
    i2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color2;
//    set_color( file_color1, (RGB *)&file_rgb1);
//    set_color( file_color2, (RGB *)&file_rgb2);
//    set_color( file_color3, (RGB *)&file_rgb3);
        /* ... */
        /* ... */
        /* ... */
    if(stickypathpal==NULL){ stmp1[0]=0; stickypathpal=(char *)&stmp1; }
    pathptr = commdlg_load( "Load palette from graphic", stickypathpal, filemasks,NULL,NULL );
    gui_bg_color = i1;
    gui_fg_color = i2;



    if(pathptr!=NULL && pathptr[0] != 0  ){  /* if cancel wasn't pressed... */
        strncpy( (char *)&stmp1, pathptr, 260 );    stmp1[260] = 0;
        strncpy( (char *)&stmp2, pathptr, 260 );    stmp2[260] = 0;
        filename = (char *)&stmp2;
        if((st=strrchr(stickypathpal,'\\'))!=NULL){ *st++='\\'; *st++=0; }
        /* ... */
        /* ... */
        /* ... */
        set_palette((RGB *)&opal);
        filename = fix_filename_case( filename );
        filename = fix_filename_slashes( filename );
        if( exists(filename) != 0 ){
        inf = infowin_on("Loading...", g.syscolor3, g.syscolor1 );

    // .................................

        flag_type = 0;
        if(find_flx_extension( get_extension(filename))==TRUE) flag_type=1;
        if(find_gif_extension( get_extension(filename))==TRUE) flag_type=2;
        if(strlen(get_extension(filename)) == 0 )              flag_type=3; //invalid file





        if(flag_type==2){    // we found GIF animation in filename
            gif = gif_openload( filename );   if( gif==NULL ) error_("allocating memory" );
            tmpmap = gif_load( gif, (RGB *)&tmppal );
            if(tmpmap!=NULL) destroy_bitmap( tmpmap );
            gif_loadclose( gif );
        }
        if(flag_type==1){    // we found FLx animation in filename
            fli = fli_open_file_read( filename, 0, 0 ); if( fli==NULL ) error_("opening FLx file: %s",filename );
            if( fli_read_frame( fli )==NULL){ msgbox_("Error reading FLx frame"); }
            fli_copy_pal( fli, (RGB *)&tmppal );
            fli_close( fli );
        }
        if(flag_type==0){    // regular animation in filename
            pspr1 = load_bitmap( filename, (RGB *)&tmppal );
            destroy_bitmap( pspr1 );
        }


    // .................................

        infowin_off( inf );

    scare_mouse();
    for(i=0;i<256;i++){
        g.palette[i].r = tmppal[i].r;
        g.palette[i].g = tmppal[i].g;
        g.palette[i].b = tmppal[i].b;
    }
    set_palette( (RGB *)&g.palette );
    refix_all_display();
    unscare_mouse();

        }
    }
}



/* ... crashbone... */
void pal_load()
{
    int     palindex, i,j,old;
    char *pathptr;
    char *filename;
    int i1,i2;
    int file_color1, file_color2, file_color3;

    old = g.buttoncolor;   /* fromcolor */

    for(i=0;i<256;i++) tmppal[i].r=tmppal[i].g=tmppal[i].b=0;

    get_palette( (RGB *)&opal );
    file_color1 = 128;
    file_color2 = 129;
    file_color3 = 130;
    i1 = gui_bg_color;
    i2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color2;
//    set_color( file_color1, (RGB *)&file_rgb1);
//    set_color( file_color2, (RGB *)&file_rgb2);
//    set_color( file_color3, (RGB *)&file_rgb3);
        /* ... */
        /* ... */
        /* ... */
    if(stickypathpal==NULL){ stmp1[0]=0; stickypathpal=(char *)&stmp1; }

    pathptr = commdlg_load( "Load palette from file", stickypathpal, (char *)&paltypes, NULL, (int *)&palindex);

//msgbox_("palindex: %d", palindex);
    gui_bg_color=i1;
    gui_fg_color=i2;

    if( pathptr!=NULL ){        /* if cancel wasn't pressed... */
        strncpy( (char *)&stmp1, pathptr, 260 );    stmp1[260] = 0;
        strncpy( (char *)&stmp2, pathptr, 260 );    stmp2[260] = 0;
        filename = (char *)&stmp2;
        if((st=strrchr(stickypathpal,'\\'))!=NULL){ *st++='\\'; *st++=0; }
        /* ... */
        /* ... */
        /* ... */
        if(palindex<0||palindex>8){
            set_palette( (RGB *)&opal );
            do j=mouse_b; while((j&7)!=0 );
            return;
        }
    if( pathptr==NULL ){        /* if cancel was pressed... */
            set_palette( (RGB *)&opal );
            do j=mouse_b; while(j&7);
            return;
    }

    filename = fix_filename_case( filename );
    filename = fix_filename_slashes( filename );
    if (exists(filename)==0){
        /* printf("file don't exist, returning\n"); */
        set_palette( (RGB *)&opal );
        do j=mouse_b; while(j&7);
        return;
        }
    /*
     * to do: should ask for action taken: replace palette, error diff. or remap.
     */


/*
printf("filename <%s>\n",filename);
printf("palindex <%d>\n",palindex);
*/
    i = FALSE;

    if(palindex==1){    /* unknown format, read header and return */
    palindex = autodetect_paltype( filename );
        if(palindex==-1){
            /*failure to autodetect*/
            alert("failed to detect palette type"," "," ","ok",NULL,0,0);
            set_palette( (RGB *)&opal );
            do j=mouse_b; while((j&7)!=0 );
            return;}
         alert("palette type is:",palnames[palindex]," ","ok",NULL,' ',0);
    }


    if(palindex==2)    // raw binary, 768 bytes bitrange VGA: 0-63
        i = load_raw6_palette( filename, (RGB *)&tmppal );
    if(palindex==3)    // raw binary, 768 bytes bitrange: 0-255
        i = load_raw8_palette( filename, (RGB *)&tmppal );
    if(palindex==4)    // JASC, bitrange VGA: 0-63
        i = load_jasc_palette( filename, (RGB *)&tmppal );
    if(palindex==5)    // NEOPAINT, bitrange: 0-255
        i = load_neop_palette( filename, (RGB *)&tmppal );
    if(palindex==6)    // Kisekae, bitrange: 0-16
        i = load_kiss_palette( filename, (RGB *)&tmppal );
    if(palindex==7)    // ascii, bitrange: 0-256
        i = load_MAP_palette( filename, (RGB *)&tmppal );
    if(palindex==8)    // binary, bitrange: 0-63
        i = load_COL_palette( filename, (RGB *)&tmppal );


    if(i==TRUE){
        scare_mouse();
        release_handle_from_palette();  /* put back original colors on palette */
        for(i=0;i<256;i++){
            g.palette[i].r = tmppal[i].r;
            g.palette[i].g = tmppal[i].g;
            g.palette[i].b = tmppal[i].b;
        }
        set_palette( (RGB *)&g.palette );
        refix_all_display();    //
        unscare_mouse();
    }else{
        // palette loading error
        alert("failed to load palette"," "," ","ok",NULL,0,0);
        set_palette( (RGB *)&opal );
    }


    }/* if pathptr is valid... */

    do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
}



void pal_save()
{
    int     palindex, i,j;
    char *pathptr;
    char *filename;
    int i1,i2;
    int file_color1, file_color2, file_color3;

    get_palette( (RGB *)&opal );
    file_color1 = 128;
    file_color2 = 129;
    file_color3 = 130;
    i1 = gui_bg_color;
    i2 = gui_fg_color;
    gui_bg_color = file_color1;
    gui_fg_color = file_color2;
//    set_color( file_color1, (RGB *)&file_rgb1);
//    set_color( file_color2, (RGB *)&file_rgb2);
//    set_color( file_color3, (RGB *)&file_rgb3);

        /* ... */
        /* ... */
        /* ... */
    if(stickypathpal==NULL){ stmp1[0]=0; stickypathpal=(char *)&stmp1; }

    pathptr = commdlg_save( "Save palette, select type", stickypathpal, (char *)&paltypes_save, NULL, (int *)&palindex );
    gui_bg_color=i1;
    gui_fg_color=i2;

    if ( pathptr != NULL && pathptr[0] != 0){  /* if cancel wasn't pressed... */
        strncpy( (char *)&stmp1, pathptr, 260 );    stmp1[260] = 0;
        strncpy( (char *)&stmp2, pathptr, 260 );    stmp2[260] = 0;
        filename = (char *)&stmp2;
        if((st=strrchr(stickypathpal,'\\'))!=NULL){ *st++='\\'; *st++=0; }
        /* ... */
        /* ... */
        /* ... */
    if(palindex<0||palindex>6){
        do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
        return;}
        filename = fix_filename_case( filename );
        filename = fix_filename_slashes( filename );
    if ( exists(filename)!=0 ){
        /** should ask for permission to overwrite **/
        i = alert("Warning! file exists!","Overwrite?",".","Ok","Cancel",' ',0);
        if(i==2){
        do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
        return;}
    }
    i = FALSE;
    if(palindex==0){    /* raw binary, 768 bytes bitrange VGA: 0-63 */
    i = save_raw6_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==1){    /* raw binary, 768 bytes bitrange: 0-255 */
    i = save_raw8_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==2){    /* JASC, bitrange: 0-255 */
    i = save_jasc_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==3){    /* NEOPAINT, bitrange VGA: 0-63 */
    i = save_neop_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==4){    /* Kisekae, bitrange: 0-16 */
    i = save_kiss_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==5){    /* ascii, bitrange: 0-256 */
    i = save_MAP_palette( filename, (RGB *)&g.palette );
    }
    if(palindex==6){    /* binary, bitrange: 0-63 */
    i = save_COL_palette( filename, (RGB *)&g.palette );
    }
    set_palette( (RGB *)&opal );
    }/* if pathptr is valid... */

    do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
}




/**************************************************************************
 *
 *  Statics, loads different types of palettes
 *
 *
 *
 **************************************************************************/


/* loads palette, VGA type, 6 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int load_raw6_palette(char *pathptr, RGB *pal )
{
    int i, size;
    FILE *fp;
    RGB *pa = pal;
    unsigned char g, r, b;

    size = file_size(pathptr);    if(size==0)return FALSE;
    if((fp=fopen(pathptr,"rb"))==NULL) return FALSE;
    size=size/3;    if(size>255)    size=255;
    for(i=0;i<size;i++){
    fread((unsigned char *)&r, 1, 1, fp);
    fread((unsigned char *)&g, 1, 1, fp);
    fread((unsigned char *)&b, 1, 1, fp);
    pa->r = r;
    pa->g = g;
    pa->b = b;
    pa++;
    }
    fclose(fp);
    return TRUE;
}

/* loads palette, 8 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int load_raw8_palette(char *pathptr, RGB *pal )
{
    int i, size;
    FILE *fp;
    RGB *pa=pal;
    unsigned char g, r, b;

    size = file_size(pathptr);    if(size==0)return FALSE;
    if((fp=fopen(pathptr,"rb"))==NULL) return FALSE;
    size=size/3;    if(size>255)    size=255;
    for(i=0;i<size;i++){
    fread((unsigned char *)&r, 1, 1, fp);
    fread((unsigned char *)&g, 1, 1, fp);
    fread((unsigned char *)&b, 1, 1, fp);
    pa->r = r>>2;
    pa->g = g>>2;
    pa->b = b>>2;
    pa++;
    }
    fclose(fp);
    return TRUE;
}

/* loads palette, 8 bits for each RGB */
static int load_jasc_palette(char *pathptr, RGB *_pal)
{
/*
 *   ID:             JASC-PAL
 *   version:        0100
 *   entries:        256
 *   rgb:            0 0 0
 */
    unsigned char g, r, b;
    int     i, size, entries;
    FILE    *fp;
    RGB     *pal = _pal;
    char    dest[55];
    char    id[]="JASC-PAL";
    char    version[]="0100";

    pal = _pal;

    size = file_size(pathptr);    if(size==0) return FALSE;
    if((fp=fopen(pathptr,"r"))==NULL) return FALSE;
    /* get Identity and compare */
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get ID */
    if( strncmp( (char *)&dest, (char *)&id, strlen(id)) != 0  ) return FALSE;
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get version */
    if( atoi( (char *)&version ) > 100 ) return FALSE;
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get entries */
    entries = atoi( (char *)&dest );
    if( entries > 256 ) entries = 256;
    for(i=0;i<entries;i++){
    if( fgets((char *)&dest, 50, fp)==NULL){ fclose(fp); return FALSE; }
    dest[20]=0;
    sscanf( (char *)&dest, "%d %d %d", (int *)&r, (int *)&g, (int *)&b);
    pal->r = r>>2;
    pal->g = g>>2;
    pal->b = b>>2;
    pal++;
    }
    fclose(fp);
    return TRUE;
}


/* loads neopaint palette, VGA type, 6 bits for each RGB  */
static int load_neop_palette(char *pathptr, RGB *pal )
{
/*
 *   ID:             NeoPaint Palette File
 *   copyright:      (C)1992-93 OSCS Software Development, Inc.
 *   entries:        256
 *   rgb:            0 0 0
 */
    int i, size, entries;
    FILE *fp;
    RGB *pa=pal;
    unsigned char g, r, b;
    char dest[55];
    char id[]="NeoPaint Palette File";

    size = file_size(pathptr);    if(size==0)return FALSE;
    if((fp=fopen(pathptr,"r"))==NULL) return FALSE;
    /* get Identity and compare */
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get ID */
    if( strncmp( (char *)&dest, (char *)&id, strlen(id)) != 0  ) return FALSE; /* compare */
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get ver/copyright */
    if( fgets( (char *)&dest, 50, fp)  == NULL ) return FALSE; /* get entries */
    entries = atoi( (char *)&dest );
    for(i=0;i<entries;i++){
    if( fgets( (char *)&dest, 50, fp) == NULL ) return FALSE;
    sscanf( (char *)&dest, "%d %d %d", (int *)&r, (int *)&g, (int *)&b);
    pa->r = r;
    pa->g = g;
    pa->b = b;
    pa++;
    }
    fclose(fp);
    return TRUE;
}

/* loads palette, 4 bits for each RGB */
/*
 *  PALETTE FILE (.KCF) FORMAT
 *  A color is specified with 16 bits (little endian).
 *  Each RGB component is 4 bits, resulting in a palette of 4096 colors.
 *  MSB           LSB
 *  | 0000 | gggg | rrrr | bbbb |
 *
 *  In the bytewise hex dump they look like:
 *      RB 0G RB 0G .. ..
 *
 *  16 bits x 16 colors x 10 groups = 320 bytes
 */
/*** should be made to ask for group, or load entire kcf file ***/
static int load_kiss_palette( char *pathptr, RGB *pal )
{
    FILE *fp;
    RGB  *pa;
    int     i,j,y,id;
    int     bpp, colors, groups, type;
    unsigned char   rb, g, r, b, idc[4],mark;
    unsigned short  trash;

    if((fp=fopen(pathptr,"rb"))==NULL) return FALSE;
    fseek( fp, 0L, SEEK_SET );

    bpp=12;                       /* assuming old type of palette */
    type=0;                       /* assuming old type of palette */
    colors = 16;                  /* assuming old type of palette */
    groups = 10;                  /* assuming old type of palette */


    /* check for newer CEL type, id must be 'KiSS' */
    fread((unsigned char  *)&idc, 4 ,1,fp);
    id = (idc[3]<<24) | (idc[2]<<16) | (idc[1]<<8) | (idc[0]);

    if( id==0x5353694b ){    /* probably new CEL, read mark */
    fread((unsigned char  *)&mark, 1 ,1,fp); /* must be 0x10 */
    }

    if( id==0x5353694b && mark==0x10 ){    /* new type of palette */
    type=1;                 /* new type of palette */
    fread((unsigned char  *)&b, 1 ,1,fp); /* read bpp 12 or 24 */
    bpp = b;
    fread((unsigned short *)&trash, 2 ,1,fp); /* reserved */
    fread((unsigned short *)&trash, 2 ,1,fp); /* number of colors in one group */
    colors = trash;
    fread((unsigned short *)&trash, 2 ,1,fp); /* number of groups */
    groups = trash;
    fseek( fp, 32L, SEEK_SET );
    }else{ fseek(fp, 0L, SEEK_SET);}

/*
offset  size    contents
+0      4B      Identifier 'KiSS' ( 4Bh 69h 53h 53h )
+4      B       Palette file mark ( 10h )
+5      B       bits per color ( 12 or 24 )
+6      W       Reserved
+8      W(L,H)  number of colors in one palette group ( 1 ... 256 )
+10     W(L,H)  number of palette groups ( 1 ... 10 )
+12     W       Reserved
+14     W       Reserved
+16     16B     Reserved
*/

    if(bpp==24){    /* read in new type */
    pa=pal;
    for(j=y=0;j < groups ;j++){
    for(i=0;  i < colors ;i++){
    fread((unsigned char *)&r, 1, 1, fp);
    fread((unsigned char *)&g, 1, 1, fp);
    fread((unsigned char *)&b, 1, 1, fp);
    r = r>>2;    g = g>>2;    b = b>>2;
    pa->r = r;
    pa->g = g;
    pa->b = b;
    y++;
    if ( y<255 ) pa++;
    }}  /* for */
    }

    if(bpp==12){    /* read in old type */
    pa=pal;
    for(i=0;i< colors*groups ; i++){
    fread((unsigned char *)&rb, 1, 1, fp);
    fread((unsigned char *)&g, 1, 1, fp);
    r = rb;
    b = rb;
    r = r>>4;
    b = b&15;
    g = g&15;
    r = r<<2;    g = g<<2;    b = b<<2;
    pa->r = r;
    pa->g = g;
    pa->b = b;
    pa++;
    }/* for */
    }

    fclose(fp);
    return TRUE;
}


/* loads palette, 8 bits for each RGB */
static int load_MAP_palette(char *pathptr, RGB *pal)
{
/*
 *   Silimar to JASC palette but without a header
 *  256 entries, each entry range 0-255
 *
 */
    int i, size;
    FILE *fp;
    RGB *pa;
    unsigned char g, r, b;
    char dest[55];

    size = file_size(pathptr);    if(size==0)return FALSE;

    if((fp=fopen(pathptr,"r"))==NULL) return FALSE;
    pa=pal;
    for(i=0;i<256;i++){
    if( fgets( (char *)&dest, 50, fp) == NULL ) return FALSE;
    sscanf( (char *)&dest, "%d %d %d", (int *)&r, (int *)&g, (int *)&b);
    pa->r = r>>2;
    pa->g = g>>2;
    pa->b = b>>2;
    pa++;
    }
    fclose(fp);
    return TRUE;
}











/* loads palette, VGA type, 6 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int load_COL_palette(char *pathptr, RGB *pal )
{
    return load_raw6_palette( pathptr, pal );
}


/**************************************************************************
 *
 *  END Statics, loads different types of palettes
 *
 *
 *
 **************************************************************************/





/**************************************************************************
 *
 *  Statics, loads different types of palettes
 *
 *
 *
 **************************************************************************/


/* saves palette, VGA type, 6 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int save_raw6_palette(char *pathptr, RGB *pal )
{
    int i;
    FILE *fp;
    RGB *pa;
    unsigned char g, r, b;

    if((fp=fopen(pathptr,"wb"))==NULL) return FALSE;
    pa=pal;
    for(i=0;i<256;i++){
    r = pa->r&63;
    g = pa->g&63;
    b = pa->b&63;
    pa++;
    fwrite((unsigned char *)&r, 1, 1, fp);
    fwrite((unsigned char *)&g, 1, 1, fp);
    fwrite((unsigned char *)&b, 1, 1, fp);
    }
    fclose(fp);
    return TRUE;
}

/* saves palette, 8 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int save_raw8_palette(char *pathptr, RGB *pal )
{
    int i;
    FILE *fp;
    RGB *pa;
    unsigned char g, r, b;

    if((fp=fopen(pathptr,"wb"))==NULL) return FALSE;
    pa=pal;
    for(i=0;i<256;i++){
    r = pa->r<<2;
    g = pa->g<<2;
    b = pa->b<<2;
    pa++;
    fwrite((unsigned char *)&r, 1, 1, fp);
    fwrite((unsigned char *)&g, 1, 1, fp);
    fwrite((unsigned char *)&b, 1, 1, fp);
    }
    fclose(fp);
    return TRUE;
}

/* saves palette, 8 bits for each RGB */
static int save_jasc_palette(char *pathptr, RGB *pal )
{
/*
 *   ID:             JASC-PAL
 *   version:        0100
 *   entries:        256
 *   rgb:            0 0 0
 */
    int i, ret;
    FILE *fp;
    RGB *pa=pal;
    unsigned char g, r, b;
    char id[]="JASC-PAL";

    if((fp=fopen(pathptr,"w"))==NULL) return FALSE;
    i=fprintf(fp,"%s\n",id);    if(i<0)return FALSE;
    i=fputs("0100\n",fp); if(i==EOF)return FALSE;
    i=fputs("256\n",fp);  if(i==EOF)return FALSE;
    for(i=0;i<256;i++){
    r=pa->r<<2;
    g=pa->g<<2;
    b=pa->b<<2;
    pa++;
    ret = fprintf(fp,"%d %d %d\n",r,g,b);
    if(ret<0)return FALSE;
    }
    fclose(fp);
    return TRUE;
}


/* saves palette, VGA type, 6 bits for each RGB */
static int save_neop_palette(char *pathptr, RGB *pal )
{
/*
 *   ID:             NeoPaint Palette File
 *   copyright:      (C)1992-93 OSCS Software Development, Inc.
 *   entries:        256
 *   rgb:            0 0 0
 */
    int i, ret;
    FILE *fp;
    RGB *pa=pal;
    unsigned char g, r, b;
    char id[]="NeoPaint Palette File";

    if((fp=fopen(pathptr,"w"))==NULL) return FALSE;
    i=fprintf(fp,"%s\n",id);    if(i<0)return FALSE;
    i=fputs("(C)1992-93 OSCS Software Development, Inc.\n",fp); if(i==EOF)return FALSE;
    i=fputs("256\n",fp);  if(i==EOF)return FALSE;
    for(i=0;i<256;i++){
    r=pa->r&63;
    g=pa->g&63;
    b=pa->b&63;
    pa++;
    ret = fprintf(fp,"%d %d %d\n",r,g,b);
    if(ret<0)return FALSE;
    }
    fclose(fp);
    return TRUE;
}

/* saves palette, 4 bits for each RGB */
/*
 *  PALETTE FILE (.KCF) FORMAT
 *  A color is specified with 16 bits (little endian).
 *  Each RGB component is 4 bits, resulting in a palette of 4096 colors.
 *  MSB           LSB
 *  | 0000 | gggg | rrrr | bbbb |
 *
 *  In the bytewise hex dump they look like:
 *      RB 0G RB 0G .. ..
 *
 *  16 bits x 16 colors x 10 groups = 320 bytes
 */
static int save_kiss_palette(char *pathptr, RGB *pal )
{
    /*** should be made to ask for group, or save entire kcf file ***/
    int  i;
    FILE *fp;
    RGB *pa=pal;
    unsigned char rb, g, r, b, idc[4]="KiSS", type,mark;
    unsigned short trash;

    if((fp=fopen(pathptr,"wb"))==NULL) return FALSE;

    type=1;     /* 0=old type, 1=new type,  either 0 or 1. */

/*
offset  size    contents
+0      4B      Identifier 'KiSS' ( 4Bh 69h 53h 53h )
+4      B       Palette file mark ( 10h )
+5      B       bits per color ( 12 or 24 )
+6      W       Reserved
+8      W(L,H)  number of colors in one palette group ( 1 ... 256 )
+10     W(L,H)  number of palette groups ( 1 ... 10 )
+12     W       Reserved
+14     W       Reserved
+16     16B     Reserved
*/
    if(type==1){
    fwrite((unsigned char *)&idc, 4, 1, fp);    /* Identifier 'KiSS' ( 4Bh 69h 53h 53h )*/
    mark=0x10;
    fwrite((unsigned char *)&mark, 1, 1, fp);   /* Palette file mark ( 10h )   */
    mark = 24;
    fwrite((unsigned char *)&mark, 1, 1, fp);   /* bits per color ( 12 or 24 ) */
    trash=0;
    fwrite((unsigned short *)&trash, 2, 1, fp); /* Reserved */
    trash=256;
    fwrite((unsigned short *)&trash, 2, 1, fp); /* number of colors in one palette group ( 1 ... 256 ) */
    trash=1;
    fwrite((unsigned short *)&trash, 2, 1, fp); /* number of palette groups ( 1 ... 10 ) */
    trash=0;
    fwrite((unsigned short *)&trash, 2, 2, fp); /* Reserved */
    fwrite((unsigned short *)&trash, 2, 8, fp); /* Reserved */
    pa=pal;
    for(i=0;i<256;i++){
    r=pa->r>>2;
    g=pa->g>>2;
    b=pa->b>>2;
    pa++;
    fwrite((unsigned char *)&r, 1, 1, fp);
    fwrite((unsigned char *)&g, 1, 1, fp);
    fwrite((unsigned char *)&b, 1, 1, fp);
    }/*for*/
    }

    if(type==0){
    for(i=0;i<160;i++){
    r=pa->r>>2;
    g=pa->g>>2;
    b=pa->b>>2;
    pa++;
    r = r&15;
    g = g&15;
    b = b&15;
    r = r<<4;
    rb = r | b;
    fwrite((unsigned char *)&rb, 1, 1, fp);
    fwrite((unsigned char *)&g, 1, 1, fp);
    }/*for*/
    }
    fclose(fp);
    return TRUE;
}




/* saves palette, 8 bits for each RGB */
static int save_MAP_palette(char *pathptr, RGB *pal )
{
/*
 *   Similar to JASC palette but without the header
 *   256 entries, each entry range 0-255
 */
    int i, ret;
    FILE *fp;
    RGB *pa=pal;
    unsigned char g, r, b;

    if((fp=fopen(pathptr,"w"))==NULL) return FALSE;
    for(i=0;i<256;i++){
    r=pa->r<<2;
    g=pa->g<<2;
    b=pa->b<<2;
    pa++;
    ret = fprintf(fp,"%d %d %d\n",r,g,b);
    if(ret<0)return FALSE;
    }
    fclose(fp);
    return TRUE;
}


/* saves palette, VGA type, 6 bits for each RGB */
/* returns TRUE on success, FALSE on failure */
static int save_COL_palette(char *pathptr, RGB *pal )
{
    return save_raw6_palette(pathptr,pal );
}





/**************************************************************************
 *
 *  END Statics, loads different types of palettes
 *
 *
 *
 **************************************************************************/






/* return index to palette type. on failure returns -1
  returned indexes:
        -1 - failure
         0 - autoselect (should not happen)
         1 - raw 6 bits
         2 - raw 8 bits
         3 - jasc       (16/256 colors)
         4 - neopaint   (16/256 colors)
         5 - kiss
         6 - MAP (ascii 256 colors)
         7 - COL (raw 6 bits)
*/
static int autodetect_paltype( char *pathptr )
{
    FILE    *fp;
    int     i, size;
    char dest[50];
    char id1[]="JASC-PAL";
    char id2[]="NeoPaint Palette File";
    char    *ext;
    unsigned char *pal, *st;

    size = file_size(pathptr);    if(size==0) return -1;

    for(i=0;i<49;i++) dest[i]=0;

    if((fp=fopen(pathptr,"r"))==NULL) return FALSE;
    st = fgets( (char *)&dest, 50, fp);         /* get ID */
    fclose(fp);
    if( st == NULL ) return -1;

    if( strncmp( dest, id1, strlen(id1)) == 0  ){
    /* file is JASC */
    return 3;
    }
    if( strncmp( dest, id2, strlen(id2) ) == 0 ){
    /* file is Neopaint */
    return 4;
    }
    /* check extension...KCF? */
    ext = get_extension( pathptr );
    if( strncmp(ext,"KCF",3)==0 || strncmp(ext,"kcf",3)==0 || size==320 ){
    /* file is kisekae */
    return 5;
    }

    /* check extension...MAP? */
    ext = get_extension( pathptr );
    if( strncmp(ext,"MAP",3)==0 || strncmp(ext,"map",3)==0 ){
    /* file is MAP */
    return 6;
    }

    /* check extension...COL? */
    ext = get_extension( pathptr );
/*    if( strncmp(ext,"COL",3)==0 || strncmp(ext,"col",3)==0 || size==768 ){ */
    if( strncmp(ext,"COL",3)==0 || strncmp(ext,"col",3)==0 ){
    /* file is COL */
    return 7;
    }

    /* file must be raw */

    pal = (unsigned char *) malloc(768+9);  if(pal==NULL) return -1;
    if((fp=fopen(pathptr,"rb"))==NULL) return FALSE;
    fread( pal, 768, 1, fp);         /* get pal data */
    fclose(fp);
    /* scan to see if data contains info above 63 */
    for(i=0;i<768;i++) if(pal[i]>63){ free(pal); return 2; }   /* 8 bits */
    free(pal);
    return 1;   /* 6 bits */
}

