/*
 * clip source/destination methods
 * copy rectangles with options.
 */


#include <allegro.h>
#include "data.h"
#include "ll.h"
#include "mtd.h"
#include "butil.h"
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)


/*  copy source to destination block        */
void copysrc2dst(  BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP *pspr3=NULL;
    int sx,sy;

    if(pspr1==NULL||pspr2==NULL) return;
    sx = min( clips.sx, clipd.sx );
    sy = min( clips.sy, clipd.sy );
    pspr3 = create_bitmap_clear ( clips.sx+1, clips.sy+1 );
    blit(pspr1, pspr3, clips.x1, clips.y1, 0, 0, sx+1, sy+1);
    blit(pspr3, pspr2, 0, 0, clipd.x1, clipd.y1, sx, sy);
    destroy_bitmap(pspr3);
}
/*  copy without scaling, with transparency */
void copysrc2dsttr(BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP *pspr3=NULL;
    int sx,sy;

    if(pspr1==NULL||pspr2==NULL) return;
    sx = min( clips.sx, clipd.sx );
    sy = min( clips.sy, clipd.sy );
    pspr3 = create_bitmap_clear ( sx + 1, sy + 1 );
    blit( pspr2, pspr3, clipd.x1, clipd.y1, 0, 0, sx+1, sy+1);
    masked_blit( pspr1, pspr3, clips.x1, clips.y1, 0, 0, sx+1, sy+1);
    blit(pspr3, pspr2, 0, 0, clipd.x1, clipd.y1, sx, sy);
    destroy_bitmap(pspr3);
}
/*  copy without scaling, with overlay      */
void copysrc2dstov(BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP *pspr3=NULL;
    int sx,sy;

    if(pspr1==NULL||pspr2==NULL) return;
    sx = min( clips.sx, clipd.sx );
    sy = min( clips.sy, clipd.sy );
    pspr3 = create_bitmap_clear ( sx + 1, sy + 1 );
    blit( pspr1, pspr3, clips.x1, clips.y1, 0, 0, sx+1, sy+1);
    masked_blit( pspr2, pspr3, clipd.x1, clipd.y1, 0, 0, sx+1, sy+1);
    blit(pspr3, pspr2, 0, 0, clipd.x1, clipd.y1, sx, sy);
    destroy_bitmap(pspr3);
}
/*  copy with scaling                       */
void copyscale(    BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP  *pspr3=NULL;

    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap_clear( clipd.sx+1, clipd.sy+1 );
    stretch_blit(pspr1, pspr3,\
    clips.x1, clips.y1, clips.sx, clips.sy, \
           0 ,        0 , clipd.sx, clipd.sy);
    blit(pspr3, pspr2, 0, 0, clipd.x1, clipd.y1, clipd.sx, clipd.sy);
    destroy_bitmap(pspr3);
}
/*  copy with scaling, with transparency    */
void copyscaletr(  BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP *pspr3=NULL, *pspr4=NULL;

    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap_clear  ( clipd.sx+1, clipd.sy+1 );
    pspr4 = create_bitmap_clear  ( clipd.sx+1, clipd.sy+1 );
    stretch_blit(pspr1, pspr3,\
    clips.x1 , clips.y1 , clips.sx, clips.sy, \
           0 ,        0 , clipd.sx, clipd.sy);
    blit( pspr2, pspr4,clipd.x1, clipd.y1, 0,0, clipd.sx+1, clipd.sy+1);
    masked_blit( pspr3, pspr4,       0  ,      0   ,0,0, clipd.sx+1, clipd.sy+1);
    blit(pspr4, pspr2, 0, 0, clipd.x1, clipd.y1, clipd.sx, clipd.sy);
    destroy_bitmap(pspr3);
    destroy_bitmap(pspr4);
}
/*  copy with scaling, with overlay         */
void copyscaleov(  BITMAP *pspr2, BITMAP *pspr1)
{
    BITMAP *pspr3=NULL, *pspr4=NULL;

    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap_clear  ( clipd.sx+1, clipd.sy+1 );
    pspr4 = create_bitmap_clear  ( clipd.sx+1, clipd.sy+1 );
    stretch_blit(pspr1, pspr3,\
    clips.x1 , clips.y1 , clips.sx, clips.sy, \
           0 ,        0 , clipd.sx, clipd.sy);
    blit( pspr3, pspr4,0,0,0,0, clipd.sx+1, clipd.sy+1);
    masked_blit( pspr2, pspr4,clipd.x1,clipd.y1,0,0, clipd.sx+1, clipd.sy+1);
    blit(pspr4, pspr2, 0, 0, clipd.x1, clipd.y1, clipd.sx, clipd.sy);
    destroy_bitmap(pspr3);
    destroy_bitmap(pspr4);
}

