/*


 */
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "method.h"
#include "ll.h"
#include "subs.h"
#include "btn.h"
#include "zoom.h"
#include "coord.h"
#include "subs.h"
#include "md.h"
#include "tb.h"
#include "ed.h"
#undef min
#undef max
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)


/**** prototypes ****/
void tristate_on_md2();
void md2_animate(char);
/**** prototypes ****/

static int oldkey[260];     /* unsorted */
static int map[260];        /* sorted   */


/* prototypes for helper functions */
static void flip(int *,int *);
static void sysblob( BITMAP *bmp, int x, int y );
/* prototypes for helper functions */























/* triangle draw, special */
/* MULTIPLE STATE MOUSE CLICKS:  CLICK, CLICK, ...       */
/* First state begins when user presses mouse button     */
/* State change occurs when user presses mouse again     */
/* states are ended when mouse is outside window         */
void tristate_on_md2()
{
    BITMAP *pspr1=NULL;
    int  x0,  y0,  x1,  y1,  x2,  y2, sx0, sy0, sx, sy;
    int  ax0, ay0, ax1, ay1, ax2, ay2;
    int  ix0, iy0, ix1, iy1, ix2, iy2;
    int  ox,  oy;
    int  dx,  dy;
    int  draw_color=0;
    int  i,j;
    char clickstate = 0;    /* states for triangle */
    int  cx1,cy1,cx2,cy2;
    int  cxs[3], cys[3];
    int  rx,ry,rsx,rsy; /* bounding rectangle dimensions */
    int  mx,my,mb;

    ax1=ay1=cx1=cy1=cx2=cy2=0;

    if( g.draw_method != MTD_DRAWTRIANGLE ) return;

    mb = mouse_b;

    i = mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
    ox  = ax0 = mx;    // 1st anchor
    oy  = ay0 = my;

    x1=y1=sx=sy=x2=y2=sx0=sy0=x0=y0=rx=ry=rsx=rsy=1;

rebegin2:
    mb = mouse_b;
    j=mb;if((j&1)!=0) draw_color = g.usercolor1;
    j=mb;if((j&4)!=0) draw_color = g.usercolor2;
    j=mb;if((j&2)!=0) draw_color = g.usercolor3;
    do j=mouse_b; while((j&7)!=0 );  // wait until user releases mouse button

    get_rect_bmp( rx,ry,rsx,rsy );


    /*********** forever loop *****************/
    for(;;){          /* forever loop */

    i = mousecatch_coords_screen( (int *)&mx, (int *)&my, NULL, NULL );
    dx = mx;    dx -= ox;   if( dx != 0 ) ox = mx;
    dy = my;    dy -= oy;   if( dy != 0 ) oy = my;


    if(  dx!=0 || dy!=0 ){         /*************  MOUSE MOVED  **************/
    set_rect_bmp( rx,ry,rsx,rsy );   // put back old buffer

    if(i==FALSE){ unscare_mouse(); return;}  // if mouse is outside MD...return

    if(clickstate==1){
    cxs[0] = ax0;     // find out the maximum extent of bounding rectangle
    cxs[1] = ax1;
    cxs[2] = mx;
    cys[0] = ay0;
    cys[1] = ay1;
    cys[2] = my;
    if( cxs[0] > cxs[1] ) flip( (int *)&cxs[0], (int *)&cxs[1] );
    if( cxs[1] > cxs[2] ) flip( (int *)&cxs[1], (int *)&cxs[2] );
    if( cxs[0] > cxs[1] ) flip( (int *)&cxs[0], (int *)&cxs[1] );
/*...*/
    if( cxs[1] > cxs[2] ) flip( (int *)&cxs[1], (int *)&cxs[2] );
    if( cxs[0] > cxs[1] ) flip( (int *)&cxs[0], (int *)&cxs[1] );

    if( cys[0] > cys[1] ) flip( (int *)&cys[0], (int *)&cys[1] );
    if( cys[1] > cys[2] ) flip( (int *)&cys[1], (int *)&cys[2] );
    if( cys[0] > cys[1] ) flip( (int *)&cys[0], (int *)&cys[1] );
/*...*/
    if( cys[1] > cys[2] ) flip( (int *)&cys[1], (int *)&cys[2] );
    if( cys[0] > cys[1] ) flip( (int *)&cys[0], (int *)&cys[1] );
    cx1 = cxs[0];
    cx2 = cxs[2];
    cy1 = cys[0];
    cy2 = cys[2];
    }
    if(clickstate==0){
        cx1 = min (ax0, mx);
        cx2 = max (ax0, mx);
        cy1 = min (ay0, my);
        cy2 = max (ay0, my);
    }
    rx  = cx1 - 1;
    ry  = cy1 - 1;
    rsx = cx2 - cx1 +1;
    rsy = cy2 - cy1 +1;

    get_rect_bmp( rx,ry,rsx,rsy );   /* get with new coords */

    scare_mouse();

/** **** APPLY METHOD ON ZOOMED SCREEN **** **/
/**                                         **/
//    if(clickstate==0){
//    draw_infoblock( cx1,cy1,cx2,cy2 );
//    }

    /* the "cad" look */
    if(g.flag_cad==TRUE )
        rect( screen,
            md_x + rx,
            md_y + ry,
            md_x + rx + rsx + g.zoom,
            md_y + ry + rsy + g.zoom,
            g.syscolor2 );
    /* the "cad" look */

    if(clickstate==0){
       line( screen, md_x + ax0+g.zoom/2, md_y + ay0+g.zoom/2, md_x + mx+g.zoom/2,  md_y + my+g.zoom/2,  g.syscolor2);
       sysblob( screen, md_x + mx,  md_y + my );
       draw_infoblock( md_x + ax0+g.zoom/2, md_y + ay0+g.zoom/2, md_x + mx+g.zoom,  md_y + my+g.zoom/2 );
    }
    if(clickstate==1){
       line( screen, md_x + ax0+g.zoom/2, md_y + ay0+g.zoom/2, md_x + ax1+g.zoom/2, md_y + ay1+g.zoom/2, g.syscolor2);
       line( screen, md_x + ax1+g.zoom/2, md_y + ay1+g.zoom/2, md_x + mx+g.zoom/2,  md_y + my+g.zoom/2,  g.syscolor2);
       line( screen, md_x + ax0+g.zoom/2, md_y + ay0+g.zoom/2, md_x + mx+g.zoom/2,  md_y + my+g.zoom/2,  g.syscolor2);
       sysblob( screen, md_x + ax1,  md_y + ay1 );
    draw_infoblock( md_x + ax1+g.zoom/2, md_y + ay1+g.zoom/2, md_x + mx+g.zoom/2,  md_y + my+g.zoom/2 );
    }
/**                                         **/
/** **** APPLY METHOD ON ZOOMED SCREEN **** **/

    unscare_mouse();
    }                              /*************  MOUSE MOVED  **************/


    mb = j = mouse_b;

    if(j&7){       /* ON CLICK ... */
    mb = mouse_b;
    j=mb;if((j&1)!=0) draw_color = g.usercolor1;
    j=mb;if((j&4)!=0) draw_color = g.usercolor2;
    j=mb;if((j&2)!=0) draw_color = g.usercolor3;

    clickstate++;
    if(clickstate==1){ /* click 1, put line */
        ax1 = mx;
        ay1 = my;
        }

    if(clickstate==2){ /* click 2, put triangle */
    ax2 = mx;
    ay2 = my;
    coord_screen2bin2( ax0, ay0, (int *)&ix0, (int *)&iy0);
    coord_screen2bin2( ax1, ay1, (int *)&ix1, (int *)&iy1);
    coord_screen2bin2( ax2, ay2, (int *)&ix2, (int *)&iy2);

    /** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/
    /**                                             **/

    set_rect_bmp( rx,ry,rsx,rsy );   /* put old coords */
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    if(g.flag_fill==TRUE){
        triangle( pspr1, ix0,iy0, ix1, iy1, ix2, iy2, draw_color);
    }else{
        if( g.flag_brush==FALSE ){
            line( pspr1, ix0,iy0,ix1,iy1, draw_color );
            line( pspr1, ix1,iy1,ix2,iy2, draw_color );
            line( pspr1, ix0,iy0,ix2,iy2, draw_color );
        }else{
            do_line ( pspr1, ix0,iy0,ix1,iy1, draw_color, put_blockbrush );
            do_line ( pspr1, ix1,iy1,ix2,iy2, draw_color, put_blockbrush );
            do_line ( pspr1, ix0,iy0,ix2,iy2, draw_color, put_blockbrush );
        }
    }
    CLOOP2
    /**                                             **/
    /** **** APPLY METHOD NOW, ON PIXEL BUFFER **** **/

        clickstate=0;
        ax0 = ax1;
        ay0 = ay1;

        scare_mouse();
        refresh_screen_quick();
        unscare_mouse();
        goto rebegin2;
    } /* clickstate 2, put triangle */





    do j=mouse_b; while((j&7)!=0 );
    }    /* when mouse is pressed */
    }    /* forever loop */
}

















/* plays a animation */
/* animtype: 0=forward play, 1=reverse play, 2=ping-pong, 3=..?... */
void md2_animate( char animtype )
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL, *bkgr=NULL;
    int i,j;
    int x,y;
    int FRAME=8;
    int bkmap_off_override;
    int ic=0, state;

    animtype &= 3;


    do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/

    x = g.screen_w/2 - g.sx/2;
    y = g.screen_h/2 - g.sy/2;
    bkgr = create_bitmap( g.sx+FRAME, g.sy+FRAME );
    if(bkgr==NULL) goto exit_now;   /*** allocation error ***/
    if(g.flag_bkmap==TRUE){
        pspr3 = create_bitmap( g.sx, g.sy );
        if(pspr3==NULL) goto exit_now;   /*** allocation error ***/
    }

    scare_mouse();
    blit( screen, bkgr, x,y,0,0,g.sx+FRAME ,g.sy+FRAME );
    rectfill( screen ,x,y,x+g.sx+FRAME-1,y+g.sy+FRAME-1, g.syscolor1 );
    unscare_mouse();
    clear_keybuf();

    state=1;
    for(;;){
    state++; state &= 1;
    /* type of anim: single play, reverse play, ping-pong */
    for(i=0;i<g.block_count;i++){
    if(animtype==0){    /* 0=forward play*/
    ic = i;
    }
    if(animtype==1){    /* 1=reverse play */
    ic = g.block_count-i;
    }
    if(animtype==2){    /* 2=ping-pong */
    if(state==0)    ic = i;
    if(state==1)    ic = g.block_count-i;
    }
    if( ic< 0 ) ic=0;
    if( ic> g.block_count) ic=g.block_count;
    if( ic==g.block_count) ic--;
    if( g.animate_delay >= 1 )
        rest( g.animate_delay );   /* delay 70 milliseconds between frames (default) */
    if (key[KEY_ESC]) goto exit_now;
    if (key[KEY_SPACE]) goto exit_now;
    if (key[KEY_ENTER]) goto exit_now;
    if ((mouse_b&7)!=0) goto exit_now;

    pspr1 = ll_get_sprite( ic );




    if( g.flag_bkmap == FALSE ){    // ...............................

        scare_mouse();
        acquire_screen();
        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy);
            blit( g.layer0, screen,0,0,x+FRAME/2,y+FRAME/2,g.sx,g.sy );//pspr1
        }else{
            blit( pspr1, screen,0,0,x+FRAME/2,y+FRAME/2,g.sx,g.sy );
        }
        release_screen();
        unscare_mouse();



    }else{                          // ...............................


    bkmap_off_override = FALSE;

    if( g.bkmap.type == 0 ){    // 0 = "number", 1 = "-1", 2 = "+1", 3 = "file"
        if( g.bkmap.nr > g.block_count ) g.bkmap.nr = g.block_count;
        pspr2 = ll_get_sprite( g.bkmap.nr );
        }
    if( g.bkmap.type == 2 ){    // -1
        if( ic==0 ) bkmap_off_override = TRUE;
        if( ic!=0 ) pspr2 = ll_get_sprite( ic-1 );
        }
    if( g.bkmap.type == 1 ){    // +1
        if( ic == (g.block_count-1) ) bkmap_off_override= TRUE;
        if( ic != g.block_count ) pspr2 = ll_get_sprite( ic+1 );
        }
    if( g.bkmap.type == 3 )  pspr2 = g.bkmap.map;

    if( pspr2==NULL ) bkmap_off_override=TRUE;

        if(bkmap_off_override==FALSE){

               clear_bitmap( pspr3 );
               blit( pspr2, pspr3, 0,0,0,0,g.sx,g.sy );

        if( g.flag_grid == TRUE ){
        grid_display_rect2( pspr3 );
        }

        masked_blit( pspr1, pspr3, 0,0,0,0,g.sx,g.sy );

               scare_mouse();
               blit( pspr3, screen,0,0,x+FRAME/2,y+FRAME/2,g.sx,g.sy );
               unscare_mouse();
        }else{

        scare_mouse();
        acquire_screen();
        if( g.flag_grid == TRUE ){
            clear_bitmap( g.layer0 );
            grid_display_rect2( g.layer0 );
            masked_blit( pspr1, g.layer0, 0,0,0,0,g.sx,g.sy);
            blit( g.layer0, screen,0,0,x+FRAME/2,y+FRAME/2,g.sx,g.sy );
        }else{
            blit( pspr1, screen,0,0,x+FRAME/2,y+FRAME/2,g.sx,g.sy );
        }
        release_screen();
        unscare_mouse();

        }
    }

    }
    }




exit_now:
    if(g.flag_bkmap==TRUE && pspr3!=NULL) destroy_bitmap(pspr3);
    if(bkgr!=NULL){
        scare_mouse();
        acquire_screen();
        blit( bkgr, screen,0,0,x,y,g.sx+FRAME,g.sy+FRAME );
        release_screen();
        unscare_mouse();
        destroy_bitmap(bkgr);
        }
    do j=mouse_b; while((j&7)!=0 );  /* wait until user releases mouse button*/
    clear_keybuf();
}


























void md2_binop_or()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y,color1, color2, color3=0;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);   if(color1==-1)color1=0;
    color2 = getpixel(pspr2,x,y);   if(color2==-1)color2=0;
    /************ OR **************/
    if( (color1 == 0) && (color2 == 0) ) color3=0;
    if( (color1 != 0) || (color2 != 0) ) color3=255;
    /************ OR **************/
    putpixel(pspr3,x,y, color3 );
    }}
    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}

void md2_binop_xor()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y,color1, color2, color3=0;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);   if(color1==-1)color1=0;
    color2 = getpixel(pspr2,x,y);   if(color2==-1)color2=0;
    /************ XOR **************/
    if((color1 == 0)&&(color2 == 0))color3=0;
    if((color1 == 0)&&(color2 != 0))color3=255;
    if((color1 != 0)&&(color2 == 0))color3=255;
    if((color1 != 0)&&(color2 != 0))color3=0;
    /************ XOR **************/
    putpixel(pspr3,x,y,color3);
    }}
    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}
void md2_binop_and()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y,color1, color2, color3=0;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);   if(color1==-1)color1=0;
    color2 = getpixel(pspr2,x,y);   if(color2==-1)color2=0;
    /************ AND **************/
    if(color1==0&&color2==0)color3=0;
    if(color1==0&&color2!=0)color3=0;
    if(color1!=0&&color2==0)color3=0;
    if(color1!=0&&color2!=0)color3=255;
    /************ AND **************/
    putpixel(pspr3,x,y,color3);
    }}
    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}


void md2_binop_copymask()   // first is image, second is mask
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y,color1, color2, color3=0;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);
    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);   if( color1==-1 ) color1=0;
    color2 = getpixel(pspr2,x,y);   if( color2==-1 ) color2=0;
    /************ Copy MASK **************/
    color3 = color1;
    if( color2!=0 ) color3 = color2;
    /************ Copy MASK **************/
    putpixel(pspr3,x,y,color3);
    }}
    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}


void md2_grey_invert()  //
{
    BITMAP *pspr1=NULL;
    int x,y;
    int color1;
    int ru,gu,bu;

    pspr1 = ll_get_sprite( g.block_current );

    for(y=0;y< g.sy ;y++){
    for(x=0;x< g.sx ;x++){
    if(g.bpp<=8){
    color1 = getpixel(pspr1,x,y) & 255;
    color1 = 255 - color1;
    putpixel(pspr1,x,y,color1);
    }else{
    ru = 255-getr(getpixel(pspr1,x,y));
    gu = 255-getg(getpixel(pspr1,x,y));
    bu = 255-getb(getpixel(pspr1,x,y));
    putpixel(pspr1,x,y,makecol(ru,gu,bu));
    }
    }}
}


void md2_grey_avg()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y;
    int color1, color2, color3;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);
    color2 = getpixel(pspr2,x,y);
    // ************ AVERAGE **************
    color3 = (color1+color2) / 2;
    // ************ AVERAGE **************
    putpixel( pspr3,x,y,color3 );
    }}

    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}

void md2_grey_add()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y;
    int color1, color2, color3;
    int ru1=0,gu1=0,bu1=0;
    int ru2=0,gu2=0,bu2=0;
    int av1=0,av2=0,av3=0;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){

    color1 = getpixel(pspr1,x,y);
    color2 = getpixel(pspr2,x,y);

    if(g.bpp<=8){
    /************ ADD **************/
    color3 = color1 + color2;   if(color3>255)color3=255;
    /************ ADD **************/
    putpixel(pspr3,x,y,color3);
    }else{
    ru1=getr(color1);   ru2=getr(color2);
    gu1=getg(color1);   gu2=getg(color2);
    bu1=getb(color1);   bu2=getb(color2);
    /************ ADD **************/
    av1 = ru1 + ru2;    if(av1>255)av1=255;
    av2 = gu1 + gu2;    if(av2>255)av2=255;
    av3 = bu1 + bu2;    if(av3>255)av3=255;
    /************ ADD **************/
    putpixel(pspr3,x,y,makecol(av1,av2,av3));

    }

    }}

    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}

void md2_grey_sub()
{
    BITMAP *pspr1=NULL, *pspr2=NULL, *pspr3=NULL;
    int x,y;
    int color1, color2, color3;
    int ru1,gu1,bu1;
    int ru2,gu2,bu2;
    int av1,av2,av3;

    if( (g.block_current) != (g.block_count-1) )
        pspr1 = ll_get_sprite( g.block_current );
    if( (g.block_current+1) != (g.block_count) )
        pspr2 = ll_get_sprite( g.block_current+1 );
    if(pspr1==NULL||pspr2==NULL) return;
    pspr3 = create_bitmap(g.sx, g.sy);  if( pspr3==NULL ) return;
    clear_bitmap(pspr3);

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    color1 = getpixel(pspr1,x,y);
    color2 = getpixel(pspr2,x,y);

    if(g.bpp<=8){
    /************ SUB **************/
    color3 = (color1/2) - (color2/2);
    if(color3<0) color3 = 0;
    /************ SUB **************/
    putpixel(pspr3,x,y,color3);
    }else{
    ru1=getr(color1);   ru2=getr(color2);
    gu1=getg(color1);   gu2=getg(color2);
    bu1=getb(color1);   bu2=getb(color2);
    /************ SUB **************/
    av1 = ru1/2-ru2/2;    if(av1<0) av1 = 0;
    av2 = gu1/2-gu2/2;    if(av2<0) av2 = 0;
    av3 = bu1/2-bu2/2;    if(av3<0) av3 = 0;
    /************ SUB **************/
    putpixel(pspr3,x,y,makecol(av1,av2,av3));
    }
    }}
    ll_insert( g.block_current, pspr3 );
    g.block_count=ll_return_spr_count();
    destroy_bitmap(pspr3);
}












/*
 ********************************************************************
 *
 *      SORT
 *
 **********************************
*/

/* helper functions */
static void md2_makesort_light_up();
static void md2_sort_g_palette();
static void md2_sort_bitmap(BITMAP *,BITMAP *);
/* helper functions */



/* sort palette indexes, according to light values */
void md2_sort_light_up()
{
    int i, old;
    BITMAP *pspr1;

    if(g.bpp>8) return;

    old = g.buttoncolor;   /* fromcolor */
    release_handle_from_palette();  /* put back original colors on palette */

    /* precalc...*/
    md2_makesort_light_up();
    /* ... sort all bitmaps ... */
    for( i=0; i<(g.block_count) ; i++ ) {
    pspr1 = ll_get_sprite( i );
    if( pspr1==NULL ) break;
    md2_sort_bitmap( pspr1, pspr1 );
    }
    /* ... sort palette ... */
    md2_sort_g_palette();                   /* sort and set */

    bestfit_main_graphic_to_g_palette();    /* new g_colors...*/
    remap_bitmap( g.bitmap_buttons, old, g.buttoncolor ); /* remap buttons to color */
    destroy_old_fillmaps();
    make_new_fillmaps();        /* ............... */

    scare_mouse();


/*
// .......
    blit( g.bitmap_buttons, g.bitmap_buttons_remap, 0,0,0,0, g.bitmap_buttons->w, g.bitmap_buttons->h );
    // do a new remap of buttons based on current colors
    remap_bitmap( g.bitmap_buttons_remap, 255, g.buttoncolor );
    alloc_buttonarray_buttons();
    refix_all_display();
// ..........
*/




//...                        /* button array */
    ed_hide_buttonarray    ( g_buttonarray_handle );
    subs_refix_buttonarray_btncolors( g_buttonarray_handle );
    ed_rerender_buttonarray( g_buttonarray_handle,g.syscolor1,g.syscolor3,g.syscolor1,g.syscolor2 );
    ed_show_buttonarray    ( g_buttonarray_handle );
    bt_draw_outlines(); /* desktop buttons !!!! */
//...                        /* button array */

    sp_draw_outlines(); /* spritebar */
    tb_draw_outlines(); /* toolbar buttons */
    md_draw_outlines(); /* main draw */
    broadcast_dialog_message(MSG_DRAW,0);
    unscare_mouse();
    in_display();
    update_pl(1);       /* display blocks on palette window */
}





/* sort the palette, increasing light value.
 * Higher light values are placed higher up in index.
 *
 * output is in global     map[]   array with the new indexes.
 * The old indexes are in  from[] array.
 */
static void md2_makesort_light_up()
{
    int i,j,k,c;
    unsigned int re,ge,be;
    int token, last_index;

    if(g.bpp>8) return;
    for(i=0;i<256;i++){ /* plain copy, create key value */
    map[i] = 0;
    re = g.palette[i].r << 2;
    ge = g.palette[i].g << 2;
    be = g.palette[i].b << 2;
    re &= 255;
    ge &= 255;
    be &= 255;
    re = re + ge + be;
    re = re/3;
    oldkey[i] = re & 255;
    }

    /* get lowest and put in buffer */
    j=0;
    for(k=0;k<256;k++){

    token = 888;
    last_index=k;
    for(i=0;i<256;i++){
        c = oldkey[i]; /* value between 0-255 */
        if( c <= token ){ token = c; last_index = i; }
    }/* for i */

    /*    map[ k ] = last_index;*/
    map[ last_index ] = k;
    oldkey[ last_index ] = 9999;  /* disable */

    }/* for k */
    /* get lowest and put in buffer */
}









/* sort global palette, using map[] array */
static void md2_sort_g_palette()
{
    PALETTE pal;
    int i,t=0;

    if(g.bpp>8) return;

    /* copy palette */
    for(i=0;i<256;i++){
    pal[i].r = g.palette[i].r & 63;
    pal[i].g = g.palette[i].g & 63;
    pal[i].b = g.palette[i].b & 63;
    }

    /* re-sort palette */
    for(i=0;i<256;i++){
    t = map[i];
    g.palette[ t ].r = pal[ i ].r & 63;
    g.palette[ t ].g = pal[ i ].g & 63;
    g.palette[ t ].b = pal[ i ].b & 63;
    }

    /* set new palette */
    set_palette( (RGB *)&g.palette );
}

/* sort pixel values, using map[] array */
static void md2_sort_bitmap( BITMAP *source, BITMAP *destination )
{
    int x,y,c,t;

    /* change bitmap */
    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    c = getpixel( source ,x,y);
    c &= 255;
    t = map[ c ];
    t &= 255;
    putpixel( destination ,x,y, t );
    }}
}

/* split one file into threee files of r,g,b */
void md2_split_rgb()
{
    BITMAP *pspr1=NULL, *bmp=NULL;
    int i,x,y,c;


    pspr1 = ll_get_sprite( g.block_current );


    if((bmp=create_bitmap(g.sx,g.sy))==NULL)return;
    // clear_bitmap(bmp);

    for(y=0;y<g.sy;y++){for(x=0;x<g.sx;x++){

        if(g.bpp<=8){
        i = getpixel(pspr1,x,y)&255;
        c = g.palette[i].b;         /* B */
        c <<= 2;
        putpixel(bmp,x,y,c);
        }else{
        i = getpixel(pspr1,x,y);
        c = getb(i);
        putpixel(bmp,x,y, makecol(c,c,c));
//        putpixel(bmp,x,y, makecol(0,0,c));
        }

    }}

    if( (g.block_current) == (g.block_count-1) ){
    ll_append_tail( bmp );
    }else{    ll_insert( g.block_current+1, bmp ); destroy_bitmap(bmp);    }



    g.block_count = ll_return_spr_count();
    ll_set_tag( g.block_current+1, 'B' );  /* crunsh... */




    if((bmp=create_bitmap(g.sx,g.sy))==NULL)return; clear_bitmap(bmp);
    for(y=0;y<g.sy;y++){for(x=0;x<g.sx;x++){

        if(g.bpp<=8){
        i = getpixel(pspr1,x,y)&255;
        c = g.palette[i].g;         /* G */
        c <<= 2;
        putpixel(bmp,x,y,c);
        }else{
        i = getpixel(pspr1,x,y);
        c = getg(i);
        putpixel(bmp,x,y, makecol(c,c,c));
//        putpixel(bmp,x,y, makecol(0,c,0));
        }

    }}

    if( (g.block_current) == (g.block_count-1) ){
    ll_append_tail( bmp );
    }else{    ll_insert( g.block_current+1, bmp ); destroy_bitmap(bmp);    }


    g.block_count = ll_return_spr_count();
    ll_set_tag( g.block_current+1, 'G' );



    if((bmp=create_bitmap(g.sx,g.sy))==NULL)return; clear_bitmap(bmp);
    for(y=0;y<g.sy;y++){for(x=0;x<g.sx;x++){

        if(g.bpp<=8){
        i = getpixel(pspr1,x,y)&255;
        c = g.palette[i].r;         /* R */
        c <<= 2;
        putpixel(bmp,x,y,c);
        }else{
        i = getpixel(pspr1,x,y);
        c = getr(i);
        putpixel(bmp,x,y, makecol(c,c,c));
//        putpixel(bmp,x,y, makecol(c,0,0));
        }

    }}

    if( (g.block_current) == (g.block_count-1) ){
    ll_append_tail( bmp );
    }else{    ll_insert( g.block_current+1, bmp ); destroy_bitmap(bmp);    }


    g.block_count=ll_return_spr_count();
    ll_set_tag( g.block_current+1, 'R' );


}






/* RGB -> color mapping table. Not needed, but speeds things up */
RGB_MAP rgb_table;


/* greyscale & negative color mapping table */
COLOR_MAP greyscale_table, negative_table;



/* Here comes our custom function. It's designed to take the input colors
 * (red, green & blue) and return a greyscale color for it. This way, when
 * any drawing function draws say over green, it draws the greyscale color
 * for green.
 * 'pal' is the palette we are looking in to find the colors.
 * Now, imagine we want to draw a pixel with color A, over color B.
 * Once the table is created, set, and the drawing mode is TRANSLUCENT, then
 * A is the 'x' color passed to the function and B is the 'y' color passed
 * to the function.
 * Since we want a greyscale effect with no matter what A (or 'x') color, we
 * ignore it and use y to look at the palette.
 * The x=x line is there to avoid compiler warnings.
 * NOTE:
 * When you return the rgb value, you don't need to search the palette for
 * the nearest color, Allegro does this automatically.
 */
RGB return_grey_color(PALETTE pal, int x, int y)
{
   int c;
   RGB rgb;

   // First create the greyscale color
   c= (pal[y].r*0.3+pal[y].g*0.5+pal[y].b*0.2);
   // Now assign to our rgb triplet the palette greyscale color...
   rgb.r = rgb.g = rgb.b = c;
/*
   rgb.r = pal[y].r;
   rgb.g = pal[y].g;
   rgb.b = pal[y].b;
*/
   x=x;
   // ...and return it.
   return rgb;
}


/*
 * ( not ready yet )
 * make a single file from 3 greyscale pictures.
 * assigning 3 bits for Red
 * assigning 3 bits for Green
 * assigning 2 bits for Blue
 * making a 332 palette.
 * setting a new palette
 */
void md2_join_rgb()
{
    BITMAP *pspr0, *pspr00;  /* new picture */
    BITMAP *pspr1, *pspr2, *pspr3;  /* rgb */
    int x,y;
    int re=0,ge=0,be=0;
//    unsigned int re,ge,be;

    if( ( g.block_current + 2) > (g.block_count-1) ) return; /* out of range */



    // TRUECOLOR......
    if(g.bpp>8){
    if((pspr0=create_bitmap( g.sx,g.sy ))==NULL) return;
    pspr1 = ll_get_sprite( g.block_current+0 ); /* R */
    pspr2 = ll_get_sprite( g.block_current+1 ); /* G */
    pspr3 = ll_get_sprite( g.block_current+2 ); /* B */
    if(pspr1==NULL||pspr2==NULL||pspr3==NULL) return;
    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    re = getr(getpixel(pspr1,x,y));
    ge = getg(getpixel(pspr2,x,y));
    be = getb(getpixel(pspr3,x,y));
    putpixel(pspr0,x,y, makecol( re, ge, be ) );
    }}
    ll_insert( g.block_current, pspr0 );
    destroy_bitmap(pspr0);
    g.block_count = ll_return_spr_count();
    return;
    }





    /* this isn't needed, but it speeds up the color table calculations */
    /* "Generating RGB Table " */
    create_rgb_table(&rgb_table, (RGB *)&g.palette, NULL);
    rgb_map = &rgb_table;                        /* for reducing colors */
    /* build a color lookup table for greyscale effect */
    /* "Generating Greyscale Table " */
//    create_color_table(&greyscale_table, (RGB *)&g.palette, return_grey_color, NULL);
    /* select the greyscale table */
    color_map = &greyscale_table;

    if((pspr0=create_bitmap_ex( 8,  g.sx,g.sy))==NULL) return;
    if((pspr00=create_bitmap_ex(24, g.sx,g.sy))==NULL) return;

    pspr1 = ll_get_sprite( g.block_current+0 ); /* R */
    pspr2 = ll_get_sprite( g.block_current+1 ); /* G */
    pspr3 = ll_get_sprite( g.block_current+2 ); /* B */
    if(pspr0==NULL||pspr1==NULL||pspr2==NULL||pspr3==NULL) return;

    set_color_conversion( COLORCONV_TOTAL   );

    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    re = getpixel(pspr1,x,y);
    ge = getpixel(pspr2,x,y);
    be = getpixel(pspr3,x,y);
    putpixel(pspr00,x,y, makecol24( re, ge, be ) );
    }}
    for(y=0;y<g.sy;y++){
    for(x=0;x<g.sx;x++){
    re = getpixel(pspr1,x,y)&255;
    ge = getpixel(pspr2,x,y)&255;
    be = getpixel(pspr3,x,y)&255;
    putpixel(pspr0,x,y, makecol8( re, ge, be ) );
    }}
    ll_insert( g.block_current, pspr0 );
    destroy_bitmap(pspr0);
    destroy_bitmap(pspr00);
    g.block_count = ll_return_spr_count();
    return;
}

static void flip( int *i, int *j )
{
    int a;
    a = *i;
    *i = *j;
    *j = a;
}


// draw a centroid on current bitmap and on coordinate
static void sysblob( BITMAP *bmp, int x, int y )
{
    int x1=x,y1=y,x2,y2;

    x2 = x1 + g.zoom*2;
    y2 = y1 + g.zoom*2;
    rectfill( screen, x1, y1, x2, y2, g.syscolor2 );
}

