/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\



        Parts and name convention:

                 MD - main draw window
                 PL - palette window
                 BT - main buttons
                 SP - sprite block bar
                 TB - toolbar buttons
                 IN - Information Window


 Position                -  x,y       -   position x
 Full size               -  sx, sy    -   size x
 Element size            -  esx, esy  -   element size x
 Space between elements  -  spx, spy  -   space size x
 Global variable prefix  -  g_        -   global_


 Files:
          btn.c   - main buttons
          clip.c  - the clipping rectangles in TB.
          coord.c - coordinates zoomed and unzoomed.
          data.c  - main data
          dlg.c   - popup dialogs
          ed.c    - Extra dialog objects
          fsel.c  - Extra File selector
          ll.c    - linked list subroutines.
          main.c  - this file
          md.c    - main display action handler and draw functions.
          md2.c   - Triangle draw function
          rect.c  - rectangle intersection and clipping.
          subs.c  - misc. subroutines.
          tb.c    - Toolbar routines.
          zoom.c  - takes care of diplaying the zoomed window in main display.

  TIF was killed yesterday, argh, damn lame code,
  hit the road yer skag! you'r a goner!

   This is probably the last version, i'm tired of bugging.
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <allegro.h>
#include <winalleg.h>
#include "method.h"
// #include "algbm.h"      /* GBM graphic formats */
// #include <sys/segments.h>   /* may noy be necessary...? */
#include "types.h"
#include "data.h"
#include "btn.h"
#include "ll.h"
#include "tb.h"
#include "ed.h"
#include "jpeg.h"
#include "subs.h"
#include "butil.h"
#include "gbminit.h"
#include "dllgbm/gbmalleg.h"
#include "tif.h"

#include "fnt8x16.h"    // data fixed font 8x16
#include "fnt8x8b.h"    // data fixed font 8x8b
#include "fnt23b.h"     //                 23x23 bold
#include "fnt6x8.h"     // data fixed font 6x8
/*
#include "fnt6x16.h"    // data fixed font 6x16
#include "fnt7x8.h"     // data fixed font 7x8
#include "fnt8x8.h"     // data fixed font 8x8
#include "fnt12x15.h"   //                 12x15
#include "fnt18x18.h"   //                 18x18
#include "fnt16x25.h"   //                 16x25
#include "fnt23.h"      //                 23x23
*/

void initialize_dxemodules();


BITMAP      *sprite_buffer;
DATAFILE    *datafile;







/** prototypes **/
void main_idle_function_callback();
/** prototypes **/






static void init_font_system(void);     /* must be done before display_frames_onscreen() */

static void init_font_system(void)
{
/*
    fnt3 = fnt_load_mem ((GRR *)&GrFont_FNT6x16, 0,0);
    fnt3 = fnt_load_mem ((GRR *)&GrFont_FNT7x8,  0,0);
    // bigger fonts
    fnt5 = fnt_load_mem ((GRR *)&GrFont_FNT12x15, 0,0);
    fnt6 = fnt_load_mem ((GRR *)&GrFont_FNT18x18, 0,0);
    fnt7 = fnt_load_mem ((GRR *)&GrFont_FNT16x25, 0,0);
    fnt8 = fnt_load_mem ((GRR *)&GrFont_FNT23b,   0,0);
*/
    // system fonts
    fnt1 = fnt_load_mem ((GRR *)&GrFont_FNT6x8,  0,0);   //(smallest font)
    fnt2 = fnt_load_mem ((GRR *)&GrFont_FNT8x16, 0,0);
    fnt4 = fnt_load_mem ((GRR *)&GrFont_FNT8x8b, 0,0);
    fnt8 = fnt_load_mem ((GRR *)&GrFont_FNT23b,   0,0); // default font, if none is selected

//    fnt8 = fnt_load_file( "fonts/xm12x24.fnt", 0,0 );  //
//    fnt8 = fnt_load_file( "fonts/xm4x6.fnt", 0,0 );  //
//    fnt8 = fnt_load_file( "fonts/cour20i.fnt", -3,0 );  // condens can be positive or negative
//    fnt8 = fnt_load_file( "fonts/helv22.fnt", 0,0 );    // default font
//    fnt8 = fnt_load_file( "fonts/tms22.fnt", 0,0 );
}


/*
 *
 * return -1 on error
 */
short strip_extension( byte *name )
{
    byte    *s;

    if(name==NULL) return -1;
    if(name[1]==0) return -1;
    s = strrchr( name, '.' );
    if(s!=NULL) s[0]=0;
    return 0;
}
void add_extension(  byte *name, byte *extension )
{
    if(name==NULL || extension==NULL) return;
    strcat( name, "." );
    strcat( name, extension );
}
/*
 * return 0 if name have extension
 */
short have_extension( byte *name )
{
    if(name==NULL) return -1;
    if(strrchr( name, '.' )==NULL) return -1;
    return 0;
}

/*
    Function Returns 0 if file exist,
    else returns -1.
*/
static int does_file_exist(char * filename)
{
    FILE *f;
    f = fopen(filename,"rb");    if(f == NULL){return -1;}
    fclose(f);
    return 0;
}



void iksipiksi( char *extension )
{
    //register extensions for all filestandards
    register_bitmap_file_type(extension,
            (BITMAP *(*)(const char *, RGB *)) load_gbm,
            (int (*)(const char *, BITMAP *, const RGB *))  save_gbm);




}




/*******************************************************
 *
 *  Idle function with mouse.
 *
 *
 *******************************************************/

/*
 * called on idle by the main drawing window screen
 *
 */
/* must be locked ? */
void main_idle_function_callback()
{
    /* ... do many idle functions ... */
    /* ... idle mouse ... */
//    if(g.flag_audio==TRUE)     // only update if allowed to
//        midi_idle_ticks();
   /* ... idle cd   player ... */
    /* ... idle other thing ... */
    return;
}



// *******************************************
// *******************************************
// *******************************************




int main(int argc, char *argv[])
{
    int     i, ret, screen_size=-1, newlen;
    char    *st = NULL;
    int     cmdl_alternate=FALSE;
    int     desktop_width=0, desktop_height=0, desktop_bpp=8;

    /**** clear global flags ****/
    clips.flag      = FALSE;
    clipd.flag      = FALSE;
    g.vga_type      = -1;      // default: invalid type
    g.bpp           = 8;       // set default value
    g.hs = 12;              // 12 pixels handle size
    g.draw_method         = MTD_PUTPIXELCONT;
    g.paletterange_start= 0;
    g.paletterange_end  = 1;
    g.flag_palette_range = FALSE;
    g.flag_animate     = FALSE;
    g.flag_cad         = FALSE;
    g.flag_all         = FALSE;
    g.flag_src         = FALSE;
    g.flag_dst         = FALSE;
    g.flag_pixelgrid   = FALSE;
    g.flag_grid        = FALSE;
    g.flag_fill        = FALSE;
    g.flag_brush       = FALSE;
    g.flag_bkmap       = FALSE;
    g.flag_verbose     = FALSE;
    g.flag_alternate   = FALSE;
    g.flag_dialog_init = FALSE;
    g.flag_multi_archives = FALSE;
    g.flag_multi_positive = FALSE;
    g.grid_sx       = 8;
    g.grid_sy       = 8;
    g.animate_type  = 0;
    g.animate_delay = 70;
    g.brush.size    = 1;
    g.brush.type    = 0;
    g.brush.bmp     = NULL;
    g.draw_method = MTD_NOTHING;
    g.bkmap.map = NULL;
    g.bkmap.sMD = NULL;
    // bitmap pointers
    g.screen_state_buffer = NULL;
    g.fillmap1            = NULL;
    g.fillmap2            = NULL;
    g.fillmap3            = NULL;
    g.bitmap_buttons      = NULL;
    g.mouse_pointer       = NULL;
    g.clipboard           = NULL;
    g.win_clipboard       = NULL;
    g.dxe_bitmap          = NULL;
    g.layer0              = NULL;
    // char pointers
    g.project_name        = NULL;
    g.graphic_name        = NULL;
    g.buttonfile          = NULL;
    g.mousefile           = NULL;
    g.fillfile            = NULL;
    g.bmp0                = NULL;
    g.bmp1                = NULL;
    g.bmp2                = NULL;
    g.bmp3                = NULL;
    g.bmp4                = NULL;
    //
    fillstruct.bmpfree = NULL;
    fillstruct.class    = 0;
    fillstruct.type     = 0;
    fillstruct.operation= 0;
    text.enabled = FALSE;






    allegro_init();



    g.path_init = alloc_string( argv[0], FILENAME_MAX + 99 );        // initial program startup directory
    if( g.path_init == NULL ) error_("fatal: can't allocate string to hold filepath");
    st = strrchr( g.path_init, '\\');   // strip away filename, and leave
    *st++='\\';                         // the path only.
    *st++=0;                            //


    g.configfilename = (char *) alloc_string( "exa.cfg", FILENAME_MAX+32 ); // default config file name
    if( g.configfilename == NULL) error_("fatal: cannot allocate memory for configfilename");
    if(argc >= 2 )
        strncpy( g.configfilename, argv[1], FILENAME_MAX );
        if( does_file_exist( g.configfilename ) == -1 ){
        // config file don't exist, test adding extension and test again
        if( have_extension( g.configfilename ) != 0 ){  // only if no extension exist
            add_extension(  g.configfilename, "cfg" );
        }
        if( does_file_exist( g.configfilename ) == -1 ){
        // nope, exit
        error_("loading config file '%s'\n", g.configfilename);
        return -1;
        }
    }

    newlen = strlen( g.path_init ) + strlen( g.configfilename )+32;
    g.path_configfile = (char *) alloc_string( g.path_init, newlen );
    if(g.path_configfile==NULL) error_("fatal: cannot allocate memory to hold filepath");
    strncat( g.path_configfile, g.configfilename, newlen);

    if( does_file_exist( g.path_configfile ) == -1 ){
    // nope, exit
    error_("loading config file '%s'\n", g.path_configfile);
    return -1;
    }




    set_gdi_color_format();     // testing

    fnt_make_branches( "fonts/xfonts.dir" );  // working 100%


    if( set_display_switch_mode( SWITCH_PAUSE ) == -1 ){ error_("no SWITCH_PAUSE available");}
//    set_color_conversion( COLORCONV_DITHER_PAL );  // dither when reducing to 8 bit
    set_color_conversion( COLORCONV_NONE );

    desktop_bpp = desktop_color_depth();  // get bpp
    i=get_desktop_resolution( &desktop_width, &desktop_height );
    if(i==-1) error_("can't get desktop resolution");
    install_keyboard();
    install_timer();
    if(install_mouse()==-1){ puts("Error initializing mouse");
        remove_timer();
        remove_keyboard();
        exit(-1);
        }
    set_window_title("EXA " VERSIONNUMBER_STR );







//    bpp = desktop_color_depth();




//    alert("_________","*0*", "_________", "OK",NULL,1,2);
//readkey();
//    allegro_exit();
//    return(0);




    register_bitmap_file_type("TIF", &load_tif, &save_tif );
    register_bitmap_file_type("JPG", &read_JPEG_file, &write_JPEG_file );



    gbm_init();     // initialize and load GBM of type DXE (DLL)
    gbm_return_fileextensions( &iksipiksi );





    load_config_data( g.path_configfile,
                      screen_size,
                      cmdl_alternate
                    );

//readkey();
//return 0;



    make_new_fillmaps();
    init_font_system();     /* must be done before display_frames_onscreen() */



    initialize_dxemodules();    // load DLL's
    clear_bitmap( screen );
    display_frames_onscreen();


    g.screen_state_buffer = create_bitmap( md_sx, md_sy );    if( g.screen_state_buffer == NULL) error_("allocating screen state buffer");
    g.bkmap.sMD = create_bitmap( (md_sx+3), (md_sy+3) );    if( g.bkmap.sMD==NULL ) error_("allocating bitmap for background");
    clear_bitmap( g.bkmap.sMD );

    g.flag_dialog_init = TRUE;
    ret = do_dialog( main_dialog , -1);
    g.flag_dialog_init = FALSE;


    unload_config_data();
    allegro_exit();
    return 0;
}




END_OF_MAIN()








