/*
 * linked list for dxe module loading
 * using link.c/h for linked lists.
 * This code is a wrapper for linked list functions.
 *
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <allegro.h>
#include "types.h"
#include "lod.h"        // dxe2
#include "link.h"       // generic link usage
#include "butil.h"      // alloc_string()


static LINKEDLIST  *le  = NULL;


static LODUSERDATA *lod_alloc_userdata()
{
    LODUSERDATA *t = NULL;
    int         i;

    t = (LODUSERDATA *) malloc(sizeof(LODUSERDATA)); if(t==NULL) return NULL;
    t->dxefilename  = NULL; // allocated string
    t->status       = 0;    // 0 = unloaded, 1 = ok,
    t->dxe_init     = NULL;
    t->dxe_deinit   = NULL;
    t->dxe_method   = NULL;
    t->mtds         = NULL; // dxe module data
    for(i=0;i<80;i++)   t->error[i] = 0;
    return t;
}



void lod_initsys()
{
    le = link_alloc_linkedlist();    if(le==NULL) return;
}
void lod_rewind()
{
    link_first( le );
}
void lod_set_error( unsigned char *error )
{
    LODUSERDATA *usr;

    if(le==NULL) return;
    if(le->currentlink==NULL) return;
    if(le->currentlink->userdata==NULL) return;
    usr = (LODUSERDATA *) le->currentlink->userdata;
    strncpy( usr->error, error, 80 );
    usr->error[79] = 0;
}
void lod_store(
    byte  *dxefilename,
    void (*init)(void),
    void (*deinit)(void),
    int (*method)(BITMAP *,int,int,int,int),
    MTDS *mtds,
    char *errstr)
{
    LODUSERDATA *usr = NULL;
    LINKITEM    *li  = NULL;

    usr = lod_alloc_userdata();   if(usr==NULL) return;
    usr->error[0]     = 0;
    usr->status       = 1;   // 0 = unloaded, 1 = ok, 2 = error ocurred w/ dxe

    if( errstr != NULL ){
        usr->status   = 2;
        strncpy( usr->error, errstr, 80 );
        usr->error[79] = 0;
    }

    if( dxefilename != NULL){
//        usr->dxefilename  = malloc( strlen(dxefilename)  );
//        strcpy(  usr->dxefilename, dxefilename );
        usr->dxefilename  = alloc_string( dxefilename, -1 );
    }else{
        usr->status = 2;
        strncat(  usr->error, ".input filename is NULL.",80 );
    }

    usr->dxe_init     = init;
    usr->dxe_deinit   = deinit;
    usr->dxe_method   = method;
    usr->mtds         = mtds;
    if( method==NULL || mtds==NULL )  usr->status = 2;
    li = (LINKITEM *) link_append_tail( le );    // append at "current" position
    if( li==NULL ){
        usr->status = 2;
        strncat( usr->error, ".cannot store userdata.",80 );
        return;}
    li->userdata = usr;      // set userdata
    usr->error[79] = 0;
}
void lod_next()
{
    link_next( le );
}
static int lod_sort_criteria( byte criterion, int index );
static int lod_sort_criteria( byte criterion, int index )
{
    int         i,j,k=0,l=0, links=0;
    LINKITEM    *lnk, *lak, *t;
    byte        a,b;
    LODUSERDATA *lod, *lud;

    if( le == NULL ) return -1;
    if( le->currentlink == NULL ) return -1;
    if( le->currentlink->userdata       == NULL ) return -1;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    if( lod->mtds == NULL ) return -1;

    links = le->links;    if( links <= 2 ) return -1;

    for( j=0 ; j < links+1 ; j++ ){
    t = link_first( le );   if(t==NULL) return -1;

    for( i=0 ; i < links+1 ; i++ ){
        lnk  = link_current( le );
        lak  = lnk->next;        if( lak == NULL ) break;
        lod = (LODUSERDATA *)lnk->userdata;
        lud = (LODUSERDATA *)lak->userdata;
        if(criterion==10){           // class string
            a = lod->mtds->class[index];  // string
            b = lud->mtds->class[index];  // string
            a = toupper(a);
            b = toupper(b);
            if( a > b ) link_swap( le );
        }
        if(criterion==20){          // type byte
            k = lod->mtds->type;  // integer
            l = lud->mtds->type;  // integer
            if( k > l ) link_swap( le );
        }
        t = link_next( le );  if( t == NULL ) break;
    }}
    link_first( le );
    return 0;
}
// return 0 = ok, -1 = error
int lod_sort_criteria1()
{
    int     a=0;

    if(le==NULL) return -1;
    if(le->currentlink==NULL) return -1;
    if(le->currentlink->userdata==NULL) return -1;
    a = lod_sort_criteria(10,4);  if(a==-1) return -1;
    a = lod_sort_criteria(10,3);  if(a==-1) return -1;
    a = lod_sort_criteria(10,2);  if(a==-1) return -1;
    a = lod_sort_criteria(10,1);  if(a==-1) return -1;
    a = lod_sort_criteria(10,0);  if(a==-1) return -1;
    link_first( le );
    return a;
}
// return 0 = ok, -1 = error
int lod_sort_criteria2()
{
    int     a=0;

    if(le==NULL) return -1;
    if(le->currentlink==NULL) return -1;
    if(le->currentlink->userdata==NULL) return -1;
    a = lod_sort_criteria(20,0);  if(a==-1) return -1;
    link_first( le );
    return a;
}



MTDS *lod_get_mtds()
{
    LODUSERDATA *lod;
    if(le==NULL) return NULL;
    if(le->currentlink->userdata==NULL) return NULL;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    return (MTDS *) lod->mtds;
}
void *lod_get_init()
{
    LODUSERDATA *lod;
    if(le==NULL) return NULL;
    if(le->currentlink->userdata==NULL) return NULL;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    return lod->dxe_init;
}
void *lod_get_deinit()
{
    LODUSERDATA *lod;
    if(le==NULL) return NULL;
    if(le->currentlink->userdata==NULL) return NULL;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    return lod->dxe_deinit;
}
void *lod_get_method()
{
    LODUSERDATA *lod;
    if(le==NULL) return NULL;
    if(le->currentlink->userdata==NULL) return NULL;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    return lod->dxe_method;
}
LODUSERDATA *lod_get_loduserdata()
{
    LODUSERDATA *lod;
    if(le==NULL) return NULL;
    if(le->currentlink->userdata==NULL) return NULL;
    lod = (LODUSERDATA *) le->currentlink->userdata;
    return lod;
}




















#ifdef NUVERR1


/*
 * Search for a filename in linked list
 * return link to found.
 * if not found returns NULL.
 */
LINKITEM *link_search_partial_filename( byte *str )
{
    LINKITEM     *l;
    byte    *s;
    byte    tstr1[99], tstr2[99];


//    l = link_first();   if(l==NULL) return NULL;
    l = link_current();   if(l==NULL) return NULL;

    for(;;){

    strncpy( (byte *)&tstr1[0], (byte *)&l->descriptive[0], 69 );
    strncpy( (byte *)&tstr2[0], str,                     69 );
    strupr(  (byte *)&tstr1[0] ); // make uppercase
    strupr(  (byte *)&tstr2[0] ); // make uppercase

    s = strstr( (byte *)&tstr1[0], (byte *)&tstr2[0] );   // find string in string

    if( s != NULL ) return l;

    l=link_next();      if(l==NULL) return NULL;
    }
    return NULL;
}

#endif















/*
 * filename may be up to 54 chars long.
 */
void expand_filename( byte *filename, int size )
{
    int     len;
    int     i,j;

    if(filename==NULL) return;
    filename[size-1]=0;
    len = strlen( filename );
    j = size-len; if(j<0) j=0;
    for( i=0 ; i < (size-len) ; i++ ){
    filename[ len + i ] = ' ';
    }// for
    filename[size]=0;
}



