#ifndef _H_LINKEDLIST_HH_
#define _H_LINKEDLIST_HH_

#include <allegro.h>

/*** structure for each block ***/
typedef struct LINKITEZ {
void    *prev, *next;        // link pointers

// user data...

BITMAP  *data;               /* bitmap pointer */
unsigned char tag;           /* display tag,   */
unsigned char *description;  // textual description,      (not used yet)
int      bpp;                // 1,4,8,15,16,24,32         (not used yet)
int      type;               //                           (not used yet)
//          type (only one):
//           0  = not specified or unknown
//           1  = bitplane                  bpp = 1
//           2  = Paletted                  bpp = 8
//           3  = grey, luminance           bpp = 8
//           4  = grey, Red channel         bpp = 8
//           5  = grey, Green channel       bpp = 8
//           6  = grey, Blue channel        bpp = 8
//           7  = RGB                       bpp = 15,16,24 or 32
} LINKITEZ;
//} LINKITEZ __attribute__ ((packed));

/*** structure for all blocks ***/
typedef struct LINKS {
LINKITEZ *first_link;
LINKITEZ *last_link;

// user data...

int     bpp;            // bits per pixel, (not used yet)
int     sx, sy;         // size x,y
int     spr_count;      // amount of blocks
int     current_sprite; // current block
} LINKS;
//} LINKS __attribute__ ((packed));

void    ll_init(int,int,int);
int     ll_append_tail( BITMAP * );
int     ll_append_head( BITMAP * );
int     ll_insert( int , BITMAP * );
int     ll_remove( int );
BITMAP *ll_get_sprite( int );       /* return BITMAP pointer to sprite object in memory */
unsigned char ll_get_tag( int );            /* return display 'tag' character */
void    ll_set_tag( int, unsigned char );   /* set display 'tag' character    */
int     ll_return_spr_count();
int     ll_return_current_spr();
LINKS  *ll_get_nodesystem_ptr();
void    ll_set_nodesystem_ptr(LINKS *);
void    ll_kill_nodesystem(LINKS *);

#endif
