/*

  TODO: Must adapt ll.c/h to use link.c/h
    Using wrapper functions


       Subroutines used by main window. ll_xxxxx
       Linked List and block allocation.
       Two pointers: Begin of link list and end of link list.
       Three elements in each link:  prev   <- pointer to previous link
                                     data   <- pointer to graphic data
                                     next   <- pointer to next link
       Functions to create link item, destroy link item.
       Functions to create graphic within link item , destroy graphic within...

    ----------------------------------------------
    USES:
    ----------------------------------------------
    _spr_count
    _current_sprite
    _sx
    _sy
    ----------------------------------------------
    Functions needed (perhaps):
    ----------------------------------------------
        ll_create_nodesystem()
        ll_reverse_order()          - of all links
        ll_reverse_order_range()    - on a range
    ----------------------------------------------
    Functions:
    ----------------------------------------------

    Warning! when appending images, use 'll_return_spr_count() ' to
    update count of sprites.
*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "ll.h"




static LINKS *links;    /* current link used by functions */





/* helper functions */
static LINKITEZ *create_link(void);
static void destroy_link( LINKITEZ *);
static void create_data ( LINKITEZ *);
static void destroy_data( LINKITEZ *);
/* helper functions */




/*
 * Init a link system.
 * size x:
 * size y:
 * destroys current 'links' pointer.
 * Should return a LINKS pointer.
 *
 */
void ll_init( int sx, int sy, int bpp )
{
    links = (LINKS *) malloc( sizeof(LINKS) );
    links->last_link = links->first_link = NULL;
    links->sx = sx;
    links->sy = sy;
    links->bpp = bpp;
    links->spr_count=0;
    links->current_sprite=0;
    return;
}
LINKS *ll_get_nodesystem_ptr()
{
    return links;
}

void ll_set_nodesystem_ptr(LINKS *new_links)
{
    links = new_links;
}

void ll_kill_nodesystem(LINKS *old_links)
{
    int i, k;
    LINKS *tl;

    if( old_links == NULL ) return;
    tl = links;     /* store */
    links = old_links;
    k = links->spr_count;
    if( k != 0 )
        for( i=0 ; i < k ; i++) ll_remove( 0 );
    free( links );
    links = tl;     /* restore */
}

int ll_return_spr_count()
{
    if( links == NULL ) return 0;
    return links->spr_count;
}
int ll_return_current_spr()
{
    return links->current_sprite;
}




/*
 * If input is NULL then does not copy bitmap into link, but a empty
 * image is created instead.
 * Input image is COPIED into the last chain, a new copy is made.
 * returns FALSE on error, else TRUE
 */
int ll_append_tail( BITMAP *new_pic )
{
    LINKITEZ *tmp1 = NULL;
    LINKITEZ *tmp2 = NULL;

    if(links->first_link == NULL){
        tmp1 = links->first_link;
        tmp1 = create_link();
        if (tmp1 == NULL) return FALSE;
        tmp1->prev = NULL;
        tmp1->next = NULL;
            create_data( tmp1 ); if(tmp1->data==NULL ){return FALSE;}
            if( new_pic != NULL)
                blit( new_pic, tmp1->data, 0, 0, 0, 0, links->sx, links->sy );
        links->first_link = tmp1;
        links->last_link =  tmp1;
        links->spr_count++;
        links->current_sprite = links->spr_count;
        return TRUE;
    }
    if(links->first_link != NULL){
        tmp1 = links->last_link;
        tmp2 = create_link();
        if( tmp2 == NULL ) return FALSE;
        tmp1->next = tmp2;
        tmp2->prev = tmp1;
        tmp2->next = NULL;
            create_data(tmp2);
            if(tmp2->data == NULL){return FALSE;}
/**** COPY ****/
            if( new_pic != NULL)
                 blit(new_pic, tmp2->data, 0, 0, 0, 0, links->sx, links->sy);

        links->last_link = tmp2;
        links->spr_count++;
        links->current_sprite = links->spr_count;
        return TRUE;
    }
    return FALSE;
}

/*
 * If input is NULL then does not copy bitmap into link, but a empty
 * image is created instead.
 * Input image is COPIED into the first chain, a new copy is made.
 * returns FALSE on error, else TRUE
 */
int ll_append_head( BITMAP *new_pic )
{
    LINKITEZ *tmp1=NULL;
    LINKITEZ *tmp2=NULL;

    links->current_sprite = 0;
    if(links->first_link == NULL){
        tmp1 = links->first_link;
        tmp1 = create_link();
        if (tmp1 == NULL) return FALSE;
        tmp1->prev = NULL;
        tmp1->next = NULL;
            create_data( tmp1 );
            if(tmp1->data==NULL){return FALSE;}
/**** COPY ****/
            if( new_pic != NULL )
                blit( new_pic, tmp1->data, 0, 0, 0, 0, links->sx, links->sy );
    links->first_link = tmp1;
    links->last_link =  tmp1;
    links->spr_count++;
    return TRUE;
    }
    if(links->first_link != NULL){
        tmp1 = links->first_link;
        tmp2 = create_link();
        if( tmp2 == NULL ) return FALSE;
            create_data(tmp2);
            if(tmp2->data == NULL){return FALSE;}
            if( new_pic != NULL )
                blit(new_pic, tmp2->data, 0, 0, 0, 0, links->sx, links->sy);
        tmp1->prev = tmp2;
        tmp2->prev = NULL;
        tmp2->next = tmp1;
        links->first_link = tmp2;
        links->spr_count++;
        return TRUE;
    }
    return FALSE;
}






/*
 * If input is NULL then does not copy bitmap into link, but a empty
 * image is created instead.
 * Input image is COPIED into the first chain, a new copy is made.
 * returns FALSE on error, else TRUE
 */
int ll_insert( int spr_number, BITMAP *new_pic )
{
    int i;
    LINKITEZ *tmp1=NULL;
    LINKITEZ *tmp3=NULL;
    LINKITEZ *tmp4=NULL;
    LINKITEZ *tmp5=NULL;

    links->current_sprite = spr_number;
    if(links->first_link == NULL){ return FALSE; }

    if(links->first_link != NULL){
        tmp1 = links->first_link;

        if(spr_number != 0)
        {
        for(i=0;i<spr_number;i++)
            {
            if(tmp1->next == NULL )return( ll_append_tail(new_pic));
            tmp1 = tmp1->next;
            }
        }
        if(spr_number==0){
        tmp5 = create_link();if (tmp5 == NULL) return FALSE;
        create_data( tmp5 );
        if(tmp5->data == NULL){return FALSE;}
/**** COPY ****/
        if( new_pic != NULL )
            blit(new_pic, tmp5->data, 0, 0, 0, 0, links->sx, links->sy);
        tmp5->prev = NULL;
        tmp5->next = tmp1;
        tmp1->prev= tmp5;
        links->first_link = tmp5;
        links->spr_count++;
        return TRUE;
                }
        tmp4  =  tmp1;
        tmp3  =  tmp1->prev;

        tmp5 = create_link();
        if (tmp5 == NULL) return FALSE;
        create_data(tmp5);
        if(tmp5->data == NULL){return FALSE;}
        if( new_pic != NULL )
            blit(new_pic, tmp5->data, 0, 0, 0, 0, links->sx, links->sy);

        tmp5->prev = tmp3;
        tmp5->next = tmp4;
        tmp3->next= tmp5;
        tmp4->prev= tmp5;
        links->spr_count++;
        return TRUE;
    }
    return FALSE;
}





/* return BITMAP pointer to sprite object in memory */
BITMAP *ll_get_sprite( int spr_number )
{
    int i;
    LINKITEZ *tmp1=NULL;

    links->current_sprite = spr_number;
    if( links->first_link != NULL ){
        tmp1 = links->first_link;
        if( spr_number!=0 ){
            for( i=0 ; i < spr_number ; i++ ){
                if( tmp1==NULL ||  tmp1->next == NULL ) return NULL;
                tmp1 = tmp1->next;
            }
        }
        return tmp1->data;
   }
   return NULL;
}


/*
 * return BITMAP pointer to sprite object in memory
 *
 * ??????????????
*/
unsigned char ll_get_tag( int spr_number )
{
    int i;
    LINKITEZ *tmp1=NULL;

    links->current_sprite = spr_number;
    if( links->first_link != NULL ){
        tmp1 = links->first_link;
        if( spr_number!=0 ){
            for( i=0 ; i < spr_number ; i++ ){
                if( tmp1==NULL || tmp1->next == NULL ) return '?';    // undefined tag (error)
                tmp1 = tmp1->next;
            }
        }
        return tmp1->tag;
   }
   return 0;
}

void    ll_set_tag( int spr_number, unsigned char tag )
{
    int i;
    LINKITEZ *tmp1=NULL;

    links->current_sprite = spr_number;
    if( links->first_link != NULL ){
        tmp1 = links->first_link;
        if( spr_number!=0 ){
            for( i=0 ; i < spr_number ; i++ ){
                if( tmp1->next == NULL ) return;
                tmp1 = tmp1->next;
            }
        }
        tmp1->tag = tag;
        return;
   }
   return;
}







/*
 * remove sprite in link.
 * returns FALSE on error, else TRUE
 */
int ll_remove( int spr_number )
{
    int i, wert;
    LINKITEZ *tmp1;
    LINKITEZ *tmp2;
    LINKITEZ *tmp3;

    links->current_sprite = spr_number;
    if( links->first_link == NULL ){ return FALSE; }
    if( links->last_link == NULL  ){ return FALSE; }
    tmp1 = links->first_link;
    wert = FALSE;
    if( spr_number != 0 )
        {
            for( i=0 ; i < spr_number ; i++)
            {
            if( wert==FALSE ) tmp2 = tmp1; /* record last link */
            if( wert==FALSE ) { if( (tmp1->next) == NULL) wert=TRUE;}
            if( wert==FALSE ) tmp1 = tmp1->next;
            }
        }
    if(spr_number == 0){
    tmp2 = tmp1->next;
    if ( tmp2 == NULL ) return FALSE;
    if(tmp1->data != NULL )     destroy_data( tmp1 );
    destroy_link( tmp1 );
    tmp2->prev = NULL;
    links->first_link = tmp2;
    if(links->spr_count !=0 )        links->spr_count--;
    return TRUE;
    }

    if( spr_number != 0 ) {
        wert=0;
        if( spr_number == (links->spr_count-1) ) wert = 1 ;
            if( wert == 1 ){
            tmp1 = links->last_link;
            if( tmp1->data != NULL ){ destroy_data( tmp1 ); }
            tmp2 = tmp1;
            tmp1 = tmp1->prev;
            destroy_link( tmp2 );

        tmp1->next = NULL;
        links->last_link = tmp1;
        if( links->current_sprite !=0 ) links->current_sprite--;
        if( links->spr_count !=0 )      links->spr_count--;
        return TRUE;
    }}

    tmp2  =  tmp1;
    tmp1  =  tmp2->prev;
    tmp3  =  tmp2->next;
    if( tmp3==NULL ) return TRUE;
    if( tmp2->data != NULL ){
        destroy_data( tmp2 );
        destroy_link( tmp2 );
        }
    tmp1->next = tmp3;
    tmp3->prev = tmp1;
    if( links->spr_count !=0 ) links->spr_count--;
    return TRUE;
}




static LINKITEZ *create_link(void)
{
    LINKITEZ *linkptr;
    linkptr = (LINKITEZ *)malloc( sizeof( LINKITEZ ));
    if( linkptr != NULL ){
    linkptr->prev = NULL;
    linkptr->data = NULL;
    linkptr->next = NULL;
    linkptr->tag  = 0;
    linkptr->description = NULL;    //  value not used yet.
    linkptr->bpp  = 0;              //  value not used yet.
    linkptr->type = 0;              //  value not used yet.
    }
    return linkptr;
}
static void create_data( LINKITEZ *linkptr )    // create empty data
{
    if( linkptr != NULL ){
    linkptr->data = create_bitmap_ex( g.bpp, links->sx, links->sy );
    if( linkptr->data != NULL ) clear_bitmap( linkptr->data );
    }
    return;
}
static void destroy_data( LINKITEZ *linkptr )
{
    if( linkptr == NULL ) return;
    if( linkptr->data != NULL ) {
        destroy_bitmap( linkptr->data );
        linkptr->data = NULL;
    }
    linkptr->tag  = 0;
    if( linkptr->description != NULL ) free( linkptr->description );
    linkptr->bpp  = 0;
    linkptr->type = 0;
}
static void destroy_link( LINKITEZ *linkptr )
{
    if( linkptr != NULL ){
    destroy_data( linkptr );
    free( linkptr );
    }
}

