/*
 * Internal to the library
 *
 */
#ifndef _EXTENDED_FLI_TYPES_H_
#define _EXTENDED_FLI_TYPES_H_

#include "flilib.h"

/*
 * Many FLIC types.
 *
 * used types.
 * DWORD  - unsigned 32 bit.
 * WORD   - unsigned 16 bit.
 * BYTE   - unsigned 8 bit.
 *
 * TYPE_FLI  0xAF11    standard FLI file 320x200, 256 colors
 * TYPE_FLC  0xAF12    standard FLC file ---x---, 256 colors
 * TYPE_EFLC 0xAF44    dta Extended FLC file, bpp's: 1,8,15,16,24
 * TYPE_CFLC 0xAF30    FLC file, Huffman or BWT compression
 */
/* chunk types */
/* PREFIX_TYPE    0xF100   prefix chunk                    */
/* FRAME_TYPE     0xF1FA   frame chunk                     */
/* SEGMENT_TABLE  0xF1FB   segment table chunk             */
/* HUFFMAN_TABLE  0xF1FC   Huffman compression table chunk */
/* sub-chunk types */
/*  CEL_DATA    3               position and transparency               */
/*  COLOR_256   4               256-level colour palette                */
/*  DELTA_FLC   7    (FLI_SS2)  delta image, word oriented RLE          */
/*  COLOR_64   11               64-level colour palette                 */
/*  DELTA_FLI  12    (FLI_LC)   delta image, byte oriented RLE          */
/*  BLACK      13               full black frame (rare)                 */
/*  BYTE_RUN   15    (FLI_BRUN) full image, byte oriented RLE           */
/*  FLI_COPY   16               uncompressed image (rare)               */
/*  PSTAMP     18               postage stamp (icon of the first frame) */
/*  DTA_BRUN   25               full image, pixel oriented RLE          */
/*  DTA_COPY   26               uncompressed image                      */
/*  DTA_LC     27               delta image, pixel oriented RLE         */
/*  LABEL      31               frame label                             */
/*  BMP_MASK   32               bitmap mask                             */
/*  MLEV_MASK  33               multilevel mask                         */
/*  SEGMENT    34               segment information                     */
/*  KEY_IMAGE  35               key image, similar to DELTA_FLC         */
/*  KEY_PAL    36               key palette, similar to COLOR_256       */
/*  REGION     37               region of frame differences             */
/*  WAVE       38               digitized audio                         */
/*  USERSTRING 39               general purpose user data               */





typedef struct
{
  DWORD size;           /* Size of the chunk, including subchunks */
  WORD  type;           /* Chunk type: 0xF100 */
  WORD  chunks;         /* Number of subchunks */
  BYTE  reserved[8];    /* Reserved, set to 0 */
} _PREFIX_HDR;

typedef struct {
  DWORD size;          /* Size of the chunk, including subchunks */
  WORD  type;          /* Chunk type: 0xF1FA */
  WORD  chunks;        /* Number of subchunks */
  WORD  delay;         /* Delay in milliseconds */
  BYTE  reserved[6];   /* Reserved, set to 0 */
} _FRAME_TYPE;
// } _FRAME_TYPE __attribute__ ((packed));

typedef struct {
  DWORD size;          /* Size of this chunk, including subchunks */
  WORD  type;          /* Chunk type: 0xF1FB */
  WORD  segments;      /* Number of SEGMENT chunks that follow */
} _SEGMENT_TABLE;

typedef struct {
  DWORD size;          /* Size of this chunk */
  WORD  type;          /* Chunk type: 0xF1FC */
  WORD  codelength;    /* Maximum length of the Huffman codes */
  WORD  numcodes;      /* The number of codes */
  BYTE  reserved[6];   /* Must be set to zero */
  /* The following three fields are repeated "numcodes" times */
  WORD  code;          /* Huffman code */
  BYTE  length;        /* Length of the Huffman code */
  BYTE  value;         /* Byte value represented by the Huffman code */
} _HUFFMAN_TABLE;


typedef struct
{
  DWORD size;           /* Size of the chunk, including subchunks */
  WORD  type;           /* Chunk type: 3 */
  WORD  center_x;       /* coordinates of the cel centre */
  WORD  center_y;
  WORD  stretch_x;      /* stretch amounts */
  WORD  stretch_y;
  WORD  rot_x;          /* rotation in x-axis (always 0) */
  WORD  rot_y;          /* rotation in y-axis (always 0) */
  WORD  rot_z;          /* z-axis rotation, 0-5760=0-360 degrees */
  WORD  cur_frame;      /* current frame in cel file */
  BYTE  reserved1[2];   /* Reserved, set to 0 */
  WORD  transparent;    /* Transparent colour index */
  BYTE  reserved2[38];  /* Reserved, set to 0 */
} _CEL_DATA;

typedef struct {
  DWORD size;          /* Size of this chunk (always 32 bytes) */
  WORD  type;          /* Subchunk type: 34 */
  WORD  label;         /* Label of the segment (user value) */
  BYTE  reserved1[2];  /* Reserved, set to zero */
  WORD  cont_image;    /* "continued from" image id */
  WORD  last_image;    /* id of the last image of this segment */
  WORD  flags;         /* Flags */
  WORD  frames;        /* Number of frames in the segment */
  DWORD oframe1;       /* File offset to frame 1 of the segment */
  DWORD oframe2;       /* File offset to frame 2 */
  WORD  next_segment;  /* segment number of segment to proceed with */
  WORD  repeat;        /* repeat count (0=indefinitely) */
  BYTE  reserved2[2];  /* Reserved, set to zero */
} _SEGMENT;
/*
   The flags field contains four bit flags:
    bit    meaning
     0     the segment contains a ring frame
     1     the first frame contains a full image
     2     the "next_segment" field of the structure is valid
     3     audio must be synchronized with the animation
*/



typedef struct {
  DWORD size;           /* Size of this chunk */
  WORD  type;           /* Chunk type: 37 */
  WORD  number;         /* Number of rectangles that form the region */
  /* The following four fields are repeated "number" times */
  WORD  x;              /* Pixel coordinates of a rectangle */
  WORD  y;
  WORD  width;          /* Size of the region in pixels */
  WORD  height;
} _REGION;

typedef struct {
  DWORD size;          /* size of this chunk */
  WORD  type;          /* Chunk type: 38 */
  WORD  flags;
  WORD  samplefreq;    /* sample frequency */
  DWORD overlap;       /* sample overlap (in bytes) */
  BYTE  reserved[6];   /* always zero */
} _WAVE;



#endif
