#ifndef _H_DLLGBM_HH_
#define _H_DLLGBM_HH_

#include "dllgbm/gbmerr.h"

GBM_ERR(* dllgbm_query_filetype)(GBMFT *)                     ;
GBM_ERR(* dllgbm_read_header   )(char *, int, GBM *, char *)  ;
GBM_ERR(* dllgbm_read_palette  )(int, GBM *, GBMRGB *)        ;
GBM_ERR(* dllgbm_read_data     )(int, GBM *, byte *)          ;
GBM_ERR(* dllgbm_write         )(char *, int, GBM *, GBMRGB *, byte *, char *);
char  *(* dllgbm_err           )(GBM_ERR) ;
void   (* dllgbm_init)( void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void * );


GBM_ERR gbm_init(void);     // load all DLL's


AHEAD *u_create_ahead(int fd);
void u_destroy_ahead(AHEAD *ahead);
byte u_next(AHEAD *ahead);
int u_open(char *filename, char *type);
int u_read(int fd, void *_ptr, int size);
int u_write(int fd, void *_ptr, int size);
int u_lseek(int fd, long offset, int origin);
void u_close(int fd);
void *u_malloc(int size);
void u_free(void *ptr);
int u_same(char *s1, char *s2, int n);
//BOOLEAN u_same(char *s1, char *s2, int n);
char *u_find_word(char *str, char *substr);
char *u_find_word_prefix(char *str, char *substr);

void gbm_return_fileextensions( void (* callback)(char *) );







#endif
