/**
 ** GRX20.H ---- GRX 2.x API functions and data structure declarations
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/
#ifndef __GRXCUSTOM_H_INCLUDED__
#define __GRXCUSTOM_H_INCLUDED__

#include <stdio.h>
#include <allegro.h>

/*****************************************************************************/
/*****************************************************************************/
/*************************** INTERNAL STRUCTURES *****************************/
/***************************                     *****************************/

/* ************** from fdv_grx.h ****************
 *  font file structure:
 *  +-----------------------+
 *  |     FILE HEADER       |
 *  +-----------------------+
 *  |     PROPORTIONAL      |
 *  |     WIDTH TABLE       |
 *  |     (16 bit ints)     |
 *  |     (prop fonts only) |
 *  +-----------------------+
 *  |     BITMAP            |
 *  +-----------------------+
 */
#define GRX_FONTSUBDIR "fonts/"

#define GRX_NAMEWIDTH   16
#define GRX_FONTMAGIC   0x19590214L
#define GRX_FONTMAGIC_SWAPPED 0x14025919L
typedef unsigned int   GR_int32u;
typedef unsigned short GR_int16u;
typedef struct _GR_fontFileHeaderGRX {  /* the header */
    GR_int32u magic;                  /* font file magic number */
    GR_int32u bmpsize;                /* character bitmap size */
    GR_int16u width;                  /* width (average for proportional) */
    GR_int16u height;                 /* font height */
    GR_int16u minchar;                /* lowest character code in font */
    GR_int16u maxchar;                /* highest character code in font */
    GR_int16u isfixed;                /* nonzero if fixed font */
    GR_int16u reserved;               /* ??? */
    GR_int16u baseline;               /* baseline from top of font */
    GR_int16u undwidth;               /* underline width (at bottom) */
    char      fnname[GRX_NAMEWIDTH];/* font file name (w/o path) */
    char      family[GRX_NAMEWIDTH];/* font family name */
    // ......
    // my own little insertion, not part of the fileheader, actually.
    char    infoline[120];          // FONT -Adobe-Helvetica-Medium-R-Normal--18-180-75-75-P-98-ISO8859-1
    char    *filename;
    char    *manufacturer;
    char    *familyname;
    char    *bold;
    char    *italic;
    char    *fontsize;
    int     flag_bold;              // 0=normal, 1 = bold
    int     flag_italic;            // 0=normal, 1 = italic
    char    bolditalic[8];          // string describing if bold or italic, "  ", "B ", "I ", "BI"
} GrFontFileHeaderGRX;
/** ************** from fdv_grx.h *****************/


/* ================================================================== */
/*                   FONTS AND TEXT PRIMITIVES                        */
/* ================================================================== */

/*
 * Font conversion flags for 'GrLoadConvertedFont'. OR them as desired.
 */
#define GR_FONTCVT_NONE         0       /* no conversion */
#define GR_FONTCVT_SKIPCHARS    1       /* load only selected characters */
#define GR_FONTCVT_RESIZE       2       /* resize the font */
#define GR_FONTCVT_ITALICIZE    4       /* tilt font for "italic" look */
#define GR_FONTCVT_BOLDIFY      8       /* make a "bold"(er) font  */
#define GR_FONTCVT_FIXIFY       16      /* convert prop. font to fixed wdt */
#define GR_FONTCVT_PROPORTION   32      /* convert fixed font to prop. wdt */

/*
 * font structures
 */
typedef struct _GR_fontHeader {         /* font descriptor */
	char    *name;                      /* font name */
	char    *family;                    /* font family name */
	char     proportional;              /* characters have varying width */
	char     scalable;                  /* derived from a scalable font */
	char     preloaded;                 /* set when linked into program */
	char     modified;                  /* "tweaked" font (resized, etc..) */
	unsigned int  width;                /* width (proportional=>average) */
	unsigned int  height;               /* font height */
	unsigned int  baseline;             /* baseline pixel pos (from top) */
	unsigned int  ulpos;                /* underline pixel pos (from top) */
	unsigned int  ulheight;             /* underline width */
	unsigned int  minchar;              /* lowest character code in font */
	unsigned int  numchars;             /* number of characters in font */
} GrFontHeader;

typedef struct _GR_fontChrInfo {        /* character descriptor */
	unsigned int  width;                /* width of this character */
	unsigned int  offset;               /* offset from start of bitmap */
} GrFontChrInfo;

typedef struct _GR_font {               /* the complete font */
	struct  _GR_fontHeader  h;          /* the font info structure */
    unsigned char *bitmap;              /* character bitmap array */
    unsigned char *auxmap;              /* map for rotated & underline chrs */
	unsigned int  minwidth;             /* width of narrowest character */
	unsigned int  maxwidth;             /* width of widest character */
	unsigned int  auxsize;              /* allocated size of auxiliary map */
	unsigned int  auxnext;              /* next free byte in auxiliary map */
    unsigned int  *auxoffs[7];          /* offsets to completed aux chars */
    struct _GR_fontChrInfo chrinfo[1]; /* character info (not act. size) */
} GrFont;


/*****************************************************************************/
/*****************************************************************************/
/***************************** USER STRUCTURES *******************************/
/*****************************                 *******************************/

typedef struct {
        GrFont        g;
        GrFontChrInfo rest[255];
}GRR;   /* for hardwired (linked) fonts */

typedef struct {
    GrFont      g;  /* font structure */
    GrFontChrInfo rest[255];    /* info structure */
    char    *filename;          /* file name      */
    FILE    *fp;                /* file pointer   */
    int     fontsize;            /* total filesize */
    int     bytes_per_char;     /* for fixed fonts */
    short   topchar;        /* maximum available character */
    int     condens;        /* space between glyphs (used defined) */
    BITMAP  *glyph;         /* tmp bitmap for glyph */
}FNT;   /* returned structure */





FNT *fnt_load_mem   (GRR *grf, int condens, int verbose_flag);
FNT *fnt_load_file  (char *filename, int condens, int verbose_flag);
int  fnt_text_length(FNT *f, unsigned char *str);
int  fnt_text_height(FNT *f);
void fnt_textout    (BITMAP *bmp, FNT *fnt, char *str, int _x, int _y, int fg, int bg, int verbose_flag);
void fnt_destroy_font( FNT *fnt );

// ********************************

GrFontFileHeaderGRX *fnt_load_header( char *filename ); // open file and load header only
void split_adobe_string( char *infoline, GrFontFileHeaderGRX *grxh );
GrFontFileHeaderGRX * fnt_make_branches( char *filename );
void split_adobe_string2( GrFontFileHeaderGRX *grxh );


typedef struct {
void    *prev;
void    *next;
char    *data;
void    *branch;
}TREEITEM;


TREEITEM *alloc_treeitem();
void    free_treeitem( TREEITEM *t );

TREEITEM *add_in_tree( GrFontFileHeaderGRX *grxh  );


TREEITEM *append_unique_family_tree( TREEITEM *_family, GrFontFileHeaderGRX *grxh );
TREEITEM *append_family_tree( TREEITEM *_family, GrFontFileHeaderGRX *grxh );
TREEITEM *append_size_tree( TREEITEM *_size, GrFontFileHeaderGRX *grxh );
TREEITEM *append_unique_size_tree( TREEITEM *_size, GrFontFileHeaderGRX *grxh );
TREEITEM *append_thickness_tree( TREEITEM *_thickness, GrFontFileHeaderGRX *grxh );
TREEITEM *append_unique_thickness_tree( TREEITEM *_thickness, GrFontFileHeaderGRX *grxh );
void view_tree( GrFontFileHeaderGRX *grxh   );

int amount_familynames();
// char *seek_familyname( int index );

void dlg_select_font();

TREEITEM *seek_familyname_by_index( int index );
TREEITEM *seek_familyname_by_string( char *string );





#endif
