/*

GBMBMP.C  OS/2 1.1, 1.2, 2.0 and Windows 3.0 support

Reads and writes any OS/2 1.x bitmap.
Will also read uncompressed, RLE4 and RLE8 Windows 3.x bitmaps too.
There are horrific file structure alignment considerations hence each
word,dword is read individually.
Input options: index=# (default: 0)

read image options:

read header options:
    "inv"
    "invb"
    "index=" ...
    "inv invb"

write options:
    "1.1"
    "win"
    "2.0"
    "inv"
    "invb"
    "1.1 win 2.0 inv invb"

Warning!:  cBitCount - can also be 16, and the code is not made for this bitdepth
            perhaps can also be 32
*/



/*...s  includes   */
#include <stdio.h>
#include <string.h>
#include "standard.h"
#include "dxegbm.h"



static GBMFT dxe_gbmft =
	{
	"Bitmap",
	"OS/2 1.1, 1.2, 2.0 / Windows 3.0 bitmap",
	"BMP VGA BGA RLE DIB RL4 RL8",
	GBM_FT_R1|GBM_FT_R4|GBM_FT_R8|GBM_FT_R24|
	GBM_FT_W1|GBM_FT_W4|GBM_FT_W8|GBM_FT_W24,
	};

#define GBM_ERR_BMP_PLANES      ((GBM_ERR) 300)
#define GBM_ERR_BMP_BITCOUNT    ((GBM_ERR) 301)
#define GBM_ERR_BMP_CBFIX       ((GBM_ERR) 302)
#define GBM_ERR_BMP_COMP        ((GBM_ERR) 303)
#define GBM_ERR_BMP_OFFSET      ((GBM_ERR) 304)

typedef struct
	{
	dword	base;
	BOOLEAN	windows;
	dword	cbFix;
	dword	ulCompression;
	dword	cclrUsed;
	dword	offBits;
	BOOLEAN	inv, invb;
	} BMP_PRIV;

#define	BFT_BMAP	0x4d42
#define	BFT_BITMAPARRAY	0x4142
#define	BCA_UNCOMP	0x00000000L
#define	BCA_RLE8	0x00000001L
#define	BCA_RLE4	0x00000002L
#define	BCA_HUFFFMAN1D	0x00000003L
#define	BCA_RLE24	0x00000004L
#define	MSWCC_EOL	0
#define	MSWCC_EOB	1
#define	MSWCC_DELTA	2

static void flip_data_upside_down( GBM *gbm,  byte *data );
static BOOLEAN read_word(  int fd,  word *w );
static BOOLEAN read_dword( int fd, dword *d );
static BOOLEAN write_word( int fd,  word w  );
static BOOLEAN write_dword(int fd, dword d  );


/*...s  invert  */
static void invert(byte *buffer, unsigned count )
	{
    while ( count-- ) *buffer++ ^= (byte) 0xff;
	}
/*...e  */


/*...s  swap_pal  */
static void swap_pal(GBMRGB *gbmrgb)
	{
	GBMRGB tmp = gbmrgb [0];
	gbmrgb [0] = gbmrgb [1];
	gbmrgb [1] = tmp;
	}
/*...e  */



/*...s  bmp_qft   */
DLLEXPORT GBM_ERR dxe_qft(GBMFT *gbmft)
	{
    *gbmft = dxe_gbmft;
	return ( GBM_ERR_OK );
	}
/*...e  */



/*...s  bmp_rhdr   */
DLLEXPORT GBM_ERR dxe_rhdr( char *fn, int fd, GBM *gbm, char *opt )
	{
    word            usType, xHotspot, yHotspot;
    dword           cbSize, offBits, cbFix;
    BMP_PRIV *bmp_priv  = (BMP_PRIV *) gbm -> priv;
    bmp_priv->inv       = ( u_find_word(opt, "inv" ) != NULL );
    bmp_priv->invb      = ( u_find_word(opt, "invb") != NULL );
    u_lseek( fd, 0L, SEEK_SET );
    read_word(fd, &usType);
	if ( usType == BFT_BITMAPARRAY )
/*...s  handle bitmap arrays   */
    {
    char    *index;
    int i;

    if ( (index = u_find_word_prefix(opt, "index=")) != NULL )
        sscanf(index + 6, "%d", &i);
    else
        i = 0;

    while ( i-- > 0 )
        {
        dword   cbSize2, offNext;

        read_dword(fd, &cbSize2);
        read_dword(fd, &offNext);
        if ( offNext == 0L )              return ( GBM_ERR_BMP_OFFSET );
        u_lseek(fd, (long) offNext, SEEK_SET);
        read_word(fd, &usType);
        if ( usType != BFT_BITMAPARRAY )  return ( GBM_ERR_BAD_MAGIC );
        }
    u_lseek(fd, 4L + 4L + 2L + 2L, SEEK_CUR);
    read_word(fd, &usType);
    }
/*...e  */


    if ( usType != BFT_BMAP )        return ( GBM_ERR_BAD_MAGIC );
    bmp_priv->base = u_lseek(fd, 0L, SEEK_CUR) - 2L;
    read_dword(fd, &cbSize);
    read_word(fd,  &xHotspot);
    read_word(fd,  &yHotspot);
	read_dword(fd, &offBits);
	read_dword(fd, &cbFix);
    bmp_priv->offBits = offBits;

	if ( cbFix == 12 )
/*...s  OS/2 1.1, 1.2   */
/* OS/2 1.x uncompressed bitmap */
    {
    word    cx, cy, cPlanes, cBitCount;

    read_word(fd, &cx);
    read_word(fd, &cy);
    read_word(fd, &cPlanes);
    read_word(fd, &cBitCount);
    if ( cx == 0 || cy == 0 )   return ( GBM_ERR_BAD_SIZE );
    if ( cPlanes != 1 )         return ( GBM_ERR_BMP_PLANES );
    if ( cBitCount != 1 && cBitCount != 4 && cBitCount != 8 && cBitCount != 24 ){
//printf("1* BMP bitcount: %d\n", cBitCount );
        return ( GBM_ERR_BMP_BITCOUNT );
}
    gbm->w   = (int) cx;
    gbm->h   = (int) cy;
    gbm->bpp = (int) cBitCount;
    bmp_priv->windows = FALSE;
    }
/*...e  */

	else if ( cbFix >= 16 && cbFix <= 64 &&
	          ((cbFix & 3) == 0 || cbFix == 42 || cbFix == 46) )
/*...s  OS/2 2.0 and Windows 3.0   */
    {
    word    cPlanes, cBitCount, usUnits, usReserved, usRecording, usRendering;
    dword   ulWidth, ulHeight, ulCompression;
    dword   ulSizeImage, ulXPelsPerMeter, ulYPelsPerMeter;
    dword   cclrUsed, cclrImportant, cSize1, cSize2, ulColorEncoding, ulIdentifier;

    read_dword(fd, &ulWidth);
    read_dword(fd, &ulHeight);
    read_word(fd, &cPlanes);
    read_word(fd, &cBitCount);

    if ( cbFix > 16 )
        read_dword(fd, &ulCompression);
    else
        ulCompression = BCA_UNCOMP;
    if ( cbFix > 20 )        read_dword(fd, &ulSizeImage);
    if ( cbFix > 24 )        read_dword(fd, &ulXPelsPerMeter);
    if ( cbFix > 28 )        read_dword(fd, &ulYPelsPerMeter);
    if ( cbFix > 32 )        read_dword(fd, &cclrUsed);
    else
        cclrUsed = ( 1 << cBitCount );
    if ( cBitCount != 24 && cclrUsed == 0 )
        cclrUsed = ( 1 << cBitCount );
    if ( cbFix > 36 )        read_dword(fd, &cclrImportant);
    if ( cbFix > 40 )        read_word(fd, &usUnits);
    if ( cbFix > 42 )        read_word(fd, &usReserved);
    if ( cbFix > 44 )        read_word(fd, &usRecording);
    if ( cbFix > 46 )        read_word(fd, &usRendering);
    if ( cbFix > 48 )        read_dword(fd, &cSize1);
    if ( cbFix > 52 )        read_dword(fd, &cSize2);
    if ( cbFix > 56 )        read_dword(fd, &ulColorEncoding);
    if ( cbFix > 60 )        read_dword(fd, &ulIdentifier);
    if ( ulWidth == 0L || ulHeight == 0L )  return ( GBM_ERR_BAD_SIZE );
    if ( cPlanes != 1 )                     return ( GBM_ERR_BMP_PLANES );
    if ( cBitCount != 1 && cBitCount != 4 && cBitCount != 8 && cBitCount != 24 ){
//printf("2* BMP bitcount: %d\n", cBitCount );
        return ( GBM_ERR_BMP_BITCOUNT );
}
    gbm -> w   = (int) ulWidth;
    gbm -> h   = (int) ulHeight;
    gbm -> bpp = (int) cBitCount;
    bmp_priv -> windows       = TRUE;
    bmp_priv -> cbFix         = cbFix;
    bmp_priv -> ulCompression = ulCompression;
    bmp_priv -> cclrUsed      = cclrUsed;
    }
/*...e  */

    else
		return ( GBM_ERR_BMP_CBFIX );

	return ( GBM_ERR_OK );
    }
/*...e  */








/*...s  bmp_rpal   */
DLLEXPORT GBM_ERR dxe_rpal( int fd, GBM *gbm, GBMRGB *gbmrgb )
	{
    BMP_PRIV *bmp_priv = (BMP_PRIV *) gbm->priv;

	if ( gbm -> bpp != 24 )
		{
		int i;
		byte b [4];

		if ( bmp_priv -> windows )
/*...s  OS/2 2.0 and Windows 3.0    */
{
u_lseek(fd, bmp_priv -> base + 14L + bmp_priv -> cbFix, SEEK_SET);
for ( i = 0; i < (int) bmp_priv -> cclrUsed; i++ )
	{
    u_read( fd, b, 4 );
	gbmrgb [i].b = b [0];
	gbmrgb [i].g = b [1];
	gbmrgb [i].r = b [2];
	}
}
/*...e  */
		else
/*...s  OS/2 1.1, 1.2    */
{
u_lseek(fd, bmp_priv -> base + 26L, SEEK_SET);
for ( i = 0; i < (1 << gbm -> bpp); i++ )
	{
    u_read(fd, b, 3);
	gbmrgb [i].b = b [0];
	gbmrgb [i].g = b [1];
	gbmrgb [i].r = b [2];
	}
}
/*...e  */
		}

	if ( gbm -> bpp == 1 && !bmp_priv -> inv )
		swap_pal(gbmrgb);

	return ( GBM_ERR_OK );
	}
/*...e  */






static GBM_ERR bmp_rdata_do(int fd, GBM *gbm, byte *data);



/*...s  bmp_rdata,  wrapper, flips data */
DLLEXPORT GBM_ERR dxe_rdata( int fd, GBM *gbm, byte *data )
{
    GBM_ERR grr;

    grr = bmp_rdata_do( fd, gbm, data );    /*    if(grr == GBM_ERR_OK)*/
    flip_data_upside_down( gbm, data );     // flip data upside down, always
    return grr;
}



/*...s  bmp_rdata_do   */
static GBM_ERR bmp_rdata_do(int fd, GBM *gbm, byte *data)
	{
    BMP_PRIV    *bmp_priv   = (BMP_PRIV *) gbm -> priv;
    int         cLinesWorth = ((gbm -> bpp * gbm -> w + 31) / 32) * 4;


    if ( bmp_priv->windows )
/*...s  OS/2 2.0 and Windows 3.0   */
{
u_lseek(fd, bmp_priv->offBits, SEEK_SET);

switch ( (int) bmp_priv->ulCompression )
	{
/*...s  BCA_UNCOMP    */
case BCA_UNCOMP:
    u_read(fd, data, gbm -> h * cLinesWorth);
	break;
/*...e  */
/*...s  BCA_RLE8    */
case BCA_RLE8:
	{
	AHEAD	*ahead;
    int     stride = ((gbm -> w + 3) & ~3);
    int     x = 0, y = 0;
	BOOLEAN	eof8 = FALSE;

    if ( (ahead = u_create_ahead(fd)) == NULL ) return ( GBM_ERR_MEM );

	while ( !eof8 )
		{
        byte    c = u_next(ahead);
        byte    d = u_next(ahead);

		if ( c )
			{
			memset(data, d, c);
			x += c;
			data += c;
			}
		else
			switch ( d )
				{
/*...s  MSWCC_EOL    */
case MSWCC_EOL:
	{
    int     to_eol = stride - x;

	memset(data, 0, to_eol);
	x = 0; y++;
	data += to_eol;
	}
	break;
/*...e  */
/*...s  MSWCC_EOB    */
case MSWCC_EOB:
    if ( y < gbm->h )
		{
		int	to_eol = stride - x;

		memset(data, 0, to_eol);
		x = 0; y++;
		data += to_eol;
		while ( y < gbm -> h )
			{
			memset(data, 0, stride);
			data += stride;
			y++;
			}
		}
	eof8 = TRUE;
	break;
/*...e  */
/*...s  MSWCC_DELTA    */
case MSWCC_DELTA:
	{
    byte    dx = u_next(ahead);
    byte    dy = u_next(ahead);
    int     fill = dx + dy * stride;

	x += dx; y += dy;

	memset(data, 0, fill);
	data += fill;
	}
	break;
/*...e  */
/*...s  default    */
default:
	{
	int	n = (int) d;

	while ( n-- > 0 )
        *data++ = u_next(ahead);
	x += d;
	if ( d & 1 )
        u_next(ahead);    /* Align */
	}
	break;
/*...e  */
				}
		}
    u_destroy_ahead(ahead);
	}
	break;
/*...e  */
/*...s  BCA_RLE4    */
case BCA_RLE4:
	{
	AHEAD	*ahead;
	int	x = 0, y = 0;
	BOOLEAN	eof4 = FALSE;
	int	inx = 0;

    if ( (ahead = u_create_ahead(fd)) == NULL )
		return ( GBM_ERR_MEM );

	memset(data, 0, gbm -> h * cLinesWorth);

	while ( !eof4 )
		{
        byte    c = u_next(ahead);
        byte    d = u_next(ahead);

		if ( c )
			{
			byte	h, l;
			int	i;

			if ( x & 1 )
				{
				h = (byte) (d >> 4); l = (byte) (d << 4);
				}
			else
				{
				h = (byte) (d & 0xf0); l = (byte) (d & 0x0f);
				}
			for ( i = 0; i < (int) c; i++, x++ )
				if ( x & 1 )
					data [inx++] |= l;
				else
					data [inx]   |= h;					
			}
		else
			switch ( d )
				{
/*...s  MSWCC_EOL    */
case MSWCC_EOL:
	for ( ; x < gbm -> w; x++ )
		if ( x & 1 )
			inx++;
	x = 0; y++;
    inx = ((inx + 3) & ~3);     /* Align output */
	break;
/*...e  */
/*...s  MSWCC_EOB    */
case MSWCC_EOB:
	eof4 = TRUE;
	break;
/*...e  */
/*...s  MSWCC_DELTA    */
case MSWCC_DELTA:
	{
    byte    dx = u_next(ahead);
    byte    dy = u_next(ahead);

	y   += dy;
	inx += dy * cLinesWorth;

	if ( dx > 0 )
		{
		if ( x & 1 )
			{
			inx++;
			x++;
			dx--;
			}

		inx += (dx / 2);
		x += dx;
		}
		
	}
	break;
/*...e  */
/*...s  default    */
default:
	{
	int	i, nr = 0;

	if ( x & 1 )
		{
		for ( i = 0; i < (int) d; i += 2 )
			{
            byte    b = u_next(ahead);

			data [inx++] |= (b >> 4);
			data [inx  ] |= (b << 4);
			nr++;
			}
		if ( i < (int) d )
			{
            data [inx++] |= (u_next(ahead) >> 4);
			nr++;
			}
		}

	else
		{
		for ( i = 0; i < (int) d; i += 2 )
			{
            data [inx++] = u_next(ahead);
			nr++;
			}
		if ( i < (int) d )
			{
            data [inx] = u_next(ahead);
			nr++;
			}
		}
	x += d;

	if ( nr & 1 )
        u_next(ahead); /* Align input stream to next word */
	}
	break;
/*...e  */
				}
		}

    u_destroy_ahead(ahead);
	}
	break;
/*...e  */
/*...s  default    */
default:
	return ( GBM_ERR_BMP_COMP );
/*...e  */
	}
}
/*...e  */
	else
/*...s  OS/2 1.1, 1.2   */
{
    u_lseek( fd, bmp_priv -> offBits, SEEK_SET );
    u_read(  fd, data, cLinesWorth * gbm -> h  );
}
/*...e  */

	if ( bmp_priv -> invb )
		invert(data, cLinesWorth * gbm -> h);

	return ( GBM_ERR_OK );
	}
/*...e  */









/*...s  bmp_w   */
/*...s  write_inv   write inverted data */
static unsigned write_inv( int fd, byte *buffer, unsigned int count );
static unsigned write_inv( int fd, byte *buffer, unsigned int count )
	{
    byte   small_buf [1024];
    unsigned int    so_far = 0, this_go, written;

	while ( so_far < count )
		{
		this_go = min(count - so_far, 1024);
		memcpy(small_buf, buffer + so_far, this_go);
		invert(small_buf, this_go);
        if ( (written = u_write(fd, small_buf, this_go)) != this_go )
			return ( so_far + written );
		so_far += written;
		}
    return ( so_far );
	}
/*...e  */




static GBM_ERR bmp_w_do(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);



/*...s  bmp_rdata   */
/* wrapper, flips data */
DLLEXPORT GBM_ERR dxe_w(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
{
    /* flip data upside down */
    flip_data_upside_down( gbm, data );
    return bmp_w_do(fn, fd, gbm, gbmrgb, data, opt);
}





static GBM_ERR bmp_w_do(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
	{
    BOOLEAN pm11 = ( u_find_word(opt, "1.1" ) != NULL );
    BOOLEAN win  = ( u_find_word(opt, "win" ) != NULL ||u_find_word(opt, "2.0" ) != NULL );
    BOOLEAN inv  = ( u_find_word(opt, "inv" ) != NULL );
    BOOLEAN invb = ( u_find_word(opt, "invb") != NULL );
	int cRGB;
	GBMRGB gbmrgb_1bpp [2];


    if ( pm11 && win ) return ( GBM_ERR_BAD_OPTION );

    cRGB = ( (1 << gbm -> bpp) & 0x1ff );
		/* 1 -> 2, 4 -> 16, 8 -> 256, 24 -> 0 */

	if ( cRGB == 2 )
/*...s  handle messy 1bpp case */
{
/*
The palette entries inside a 1bpp PM bitmap are not honored, or handled
correctly by most programs. Current thinking is that they have no actual
meaning. Under OS/2 PM, bitmap 1's re fg and 0's are bg, and it is the job of
the displayer to pick fg and bg. We will pick fg=black, bg=white in the bitmap
file we save. If we do not write black and white, we find that most programs
will incorrectly honor these entries giving unpredicatable (and often black on
a black background!) results.
*/

gbmrgb_1bpp [0].r = gbmrgb_1bpp [0].g = gbmrgb_1bpp [0].b = 0xff;
gbmrgb_1bpp [1].r = gbmrgb_1bpp [1].g = gbmrgb_1bpp [1].b = 0x00;

/*
We observe these values must be the wrong way around to keep most PM
programs happy, such as WorkPlace Shell WPFolder backgrounds.
*/

if ( !inv )
	swap_pal(gbmrgb_1bpp);

gbmrgb = gbmrgb_1bpp;
}
/*...e  */

	if ( pm11 )
/*...s  OS/2 1.1 */
{
word usType, xHotspot, yHotspot, cx, cy, cPlanes, cBitCount;
dword cbSize, offBits, cbFix;
int cLinesWorth, i;

usType      = BFT_BMAP;
xHotspot    = 0;
yHotspot    = 0;
cbFix       = 12L;
cx          = gbm -> w;
cy          = gbm -> h;
cPlanes     = 1;
cBitCount   = gbm -> bpp;
cLinesWorth = (((cBitCount * cx + 31) / 32) * cPlanes) * 4;
offBits     = 26L + cRGB * 3L;
cbSize      = offBits + (dword) cy * (dword) cLinesWorth;

write_word(fd, usType);
write_dword(fd, cbSize);
write_word(fd, xHotspot);
write_word(fd, yHotspot);
write_dword(fd, offBits);
write_dword(fd, cbFix);
write_word(fd, cx);
write_word(fd, cy);
write_word(fd, cPlanes);
write_word(fd, cBitCount);

for ( i = 0; i < cRGB; i++ )
	{
	byte b [3];

	b [0] = gbmrgb [i].b;
	b [1] = gbmrgb [i].g;
	b [2] = gbmrgb [i].r;
    u_write(fd, b, 3);
	}

if ( invb )
	write_inv(fd, data, gbm -> h * cLinesWorth);
else
    u_write(fd, data, gbm -> h * cLinesWorth);
}
/*...e  */
	else
/*...s  OS/2 2.0 and Windows 3.0   */
{
word    usType, xHotspot, yHotspot, cPlanes, cBitCount;
dword   cx, cy, cbSize, offBits, cbFix, ulCompression, cbImage;
dword   cxResolution, cyResolution, cclrUsed, cclrImportant;
int     cLinesWorth, i;

usType      = BFT_BMAP;
xHotspot    = 0;
yHotspot    = 0;
cbFix       = 40L;
cx          = gbm -> w;
cy          = gbm -> h;
cPlanes     = 1;
cBitCount   = gbm -> bpp;
cLinesWorth = (((cBitCount * (int) cx + 31) / 32) * cPlanes) * 4;
offBits     = 54L + cRGB * 4L;
cbSize      = offBits + (dword) cy * (dword) cLinesWorth;

ulCompression = BCA_UNCOMP;
cbImage       = cLinesWorth * gbm -> h;
cxResolution  = 0;
cyResolution  = 0;
cclrUsed      = 0;
cclrImportant = 0;

write_word(fd, usType);
write_dword(fd, cbSize);
write_word(fd, xHotspot);
write_word(fd, yHotspot);
write_dword(fd, offBits);
write_dword(fd, cbFix);
write_dword(fd, cx);
write_dword(fd, cy);
write_word(fd, cPlanes);
write_word(fd, cBitCount);
write_dword(fd, ulCompression);
write_dword(fd, cbImage);
write_dword(fd, cxResolution);
write_dword(fd, cyResolution);
write_dword(fd, cclrUsed);
write_dword(fd, cclrImportant);

for ( i = 0; i < cRGB; i++ )
	{
	byte b [4];

	b [0] = gbmrgb [i].b;
	b [1] = gbmrgb [i].g;
	b [2] = gbmrgb [i].r;
	b [3] = 0;
    u_write(fd, b, 4);
	}

if ( invb )
	write_inv(fd, data, gbm -> h * cLinesWorth);
else
    u_write(fd, data, gbm -> h * cLinesWorth);
}
/*...e  */

	return ( GBM_ERR_OK );
	}
/*...e  */
/*...s  bmp_err   */
DLLEXPORT char *dxe_err(GBM_ERR rc)
	{
	switch ( (int) rc )
		{
		case GBM_ERR_BMP_PLANES:
			return ( "number of bitmap planes is not 1" );
		case GBM_ERR_BMP_BITCOUNT:
			return ( "bit count not 1, 4, 8 or 24" );
		case GBM_ERR_BMP_CBFIX:
			return ( "cbFix bad" );
		case GBM_ERR_BMP_COMP:
			return ( "compression type not uncompressed, RLE4 or RLE8" );
		case GBM_ERR_BMP_OFFSET:
			return ( "less bitmaps in file than index requested" );
		}
	return ( NULL );
	}
/*...e  */



/* flips a picture data upside down
 * not ready for all bpp's yet
 */
static void flip_data_upside_down( GBM *gbm,  byte *data )
{
    int     bpp = gbm->bpp;
    int     x,y,i,j;
    byte    a;
    int     stride = ((gbm -> bpp * gbm -> w + 31) / 32) * 4;
    int     istride=1;

    if(bpp==1)  istride = gbm->w/8;
    if(bpp==4)  istride = gbm->w/2;
    if(bpp==8)  istride = gbm->w;
    if(bpp==24) istride = gbm->w*3;
    for ( y = 0; y < gbm->h/2; y++ ){
    for ( x = 0; x < istride; x++ ){
    i = stride * y + x;
    j = stride * ((gbm->h-1) - y) + x;
    a = data[j];
    data[j] = data[i];
    data[i] = a;
    }}
    return;
}

/*...sread_word:0:*/
static BOOLEAN read_word(int fd, word *w)
	{
	byte	low = 0, high = 0;

    u_read(fd, (char *) &low, 1);
    u_read(fd, (char *) &high, 1);
	*w = (word) (low + ((word) high << 8));
	return ( TRUE );
	}
/*...e*/
/*...sread_dword:0:*/
static BOOLEAN read_dword(int fd, dword *d)
	{
	word	low, high;

	read_word(fd, &low);
	read_word(fd, &high);
	*d = low + ((dword) high << 16);
	return ( TRUE );
	}
/*...e*/
/*...swrite_word:0:*/
static BOOLEAN write_word(int fd, word w)
	{
	byte	low  = (byte) w;
	byte	high = (byte) (w >> 8);

    u_write(fd, &low, 1);
    u_write(fd, &high, 1);
	return ( TRUE );
	}
/*...e*/
/*...swrite_dword:0:*/
static BOOLEAN write_dword(int fd, dword d)
	{
	write_word(fd, (word) d);
	write_word(fd, (word) (d >> 16));
	return ( TRUE );
	}
/*...e*/


