#include <windows.h>
#include <stdio.h>

int load_and_exec (const char* dllname, const char *procname) {
    HINSTANCE dllhandle;
    FARPROC proc;
    typedef void (*ifuncp) ();
    ifuncp dllfunc;

    if (! (dllhandle = LoadLibrary(dllname))) {
	printf ("Error loading DLL `%s'\n", dllname);
	return 1;
    }

    if (! (proc = GetProcAddress (dllhandle, "thunder"))) {
	printf ("Can't find proc `%s' in DLL `%s'\n", procname, dllname);
	return 1;
    }
    printf("<%s>\n", proc );


    if (! (proc = GetProcAddress (dllhandle, procname))) {
	printf ("Can't find proc `%s' in DLL `%s'\n", procname, dllname);
	return 1;
    }


    dllfunc = (ifuncp) proc;
    (*dllfunc) ();

    return 0;
}

int main (int argc, char *argv[]) {
    load_and_exec ("foo1.dll", "foo1@0");
    load_and_exec ("foo2.dll", "foo2@0");
    load_and_exec ("foo3.dll", "foo3@0");

    load_and_exec ("foo1.dll", "foo_common@0");
    load_and_exec ("foo2.dll", "foo_common@0");
    load_and_exec ("foo3.dll", "foo_common@0");
    exit (0);
}

