#ifndef _IMPORT_DLLGREY_
#define _IMPORT_DLLGREY_

#include "../global.h"
#include "mtds.h"


MTDS dxemod_params;
void dxemod_init();
void dxemod_deinit();
int  dxemod_method ( BITMAP *src, int x1, int y1, int sx, int sy );




// ---------------------------------------------------------------------
// prototypes

 BITMAP *(* v_create_bitmap)(int width, int height);
 BITMAP *(* v_create_bitmap_ex)(int color_depth, int width, int height);
 BITMAP *(* v_create_sub_bitmap)(BITMAP *parent, int x,int y,int width,int height);
 void (* v_destroy_bitmap)(BITMAP *bitmap);
 int  (* v_bitmap_color_depth)(BITMAP *bmp);
 int  (* v_bitmap_mask_color)(BITMAP *bmp);
 void (* v_set_clip)(BITMAP *bitmap, int x1, int y1, int x2, int y2);

 BITMAP *(* v_load_bitmap)(const char *filename, RGB *pal);
 int  (* v_save_bitmap)(const char *filename, BITMAP *bmp, const RGB *pal);
 void (* v_register_bitmap_file_type)(const char *ext, BITMAP *(*load)(const char *filename, RGB *pal), int (*save)(const char *filename, BITMAP *bmp, const RGB *pal));
 void (* v_set_color_conversion)(int mode);

 void (* v_set_color)(int index, const RGB *p);
 void (* v_set_palette)(const PALETTE p);
 void (* v_get_color)(int index, RGB *p);
 void (* v_get_palette)(PALETTE p);

 int  (* v_makecol8)(int r, int g, int b);
 int  (* v_makecol15)(int r, int g, int b);
 int  (* v_makecol16)(int r, int g, int b);
 int  (* v_makecol24)(int r, int g, int b);
 int  (* v_makecol32)(int r, int g, int b);
 int  (* v_makecol)(int r, int g, int b);
 int  (* v_makecol_depth)(int color_depth, int r, int g, int b);

 int  (* v_getr)(int c);
 int  (* v_getg)(int c);
 int  (* v_getb)(int c);
 int  (* v_geta)(int c);
 int  (* v_getr_depth)(int color_depth, int c);
 int  (* v_getg_depth)(int color_depth, int c);
 int  (* v_getb_depth)(int color_depth, int c);
 int  (* v_geta_depth)(int color_depth, int c);

 int  (* v_getpixel)(BITMAP *bmp, int x, int y);
 void (* v_putpixel)(BITMAP *bmp, int x, int y, int color);
 void (* v_vline)(BITMAP *bmp, int x, int y1, int y2, int color);
 void (* v_hline)(BITMAP *bmp, int x1, int y, int x2, int color);
 void (* v_do_line)(BITMAP *bmp, int x1, int y1, int x2, int y2, int d, void (*proc)(BITMAP *bmp, int x, int y, int d));
 void (* v_line)(BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
 void (* v_triangle)(BITMAP *bmp, int x1, int y1, int x2,int y2, int x3, int y3, int color);
 void (* v_polygon)(BITMAP *bmp, int vertices, int *points, int color);
 void (* v_rect)(BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
 void (* v_rectfill)(BITMAP *bmp, int x1, int y1, int x2, int y2, int color);
 void (* v_do_circle)(BITMAP *bmp, int x, int y, int radius, int d, void (*proc)(BITMAP *bmp, int x, int y, int d));
 void (* v_circle)(BITMAP *bmp, int x, int y, int radius, int color);
 void (* v_circlefill)(BITMAP *bmp, int x, int y, int radius, int color);
 void (* v_do_ellipse)(BITMAP *bmp, int x, int y, int rx, int ry, int d, void (*proc)(BITMAP *bmp, int x, int y, int d));
 void (* v_ellipse)(BITMAP *bmp, int x, int y, int rx, int ry, int color);
 void (* v_ellipsefill)(BITMAP *bmp, int x, int y, int rx, int ry, int color);
 void (* v_floodfill)(BITMAP *bmp, int x, int y, int color);

 void (* v_clear_bitmap)(BITMAP *bitmap);
 void (* v_clear)(BITMAP *bitmap);
 void (* v_clear_to_color)(BITMAP *bitmap, int color);
 void (* v_blit)(BITMAP *source, BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
 void (* v_masked_blit)(BITMAP *source, BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
 void (* v_stretch_blit)(BITMAP *source, BITMAP *dest, int source_x, int source_y, int source_width, int source_height, int dest_x, int dest_y, int dest_width, int dest_height);
 void (* v_masked_stretch_blit)(BITMAP *source, BITMAP *dest, int source_x, int source_y, int source_w, int source_h, int dest_x, int dest_y, int dest_w, int dest_h);
 void (* v_draw_sprite)(BITMAP *bmp, BITMAP *sprite, int x, int y);
 void (* v_draw_sprite_v_flip)(BITMAP *bmp, BITMAP *sprite, int x, int y);
 void (* v_draw_sprite_h_flip)(BITMAP *bmp, BITMAP *sprite, int x, int y);
 void (* v_draw_sprite_vh_flip)(BITMAP *bmp, BITMAP *sprite, int x, int y);
 void (* v_draw_character)(BITMAP *bmp, BITMAP *sprite, int x, int y, int color);
 void (* v_rotate_sprite)(BITMAP *bmp, BITMAP *sprite, int x, int y, fixed angle);
 void (* v_stretch_sprite)(BITMAP *bmp, BITMAP *sprite, int x, int y, int w, int h);

 int  (* v_text_mode)(int mode);
 void (* v_textout)(BITMAP *bmp, const FONT *f, const char *s, int x, int y, int color);
 void (* v_textout_centre)(BITMAP *bmp, const FONT *f, const char *s, int x, int y, int color);
 void (* v_textout_right)(BITMAP *bmp, const FONT *f, const char *s, int x, int y, int color);
 void (* v_textout_justify)(BITMAP *bmp, const FONT *f, const char *s, int x1, int x2, int y, int diff, int color);
 void (* v_textprintf)(BITMAP *bmp, const FONT *f, int x, int y, int color, const char *fmt, ...);
 void (* v_textprintf_centre)(BITMAP *bmp, const FONT *f, int x, int y, int color, const char *fmt, ...);
 void (* v_textprintf_right)(BITMAP *bmp, const FONT *f, int x, int y, int color, const char *fmt, ...);
 void (* v_textprintf_justify)(BITMAP *bmp, const FONT *f, int x1, int x2, int y, int diff, int color, const char *fmt, ...);
 int  (* v_text_length)(const FONT *f, const char *str);
 int  (* v_text_height)(const FONT *f);
 void (* v_destroy_font)(FONT *f);

 int  (* v_bestfit_color)(const PALETTE pal, int r, int g, int b);
 void (* v_hsv_to_rgb)(float h, float s, float v, int *r, int *g, int *b);
 void (* v_rgb_to_hsv)(int r, int g, int b, float *h, float *s, float *v);

 void (* v_scare_mouse)();
 void (* v_unscare_mouse)();

// ---------------------------------------------------------------------




void dxemod_import1(
    void *u_create_bitmap,
    void *u_create_bitmap_ex,
    void *u_create_sub_bitmap,
    void *u_destroy_bitmap,
    void *u_bitmap_color_depth,
    void *u_bitmap_mask_color,
    void *u_set_clip,
    void *u_load_bitmap,
    void *u_save_bitmap,
    void *u_register_bitmap_file_type,
    void *u_set_color_conversion,
    void *u_set_color,
    void *u_set_palette,
    void *u_get_color,
    void *u_get_palette,
    void *u_makecol8,
    void *u_makecol15,
    void *u_makecol16,
    void *u_makecol24,
    void *u_makecol32,
    void *u_makecol,
    void *u_makecol_depth,
    void *u_getr,
    void *u_getg,
    void *u_getb,
    void *u_geta,
    void *u_getr_depth,
    void *u_getg_depth,
    void *u_getb_depth,
    void *u_geta_depth,
    void *u_getpixel,
    void *u_putpixel,
    void *u_vline,
    void *u_hline,
    void *u_do_line,
    void *u_line,
    void *u_triangle,
    void *u_polygon,
    void *u_rect,
    void *u_rectfill,
    void *u_do_circle,
    void *u_circle,
    void *u_circlefill,
    void *u_do_ellipse,
    void *u_ellipse,
    void *u_ellipsefill,
    void *u_floodfill,
    void *u_clear_bitmap,
    void *u_clear,
    void *u_clear_to_color,
    void *u_blit,
    void *u_masked_blit,
    void *u_stretch_blit,
    void *u_masked_stretch_blit,
    void *u_draw_sprite,
    void *u_draw_sprite_v_flip,
    void *u_draw_sprite_h_flip,
    void *u_draw_sprite_vh_flip,
    void *u_draw_character,
    void *u_rotate_sprite,
    void *u_stretch_sprite,
    void *u_text_mode,
    void *u_textout,
    void *u_textout_centre,
    void *u_textout_right,
    void *u_textout_justify,
    void *u_textprintf,
    void *u_textprintf_centre,
    void *u_textprintf_right,
    void *u_textprintf_justify,
    void *u_text_length,
    void *u_text_height,
    void *u_destroy_font,
    void *u_bestfit_color,
    void *u_hsv_to_rgb,
    void *u_rgb_to_hsv,
    void *u_scare_mouse,
    void *u_unscare_mouse );


GLOBAL_DATA *g;


void dxemod_import2(
    void *,
    void *,
    void *,
    void *,
    void *,
    void *,
    void *,
    void *,
    void * );


#define DLLEXPORT __declspec(dllexport)
#define DLLIMPORT __declspec(dllimport)

#endif

