/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"EDGE",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"embossed object",
"Make object from image already embossed",
"Testing->",
"                              "
"                              "
"  **************************  "
"  ***********************  *  "
"  **********************   *  "
"  ************  *******    *  "
"  *****       **      *    *  "
"  *****      ****          *  "
"  *****     ******    *    *  "
"  *****       **           *  "
"  *****       **      *    *  "
"  ****        **           *  "
"  ***                      *  "
"  **  **              **   *  "
"  *  *******      *******  *  "
"  *  *******      *******  *  "
"  **  **              **   *  "
"  ***                      *  "
"  ****        **           *  "
"  *****       **      *    *  "
"  *****       **           *  "
"  *****     ******    *    *  "
"  *****      ****          *  "
"  *****       **      *    *  "
"  ****** * * * * * * **    *  "
"  ***                      *  "
"  **                       *  "
"  **************************  "
"                              "
"                              ",
"******************************"
"******************************"
"**                          **"
"**                       ** **"
"**                      *** **"
"**            **       **** **"
"**     *******  ****** **** **"
"**     ******    ********** **"
"**     *****      **** **** **"
"**     *******  *********** **"
"**     *******  ****** **** **"
"**    ********  *********** **"
"**   ********************** **"
"**  **  **************  *** **"
"** **       ******       ** **"
"** **       ******       ** **"
"**  **  **************  *** **"
"**   ********************** **"
"**    ********  *********** **"
"**     *******  ****** **** **"
"**     *******  *********** **"
"**     *****      **** **** **"
"**     ******    ********** **"
"**     *******  ****** **** **"
"**      * * * * * * *  **** **"
"**   ********************** **"
"**  *********************** **"
"**                          **"
"******************************"
"******************************",
1,0,1,1,0
};     

static    int     threshold = 20, retval = -1;


DLLEXPORT void dxemod_init()
{
    if( g->dxe_bitmap==NULL )
        g->dxe_bitmap = v_create_bitmap( g->sx+2, g->sy+2 );
    retval = v_dlg_request_uchar(" Threshold ",0,threshold,254 );
    if( retval >= 0 ) threshold = retval;
}
DLLEXPORT void dxemod_deinit(){}


#define EVENT_UNDEF 0
#define EVENT_UP   11
#define EVENT_DOWN 22

/*
 * Changes greater than threshold mark an edge.
 * Should be used after EMBOSS method, to detect edges
 * return -1 on error
 */
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x=0, y=0, xlim, ylim;
    int     dx, idx;
    int     dy, idy;
    int     eventx_type = EVENT_UNDEF, event_x=0, event_y=0;
    int     eventy_type = EVENT_UNDEF;
    int     black, white,p;

    black = 0;
    white = 255;
    if( src==NULL || g->dxe_bitmap==NULL ) return -1;
    if( retval < 0 ) return -1;
    v_clear_to_color(  g->dxe_bitmap, black );

    ylim = y1+sy;
    xlim = x1+sx;

    for(y=y1 ; y<ylim ; y++){   // already based on emboss
    for(x=x1 ; x<xlim ; x++){
    p   = v_getpixel( src, x, y ) & 255;
    idx = p - 128;
    dx  = 128 - p;

    if ( idx >= threshold ){        // grey to high intensity (UP)
        if( eventx_type != EVENT_UP ){  // only catch the first event_up
            eventx_type = EVENT_UP;
            event_x = x;
            event_y = y;
        }
    }
    if ( dx >=  threshold ){        // grey to low intensity (DOWN)
        if( eventx_type == EVENT_UP ){
            v_hline( g->dxe_bitmap, x, y, event_x, white );
            eventx_type = EVENT_UNDEF;      // reset
        }
    }



    }
        eventx_type = EVENT_UNDEF;
    }


    for(x=x1;x<xlim;x++){
    for(y=y1;y<ylim;y++){
    // already based on emboss
    p   = v_getpixel( src, x, y ) & 255;
    idy = p - 128;
    dy  = 128 - p;
    if ( idy >= threshold ){        // grey to high intensity (UP)
        if( eventy_type != EVENT_UP ){  // only catch the first event_up
            eventy_type = EVENT_UP;
            event_x = x;
            event_y = y;
        }
    }
    if ( dy >=  threshold ){        // grey to low intensity (DOWN)
        if( eventy_type == EVENT_UP ){
            v_vline(  g->dxe_bitmap, x, y, event_y, white );
            eventy_type = EVENT_UNDEF;      // reset
        }
    }

    }
        eventy_type = EVENT_UNDEF;
    }










    v_blit( g->dxe_bitmap, src, x1,y1,x1,y1,sx,sy );
    return 0;
}




