/*
 * Improved Gray Scale (IGS)
 * Algorithm as described in book 'Digital Image processing'
 *  by Rafael C. Gonzalez and Richard E. Woods
 *  Addison Wesley Publishing Company - world student series
 *   ISBN 0-201-60078-1
 *  page 317 to 318.
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"QUANT",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"4bit IGS quant.",
"4bit IGS quantization",
"Do 4 bits Improved Gray Scale quantization on image block.upper 4 bits are valid ",
"                              "
"                              "
"   ******   ******  *******   "
"   ******   ******  *******   "
"       **   **      **        "
"       **   **      **        "
"       **   **      **        "
"   ******   ******  *******   "
"   **           **  *******   "
"   **           **  **   **   "
"   **           **  **   **   "
"   ******   ******  *******   "
"   ******   ******  *******   "
"                              "
"                              "
"                              "
"                              "
"                              "
"     **   *******     ***     "
"    ***   *******     ***     "
"   ****   **          ***     "
"  ** **   **          ***     "
"     **   *******     ***     "
"     **   *******  *********  "
"     **   **   **   *******   "
"     **   **   **    *****    "
"     **   *******     ***     "
"     **   *******      *      "
"                              "
"                              ",
"******************************"
"******************************"
"***      ***      **       ***"
"***      ***      **       ***"
"*******  ***  ******  ********"
"*******  ***  ******  ********"
"*******  ***  ******  ********"
"***      ***      **       ***"
"***  ***********  **       ***"
"***  ***********  **  ***  ***"
"***  ***********  **  ***  ***"
"***      ***      **       ***"
"***      ***      **       ***"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"*****  ***       *****   *****"
"****   ***       *****   *****"
"***    ***  **********   *****"
"**  *  ***  **********   *****"
"*****  ***       *****   *****"
"*****  ***       **         **"
"*****  ***  ***  ***       ***"
"*****  ***  ***  ****     ****"
"*****  ***       *****   *****"
"*****  ***       ****** ******"
"******************************"
"******************************",

1,0,0,1,0
};     


#define DO_IGS_BLOCK lsb &= 0x0f;\
msb &= 0xf0;\
if( sum==0 ) sum = e;\
if( msb == 0xf0 ){ e += 0; }else{ e += s_lsb; sum = e; }\
s_msb = s_lsb = sum;\
s_lsb &= 0x0f;\
s_msb &= 0xf0;\
e &= 0xf0;\


DLLEXPORT void dxemod_init(){}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int x,y;
    unsigned char e, sum, s_lsb, s_msb, msb,lsb;
    int ru,gu,bu;

    s_lsb=0;
    sum = 0;
    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    if(g->bpp<=8){
    lsb=msb=e=   v_getpixel(src,x,y) & 0xff;
    DO_IGS_BLOCK
    v_putpixel(src,x,y, e );
    }else{
    lsb=msb=e=  v_getr( v_getpixel(src,x,y) );
    DO_IGS_BLOCK
    ru = e;
    lsb=msb=e=  v_getg( v_getpixel(src,x,y) );
    DO_IGS_BLOCK
    gu = e;
    lsb=msb=e=  v_getb( v_getpixel(src,x,y) );
    DO_IGS_BLOCK
    bu = e;
    v_putpixel(src,x,y, v_makecol(ru,gu,bu) );
    }
    }}
    return 0;
}

