/*
 *
 *
 */
#include <stdio.h>
#include <allegro.h>
#include "import.h"
#include "mtds.h"
#include "dllinit.h"
#include "../dlg.h"
#include "../global.h"
#include "../types.h"


DLLEXPORT MTDS dxemod_params = {
"BINOP",                                // CLASS
"i.p.",__DATE__ ", " __TIME__,"0.1",    // author, datetime, version
"binaryzation",
"3 color binaryzation with hysteres, outside value = grey",
"Make a image binary by thresholding->Any value above or below positive/negative hysteres level switches color.",
"                              "
"                              "
"                              "
"                              "
"                              "
"                              "
"                              "
"  ********    ********        "
"  **    **    **    **        "
"  **    **    **    **        "
"  **    **    **    **        "
"***************************** "
"        **    **    **        "
"        **    **    **        "
"        **    **    **        "
"        **    **    **        "
"        **    **    **        "
"***************************** "
"        **    **    **    **  "
"        **    **    **    **  "
"        **    **    **    **  "
"        ********    ********  "
"                              "
"                              "
"                              "
"                              "
"                              "
"                              "
"                              "
"                              ",
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"**        ****        ********"
"**  ****  ****  ****  ********"
"**  ****  ****  ****  ********"
"**  ****  ****  ****  ********"
"                             *"
"********  ****  ****  ********"
"********  ****  ****  ********"
"********  ****  ****  ********"
"********  ****  ****  ********"
"********  ****  ****  ********"
"                             *"
"********  ****  ****  ****  **"
"********  ****  ****  ****  **"
"********  ****  ****  ****  **"
"********        ****        **"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************"
"******************************",
1,0,1,1,0
};     

static int hysteres_positive = 32, retval1 = -1;
static int hysteres_negative = 64, retval2 = -1;

DLLEXPORT void dxemod_init()
{
    retval1 = v_dlg_request_uchar( "positive distance", 1, hysteres_positive, 127);
    retval2 = v_dlg_request_uchar( "negative distance", 1, hysteres_negative, 127);
    if( retval1 > 0 ) hysteres_positive = retval1;
    if( retval2 > 0 ) hysteres_negative = retval2;
}
DLLEXPORT void dxemod_deinit(){}
DLLEXPORT int dxemod_method (BITMAP *src, int x1, int y1, int sx, int sy )
{
    int     x,y,e=0;
    int     bwlevel=0, sum=0, num=0;
    int     minval, maxval, average;
    int     range_median, delta_range;
    int     hysteres_pos;
    int     hysteres_neg;
    int     grey = 128;
    char    set;

    if( retval1 < 0 ) return -1;         // cancel was pressed
    if( retval2 < 0 ) return -1;         // cancel was pressed
    if( hysteres_positive <= 0) return -1;
    if( hysteres_negative <= 0) return -1;


    maxval = 0;
    minval = 255;
    sum = num = 0;
    for(y=y1; y<(y1+sy); y++){   // get image extremes of sample image
    for(x=x1; x<(x1+sx); x++){
    e = v_getpixel(src,x,y) & 255;
    if(e>maxval) maxval = e;
    if(e<minval) minval = e;
    sum += e;   // the sum of grey levels
    num++;      // number of pixels
    }}
    average      = sum / num;               // average grey value
    delta_range  = maxval - minval;         // range of values
    range_median = (maxval + minval) / 2;   //

    hysteres_pos = maxval - hysteres_positive; // distance from maxval
    hysteres_neg = minval + hysteres_negative; // distance from minval

    bwlevel=  0;
    e = v_getpixel(src,x1,y1) & 255;
    if( e > hysteres_pos) bwlevel = 255;
    if( e < hysteres_neg) bwlevel = 0;
    for(y=y1; y<(y1+sy); y++) {
    for(x=x1; x<(x1+sx); x++) {
    e = v_getpixel(src,x,y) & 255;
    // switching, limit
    set = 0;
    if( e >= hysteres_pos ){ bwlevel = 255;  set = 1;}
    if( e <= hysteres_neg ){ bwlevel = 0;    set = 1;}
    if( set==1 )
        v_putpixel(src,x,y, bwlevel );
    else
        v_putpixel(src,x,y, grey );
/*
    // simple limit compare
    if( e >= hysteres_pos ) v_putpixel(src,x,y, 255 );
    if( e <= hysteres_neg ) v_putpixel(src,x,y, 0   );
*/
    }}
    return 0;
}

