/*
 * interface to Windows
 *  for loading DLL's
 *
 *  Allegro must not be defined here
 *
 *
 */

#include <stdio.h>
#include <windows.h>
#include "dllbtn/mtds.h"


    void    (*dxegrey_init)   (void);
    void    (*dxegrey_deinit) (void);
    int     (*dxegrey_method) (void *,BITMAP *,int,int,int,int);
    MTDS    *mtds;             // dxemodule variables
    void    (*dll_init1)( void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *);
    void    (*dll_init2)(
            void *, void *, void *, void *,
            void *, void *, void *, void *, void * );


int dll_load( const char* dllname )
{
    HINSTANCE dllhandle;

    if (! (dllhandle = LoadLibrary(dllname))) return 1;   // error

    dxegrey_init   = (void (*)(void))                     GetProcAddress (dllhandle, "dxemod_init");
    dxegrey_deinit = (void (*)(void))                     GetProcAddress (dllhandle, "dxemod_deinit");
    dxegrey_method = (int (*)(void *,BITMAP *,int,int,int,int))  GetProcAddress (dllhandle, "dxemod_method");
    mtds           = (MTDS *)                             GetProcAddress (dllhandle, "dxemod_params");
    dll_init1      = (void (*)( void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *,
 void *, void *, void *, void *, void *, void *, void *, void *, void *)) GetProcAddress (dllhandle, "dxemod_import1");
    dll_init2      = (void (*)(
            void *, void *, void *, void *,
            void *, void *, void *, void * , void * )) GetProcAddress (dllhandle, "dxemod_import2");
    if( dxegrey_init == NULL || dxegrey_deinit == NULL ||
    dxegrey_method == NULL || mtds == NULL || dll_init1  == NULL || dll_init2 == NULL ){
    return 1;   // error
    }
    return 0;   // ok
}


// ------------------------------------------------------------------------


#include "gbminit.h"


int dll_load2( const char *dllname )
{
    HINSTANCE dllhandle;

    if (! (dllhandle = LoadLibrary(dllname))) return 1;   // error

    dllgbm_query_filetype = (GBM_ERR(*)(GBMFT *))                                       GetProcAddress (dllhandle, "dxe_qft");
    dllgbm_read_header    = (GBM_ERR(*)(char *, int, GBM *, char *))                    GetProcAddress (dllhandle, "dxe_rhdr");
    dllgbm_read_palette   = (GBM_ERR(*)(int, GBM *, GBMRGB *))                          GetProcAddress (dllhandle, "dxe_rpal");
    dllgbm_read_data      = (GBM_ERR(*)(int, GBM *, byte *))                            GetProcAddress (dllhandle, "dxe_rdata");
    dllgbm_write          = (GBM_ERR(*)(char *, int, GBM *, GBMRGB *, byte *, char *))  GetProcAddress (dllhandle, "dxe_w");
    dllgbm_err            = (char  *(*)(GBM_ERR))                                       GetProcAddress (dllhandle, "dxe_err");
    dllgbm_init           = (void   (*)( void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void *, void * ))  GetProcAddress (dllhandle, "dxe_import1");

    if( dllgbm_query_filetype == NULL ||
        dllgbm_read_header    == NULL ||
        dllgbm_read_palette   == NULL ||
        dllgbm_read_data      == NULL ||
        dllgbm_write          == NULL ||
        dllgbm_err            == NULL ||
        dllgbm_init           == NULL ) return 1;
    return 0;   // ok
}
