/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\





 buttonarray subroutines
*/

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "method.h"
#include "fill.h"
//#include "fnt.h"
#include "ll.h"
#include "tb.h"
#include "md2.h"
#include "btn.h"
#include "subs.h"
#include "clip.h"
#include "dlg.h"
#include "zoom.h"
#include "md.h"
#include "ed.h"
#include "main.h"       /* for mousi system */
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)


// #include "butil.h"       // for msgbox_(...);



static char rept_flag=0;  // do each button function multiple times if 1
static int  rept_iteration=0;

#define REPTIL(selfy)\
    if(rept_flag==1){\
    if(--rept_iteration==0){ rept_flag=0; refresh_screen2(); return; }\
    selfy (a,index);    }
#define REPTIL2(selfy)\
    if(rept_flag==1){\
    if(--rept_iteration==0){ rept_flag=0; refresh_screen_quick2(); return; }\
    selfy (a,index);    }
#define NOREPT()\
    rept_iteration=0;\
    rept_flag=0;\
    refresh_screen2();\
    return;
#define NOREPT2()\
    rept_iteration=0;\
    rept_flag=0;\
    refresh_screen_quick2();\
    return;

static void refresh_screen2()
{
    if( rept_flag==0 ){   // update graphically only if rept_flag is not set
    refresh_screen();
    in_display();
    }
}
void refresh_screen_quick2()
{
    if( rept_flag==0 ){   // update graphically only if rept_flag is not set
    refresh_screen_quick();
    display_zoomed_md();
    }
}











void b_copy(char a, int index)
{
    int sx,sy,w,h;
    BITMAP *pspr1=NULL;
    /*******************************/
    if(g.clipboard==NULL){
        if((g.clipboard=create_bitmap(g.sx,g.sy))==NULL) return;
    }
    pspr1=ll_get_sprite(g.block_current);
    w=pspr1->w;
    h=pspr1->h;
    sx=g.clipboard->w;
    sy=g.clipboard->h;
    if( (w!=sx) && (h!=sy) ){
        destroy_bitmap( g.clipboard );
        if((g.clipboard=create_bitmap(g.sx,g.sy))==NULL) return;
    }

    blit(pspr1, g.clipboard, 0, 0, 0, 0, g.sx, g.sy);
    /*******************************/
}
void b_prev(char a, int index)
{
    /*******************************/
    if ( g.block_current > 0 )
    {
    g.block_current--;
        refresh_screen2();
    }
    /*******************************/
    REPTIL(b_prev)
}
void b_next(char a, int index)
{
    /*******************************/
    if (g.block_count !=0 )
    {
    if (g.block_current < (g.block_count-1) )
    {
    g.block_current++;
    refresh_screen2();
    }}
    /*******************************/
    REPTIL(b_next)
}
void b_paste(char a, int index)
{
    int x1,y1,sx,sy;
    BITMAP *pspr1=NULL;

    if(g.clipboard==NULL) return;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        x1=y1=0;sx=g.sx;sy=g.sy;
        blit(g.clipboard, pspr1, 0, 0, x1, y1, sx, sy);
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        x1=clips.x1;    y1=clips.y1;    sx=clips.sx;    sy=clips.sy;
        blit(g.clipboard, pspr1, x1, y1, x1, y1, sx, sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        x1=clipd.x1;    y1=clipd.y1;    sx=clipd.sx;    sy=clipd.sy;
        blit(g.clipboard, pspr1, x1, y1, x1, y1, sx, sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
}
void b_first(char a, int index)
{
    /*******************************/
    g.block_current = 0;
    refresh_screen2();
    /*******************************/
}
void b_last(char a, int index)
{
    int i;
    /*******************************/
    g.block_current = g.block_count-1;
    i = 6;  drau_void( i );
    i = 7;  drau_void( i );
    i = 8;  drau_void( i );
    refresh_screen2();
    /*******************************/
}
void b_cut(char a, int index)
{
    /*******************************/
    ll_remove( g.block_current );
    g.block_count = ll_return_spr_count();
    if( g.block_current == g.block_count )
        if( g.block_current !=0 ) g.block_current--;
//msgbox_("block_current=%d clips.block=%d",g.block_current, clips.block);
        if(clips.flag==TRUE && g.block_current==clips.block ) clips.flag = FALSE;
        if(clips.flag==TRUE && clips.block!=0 ){
            if( g.block_current < clips.block )
            clips.block--;
        }
        if(clipd.flag==TRUE && g.block_current==clipd.block ) clipd.flag = FALSE;
        if(clipd.flag==TRUE && clipd.block != 0 ){
            if( g.block_current < clipd.block )
            clipd.block--;
        }
    refresh_screen2();
    /*******************************/
    REPTIL(b_cut)
}
void b_insert(char a, int index)
{
    int i;
    /*******************************/
    i = ll_insert( g.block_current, NULL ); /* new default behaviour */
    g.block_count = ll_return_spr_count();
    if( clips.block>=g.block_current && clips.flag==TRUE) clips.block++;
    if( clipd.block>=g.block_current && clipd.flag==TRUE) clipd.block++;
    refresh_screen2();
    /*******************************/
    REPTIL(b_insert)
}
void b_zoomp(char a, int index)
{
    /*******************************/
    g.zoom++;
    in_display();
    display_zoomed_md();
    /*******************************/
    REPTIL(b_zoomp)
}
/*
 *   pspr1 is original
 *   pspr2 is intermediate buffer
*/
void bb_shl(BITMAP *pspr1, BITMAP *pspr2, int x1, int y1, int sx, int sy)
{
    int s=1;
    if(rept_flag==1){ s=rept_iteration; if(s>sx) s=sx;}
    blit (pspr1, pspr2, x1+s, y1, 0, 0, sx-s, sy);
    blit (pspr1, pspr2, x1, y1, sx-s, 0, s, sy);
    blit (pspr2, pspr1, 0,0,x1,y1,sx,sy);
}
void b_shl(char a, int index)
{
    BITMAP *pspr1=NULL, *pspr2=NULL;

    if((pspr2=create_bitmap(g.sx, g.sy))==NULL) return;
    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_shl(pspr1,pspr2,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_shl(pspr1,pspr2,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_shl(pspr1,pspr2,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
    destroy_bitmap(pspr2);
    NOREPT2()
}
void bb_shr(BITMAP *pspr1, BITMAP *pspr2, int x1, int y1, int sx, int sy)
{
    int s=1;
    if(rept_flag==1){ s=rept_iteration; if(s>sx) s=sx;}
    blit (pspr1, pspr2, x1, y1, s, 0, sx-s, sy);
    blit (pspr1, pspr2, x1 + sx-s, y1, 0, 0, s, sy);
    blit (pspr2,pspr1,0,0,x1,y1,sx,sy);
}
void b_shr(char a, int index)
{
    BITMAP *pspr1=NULL, *pspr2=NULL;

    if((pspr2=create_bitmap(g.sx, g.sy))==NULL) return;
    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_shr(pspr1,pspr2,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_shr(pspr1,pspr2,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_shr(pspr1,pspr2,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
    destroy_bitmap(pspr2);
    NOREPT2()
}
void bb_shd(BITMAP *pspr1, BITMAP *pspr2, int x1, int y1, int sx, int sy)
{
    int s=1;
    if(rept_flag==1){ s=rept_iteration; if(s>sy) s=sy;}
    blit (pspr1, pspr2, x1, y1, 0, s, sx, sy-s);
    blit (pspr1, pspr2, x1, y1 + sy-s, 0, 0, sx, s);
    blit (pspr2,pspr1,0,0,x1,y1,sx,sy);
}
void b_shd(char a, int index)
{
    BITMAP *pspr1=NULL, *pspr2=NULL;

    if((pspr2=create_bitmap(g.sx, g.sy))==NULL) return;
    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_shd(pspr1,pspr2,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_shd(pspr1,pspr2,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_shd(pspr1,pspr2,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
    destroy_bitmap(pspr2);
    NOREPT2()
}
void bb_shu(BITMAP *pspr1, BITMAP *pspr2, int x1, int y1, int sx, int sy)
{
    int s=1;
    if(rept_flag==1){ s=rept_iteration; if(s>sy) s=sy;}
    blit (pspr1, pspr2, x1, y1+s, 0, 0, sx, sy-s);
    blit (pspr1, pspr2, x1, y1, 0, sy-s, sx, s);
    blit (pspr2,pspr1,0,0,x1,y1,sx,sy);
}
void b_shu(char a, int index)
{
    BITMAP *pspr1=NULL, *pspr2=NULL;

    if((pspr2=create_bitmap(g.sx, g.sy))==NULL) return;
    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_shu(pspr1,pspr2,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_shu(pspr1,pspr2,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_shu(pspr1,pspr2,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
    destroy_bitmap(pspr2);
    NOREPT2()
}
void bb_rotINT(BITMAP *pspr1, int angle, int x1, int y1, int sx, int sy)
{
    BITMAP *pspr2=NULL, *pspr3=NULL;

    if((pspr2=create_bitmap(sx,sy))==NULL) return;
    if((pspr3=create_bitmap(sx,sy))==NULL) return;
    clear_bitmap(pspr3);
    blit (pspr1,pspr2,x1,y1,0,0,sx,sy);
    rotate_sprite(pspr3, pspr2, 0, 0,  itofix(angle)   );
    blit (pspr3,pspr1,0,0,x1,y1,sx,sy);
    destroy_bitmap( pspr2 );
    destroy_bitmap( pspr3 );
}
void b_rotINT(char a, int index)
{
    int angle = 0;
    BITMAP *pspr1=NULL;

    /*******************************/
    angle = dlg_rotate_integer();    if( angle == -1 ) return;
    angle = angle & 255;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_rotINT(pspr1,angle, 0      , 0      , g.sx   , g.sy   );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_rotINT(pspr1,angle,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_rotINT(pspr1,angle,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
}
void b_zoomm(char a, int index)
{
    /*******************************/
    if ( g.zoom != 0 ) g.zoom--;
    display_zoomed_md();
    in_display();
    /*******************************/
    REPTIL(b_zoomm)
}
void bb_flip(BITMAP *pspr1, int x1, int y1, int sx, int sy)
{
    BITMAP *pspr2=NULL, *pspr3=NULL;

    if((pspr2=create_bitmap(sx,sy))==NULL) return;
    if((pspr3=create_bitmap(sx,sy))==NULL) return;
    clear_bitmap(pspr3);
    blit (pspr1,pspr2,x1,y1,0,0,sx,sy);
    draw_sprite_v_flip(pspr3, pspr2, 0,0);
    blit (pspr3,pspr1,0,0,x1,y1,sx,sy);
    destroy_bitmap( pspr2 );
    destroy_bitmap( pspr3 );
}
void b_flip(char a, int index)
{
    BITMAP *pspr1=NULL;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_flip(pspr1,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_flip(pspr1,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_flip(pspr1,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
}








void bb_mirror(BITMAP *pspr1, int x1, int y1, int sx, int sy)
{
    BITMAP *pspr2, *pspr3;

    if((pspr2=create_bitmap(sx,sy))==NULL) return;
    if((pspr3=create_bitmap(sx,sy))==NULL) return;
    clear_bitmap(pspr3);
    blit (pspr1,pspr2,x1,y1,0,0,sx,sy);
    draw_sprite_h_flip(pspr3, pspr2, 0,0);
    blit (pspr3,pspr1,0,0,x1,y1,sx,sy);
    destroy_bitmap( pspr2 );
    destroy_bitmap( pspr3 );
}

void b_mirror(char a, int index)
{
    BITMAP *pspr1=NULL;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_mirror(pspr1,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_mirror(pspr1,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_mirror(pspr1,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
}

void bb_rot90(BITMAP *pspr1, int x1, int y1, int sx, int sy)
{
    BITMAP *pspr2, *pspr3;
    /*******************************/
    if((pspr2=create_bitmap(sx,sy))==NULL) return;
    if((pspr3=create_bitmap(sx,sy))==NULL) return;
    clear_bitmap(pspr3);
    blit (pspr1,pspr2,x1,y1,0,0,sx,sy);
    rotate_block( pspr2, pspr3 );
    blit (pspr3,pspr1,0,0,x1,y1,sx,sy);
    destroy_bitmap( pspr2 );
    destroy_bitmap( pspr3 );
    /*******************************/
}
void b_rot90(char a, int index)
{
    BITMAP *pspr1=NULL;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        bb_rot90(pspr1,   0    ,   0    ,  g.sx  ,  g.sy  );
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        bb_rot90(pspr1,clips.x1,clips.y1,clips.sx,clips.sy);
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        bb_rot90(pspr1,clipd.x1,clipd.y1,clipd.sx,clipd.sy);
    }
    /***************/
    CLOOP2
    /*******************************/
    NOREPT();
}
void b_cls (char a, int index)
{
    BITMAP *pspr1=NULL;

    /*******************************/
    CLOOP1
    pspr1 = ll_get_sprite(g.block_current);
    /***************/
    if( g.flag_src==FALSE && g.flag_dst==FALSE ){
        rectfill(pspr1,   0    ,   0    ,  g.sx  ,  g.sy  ,bitmap_mask_color(pspr1));
    }
    if( g.flag_src==TRUE && clips.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clips.block );
        rectfill(pspr1,clips.x1,clips.y1,clips.x2,clips.y2,bitmap_mask_color(pspr1));
    }
    if( g.flag_dst==TRUE && clipd.flag==TRUE ){
        if( g.flag_all==FALSE ) pspr1 = ll_get_sprite( clipd.block );
        rectfill(pspr1,clipd.x1,clipd.y1,clipd.x2,clipd.y2,bitmap_mask_color(pspr1));
    }
    /***************/
    CLOOP2
    /*******************************/
    refresh_screen_quick2();
}



void b_play(char a, int index)
{
    int mb = mouse_b;


    if(mb&2) dlg_request_animate_types();

    /*******************************/
    if(mb&1)
    md2_animate( g.animate_type ); /* 0=forward play, 1=reverse play, 2=ping-pong */
    /*******************************/
}
void b_fillpat(char a, int index)
{
    /*******************************/
    fillstruct.fi_group = dlg_fillselect( fillstruct.fi_group );   /* defined in fill.h */
    /*******************************/
}











// font selector
void b_textfont(char a, int index)    // for each popup of the font selector
{

    dlg_select_font();
    if( text.block == g.block_current && g.draw_method == MTD_PUTTEXT ){
        write_into_text();
        display_zoomed_md();
    }

}



void b_import(char a, int index)
{
    /*******************************/
    dlg_importexportbmp();    /****   ****    ****    ****    ****/
    refresh_screen2();
    /*******************************/
}
void b_save(char a, int index)
{
    /*******************************/
    dlg_saveall();
    refresh_screen2();
    /*******************************/
}


// ------------------------------------------------------------

/*
 * Called after any button function
 */
void b_clickade(char a, int index)
{
    rept_flag=0;
    rept_iteration=0;
}

/*
 * Called before any button function
 *
 */
int b_clickare(char a, int index)
{
    char btn=a;
    char ok[24]={0,1,1,     //permission map 3x8 buttons
                 0,0,0,
                 1,1,1,
                 1,0,1,
                 1,1,1,
                 0,0,1,
                 0,0,0,
                 0,0,0};

    if(index>24) index=24;
    if( ok[index]==1){      // only valid for some buttons
    if( (btn & 2) != 0 ){    // left mouse button pressed
    rept_flag=1;
    rept_iteration = dlg_request_short("Repeat how many times", 1, 2, 32000);
    if( rept_iteration<=0 ) { rept_flag=0; rept_iteration=0; return -1; }
    }
    }   // only vali...
    return 0;   // ok
}



