/*
   ____  __  __  _
  | ___| \ \/ / | \
  | |_    \ \/  |  \
  | __|   /\ \  | _ \   spaghetti programming inc.
  | |__  /_/\_\ | |\ \
  |____|        |_| \_\





 Subroutines used by main window. b_xxxxx



******** NAMES:                *******
   PL - palette bar
   MD - main editor window
   BT - buttonbar window
   SP - sprite bar window
   IN - information window
   TB - toolbar window (plugins)
 Full size     -  sx, sy
 Element size  -  esx, esy
 Space between elements  - spx, spy

*/
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "data.h"
#include "method.h"
#include "btnsub.h"
#include "butil.h"      // msgbox_()  error_()
#include "fill.h"
#include "ll.h"
#include "fnt.h"
#include "tb.h"
#include "md2.h"
#include "subs.h"
#include "clip.h"
#include "dlg.h"
#include "zoom.h"
#include "md.h"
#include "ed.h"
#include "btn.h"
#include "dlg_prj.h"
#define min(a,b) (a<b ? a:b)
#define max(a,b) (a>b ? a:b)

/* prototypes for helper functions      */
       void sp_draw_outlines(void);
       void bt_draw_outlines(void);
       void in_display(void);
       void update_pl(char f);
       void rotate_block(BITMAP *, BITMAP *);
static void helper_update_pl(int,int,int);
static void helper_update_pl2( int z );
static void change_col_pl(int x, int y, unsigned char mb);
static unsigned char  get_col_pl(int x, int y);
static void drau(int bitmap_index, int i );
       void drau_void( int );
static void draw_knobs(void);
/* prototypes for helper functions ENDS */

/* helper variables, local      */
static int old_slidex;
static int old_slidey;
/* helper variables, local ENDS */


/* once for each time the screen needs repainting */
/* should be called each time the blocksize for sprites are changed */
void display_frames_onscreen( void )
{
    int     i=0,j=0,x=0,y=0,h=0;


    scare_mouse();


/* MAIN */
    g.clipboard = NULL;
/* MAIN */


/* SP  -   sprite bar */
    i = 4;
    sp_x=0;
    sp_y=0;
    sp_esx = g.screen_w / 9;
    sp_esy = sp_esx;
    sp_sx  = sp_esx * 9;
    sp_sy  = sp_esy;
//    sp_x = g.screen_w/2 - sp_sx/2;
    sp_mx  = sp_x + i * sp_esx;
    sp_my  = sp_y;
    main_dialog[IDX_SPRITEBAR].x = sp_x;
    main_dialog[IDX_SPRITEBAR].y = sp_y;
    main_dialog[IDX_SPRITEBAR].w = sp_sx;
    main_dialog[IDX_SPRITEBAR].h = sp_sy;

    display_sprite_bar();       // errbone...fixed!
    sp_draw_outlines(); /* spritebar */

/* SP */



/* PL - Palette object */
        /* create palette on screen */
    /* pl_esx, pl_esy  from config file */

    pl_dd = 2;
    pl_tx = pl_dd;
    pl_ty = pl_dd;
    pl_sx = pl_esx * 8 + pl_dd*2;
    pl_tsx = pl_sx - pl_dd * 2;
    pl_tsy = pl_esy;
    pl_psx = pl_tsx;
    pl_psy = pl_esy * 32;
    pl_sy = pl_tsy + pl_psy + pl_dd*4;
    pl_px = pl_dd;
    pl_py = pl_tsy + pl_dd * 3;

    pl_x = g.screen_w - pl_sx;
    pl_y = g.screen_h - pl_sy;
    /**** Fix clickable area ****/
    main_dialog[IDX_PALETT].x = pl_x;
    main_dialog[IDX_PALETT].y = pl_y;
    main_dialog[IDX_PALETT].w = pl_sx;
    main_dialog[IDX_PALETT].h = pl_sy;
    main_dialog[IDX_PALETT].fg= g.syscolor1;

    update_pl(0);
/* PL */


/* IN - information object */
        in_infostate = 0;   // begin with first info window
        in_x  = sp_x;
        in_y  = sp_y + sp_sy + 1 + 10;
        in_sx = 109;        // in_sx = 100;

    in_sy = 5 * text_height(font)  + 2;
    in_bmp = create_bitmap(in_sx+1,in_sy+1);
    if(in_bmp==NULL){ error_("can't alloc infomap"); }
    clear_bitmap( in_bmp );

    main_dialog[ IDX_INFOBLOCK ].x = in_x ;
    main_dialog[ IDX_INFOBLOCK ].y = in_y ;
    main_dialog[ IDX_INFOBLOCK ].w = in_sx;
    main_dialog[ IDX_INFOBLOCK ].h = in_sy;
    main_dialog[ IDX_INFOBLOCK ].dp2 = in_bmp;
/* IN */



/* BT - buttonarray object */
        bt_spx = 4;
        bt_spy = 4;
        bt_x = in_x;
        bt_y = in_y + in_sy + 1 + 12 ;  // testing 12, original: 10
        bt_sy = g.screen_h - bt_y - 1;
/* BT */

/* BT */

    main_dialog[IDX_BUTTONARRAY].x = bt_x;
    main_dialog[IDX_BUTTONARRAY].y = bt_y;
    bt_sx = main_dialog[IDX_BUTTONARRAY].w-1;
    j = main_dialog[IDX_BUTTONARRAY].h;

    // toggle objects
    x = bt_x + 8 ;         // adjustment in x
    y = bt_y + j + 8;      // adjustment in y
    h = main_dialog[IDX_CHECK1].h + 4;  // height

    main_dialog[IDX_CHECK1].x = x;          // "all"
    main_dialog[IDX_CHECK1].y = y + h*0;    //
    main_dialog[IDX_CHECK2].x = x;          // "fill
    main_dialog[IDX_CHECK2].y = y + h*1;    //
    main_dialog[IDX_CHECK7].x = x;          // "ani"
    main_dialog[IDX_CHECK7].y = y + h*2;    //
    main_dialog[IDX_CHECK3].x = x;          // "cad"
    main_dialog[IDX_CHECK3].y = y + h*3;

    main_dialog[IDX_CHECK6].x = x+52;       // "grd"
    main_dialog[IDX_CHECK6].y = y + h*0;    //
    main_dialog[IDX_CHECK4].x = x+52;       // "src"
    main_dialog[IDX_CHECK4].y = y + h*1;    //
    main_dialog[IDX_CHECK5].x = x+52;       // "dst"
    main_dialog[IDX_CHECK5].y = y + h*2;

    if(g.flag_fullscreen == TRUE && ( g.vga_type==0 || g.vga_type==1 ) ){
    main_dialog[IDX_CHECK6].x = x+0;       // "grd"
    main_dialog[IDX_CHECK6].y = y + h*4;   //
    main_dialog[IDX_CHECK4].x = x+0;       // "src"
    main_dialog[IDX_CHECK4].y = y + h*5;   //
    main_dialog[IDX_CHECK5].x = x+0;       // "dst"
    main_dialog[IDX_CHECK5].y = y + h*6;
    }

    main_dialog[IDX_CHECK1].fg = main_dialog[IDX_CHECK2].fg =
    main_dialog[IDX_CHECK3].fg = main_dialog[IDX_CHECK4].fg =
    main_dialog[IDX_CHECK5].fg = main_dialog[IDX_CHECK6].fg =
    main_dialog[IDX_CHECK7].fg = g.syscolor1;

    main_dialog[IDX_CHECK1].d1 = main_dialog[IDX_CHECK2].d1 =
    main_dialog[IDX_CHECK3].d1 = main_dialog[IDX_CHECK4].d1 =
    main_dialog[IDX_CHECK5].d1 = main_dialog[IDX_CHECK6].d1 =
    main_dialog[IDX_CHECK7].d1 = 0;




//allegro_message("* 1 *");

    bt_draw_outlines();
//allegro_message("* 2 *");

/* BT */


/* MD - main editor window */
    md_init();
/* MD */

/* TB - toolbar object */
    tb_init();
/* TB */

    old_slidex = old_slidey = -1;

    unscare_mouse();
}

void sp_draw_outlines(void)
{
    int i;
    acquire_screen();
    for(i=0;i<9;i++){
        rect(screen,
        sp_x + i*sp_esx,               sp_y,
        sp_x + i*sp_esx+sp_esx,        sp_y+sp_esy, g.syscolor1);
    }
    release_screen();
}
void bt_draw_outlines(void)
{
    acquire_screen();
    rect( screen, bt_x, bt_y,   bt_x + bt_sx ,  bt_y + bt_sy , g.syscolor1);
    drawing_mode( DRAW_MODE_COPY_PATTERN, g.fillmap1, 0, 0);
    rectfill( screen, bt_x+1, bt_y+1,   bt_x + bt_sx-1 ,  bt_y + bt_sy-1 , g.syscolor1);
    release_screen();
    drawing_mode( DRAW_MODE_SOLID, NULL,0,0 );
    main_dialog[IDX_CHECK1].fg = main_dialog[IDX_CHECK2].fg =
    main_dialog[IDX_CHECK3].fg = main_dialog[IDX_CHECK4].fg =
    main_dialog[IDX_CHECK5].fg = g.syscolor1;

    if( g.flag_dialog_init == TRUE )
        object_message( &main_dialog[ IDX_BUTTONARRAY ], MSG_DRAW, 0 );

}














static void drau(int bitmap_index, int i )
{
    BITMAP *map;
    unsigned char tag;

    map = ll_get_sprite( bitmap_index );    // returns NULL on end of links
    tag = ll_get_tag   ( bitmap_index );
    if( i<0 || i>8 ) return;
    acquire_screen();
    if( map!=NULL )
        stretch_blit ( map,screen,0,0,g.sx, g.sy, sp_x+i*sp_esx+1,sp_y+1,sp_esx-1,sp_esy-1 );
    if(i==4) draw_knobs();
    if( tag > 32 ){
    textprintf(screen,font, sp_x+i*sp_esx+1, sp_y+sp_sy-9, g.syscolor1, "%c", tag );
    }
    release_screen();
}



/* helper funtion, draw empty block onto screen */
void drau_void( int i )
{
    int x,y,sx,sy;

    if( i<0 || i>8 ) return;
    x = sp_x+i * sp_esx+1;
    y = sp_y+1;
    sx = sp_esx-1;
    sy = sp_esy-1;
    acquire_screen();
    drawing_mode( DRAW_MODE_COPY_PATTERN, g.fillmap1, 0, 0);
    rectfill(screen, x, y, x+sx-1, y+sy-1, g.syscolor1 );
    drawing_mode( DRAW_MODE_SOLID, NULL,0,0 );
    if(i==4) draw_knobs();
    release_screen();
}


void display_sprite_bar()
{
    int i;

//msgbox_("block_current %d", g.block_current);

    i=g.block_current+4;   if( i < g.block_count ){    drau( i,8 );
    }else{ drau_void(8); }
    i=g.block_current+3;   if( i < g.block_count ){    drau( i,7 );
    }else{ drau_void(7); }
    i=g.block_current+2;   if( i < g.block_count ){    drau( i,6 );
    }else{ drau_void(6); }
    i=g.block_current+1;   if( i < g.block_count ){    drau( i,5 );
    }else{ drau_void(5); }

    i=g.block_current;     if( i >= 0 ){   drau( i,4 );
    }else{ drau_void(4); }

    i=g.block_current-1;   if( i >= 0 ){   drau( i,3 );
    }else{ drau_void(3); }
    i=g.block_current-2;   if( i >= 0 ){   drau( i,2 );
    }else{ drau_void(2); }
    i=g.block_current-3;   if( i >= 0 ){   drau( i,1 );
    }else{ drau_void(1); }
    i=g.block_current-4;   if( i >= 0 ){   drau( i,0 );
    }else{ drau_void(0); }
//    sp_draw_outlines();
}


static void draw_knobs(void)
{
    int x1,y1,x2,y2,ex,ey;

    x1 = sp_mx+1;
    y1 = sp_my+1;
    x2 = sp_mx+sp_esx-1;
    y2 = sp_my+sp_esy-1;
    ex = sp_esx/10;
    ey = sp_esy/10;

    hline( screen, x1, y1, x1+ex, g.syscolor1);
    hline( screen, x1, y2, x1+ex, g.syscolor1);
    hline( screen, x2, y1, x2-ex, g.syscolor1);
    hline( screen, x2, y2, x2-ex, g.syscolor1);

    line( screen,  x1,y1+ex, x1+ex,y1, g.syscolor1);
    line( screen,  x2-ex,y1, x2,y1+ex, g.syscolor1);
    line( screen,  x2-ex,y2, x2,y2-ex, g.syscolor1);
    line( screen,  x1,y2-ex, x1+ex,y2, g.syscolor1);

    vline( screen, x1, y1, y1+ey, g.syscolor1);
    vline( screen, x2, y1, y1+ey, g.syscolor1);
    vline( screen, x1, y2, y2-ey, g.syscolor1);
    vline( screen, x2, y2, y2-ey, g.syscolor1);
}




int b_sp(int msg, DIALOG *d, int c)    //  main_dialog[IDX_SPRITEBAR]
{
    int     mx, my, mb;
    int     distance=0,i,j,k;
    int     x1,y1,x2,y2;

    if(msg==MSG_IDLE) return D_O_K;

    switch (msg){
    case MSG_CHAR:
    return D_USED_CHAR;

    case MSG_KEY:
    return D_O_K;
    break;

    case MSG_START:
    break;

    case MSG_END:
//        if( d->dp2!=NULL ) destroy_bitmap( d->dp2 ); d->dp2=NULL;
    break;

    case MSG_DRAW:
        sp_draw_outlines();
        display_sprite_bar();
        draw_knobs();
    break;

    case MSG_CLICK:
        mx = mouse_x;
        my = mouse_y;
        mb = mouse_b;
        x1 = d->x + 1;
        y1 = d->y + 1;
        x2 = x1 + sp_sx - 2;
        y2 = y1 + sp_sy - 2;
//    scare_mouse();
//    rect(screen, x1,y1, x2, y2, g.syscolor2 );
//    textprintf(screen, font,10,10,g.syscolor3,"%d %d %d %d", x1, y1, x2, y2 );
//    textprintf(screen, font,10,22,g.syscolor3,"%d %d %d %d", sp_esx, sp_esy, sp_sx, sp_sy );
//    unscare_mouse();

    for(i=0;i<9;i++){
    x1 = sp_x + i * sp_esx + 2;
    x2 = sp_x + i * sp_esx + sp_esx - 2;
    y1 = sp_y + 2;
    y2 = sp_y + sp_esy - 2;


    if( mx > x1 && mx < x2 && (mb&1) == 1 ){
//        scare_mouse();
//        rectfill(screen, x1,y1, x2, y2, g.syscolor1 );
//        rectfill(screen, 10,22,66,33, g.syscolor2 );
//        unscare_mouse();
        j = g.block_current + i - 4;

            if( j >= 0 && j < g.block_count ){ // clicked on valid image frame?
            // valid
            distance = i-4;
            if(distance<0){
                 distance = -distance;
            for(k=0;k<distance;k++){ b_prev(0,0); } // go to previous
            }else{
            for(k=0;k<distance;k++){ b_next(0,0); } // go to next
            }
//            text_mode(0);
//            textprintf(screen, font,10,22,g.syscolor3,"****" );
//            textprintf(screen, font,10,42,g.syscolor3,"distance=%d   ", distance );


            }else{
            // invalid
//            textprintf(screen, font,10,22,g.syscolor3,"----" );
            }
            if( j == g.block_current ){
//                textprintf(screen, font,10,22,g.syscolor3,"++++" ); // self
            }

        }
    }
    break;

    case MSG_DCLICK:
    break;
    }

    return D_O_K;
}








/* *************************************************************************** */




/* char * itoa(int value, char *buffer, int radix); */

int b_slidex(void *dp3, int d2)
{
    g.ox = d2;
    if( old_slidex != g.ox){
        scare_mouse();
        display_zoomed_md();
        unscare_mouse();
        old_slidex = g.ox;
    }
    if( in_infostate==3 ) in_display();   // only call if relevant
    return D_O_K;
}
int b_slidey(void *dp3, int d2)
{
    g.oy = main_dialog[IDX_SLIDEY].d1 - d2;
    if( old_slidey != g.oy){
        scare_mouse();
        display_zoomed_md();
        unscare_mouse();
        old_slidey = g.oy;
    }
    if( in_infostate==3 ) in_display();   // only call if relevant
    return D_O_K;
}


void refresh_screen()
{
    scare_mouse();
//    acquire_screen();
    display_sprite_bar();
    drau( g.block_current, 4 );
    display_zoomed_md();
//    release_screen();
    unscare_mouse();
}
void refresh_screen_quick()     // update only one current sprite if quick
{
    scare_mouse();
    if(g.flag_all==TRUE  ) display_sprite_bar();
    if(g.flag_all==FALSE ) drau( g.block_current,4 );
    display_zoomed_md();
    unscare_mouse();
}







/*******************/
/*******************/
/*******************/





void    update_pl( char f )       /* display blocks on palette window */
{
        int z;

//   if(g.bpp > 8 ) return;
        f = f & 1;
        z = 0;
        if( f==1 ) z = g.syscolor1;
        if( f==0 ) z = 0;

    if( g.flag_palette_range == FALSE){
        helper_update_pl( g.usercolor1, z, 0 );
        helper_update_pl( g.usercolor2, z, 1 );
        helper_update_pl( g.usercolor3, z, 2 );
        if( in_infostate==1 ) in_display();   // only call if relevant
    }
    if( g.flag_palette_range == TRUE){  // display ranges
        helper_update_pl2(  z );
    }

        return;
}
static void helper_update_pl( int _mbt, int z, int xx )
{
    int     i,x,y, rest_, mbt=_mbt;
    char    snum[12];

    if( g.bpp == 8 ){
    x = y = mbt;        // convert color into x/y coordinates
    x &= 7;
    y &= ~7;
    y = y>>3;
    rect( screen,           // draw outlined box
    pl_x + pl_px + x * pl_esx-1,
    pl_y + pl_py + y * pl_esy-1,
    pl_x + pl_px + x * pl_esx + pl_esx-1,
    pl_y + pl_py + y * pl_esy + pl_esy-1,
    z   );
    }

    rest_ = pl_tsx / 3;


    if(g.bpp==8){
    rectfill(screen,        // draw selected color box
    pl_x + pl_dd + rest_ * xx,
    pl_y + pl_dd,
    pl_x + pl_dd + rest_ * xx + rest_,
    pl_y + pl_dd + pl_tsy,
    mbt );
    i = text_mode(-1);
    sprintf( (char *)&snum, "%d", mbt );
    textout_centre( screen, font, (char *)&snum,
        pl_x + pl_dd + pl_tsx/6 + rest_ * xx,
        pl_y + pl_dd + 3,
        0);
    text_mode(i);

    }else{

        i = text_mode(-1);
        if(xx==0) sprintf( (char *)&snum, "M" );
        if(xx==1) sprintf( (char *)&snum, "S1" );
        if(xx==2) sprintf( (char *)&snum, "S2" );
        textout_centre( screen, font, (char *)&snum,
            pl_x + pl_dd + pl_tsx/6 + rest_ * xx,
            pl_y + pl_dd + 3,
            g.syscolor1);
        text_mode(i);

    }

}




static void helper_update_pl2( int z )
{
    int     i,j,k,x,y;

    if(g.bpp > 8 ) return;
    j = g.paletterange_start;
    k = g.paletterange_end; 
    if( g.paletterange_end < g.paletterange_start ){ // flip values
    k = g.paletterange_start;
    j = g.paletterange_end;
    }

    for( i = j ; i< k+1 ; i++ ){
    x = y = i;              // convert color into x/y coordinates
    x &= 7;
    y &= ~7;
    y = y>>3;
    rect( screen,           // draw outlined box
    pl_x + pl_px + x * pl_esx-1,
    pl_y + pl_py + y * pl_esy-1,
    pl_x + pl_px + x * pl_esx + pl_esx-1,
    pl_y + pl_py + y * pl_esy + pl_esy-1,
    z   );
    }
}




static void change_col_pl( int x, int y, unsigned char mb )
{
    int  t=0, m=0;

    if(g.bpp > 8 ) return;

    t = x/(pl_esx) + (y/(pl_esy))*8; // convert coordinates X/Y to color index

    if( g.flag_palette_range == FALSE ){
        m = mb;if((m&1)==1) g.usercolor1 = t;
        m = mb;if((m&4)==4) g.usercolor2 = t;
        m = mb;if((m&2)==2) g.usercolor3 = t;

    if( text.block == g.block_current && g.draw_method == MTD_PUTTEXT ){
        write_into_text();
        display_zoomed_md();
    }

    }else{  // palette range is activated
        g.paletterange_start = t;
        g.paletterange_end   = t+1;
    }


    /* make previsions for brush */
    m = mb;
    if( g.flag_brush==TRUE && g.brush.type==2 &&\
        g.brush.bmp != NULL && (m&7)!=0 ){
        remap_bitmap_to_color( g.brush.bmp, t );
        }

}
static unsigned char get_col_pl(int x, int y)
{
    return( ((x/(pl_esx) + (y/(pl_esy))*8) & 255) );
}

void create_colors_on_bitmap( BITMAP *map, float _saturation )
{
    int     x1,y1,x,y,_r,_g,_b;
    double  fractiony,fractionx,hue,saturation,value;

        if(map==NULL) return;
        clear_bitmap(map);
        x1 = pl_px;
        y1 = pl_py;

        if(g.bpp > 8 ){
        fractiony = 360.0 / (double) pl_psy;
        fractionx = 1.0 / (double) pl_psx;
        hue = 0.0;
        saturation = _saturation;
        value = 0.0;
        for(y = 0; y<pl_psy;y++){   /* base blocks, draw only once */
        value = 0.0;
        hue   += fractiony;
        for(x = 0; x<pl_psx;x++) {
        hsv_to_rgb( hue, saturation, value, (int *)&_r, (int *)&_g, (int *)&_b);
        value += fractionx;
        putpixel( map, x1+x,y1+y,  makecol( _r,_g,_b ) );
        }}
        }
        if(g.bpp<=8){
        for(y = 0; y<32;y++){   /* base blocks, draw only once */
        for(x = 0; x<8;x++) {
        rectfill( map,
                x1+x*pl_esx,
                y1+y*pl_esy,
                x1+x*pl_esx+pl_esx-2,
                y1+y*pl_esy+pl_esy-2,
                x+y*8
                );
        }}
        }
}




/* uses d->dp2 for internal use, must be NULL on initialization (firstinint) */
// palette control thingy
int b_pl( int msg, DIALOG *d, int c)
{
    BITMAP  *dip;
    int     mx, my;
    int     x, y, i,j,dx,dy,ox=0,oy=0;
    int     x1,y1,x2,y2;
    int     x3,x4;
    int     mb,m;


    if(msg==MSG_IDLE) return D_O_K;

    dip = (BITMAP *) d->dp2;

    switch (msg){
    case MSG_CHAR:
    return D_USED_CHAR;
    break;

    case MSG_KEY:
    if(key[KEY_Z]){
        broadcast_dialog_message(MSG_DRAW, 0);
        acquire_screen();
        save_bitmap("out.pcx", screen, g.palette );
        release_screen();
    do{} while( key[KEY_Z] );
//    do{} while( !key[KEY_Z] );
        allegro_message("Saving screen capture in 'out.pcx'");
    }
    return D_O_K;
    break;

    case MSG_START:
    if( d->dp2 != NULL ){ destroy_bitmap( d->dp2 );  d->dp2=NULL; }
    d->dp2 = (BITMAP *) create_bitmap(pl_sx, pl_sy);
    dip = (BITMAP *) d->dp2;
    create_colors_on_bitmap( dip,  0.75  );
    break;


    case MSG_END:
        if( d->dp2!=NULL ) destroy_bitmap( d->dp2 ); d->dp2=NULL;
    break;
    case MSG_DRAW:
        y = pl_tsy + pl_dd*2;
        rect(dip, 0, 0, d->w-1, d->h-1, g.syscolor1 );  /* outline */
        rect(dip, 0, y, d->w-1, y,      g.syscolor1 );  /* midline between clickareas */
        acquire_screen();
        blit( dip, screen, 0, 0, d->x, d->y, pl_sx, pl_sy );
        release_screen();
        update_pl(1);


/*
void hsv_to_rgb(float h, float s, float v, int *r, int *g, int *b);

void rgb_to_hsv(int r, int g, int b, float *h, float *s, float *v);
   Convert color values between the HSV and RGB colorspaces. The RGB values 
   range from 0 to 255, hue is from 0 to 360, and saturation and value are 
   from 0 to 1.
*/








    break;

    case MSG_CLICK:
        mx = mouse_x;
        my = mouse_y;
        x1 = d->x + pl_px;          /* enter second clickarea */
        y1 = d->y + pl_py;
        x2 = x1 + pl_psx;
        y2 = y1 + pl_psy;


        if( mx > x1 && mx < x2 && my > y1 && my < y2){


        if( g.flag_palette_range == FALSE ){
            x = mx - x1;
            y = my - y1;
            if(x<0||y<0) break;
            if(x>pl_psx||y>pl_psy) break;

            scare_mouse();                  /* inside second clickarea */
            update_pl(0);
            change_col_pl( x, y, mouse_b );


// ---------------------------....................
    if(g.bpp>8){
        mb = mouse_b;
        m = mb;if((m&1)==1) g.usercolor1 = getpixel(screen,pl_x+x,pl_y+pl_tsy+y);
        m = mb;if((m&4)==4) g.usercolor2 = getpixel(screen,pl_x+x,pl_y+pl_tsy+y);
        m = mb;if((m&2)==2) g.usercolor3 = getpixel(screen,pl_x+x,pl_y+pl_tsy+y);
    }
// ---------------------------....................


            update_pl(1);
            unscare_mouse();



        }else{        // keep continued tracking

            update_pl(0);   // delete previous
            mx = mouse_x;
            my = mouse_y;
            x = mx - x1;
            y = my - y1;
        g.paletterange_start = get_col_pl( x, y );
        j = 0;
        do{
            mx = mouse_x;
            my = mouse_y;
            dx = mx - ox;
            dy = my - oy;
        if( dx != 0 || dy != 0){
            x = mx - x1;
            y = my - y1;
            if(x<0||y<0) break;
            if(x>pl_psx||y>pl_psy) break;
            scare_mouse();                  /* inside second clickarea */
            update_pl(0);
            g.paletterange_end = get_col_pl( x, y );
            update_pl(1);
            unscare_mouse();
        }
        ox = mx;
        oy = my;
        i = mouse_b;
        }while(i&7);
        if( g.paletterange_end < g.paletterange_start ){ // flip values
            i = g.paletterange_start;
            g.paletterange_start = g.paletterange_end;
            g.paletterange_end  = i;
        }
        }

        }else{


        scare_mouse();

//    msgbox_("*");

        x1 = d->x + pl_tx;          /* enter second clickarea */
        y1 = d->y + pl_ty;
        x2 = x1 + pl_tsx/3 -1;
        y2 = y1 + pl_tsy;
        x3 = x1 + pl_tsx/3 + pl_tsx/3 -1;
        x4 = x1 + pl_tsx -1;


     if( my > y1 && my < y2 && g.bpp > 8 ){
        if( mx > x1 && mx < x2 && g.bpp > 8 ){           // Click Area1
// ---------------------------....................
            if(g.bpp>8){
            mb = mouse_b;
            m = mb;if((m&1)==1) g.usercolor1 = bitmap_mask_color( screen );
            m = mb;if((m&4)==4) g.usercolor2 = bitmap_mask_color( screen );
            m = mb;if((m&2)==2) g.usercolor3 = bitmap_mask_color( screen );
            }
// ---------------------------....................
        }
        if( mx > x2 && mx < x3 && g.bpp > 8  ){           // Click Area2
            dip = (BITMAP *) d->dp2;
            create_colors_on_bitmap( dip,  0.5  );
            y = pl_tsy + pl_dd*2;
            rect(dip, 0, 0, d->w-1, d->h-1, g.syscolor1 );  /* outline */
            rect(dip, 0, y, d->w-1, y,      g.syscolor1 );  /* midline between clickareas */
            acquire_screen();
            blit( dip, screen, 0, 0, d->x, d->y, pl_sx, pl_sy );
            release_screen();
            update_pl(1);
        }
        if( mx > x3 && mx < x4 && g.bpp > 8  ){           // Click Area3
            dip = (BITMAP *) d->dp2;
            create_colors_on_bitmap( dip,  0.75  );
            y = pl_tsy + pl_dd*2;
            rect(dip, 0, 0, d->w-1, d->h-1, g.syscolor1 );  /* outline */
            rect(dip, 0, y, d->w-1, y,      g.syscolor1 );  /* midline between clickareas */
            acquire_screen();
            blit( dip, screen, 0, 0, d->x, d->y, pl_sx, pl_sy );
            release_screen();
            update_pl(1);
        }
     }

        if( my > y1 && my < y2 && g.bpp == 8 ){
        if( mx > x1 && mx < x2 && g.bpp == 8 ){           // Click Area1

            scare_mouse();
            acquire_screen();

            update_pl(0);
            g.flag_palette_range = TRUE;    //
            //...
            rectfill( screen, x1,y1,x2,y2, 0 );
            rect( screen, x1,y1,x2,y2, g.syscolor1 );
            rect( screen, x1+1,y1+1,x2-1,y2-1, g.syscolor1 );
            rect( screen, x1+2,y1+2,x2-2,y2-2, g.syscolor1 );
            line( screen, x1,y1,x2,y2, g.syscolor1 );
            line( screen, x1,y2,x2,y1, g.syscolor1 );
            //...
                rectfill( screen, x2,y1,x3,y2, 0 );
                rect( screen, x2,y1,x3,y2, g.syscolor1 );
                rect( screen, x2+1,y1+1,x3-1,y2-1, g.syscolor1 );
                rect( screen, x2+2,y1+2,x3-2,y2-2, g.syscolor1 );
                line( screen, x2,y1,x3,y2, g.syscolor1 );
                line( screen, x2,y2,x3,y1, g.syscolor1 );
            //...
            rectfill( screen, x3,y1,x4,y2, 0 );
            rect( screen, x3,y1,x4,y2, g.syscolor1 );
            rect( screen, x3+1,y1+1,x4-1,y2-1, g.syscolor1 );
            rect( screen, x3+2,y1+2,x4-2,y2-2, g.syscolor1 );
            line( screen, x3,y1,x4,y2, g.syscolor1 );
            line( screen, x3,y2,x4,y1, g.syscolor1 );
            //...
            release_screen();
            unscare_mouse();
        }
        if( mx > x2 && mx < x3 && g.bpp == 8  ){           // Click Area2
            if( g.flag_palette_range == TRUE){
                dlg_select_palette_range();
            }
        }
        if( mx > x3 && mx < x4 && g.bpp == 8  ){           // Click Area3
            g.flag_palette_range = FALSE;
            dip = (BITMAP *) d->dp2;
            scare_mouse();
            acquire_screen();
            blit( dip, screen, 0, 0, d->x, d->y, pl_sx, pl_sy );
            release_screen();
            unscare_mouse();
            update_pl(1);
        }
        }else{  // standard click area

        }
    unscare_mouse();


    }
    break;

    case MSG_DCLICK:
        mx = mouse_x;
        my = mouse_y;
        mb = mouse_b;
        x1 = d->x + pl_px;          /* enter second clickarea */
        y1 = d->y + pl_py;
        x2 = x1 + pl_psx;
        y2 = x2 + pl_psy;
        x = mx - x1;
        y = my - y1;

        if( g.bpp > 8 ){
        mb = mouse_b;
        if(x<0||y<0) break;
        m = mb;if((m&1)==1) g.usercolor1 = dlg_select_rgb_bpp24(  getpixel(screen,pl_x+x,pl_y+pl_tsy+y) );
        m = mb;if((m&4)==4) g.usercolor2 = dlg_select_rgb_bpp24(  getpixel(screen,pl_x+x,pl_y+pl_tsy+y) );
        m = mb;if((m&2)==2) g.usercolor3 = dlg_select_rgb_bpp24(  getpixel(screen,pl_x+x,pl_y+pl_tsy+y) );
        break;
        }

        x1 = d->x + pl_px;          /* enter second clickarea */
        y1 = d->y + pl_py;
        x2 = x1 + pl_psx;
        y2 = x2 + pl_psy;
        x = mx - x1;
        y = my - y1;

        if( mx > x1 && mx < x2){
        if( my > y1 && my < y2 && g.bpp == 8 ){
        if(x<0||y<0) break;
        if(x>pl_psx||y>pl_psy) break;
        dlg_select_rgb_bpp8(  get_col_pl(x, y)  );
        }}
    break;
    }
    return D_O_K;
}


















void rotate_block( BITMAP *in, BITMAP *out )
{
    int x,y;
    for( y=0; y < in->h ; y++) {
    for( x=0; x < in->w ; x++) {
    putpixel(out,(in->h-y)-1,x,getpixel(in,x,y));
    }}
}




/* should be called after the main dialog has been closed */
void undisplay_frames_onscreen(void)
{
    if( g.flag_dialog_init == FALSE ){
    if(g.clipboard!=NULL) destroy_bitmap( g.clipboard );
    md_deinit();
    clear_bitmap( screen );
    }
}


/* clickable grid on/off checkbox */
int bu_grid(int msg, DIALOG *d, int c)
{
    if(msg==MSG_CLICK){
    msg = ed_check(msg,d,c);
    scare_mouse();
    display_zoomed_md();
    unscare_mouse();
    return msg;
    }
    return ed_check(msg,d,c);
}




int b_infoblock( int msg, DIALOG *d, int c)
{
    FNT *fntx;
    int l1,l2,l3,l4,tx1,c1=0,c2=0,c3=0,u=0;
    int x,y,sx,sy, x1;
    char in_s1[128];
    char in_s2[128];
    char in_s3[128];
    char in_s4[128], rectgl, a,b;
    x  = d->x;
    y  = d->y;
    sx = d->w;
    sy = d->h;


    switch(msg) {   //
    // ----------------------------------------------------------------
    case MSG_DRAW:
    x1 = 4;         // x adjustment
    l1 = 8*0+4;     // line1 adjustment
    l2 = 8*1+4+1;   // line2 adjustment
    l3 = 8*2+4+2;   // line3 adjustment
    l4 = 8*3+4+3;   // line4 adjustment
    tx1= g.syscolor1;  // text color
    // ----------------------------------
    text_mode(0);
    clear_bitmap( in_bmp );
    in_s1[0]=in_s2[0]=in_s3[0]=in_s4[0]=rectgl=0;
    // ----------------------------------
    // infoscreen 0
    if( in_infostate==0 ){
    sprintf( (char *)&in_s1, "%s",         g.graphic_name  );
    sprintf( (char *)&in_s2, " %dx%d",     g.sx, g.sy);
    sprintf( (char *)&in_s3, "  %d/%d",    g.block_current, g.block_count );
    sprintf( (char *)&in_s4, "zoom [%2d]", g.zoom);
    }
    // ----------------------------------

    // ----------------------------------
    // infoscreen 1
    if( in_infostate==1 ){
    c1 = g.usercolor1;
    c2 = g.usercolor2;
    c3 = g.usercolor3;
    sprintf( (char *)&in_s1, "user color");
    sprintf( (char *)&in_s2, "color1  %d",   c1 );
    sprintf( (char *)&in_s3, "color2  %d",   c2 );
    sprintf( (char *)&in_s4, "color3  %d",   c3 );
    rectgl = 1;
    }
    // ----------------------------------

    // ----------------------------------
    // infoscreen 2
    if( in_infostate==2 ){
    c1 = g.syscolor1;
    c2 = g.syscolor2;
    c3 = g.syscolor3;
    sprintf( (char *)&in_s1, "system color");
    sprintf( (char *)&in_s2, "color1  %d",    c1 );
    sprintf( (char *)&in_s3, "color2  %d",    c2 );
    sprintf( (char *)&in_s4, "color3  %d",    c3 );
    rectgl = 1;
    }
    // ----------------------------------

    // ----------------------------------
    // infoscreen 3
    if( in_infostate==3 ){
    sprintf( (char *)&in_s1, "scrollbars" );
    sprintf( (char *)&in_s2, " ");
    sprintf( (char *)&in_s3, "x: %d", g.ox );
    sprintf( (char *)&in_s4, "y: %d", g.oy );
    }
    // ----------------------------------


    // ----------------------"-------------"
    // infoscreen 4
    if( in_infostate==4 ){
    sprintf( (char *)&in_s1, "Project name:");
    sprintf( (char *)&in_s2, "%s",g.project_name);
    sprintf( (char *)&in_s3, "screen size:");
//    sprintf( (char *)&in_s4, " [%dx%d]",1600,1200);
    sprintf( (char *)&in_s4, " [%dx%d]",g.screen_w,g.screen_h);
    }
    // ----------------------------------


    // ----------------------------------
    // infoscreen 5
    if( in_infostate==5 ){
    sprintf( (char *)&in_s1, "EXA V%s", VERSIONNUMBER_STR );
    sprintf( (char *)&in_s2, "compiled");
    sprintf( (char *)&in_s3, "   date:");
    sprintf( (char *)&in_s4, "%s", __DATE__ );
    }
    // ----------------------------------


    // ----------------------------------
    // infoscreen 6
    if( in_infostate==6 ){
    sprintf( (char *)&in_s1, "             " );
    sprintf( (char *)&in_s2, "    O o      ");
    sprintf( (char *)&in_s3, "     -       ");
    sprintf( (char *)&in_s4, "             ");
    }
    // ----------------------------------

//how many infoscreens we have
#define MAXINFOSCREENS 5


    // ----------------------------------
    // limit text size to a maximum
    in_s1[70] = in_s2[70] = in_s3[70] = in_s4[70] = 0;
    // ----------------------------------

    // ----------------------------------
    if(g.vga_type==0)
        fntx = fnt1;
    else
        fntx = fnt4;
    fnt_textout( in_bmp, fntx, (char *)&in_s1, x1,l1, tx1, 0, 0 );
    fnt_textout( in_bmp, fntx, (char *)&in_s2, x1,l2, tx1, 0, 0 );
    fnt_textout( in_bmp, fntx, (char *)&in_s3, x1,l3, tx1, 0, 0 );
    fnt_textout( in_bmp, fntx, (char *)&in_s4, x1,l4, tx1, 0, 0 );

    // ----------------------------------
    if(rectgl==1){
    if(g.screen_w==360)
        u=x1+47;
    else
        u=x1+55;
    rectfill( in_bmp, u,l2+1, u+5, l2+5+1, c1);
    rectfill( in_bmp, u,l3+1, u+5, l3+5+1, c2);
    rectfill( in_bmp, u,l4+1, u+5, l4+5+1, c3);
    rect    ( in_bmp, u,l2+1, u+5, l2+5+1, tx1);
    rect    ( in_bmp, u,l3+1, u+5, l3+5+1, tx1);
    rect    ( in_bmp, u,l4+1, u+5, l4+5+1, tx1);
    }
    // ----------------------------------
    rect(  in_bmp, 0, 0, sx-1, sy-1, g.syscolor1 );
    vline( in_bmp, 1, 0, sy-1,       g.syscolor1 );
    vline( in_bmp, sx-2, 0, sy-1,    g.syscolor1 );
    acquire_screen();
    blit( in_bmp , screen ,0,0,in_x,in_y,in_sx,in_sy);  // on screen
    release_screen();
    msg = D_O_K;
    break;



    case MSG_CLICK:
    a=b= mouse_b;
    if( (a&1) ){
        in_infostate++;
        if(in_infostate>MAXINFOSCREENS) in_infostate=0;
    }
    if( (b&2) ){
//        in_infostate--;
//        if(in_infostate<0) in_infostate=MAXINFOSCREENS;

    dlg_select_project( mouse_x, mouse_y );


    }


    scare_mouse();
    b_infoblock( MSG_DRAW, d, c);   // self: redraw
    unscare_mouse();
    msg = D_O_K;
    break;


    default:
    msg = D_O_K;
    break;
    // ----------------------------------------------------------------
    }   // end switch

    return msg;
}

/* update display of information window */
void in_display(void)
{
    scare_mouse();
    b_infoblock( MSG_DRAW, (DIALOG *)&main_dialog[IDX_INFOBLOCK] , 0);   // self: redraw
    unscare_mouse();
}


//
// the REDRAW_xxxxxxxxx  FAMILY
// ---------------------------------------- ************* ---------------
void redraw_slider(void)
{
    main_dialog[IDX_SLIDEX].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_SLIDEX],0);
    main_dialog[IDX_SLIDEY].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_SLIDEY],0);
}
void redraw_pl(void)
{
    main_dialog[IDX_PALETT].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_PALETT],0);
}
void redraw_md(void)
{
    main_dialog[IDX_MAINMD].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_MAINMD],0);
}
void redraw_infoblock(void)
{
    main_dialog[IDX_INFOBLOCK].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_INFOBLOCK],0);
}
void redraw_buttonarray(void)
{
    main_dialog[IDX_BUTTONARRAY].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_BUTTONARRAY],0);
}
void redraw_checkbox(void)
{
    scare_mouse();
    main_dialog[IDX_SCLICK].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_SCLICK],0);
    main_dialog[IDX_CHECK1].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK1],0);
    main_dialog[IDX_CHECK2].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK2],0);
    main_dialog[IDX_CHECK3].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK3],0);
    main_dialog[IDX_CHECK4].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK4],0);
    main_dialog[IDX_CHECK5].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK5],0);
    main_dialog[IDX_CHECK6].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK6],0);
    main_dialog[IDX_CHECK7].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_CHECK7],0);
    unscare_mouse();
}
void redraw_exchange(void)
{
    scare_mouse();
    main_dialog[IDX_EXCHNG].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_EXCHNG],0);
    unscare_mouse();
}
void redraw_toolbar(void)
{
    scare_mouse();
    main_dialog[IDX_TOOLBR].proc(MSG_DRAW,(DIALOG *)&main_dialog[IDX_TOOLBR],0);
    unscare_mouse();
}
// ---------------------------------------- ************* ---------------












int b_edcheck(int msg, DIALOG *d, int c)
{
    int retval;

    if(msg==MSG_IDLE) return D_O_K;

    switch (msg){
    case MSG_CLICK:
    retval = ed_check(msg,d,c);
    display_zoomed_md();
    return retval;
    break;

    default:
    break;
    }
    return ed_check(msg,d,c);
}


int b_edcheck2(int msg, DIALOG *d, int c)
{
    int retval, mb;

    if(msg==MSG_IDLE) return D_O_K;

    switch (msg){
    case MSG_CLICK:
    //  check mouse button pressed
    mb = mouse_b;
    if(mb&1){   // left mousebutton
        retval = ed_check(msg,d,c);
        display_zoomed_md();
        return retval;
    }
    if(mb&2){   // right mouse button
        // popup a dialog, to change the gridsizes
        dlg_request_gridsxsy();
        display_zoomed_md();
        return D_O_K;
    }
    return D_O_K;
//    retval = ed_check(msg,d,c);
//    display_zoomed_md();
//    return retval;
    break;

    default:
    break;
    }
    return ed_check(msg,d,c);
}


// for animate flag activation
int b_edcheck3(int msg, DIALOG *d, int c)
{
    int retval, mb, *btnvalue, value;

    if(msg==MSG_IDLE) return D_O_K;



    switch (msg){

    case MSG_START:
    get_palette( g.animate_tmp );
    if( g.flag_animate == TRUE ){
    animate_make_32bkgrs();
    }
    break;

    case MSG_CLICK:
    //  check mouse button pressed
    mb = mouse_b;
    if(mb&1){   // left mousebutton
        retval = ed_check(msg,d,c);
        btnvalue = d->dp2;
        value = *btnvalue;
        if( value== TRUE ){
            animate_make_32bkgrs();
        }else{
            animate_restore_32bkgrs();
        }
        display_zoomed_md();
        return retval;
    }
    if(mb&2){   // right mouse button
    // todo: popup a dialog asking for fade to black or fade to white...?
        display_zoomed_md();
    return D_O_K;
    }
    return D_O_K;
    break;

    default:
    break;
    }
    return ed_check(msg,d,c);
}





void copy_pal( RGB *pal_src, RGB *pal_dst, int positions )
{
    int     i;

    for(i=0;i<32;i++){
    pal_dst[ i + (32 * positions) ].r = pal_src[i].r;
    pal_dst[ i + (32 * positions) ].g = pal_src[i].g;
    pal_dst[ i + (32 * positions) ].b = pal_src[i].b;
    }
}


/*
void fade_interpolate(const PALETTE source, const PALETTE dest,
                      PALETTE output, int pos, int from, to);
   Calculates a temporary palette part way between source and dest, 
   returning it in the output parameter. The position between the two 
   extremes is specified by the pos value: 0 returns an exact copy of 
   source, 64 returns dest, 32 returns a palette half way between the two, 
   etc. This routine only affects colors between from and to (inclusive: 
   pass 0 and 255 to interpolate the entire palette).

*/

void animate_make_32bkgrs()
{
    PALETTE     white_palette, pal_tmp;
    int i;

    for(i=0;i<256;i++){
    pal_tmp[i].r=g.animate[i].r = g.animate_tmp[i].r = g.palette[i].r;
    pal_tmp[i].g=g.animate[i].g = g.animate_tmp[i].g = g.palette[i].g;
    pal_tmp[i].b=g.animate[i].b = g.animate_tmp[i].b = g.palette[i].b;
    }
    // --------------------------------------------------
    // -    Fade to White                               -
    for(i=0;i<255;i++){ white_palette[i].r = white_palette[i].g = white_palette[i].b = 63; }
    // --------------------------------------------------

    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 18, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 1 );
    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 28, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 2 );
    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 38, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 3 );
    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 44, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 4 );
    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 53, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 5 );

    fade_interpolate( (RGB *)&g.palette, (RGB *)&white_palette, (RGB *)&pal_tmp, 56, 1,32);
    copy_pal( (RGB *)&pal_tmp, (RGB *)&g.animate, 6 );


    for(i=0;i<6*32;i++){
    g.palette[i].r = g.animate[i].r;
    g.palette[i].g = g.animate[i].g;
    g.palette[i].b = g.animate[i].b;
    }
    get_palette( g.animate_tmp );
    set_palette_range(g.palette, 0, 6*32, 0 );

}

void animate_restore_32bkgrs()
{
    int i;
    for(i=0;i<256;i++){
    g.palette[i].r = g.animate_tmp[i].r;
    g.palette[i].g = g.animate_tmp[i].g;
    g.palette[i].b = g.animate_tmp[i].b;
    }
    set_palette( (RGB *)&g.palette );
}

