#include <allegro.h>
#include "main.h"

int frames;
int fps;
BITMAP *page;

static volatile int ticks = 0;
static void ticker()
{
	ticks++;
}

extern void run_init();
extern void run_frame();
extern void run_render();
extern void run_end();

int main(int anr, char *arg[])
{
	BITMAP *vpage[3];
	int pagenum = 0;
	int vpages = 2;
	int gframes;
	int framecounttime, framecounter;

	allegro_init();
	set_color_depth(8);
	if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) < 0) {
		allegro_message("Cannot set graphics mode.\n");
		exit(-1);
	}

	install_keyboard();
	install_mouse();

	install_timer();

	install_int_ex(ticker, BPS_TO_TIMER(FPS));

	reserve_voices(8, 0);
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	if (vpages == 0) {
		page = create_bitmap(SCREEN_W, SCREEN_H);
	}
	if (vpages == 1) {
		page = screen;
	}
	if (vpages == 2) {
		vpage[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
		vpage[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
		pagenum = 1;
		page = vpage[pagenum];
	}
	if (vpages == 3) {
		vpage[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
		vpage[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
		vpage[2] = create_video_bitmap(SCREEN_W, SCREEN_H);
		pagenum = 1;
		page = vpage[pagenum];
	}

	run_init();

	framecounter = 0;
	framecounttime = ticks;
	gframes = ticks;
	frames = ticks;
	while (1) {

		while (frames <= ticks) {
			run_frame();
			frames++;
		}
		{
			run_render();
			
			if(key[KEY_F1]) {
				static int sst = 0;
				if(ticks - sst > FPS) {
					static int ssn = 0;
					char name[256];
					PALETTE pal;
					get_palette(pal);			
					sprintf(name, "ss%d.bmp", ssn);
					save_bitmap(name, page, pal); 
					ssn++;
					sst = ticks;
				}
			}
						
			if (vpages == 0) {
				blit(page, screen, 0, 0, 0, 0, page->w, page->h);
			}
			if (vpages == 2) {
				show_video_bitmap(page);
				pagenum++;
				if (pagenum == vpages)
					pagenum = 0;
				page = vpage[pagenum];
			}
			if (vpages == 3) {
				while (poll_scroll());								  // in case not done with previous flip
				request_video_bitmap(page);
				pagenum++;
				if (pagenum == vpages)
					pagenum = 0;
				page = vpage[pagenum];
			}

			gframes = frames;
			framecounter++;

			if (ticks - framecounttime >= FPS) {
				fps = framecounter;
				framecounter = 0;
				framecounttime = ticks;
			}

		}

	}
	run_end();
	return -1;
}
END_OF_MAIN();
