#include <allegro.h>

#include "Game.h"
#include "main.h"



void midi_note_on(int channel, int note, int speed) {
	unsigned char data[256];
	data[0] = 144 + channel;
	data[1] = note;
	data[2] = speed;
	midi_out(data, 3);
}

void midi_note_off(int channel, int note, int speed) {
	unsigned char data[256];
	data[0] = 128 + channel;
	data[1] = note;
	data[2] = speed;
	midi_out(data, 3);
}

void midi_program_change(int channel, int program) {
	unsigned char data[256];
	data[0] = 192 + channel;
	data[1] = program;
	midi_out(data, 2);
}


int beat;

void music_init(void) {
	
	
	midi_program_change(1, 116);
	midi_program_change(2, 115);
		
	beat = 0;
}

void music_play(void) {			
	static int tm1 = 0;
			
	if((tm1 %  20) == 0) {		
		midi_note_on(1, 40, 100); 
		beat++;
	}
		
	if(beat > 40) {	
		if((tm1 % 20) == 0) {
			midi_note_on(2, 40, 100);
		}
		if((tm1 % 20) == 10) {
			midi_note_on(2, 40, 100);
		}
	}	
	
	tm1++;		
					
}


Sound *snd;
Screen *scr;
extern Game *game;
void blah();
SAMPLE *sam[256];
BITMAP *back;
int music = 1;

int Screen::rect(int x1, int y1, int x2, int y2, char color) {
	rectfill(framebuffer, x1, y1, x2, y2, color);
	return 0;
}
int Screen::blit(int x1, int y1, int x2, int y2, int w, int h) {
	::blit(back, ::page, x1, y1, x2, y2, w, h);
	return 0;
}
int Screen::sync() {
	return 0;
}

volatile int ticks = 0;
void ticker(void)
{
	ticks++;
}

void run_init()
{
	
	back = create_video_bitmap(640, 480);	
			
	PALETTE colors;
	int c = 0;
	for(int r = 0; r < 6; r++) {
		for(int g = 0; g < 7; g++) {
			for(int b = 0; b < 6; b++) {
				colors[c].r = r * 63 / 5;
				colors[c].g = g * 63 / 6;
				colors[c].b = b * 63 / 5;				
				c++;
			}
		}
	}
	while(c < 256) {
		colors[c].r = 0;
		colors[c].g = 0;
		colors[c].b = 0;			
		c++;
	}
	
	set_palette(colors);
	
	scr = new Screen();
	scr->page = 0;
	scr->w = 640;
	scr->h = 480;
	
	snd = new Sound();
					
	blah();	
	
	game->init(snd);		
		
	int n;
	for(n = 0; n < snd->num; n++) {
		SAMPLE *s = create_sample(8, 0, snd->freq[n], snd->len[n]);
		memcpy(s->data, snd->data[n], snd->len[n]);		
		sam[n] = s;
	}
	
	
	scr->background = back;
	
	acquire_bitmap(back);
	game->uploadgfx(scr);
	release_bitmap(back);
	
	music_init();
}

void run_end()
{
	exit(0);
}

   

void run_frame()
{
	while (keypressed()) {
		int k = readkey();

		k >>= 8;
		if (k == KEY_ESC)	run_end();
			
		if (k == KEY_M) music ^= 1;	
	}
	
	int d = 0;	
						
	if(key[KEY_UP]) { // Up
		d |= 1;
	}
	if(key[KEY_LEFT]) { // Left
		d |= 2;
	}
	if(key[KEY_DOWN]) { // Down
		d |= 4;
	}
	if(key[KEY_RIGHT]) { // Right
		d |= 8;
	}
	if(key[KEY_RCONTROL]) { // Fire
		d |= 16;
	}
	//if(key[KEY_C]) { // Cheat
	//	d |= 32;
	//}	
	
	int s[256];
	int i;
	for(i = 0; i < snd->num; i++) s[i] = 0;
	game->process(d, s);
	for(i = 0; i < snd->num; i++){
		if(s[i]) play_sample(sam[i], 255, 128, 1000, 0);
	}
	
	if(music) music_play();		
	
	acquire_bitmap(back);			
	game->uploadline(scr);
	release_bitmap(back);
	
}



void run_render()
{
			
	scr->framebuffer = page;
	
	game->render(scr);				

	//textprintf_right(page, font, SCREEN_W, 0,
	//					  makecol(100, 100, 100), "%d fps", fps);
}