// This is my second complete program written in BeOS, and what else could
// it be than a game. I'm using the GameKit for it, which would be quite
// wonderful without the bugs. Despite this program even having a design
// document, don't think it is written particulary well. The opposite might
// be the case. (The first part of this was done to test monitor refresh
// change which didn't work, then I added a test for hw accel functions,
// and finally tried the gamesound. The actual game was written in 2 nights
// instead of sleeping plus some days spent on writing the monser AI.. so
// this might explain some things..
//
// by anonymous - I don't want my name in connection with this code, you
// can freely use it without ever mentioning where you got it from,
// release it under your name if you're desperate enough, I won't care :)

#include "Game.h"

#include <math.h>

#ifndef M_PI
#define M_PI 3.141592654
#endif

/*

Design Document (not quite detailed, but normally i have none at all):

Level 1: Riverbank
Wave 1: Mosquito Swarm
Wave 2: Water Runners
Wave 3: Wasp Attack
Boss: Evil Hornet

Level2: Swamp
Wave 1: Biting Bugs
Wave 2: Flying Leaves
Wave 3: Hopping Spiders
Boss: Horrible Spider

Level3: Pond
Wave 1: Jumping Fish
Wave 2: Water Splashes
Wave 3: Sea Birds
Boss: Ugly Catfish

Final Level: Stoney Island
Wave 1: Rolling Stones
Wave 2: Carnivorous Plants
Wave 3: Spitting Lizards
Final Boss: Big Lizard

*/

const int BN = 21;
//                   m  r  w  H  b  l  s  S  f  w  b  C  s  p  l BL  s  w ws fc ln  
static float BW[] = {3, 2, 7,14, 3, 8, 5,15, 5, 3, 4,20, 6, 8,14,12, 1, 5, 1, 4, 4};
static float BH[] = {3, 2, 4, 8, 3, 6, 4,12, 8, 3, 3,24, 6, 4, 3,12, 1, 3, 1, 4, 4};

float scrollw, scrollh;
inline char mRGB(int r, int g, int b) { return (char)(b + g * 6 + r * 42); }
void circle(Screen *screen, float xp, float yp, float d, char c, float a = 0) {								
	if(a == 0) a = d;
	screen->rect(int(xp), int(yp), int(xp + d), int(yp + a), c);							
}

template<class El> struct _ {	
	int n;	
	El e[256];
	
	_() { n = 0; }
	
	int add(El el) {
		if(n == 255) return 0;
		e[n] = el;
		return ++n;			
	}
	void rem(int i) {
		n--;			
		e[i] = e[n];			
	}	
	void del() {
		for(int i = 0; i < n; i++) {
			delete e[i];
		}
		n = 0;
	}	
};

struct Block {	
	float x, y, u, v;	
	
	virtual float w() { return 0; }
	virtual float h() { return 0; }
		
	Block(float _x, float _y, float _u, float _v) : x(_x), y(_y), u(_u), v(_v) {}
};

struct DragonFly : public Block {
	int l;
	DragonFly() : Block(0, 0, 0, 0) {
		l = 1;
	}
	float w() { return 116; }
	float h() { return 32; }
};

struct Bad : public Block {
	int t;
	int l;
	
	float w() { return BW[t]; }
	float h() { return BH[t]; }
	
	Bad(int _t, float _x, float _y, float _u, float _v, int _l) :
		Block(_x, _y, _u, _v), t(_t), l(_l) {};
	virtual ~Bad() {};	
	virtual bool move() { return 0; }
	virtual void draw(Screen *screen, int p) {}
};

struct Drop : public Block {				
	int c;
	
	Drop(float _x, float _y, float _u, float _v, int _c) : Block(_x, _y, _u, _v), c(_c) {}
};

struct Shot : public Block {
	int t;
	Shot(int _t, float _x, float _y, float _u, float _v) : Block(_x, _y, _u, _v), t(_t) {}
};

DragonFly dragonfly;

struct Bads : public _<Bad *> {		
} bads;
			
struct Drops : public _<Drop *> {
} drops;
	
struct Shots : public _<Shot *> {
} shots;		

struct Badshot : public Bad {
	Badshot(float _x, float _y, float _u, float _v) : Bad(16, _x, _y, _u, _v, 1) {
		
	};
	bool move() {
		x += u;
		y += v;
		
		if(y > scrollh - h() || y < 0 || x > scrollw - w() || x < 0) return true; 
							
		return 0;
	}
	void draw(Screen *screen, int p) {			
		circle(screen, x, p + y, w() - 1, mRGB(5, 0, 0));			
	}
};

struct Mosquito : public Bad {
	Mosquito(float _x, float _y, float _u, float _v) : Bad(0, _x, _y, _u, _v, 1) {
		
	};
	bool move() {
		x -= 2;
		if(x < 0) return true;					
		return 0;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, w() - 1, mRGB(4, 0, 0));
		circle(screen, x, p + y + 8, 11, mRGB(0, 0, 0));
	}
};

struct Runner : public Bad {
	int s;
	Runner(float _x, float _y, float _u, float _v) : Bad(1, _x, _y, _u, _v, 1) {

		s = 0;
	};
	bool move() {
		x += u;
		if(x < 0) {
			x -= u;
			u = -u * 2;
		}
		
		if(x + BW[t] > scrollw)	return true;					
		
		if(s) {
			s--;
		} else if( y - dragonfly.y < x - dragonfly.x &&
		           y - dragonfly.y > x - dragonfly.x - dragonfly.w() ) {
			Badshot *b = new Badshot(x, y, -3, -3);
			if(!bads.add(b)) delete b;
			s = 30;
		}
		
		return 0;
	}
	void draw(Screen *screen, int p) {			
		circle(screen, x, p + y, w() - 1, mRGB(1, 1, 4));
		circle(screen, x, p + y + 4, 7, mRGB(0, 0, 0));
	}
	
};

struct Wasp : public Bad {
	int s;
	Wasp(float _x, float _y, float _u, float _v) : Bad(2, _x, _y, _u, _v, 2) {
	
		s = 0;
	};
	bool move() {
		x--;
					
		if(s) s--; 	
			
		if(dragonfly.x < x) x--;	
		
		if(x < 0) return true;
			
		if(dragonfly.y + dragonfly.h() / 2 - 1 < y) {
			if(y > 0) y--;
		} else if(dragonfly.y > y ) {
			if(y + h() < scrollh) y++;
		} else if(s == 0) {	
			Badshot *b = new Badshot(x, y, -4, 0);
			if(!bads.add(b)) delete b;
			s = 20;
		}
		
		return 0;
	}
	void draw(Screen *screen, int p) {			
		circle(screen, x, p + y, 39, mRGB(5, 6, 0));
		circle(screen, x + 40, p + y, 14, mRGB(0, 0, 0), 29);
		circle(screen, x + 55, p + y, 14, mRGB(5, 6, 0), 29);
		circle(screen, x + 5, p + y + 12, 15, mRGB(0, 0, 0));
	}
	
};

struct Hornet : public Bad {
	int s;
	int cn;
	Hornet(float _x, float _y, float _u, float _v) : Bad(3, _x, _y, _u, _v, 60) {
		l = 60;
		s = 0;
		cn = 0;
		u = 0;
	};
	
	bool move() {
		
		x += u;
		y += v;
					
		if(s) s--; 	
			
		if(x < 0) {
			x = 0;
			u = 6;
		}	
		
		if(x > scrollw - w()) {
			x = scrollw - w();
			u = 0;
			v = -3;
		}	
			
		if(y < 0) {
			y = 0;
			v = 3;
		}
		if(y > scrollh - h()) {
			y = scrollh - h();
			v = -3;
			cn++;
			
			if((cn&3) == 3) {
				u = -2;
				v = 0;
			}
			
		}
									
		if(s == 0) {	
			Badshot *b = new Badshot(x, y, -5, 4 * y / scrollh);
			if(!bads.add(b)) delete b;
			s = 10;
		}
		
		return 0;
	}
	void draw(Screen *screen, int p) {			
		circle(screen, x, p + y, 79, mRGB(5, 6, 0));
		circle(screen, x + 80, p + y, 29, mRGB(0, 0, 0), 59);
		circle(screen, x + 110, p + y, 29, mRGB(5, 6, 0), 59);
		circle(screen, x + 10, p + y + 24, 31, mRGB(0, 0, 0));
	}
	
};

inline void swap(float &a, float &b) {
	float t = a;
	a = b;
	b = t;
}

struct Bug : public Bad {
	int s;	
	float cn;
	int turns;
	Bug(float _x, float _y, float _u, float _v) : Bad(4, _x, _y, _u, _v, 2) {
	
		s = 400;		
		cn = v > 0 ? 1 : -1;	
		turns = 0;	
	};
	
	bool move() {
		
		x += u;
		y += v;
					
		if(s) s--; 	
			
		if(x < 0) {
			x = 0;
			swap(u, v);			
			u = u * -cn;
			v = v * cn;
			turns++;
		}	
		
		if(x > scrollw - w()) {
			x = scrollw - w();
			swap(u, v);
			u = u * -cn;
			v = v * cn;
			turns++;
		}	
			
		if(y < 0) {
			y = 0;
			swap(u, v);	
			u = u * -cn;
			v = v * cn;					
			turns++;
		}
		if(y > scrollh - h()) {
			y = scrollh - h();
			swap(u, v);
			u = u * -cn;	
			v = v * cn;			
			turns++;
		}
									
		if(s == 0) {				
			float dx = dragonfly.x - x;
			float dy = dragonfly.y - y;
			float d = sqrt(dx * dx + dy * dy);
			Badshot *b = new Badshot(x, y, 4 * dx / d, 4 * dy / d);
			if(!bads.add(b)) delete b;
			s = 400;			
		}
		
		if(turns == 4) return true;
		return 0;
	}
	
	void draw(Screen *screen, int p) {					
		circle(screen, x, p + y, w() - 1, mRGB(3, 2, 1));
		circle(screen, x, p + y + 8, 11, mRGB(5, 0, 0));
	
	}
	
};

struct Leaf : public Bad {
	Leaf(float _x, float _y, float _u, float _v) : Bad(5, _x, _y, _u, _v, 1) {
		
	};
	bool move() {
		x += u;
		y += v;
		
		u -= 0.1;
		v += 0.1;
		
		if(y + h() > scrollh) {y = scrollh - h(); v = -3;}
		if(x < 0) return true;
		return 0;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y + 30, 39, mRGB(3, 2, 1), 29);
		circle(screen, x + 40, p + y, 39, mRGB(4, 3, 2), 29);
		circle(screen, x + 40, p + y + 35, 39, mRGB(2, 1, 0), 24);
	}
};

struct Spider : public Bad {
	int bye;
	Spider(float _x, float _y, float _u, float _v) : Bad(6, _x, _y, _u, _v, 3) {
		
		bye = 6;
	};
	bool move() {
		x += u;
		y += v;
		
		v += 0.4;
							
		if(y + h() > scrollh) {
			y = scrollh - h();
			v = -18;
			if(dragonfly.x > x) u = 4;
			if(dragonfly.x < x) u = -4;			
			bye--;
			if(bye == 0) return true; // out through the bottom..
		}
		if(x < 0) {
			x = 0;
			u = -u;
		}
		if(x + w() > scrollw) {
			x = scrollw - w();
			u = -u;
		}	
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 49, mRGB(5, 0, 4), 29);
		circle(screen, x, p + y + 30, 9, mRGB(2, 0, 1));
		circle(screen, x + 20, p + y + 30, 9, mRGB(2, 0, 1));
		circle(screen, x + 40, p + y + 30, 9, mRGB(2, 0, 1));
		
		circle(screen, x + 10, p + y + 10, 9, mRGB(2, 0, 0));
		circle(screen, x + 30, p + y + 10, 9, mRGB(2, 0, 0));
	}
};

struct SpiderBoss : public Bad {
	int kid;
	SpiderBoss(float _x, float _y, float _u, float _v) : Bad(7, _x, _y, _u, _v, 80) {
		kid = 0;
	};
	bool move() {
		x += u;
		y += v;
		
		v += 0.4;
						
		if(v < 0 && v > -1) {					
			if(kid  == 13 || kid == 20 || kid == 25 || (kid >25 && (kid & 3) == 1)) {
				Spider *b = new Spider(x, y, u, v);
				b->x += (w() - b->w()) / 2;
				b->y += h() - b->h();
				if(!bads.add(b)) delete b;					
			}
		}
							
		if(y + h() > scrollh) {
			y = scrollh - h();
			v = -16;
			if(dragonfly.x > x) u = 4;
			if(dragonfly.x < x) u = -4;	
			kid++;								
		}
		if(x < 0) {
			x = 0;
			u = -u;
		}
		if(x + w() > scrollw) {
			x = scrollw - w();
			u = -u;
		}	
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 149, mRGB(5, 0, 4), 89);
		
		circle(screen, x, p + y + 90, 29, mRGB(2, 0, 1));
		circle(screen, x + 60, p + y + 90, 29, mRGB(2, 0, 1));
		circle(screen, x + 120, p + y + 90, 29, mRGB(2, 0, 1));
		
		circle(screen, x + 20, p + y + 20, 19, mRGB(2, 0, 0));
		circle(screen, x + 60, p + y + 20, 19, mRGB(2, 0, 0));
	}
};

struct Fish : public Bad {
	
	Fish(float _x, float _y, float _u, float _v) : Bad(8, _x, _y, _u, _v, 3) {				
	};
	bool move() {		
		y += v;
		
		if(v < 0) y += v<-4?-4:v;
		if(v > 0) y += v>4?4:v;		
		
		v += 0.4;
							
		if(y < 0) {
			y = 0;			
			v = 0;								
		}		
		
		if(y > scrollh - h()) {
			return true;
		}
				
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 49, mRGB(0, 3, 5), 59);
		circle(screen, x + 10, p + y + 60, 29, mRGB(0, 4, 5), 9);
		circle(screen, x , p + y + 70, 49, mRGB(0, 5, 5), 9);
		
		circle(screen, x + 20, p + y + 10, 9, mRGB(0, 0, 0));
	}
};

struct Water : public Bad {
	Water(float _x, float _y, float _u, float _v) : Bad(9, _x, _y, _u, _v, 2) {
		
	};
	bool move() {
		y += 2;
		if(y > scrollh - h()) return true;					
		return 0;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 29, mRGB(0, 0, 5));
		circle(screen, x + 5, p + y, 19, mRGB(2, 2, 5));
	}
};


struct Part : public Bad {
	Part(int _t, float _x, float _y, float _u, float _v, int _l) :
		Bad(_t, _x, _y, _u, _v, _l) {};
	virtual void detach(Part *who) {};
};

struct Wing : public Part {
	Part *par;
	Wing(Part *_par, float _x, float _y, float _u, float _v) : Part(17, _x, _y, _u, _v, 20) {
		par = _par;
	}
	~Wing() {		
		if(par) par->detach(this);				
	}
	void detach(Part *who) {		
		par = 0;
	}
	bool move() {
		if(par) {
			if(u < 0) x = par->x - 40;
			if(u > 0) x = par->x + 30;
			y = par->y - 30;					
		} else {
			y+=v;
			v++;
			if(y + h() > scrollh) return true;
		}
		return false;
	}	
	void draw(Screen *screen, int p) {					
		circle(screen, x, p + y, w() - 1, mRGB(1, 1, 1), h() - 1);		
	}
};

struct Bird : public Part {
	int ct;
	Part *wingl, *wingr;
	Bird(float _x, float _y, float _u, float _v) : Part(10, _x, _y, _u, _v, 80) {
		ct = 0;		
		wingl = new Wing(this, x - 40, y - 30, -1, 0);				
		bads.add(wingl);
		wingr = new Wing(this, x + 10, y - 30, 1, 0);				
		bads.add(wingr);
	};
	~Bird() {		
		if(wingl) wingl->detach(this);
		if(wingr) wingr->detach(this);
	}
	void detach(Part *who) {	
		l = (l + 1) / 2;		
		if(who == wingl) wingl = 0;
		if(who == wingr) wingr = 0;
	}
	
	bool move() {			
		
		ct++;
			
		x += u;
		y += v;								
						
		if(x < 40) {
			x = 40;			
		}	
		
		if(x > scrollw - 40) {
			x = scrollw - 40;	
		}	
			
		if(y < 30) {
			y = 30;			
		}
		if(y > scrollh - h()) {
			return true;		
		}
									
		if(ct == 30) {		
			float dx = dragonfly.x + dragonfly.w()/2 - x;
			float dy = dragonfly.y + dragonfly.h()/2 - y;
			float d = sqrt(dx * dx + dy * dy);
			
			u = dx / d;
												
			if(!wingl && !wingr) {
				v++;
			} else {					
				v = dy / d;		
				if(!wingl || !wingr) v *= 0.5;
			}
										
			ct = 0;
										
		}
		return false;
	}
	
	void draw(Screen *screen, int p) {					
		circle(screen, x, p + y, 39, mRGB(0, 0, 0), 19);

		circle(screen, x + 10, p + y + 5, 7, mRGB(5, 0, 0));
		circle(screen, x + 22, p + y + 5, 7, mRGB(5, 0, 0));
	
		circle(screen, x, p + y + 20, 9, mRGB(2, 1, 0));
		circle(screen, x + 30, p + y + 20, 9, mRGB(2, 1, 0));
	}
	
};

struct Badwatershot : public Bad {
	Badwatershot(float _x, float _y, float _u, float _v) : Bad(18, _x, _y, _u, _v, 2) {
		
	};
	bool move() {
		x += u;
		y += v;
		
		if(y > scrollh - h() || y < 0 || x > scrollw - w() || x < 0) return true; 
							
		return 0;
	}
	void draw(Screen *screen, int p) {			
		circle(screen, x, p + y, w() - 1, mRGB(5, 5, 0));			
	}
};

struct Fishcannon : public Part {
	Part *par;
	int st;
	Fishcannon(Part *_par, float _x, float _y, float _u, float _v) : Part(19, _x, _y, _u, _v, 20) {
		par = _par;
		st = 25;
	}
	~Fishcannon() {		
		if(par) par->detach(this);				
	}
	void detach(Part *who) {		
		par = 0;
	}
	bool move() {
		if(par) {
			if(v < 0) y = par->y;
			if(v > 0) y = par->y + par->h() - h();
			x = par->x - w();					
		} else {
			y+=2;			
			if(y + h() > scrollh) return true;
		}
		if(st) st--; else {
			Badwatershot *b = new Badwatershot(x, y + 15, -5, 0);
			if(!bads.add(b)) delete b;
			st = 25;
		}
		
		return false;
	}	
	void draw(Screen *screen, int p) {					
		circle(screen, x, p + y, w() - 1, mRGB(3, 3, 5));		
	}
};

struct CatFish : public Part {
	int pos;
	int st;
	Part *cannon1, *cannon2;
	CatFish(float _x, float _y, float _u, float _v) : Part(11, _x, _y, _u, _v, 200) {				
		pos = 0;
		cannon1 = new Fishcannon(this, x - 40, y, 0, -1);				
		bads.add(cannon1);
		cannon2 = new Fishcannon(this, x - 40, y + h() - 40, 0, 1);				
		bads.add(cannon2);
				
		st = 25;
	};
	~CatFish() {		
		if(cannon1) cannon1->detach(this);
		if(cannon2) cannon2->detach(this);
	}
	void detach(Part *who) {	
		l = (l + 1) / 2;		
		if(who == cannon1) cannon1 = 0;
		if(who == cannon2) cannon2 = 0;
	}
	
	bool move() {		
		y += v;
																
		if(y < 0) {
			y = 0;			
			v = -v;								
		}		
		
		if(y + h() > scrollh) {
			y = scrollh - h();
			v = -v;
		}
		
		if(st) st--; else {
			Badshot *b = new Badshot(x + 40, y + h()/2, -3, 0);
			if(!bads.add(b)) delete b;
			st = 25;
		}
				
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 119, mRGB(0, 6, 5), 39);
		circle(screen, x, p + y + 40, 159, mRGB(0, 5, 4), 39);
		circle(screen, x + 40, p + y + 80, 119, mRGB(0, 4, 3), 79);
		circle(screen, x, p + y + 160, 159, mRGB(0, 4, 2), 39);
		circle(screen, x, p + y + 200, 119, mRGB(0, 2, 1), 39);
		
		circle(screen, x + 160, p + y, 39, mRGB(0, 4,2), 239);
		
		circle(screen, x + 80, p + y + 80, 39, mRGB(1, 0, 0));		
		
	}
};

struct Stone : public Bad {
	Stone(float _x, float _y, float _u, float _v) : Bad(12, _x, _y, _u, _v, 4) {
				
	};
	bool move() {
		x += u;
		y += v;
		
		v += 0.4;
							
		if(y + h() > scrollh) {
			y = scrollh - h();
			v = -v;			
		}
		if(y < 0) { y = 0; v = 0; }
		if(x < 0) return true;
		
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, w() - 1, mRGB(3, 3, 3));		
	}
};

struct Plant : public Part {
	int pos;
	int gt;
	char col;
	Part *par, *kid;
	int lt;
	Plant(float _x, float _y, float _u, float _v) : Part(13, _x, _y, _u, _v, 40) {				
		pos = 0;
		
		if(v == 0) if(y < scrollh/2) v = 1; else v = -1;
		
		col = mRGB(int(y) % 6, 6, 0);
		
		par = 0;
		kid = 0;
		
		lt = 1000;		
		gt = 200;
	};
	~Plant() {		
		if(par) par->detach(this);
		if(kid) kid->detach(this);
	}
	void detach(Part *who) {			
		if(who == par) {
			par = 0;
			if(kid) {
				kid->detach(this);
				kid = 0;
			}
		}
		if(who == kid) kid = 0;
	}
	
	bool move() {	
		if(lt) lt--; else return true;
		if(kid == 0 && (pos == 0 || par) && pos < 5) {	
			if(gt) {
				gt--;
			} else {
				float yp = y + h() * v;			
				kid = new Plant(x, yp, 0, v);
				((Plant *)kid)->par = this;
				((Plant *)kid)->pos = pos + 1;
				bads.add(kid);	
				gt = 200;		
			}
		} 
		
		if(par) {				
		
			if(dragonfly.x < x) x--;
			if(dragonfly.x > x) x++;
			if(x < 0) x = 0;
			if(x + w() < par->x + par->w()/2) x = par->x + par->w()/2 - w();
			
			if(x + w() > scrollw) x = scrollw - w();
			if(x > par->x + par->w()/2) x = par->x + par->w()/2;
		} else {
			if(pos) {
				y++;
				if(y + h() > scrollh) return true;
			}
		}
				
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, w() - 1, col, h() - 1);					
	}
};

struct Lizard : public Bad {
	int bye;
	int s;
	Lizard(float _x, float _y, float _u, float _v) : Bad(14, _x, _y, _u, _v, 5) {
		s = 50;
		bye = 6;
	};
	bool move() {
		x += u;
		y += v;
		
		v += 0.4;
		
		if(s) s--;
			
		if(s == 0) {	
			Badshot *b = new Badshot(x, y, -4, 0);
			if(!bads.add(b)) delete b;
			s = 50;
		}	
							
		if(y + h() > scrollh) {
			y = scrollh - h();
			v = -18;
			if(dragonfly.x > x) u = 4;
			if(dragonfly.x < x) u = -4;			
			bye--;
			if(bye == 0) return true; // out through the bottom..
		}
		if(x < 0) {
			x = 0;
			u = -u;
		}
		if(x + w() > scrollw) {
			x = scrollw - w();
			u = -u;
		}	
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, 39, mRGB(0, 4, 0), 9);
		circle(screen, x + 10, p + y + 10, 39, mRGB(0, 4, 0), 9);
		circle(screen, x, p + y + 20, 39, mRGB(0, 4, 0), 9);
		
		circle(screen, x + 50, p + y, 49, mRGB(2, 0, 1), 19);
		
		circle(screen, x + 50, p + y + 20, 9, mRGB(0, 3, 3));
		circle(screen, x + 90, p + y + 20, 9, mRGB(0, 3, 3));
		
		circle(screen, x + 100, p + y, 39, mRGB(0, 5, 1), 9);
		
		circle(screen, x + 20, p + y + 10, 9, mRGB(0, 0, 2));		
	}
};

struct Neck : public Part {	
	Part *par, *kid;
	
	Neck(float _x, float _y, float _u, float _v) : Part(20, _x, _y, _u, _v, 40) {				
												
		par = 0;
		kid = 0;					
				
	};
	~Neck() {		
		if(par) par->detach(this);
		if(kid) kid->detach(this);
	}
	void detach(Part *who) {			
		if(who == kid) {
			kid = 0;
			if(par) {
				par->detach(this);
				par = 0;
			}
		}
		if(who == par) par = 0;
	}
	
	bool move() {	
		if(par) {
			if(par->y + par->h() < y) {
				y = par->y + par->h();
			}
			if(par->y > y + h()) {
				y = par->y - h();
			}		
		} else {
			y++;
			if(y + h() > scrollh) return true;
		}
								
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y, w() - 1, mRGB(3, 5, 1), h() - 1);					
	}
};

struct Biglizard : public Part {	
	Part *kid;
	float moved;
	Part *cannon1, *cannon2;
	int len;
	int st;
	Biglizard(float _x, float _y, float _u, float _v) : Part(15, _x, _y, _u, _v, 250) {
		st = 25;
		len = 0;
		moved = 0;
		kid = 0;
		cannon1 = new Fishcannon(this, x - 40, y, 0, -1);				
		bads.add(cannon1);
		cannon2 = new Fishcannon(this, x - 40, y + h() - 40, 0, 1);				
		bads.add(cannon2);
	};
	~Biglizard() {				
		if(kid) kid->detach(this);
		if(cannon1) cannon1->detach(this);
		if(cannon2) cannon2->detach(this);
	}
	void detach(Part *who) {			
		if(who == kid) kid = 0;
		if(who == cannon1) cannon1 = 0;
		if(who == cannon2) cannon2 = 0;
	}											
	
	bool move() {		
				
		if(moved <= 0 && len < 8) {
			moved = 35;
			Neck *b = new Neck(x + w() - 40, y + 40, 0, 0);
			if(kid) {
				((Neck *)kid)->par = b;
				b->kid = kid;
			} 
			kid = b;			
			b->par = this;
			bads.add(b);
			len++;
			if(len == 8) v = -2;
		} else {
			moved -= 1;			
		}
		if(len < 8) x -= 1;
		
		if(st) st--; else {
			Badshot *b = new Badshot(x, y + h()/2, -3, 0);
			if(!bads.add(b)) delete b;
			st = 25;
		}
		
		y += v;
		
		if(y < 0) {
			y = 0;
			v = -v;
		}
		if(y + h() > scrollh) {
			y = scrollh - h();
			if(kid == 0 && len) return true; else v = -v;
		}
	
		return false;
	}
	void draw(Screen *screen, int p) {
		circle(screen, x, p + y +  0, 119, mRGB(2, 4, 0), 39);
		circle(screen, x, p + y + 40, 119, mRGB(0, 4, 0), 39);
		circle(screen, x, p + y + 80, 119, mRGB(2, 4, 0), 39);
		
		circle(screen, x + 40, p + y + 40, 39, mRGB(0, 0, 2));
				
	}
};


const char digits[5][45] = {
	" x   x  xx  xx  x x xxx  xx xx  xx  xx  x   ",
	"x x  x    x   x x x x   x     x x x x x x   ",
	"x x  x   xx xxx  xx xxx xx    x xxx  xx x   ",
	"x x  x  x     x   x   x x x   x x x   x x   ",
	" x   x  xxx xx    x xx   xx   x  xx   x  xx "
};

void displaydigit2(Screen *screen, int xp, int yp, int d) {
	int x, y;
	for(y = 0; y < 5; y++) {
		for(x = 0; x < 3; x++) {
			if(digits[y][d * 4 + x] == 'x')
				circle(screen, xp + x * 10 + 1, yp + y * 10 + 1, 7, mRGB(y, y/2, y/2));
		}
	}
}	

void displaydigit(Screen *screen, int xp, int yp, int d) {
	int x, y;
	for(y = 0; y < 5; y++) {
		for(x = 0; x < 3; x++) {
			if(digits[y][d * 4 + x] == 'x')
				circle(screen, xp + x * 10 + 1, yp + y * 10 + 1, 7, mRGB(y, y, y));
		}
	}
}	

void displaynum(Screen *screen, int xp, int yp, int v) {				
	for(int n = 5; n >= 0; n--) {
		int nv = v / 10;
		int d = v - 10 * nv;
		displaydigit(screen, xp + n * 40, yp, d);
		v = nv;
	}	
}	
			
class DragonFlyGame : public Game {
	
	const char * name() { return "DragonFly"; }		
			
	bool boss;		
			
	int score;			
	int upgrade;
	int upgradescore;
	int nextlife;
																	
	int shotdelay;	
	
	bool dshot;
	bool sshot;
	
	int afterlife;
	int baddelay;
	int badn;
		
	int doublehit;
	int triplehit;
	int megahit;
	
	int scroll;
	int t;
	
	bool gameover;
							
	void initsound(Sound *sound) {
		int n = 0;
		
		// blllemb (shot)
		
		sound->len[n] = 1024;
		sound->freq[n] = 16384;
		sound->mult[n] = 16;
		sound->data[n] = new unsigned char[sound->len[n]];
		
		for(int s = 0; s < sound->len[n]; s++) {
			float t = float(s) / float(sound->freq[n]);
			float p = float(s) / float(sound->len[n]);
			sound->data[n][s] = 128 + int(

				50 * (1 - 2 * fabs(p - 0.5)) * // linear intensity
				sin(2 * M_PI * t * 1024 * // frequency: 1024 hz
					(0.7 + p * p * 0.5) // frequency change
				)
			);
		}
		
		n++;
		
		// beeeeww (monster hit)
		
		sound->len[n] = 8192;
		sound->freq[n] = 22050;
		sound->mult[n] = 8;
		sound->data[n] = new unsigned char[sound->len[n]];
				
		for(int s = 0; s < sound->len[n]; s++) {
			float t = float(s) / float(sound->freq[n]);
			float p = float(s) / float(sound->len[n]);
			sound->data[n][s] = 128 + int(
				100 * sin(p * M_PI) * // sin intensity
				sin(2 * M_PI * t * 1024 * // max frequency: 1024 hz
					(1 - 0.3 * p) // linear decreasing
				)
			);			
		}				
		
		n++;
		
		// blaaaa (game over)
		
		sound->len[n] = 16384;
		sound->freq[n] = 22050;
		sound->mult[n] = 1;
		sound->data[n] = new unsigned char[sound->len[n]];
				
		for(int s = 0; s < sound->len[n]; s++) {
			float t = float(s) / float(sound->freq[n]);
			float p = float(s) / float(sound->len[n]);
			sound->data[n][s] = 128 + int(
				120 * sin(p * M_PI) * // sin intensity
				sin(2 * M_PI * t * 1400 * // max frequency: 1024 hz
					(1 - 0.3 * p) // linear decreasing
				)
			);			
		}					
		
		n++;
		
		sound->num = n;
	}
	
	int ok;
	int wave;	
	
	void reset() {
		ok = 0;
		gameover = false;
		dragonfly.x = 0;
		dragonfly.y = 0;
		shotdelay = 0;			
			dshot = false;							
			sshot = false;
		baddelay = 200;
		badn = 0;
		scroll = 0;	
					t = 0;//int(scrollw) * (5 * 13);
					wave = 0;//13;
		score /= 2;		
		upgrade = 0;
		upgradescore = 100;
		doublehit = true;
		triplehit = false;
		megahit = false;	
		boss = false;	
		dragonfly.l = 3;
		nextlife = score + 100;
		afterlife = 0;
		
		bads.del();
		drops.del();
		shots.del();
	}
	
	void init(Sound *sound) {
				
		scrollw = 640;
		scrollh = 480;
					
		if(sound) initsound(sound);
					
		for(int i = 0; i < BN; i++) { BW[i] *= 10.0; BH[i] *= 10.0; }
		
		score = 0;	
		reset();								
						
	}
		
	int cheat;							
	void process(int d, int *sound) {
		
		if(gameover) {			
			if(!(d & 16)) ok = 1;
			else if(ok) {				
				int curwave = wave;
				if(boss) {
					curwave = wave - 3;
					boss = false;
				}
				reset();
				wave = curwave;
				t = wave * int(scrollw) * 5;
				sound[255] = 1;
			}
			return;
		}
		
		if(afterlife) afterlife--;	
			
		if(shotdelay) shotdelay--;			
		
		if(boss) {	
			if(baddelay) {			
				if(bads.n == 0) {
					if(baddelay == 1) {
						if(wave == 3) {
							Bad *b = new Hornet(scrollw - BW[4], (scrollh - BH[4]) * (badn & 7) / 7, -1, 3);
							if(!bads.add(b)) delete b;		
						}
						if(wave == 7) {
							Bad *b = new SpiderBoss((scrollw - BW[8]) / 2, 0, 0, 0);
							if(!bads.add(b)) delete b;		
						}
						if(wave == 11) {
							Bad *b = new CatFish(scrollw - BW[11], 0, 0, 1);
							if(!bads.add(b)) delete b;		
						}
						if(wave == 15) {
							Bad *b = new Biglizard(scrollw - BW[15], (scrollh - BH[15])/2, 0, 0);
							if(!bads.add(b)) delete b;		
						}
					}
					baddelay--; 
				}	
			} else {													
				if(bads.n == 0) {
					baddelay = 200;
					dragonfly.l++; // Yay, get a life!
					boss = false;					
					wave++;
					t = wave * int(scrollw) * 5;					
				}
			}
		} else if(baddelay) {
			baddelay--;	 	
		} else {
			int oldwave = wave;
			wave = t / int(scrollw) / 5;						
			
			bool newwave = (oldwave != wave);
			
			Bad *b = 0, *b2 = 0;
			
			if(newwave) {
			
				if(wave == 3 || wave == 7 || wave == 11 || wave == 15) {
					baddelay = 50;
					boss = true;
				}
			
				badn = 0;
			}
			
			if(!boss)						
			switch(wave) {
				case 0: { // Mosquitos
					b = new Mosquito(scrollw - BW[wave], (scrollh - 30) * (badn & 7) / 7, -1, 0);
					baddelay = 10 + (badn & 15) * 4;	
					break;
				}
				case 1: { // Water Runners
					if((badn % 17) == 1) b = new Runner(0, scrollh - BH[wave], 3, 0);					
					else b = new Runner(scrollw - BW[wave], scrollh - BH[wave], -3, 0);
					baddelay = 20 + (badn & 15) * (badn & 15);	
					
					if(badn > 9 && badn < 19) b2 = new Mosquito(scrollw - BW[0], (scrollh / 2 - BH[0]) * (badn & 7) / 7, -1, 0);
					
					break;
				}
				case 2: { // Wasps
												
					b = new Wasp(scrollw - BW[wave], (scrollh - BH[wave]) * (badn & 7) / 7, -1, 0);
					
					if((badn % 35) == 1) b2 = new Runner(0, scrollh - BH[1], 3, 0);	
					
					baddelay = 10 + (badn & 15) * 4;	
					break;
				}		
				case 4: { // Bugs
				
					if((badn % 53) >= 50) {
						if((badn/2)&1) {
							b = new Leaf(scrollw - BW[5],
								(scrollh - BH[5]) * fabs(sin(badn / 10.0 * M_PI)), 0, 0);
						} else {
							b = new Leaf((scrollw - BW[5]) * fabs(sin(badn / 10.0 * M_PI)),
								0 , 0, 0);
						}
						baddelay = 300;
						break;
					}
								
					b = new Bug(scrollw - BW[wave], scrollh / 2, 0, badn & 1 ? 3 : -3);
																
					baddelay = 10;	
					if((badn % 53) == 49) baddelay += 300;
					break;
				}			
				case 5: { // Leaves
				
					if((badn % 15) == 1) b2 = new Wasp(scrollw - BW[2], (scrollh - BH[2]) * (badn & 7) / 7, -1, 0);						
						
					if(badn&1) {			
						if((badn/2)&1) {
							b = new Leaf(scrollw - BW[wave],
								(scrollh - BH[wave]) * fabs(sin(badn / 10.0 * M_PI)), 0, 0);
						} else {
							b = new Leaf((scrollw - BW[wave]) * fabs(sin(badn / 10.0 * M_PI)),
								0 , 0, 0);
						}
					} else {
						badn++;
						
						float dx = 0, dy = 0;
						
						switch((badn/2)&3) {
							case 0: dx = -1; dy = 1; break;
							case 1: dx = -1; dy = -1; break;
							case 2: dx = 1; dy = -1; break;
							case 3: dx = 1; dy = 1; break;
						}
							
						dragonfly.u += dx * 3 - 2;
						dragonfly.v += dy * 3 + 2;	
					}
																
					baddelay = 25;						
					break;
				}	
				case 6: { // Spiders
				
					if(badn >= 15) b2 = new Bug(scrollw - BW[4], scrollh / 2, 0, -3);
					if(badn == 6) b2 = new Wasp(scrollw - BW[2], (scrollh - BH[2]) * (badn & 7) / 7, -1, 0);						
																				
					b = new Spider( (scrollw - BW[wave]) * (badn & 1), 0, 0, 0);
																
					baddelay = 100;	
					
					break;
				}			
				case 8: { // Fish
																													
					b = new Fish(
						(scrollw - BW[wave]) * abs((badn&7) - 4) / 4,
						scrollh - BH[wave], 0, -17);
										
					if((badn % 6) == 5) {
						b2 = new Runner(scrollw - BW[1], scrollh - BH[1], -3, 0);				
						badn--;
					} else if((badn % 10) == 9) {
						b2 = new Mosquito(scrollw - BW[0], (scrollh - BH[0]) * (badn & 7) / 7, -1, 0);
						badn--;
					}
												
																
					baddelay = 60;	
					
					break;
				}			
				case 9: { // Water
																													
					b = new Water(
						(scrollw - BW[wave]) * (7 - (badn&7)) / 7, 0, 0, 0);
						
					if(badn > 17) {	
						b2 = new Water(
							(scrollw - BW[wave]) * (badn&7) / 7, 0, 0, 0);	
						badn--;
					}
																																											
					baddelay = 30;						
					
					break;
				}	
				// 0        9 
				// BwFmFsFrFwFFBFBFB
				//  1           9   
				case 10: { // Birds
								
					if(badn == 1) b2 = new Wasp(scrollw - BW[2], (scrollh - BH[2]) / 4, -1, 0);
					if(badn == 3) b2 = new Mosquito(scrollw - BW[0], (scrollh - BH[0]) * (badn & 7) / 7, -1, 0);
					if(badn == 5) b2 = new Spider(scrollw - BW[6], 0, 0, 0);
					if(badn == 7) b2 = new Runner(scrollw - BW[1], scrollh - BH[1], -3, 0);						
					if(badn == 9) b2 = new Water((scrollw - BW[9]) * 3 / 4, 0, 0, 0);
						
					if((badn & 1) == 1) b = new Fish((scrollw - BW[8]) * 2 / 4, scrollh - BH[8], 0, -17);
																																
					if((badn & 1) == 0) b = new Bird(
						(scrollw - BW[wave] - 80) * (7 - (badn&7)) / 7, 30, 0, 0); // remember parts sizes
																																																						
					baddelay = 250;						
					
					break;
				}	
				case 12: { // Stones
					float xs = -2 - 2 * (badn % 8);
					float yp = 10 - ((badn / 13) % 11);
					float ys = -yp * 2;
					
					b = new Stone(scrollw - BW[wave], (scrollh - BH[wave]) * yp / 10, xs, ys);
					baddelay = 100;
					baddelay -= badn * 2;	
					if(baddelay < 0) baddelay = 10;
					break;
				}	
				case 13: { // Plants
					if(badn < 4) {
						b = new Plant((scrollw - BW[wave]) * (3 - (badn&3)) / 3,
							(scrollh - BH[wave]) * (1 - (badn&1)) / 1, 0, 0);
						baddelay = 400;
					} else {
						if(badn&1) {
							b = new Leaf(scrollw - BW[5],
								(scrollh - BH[5]) * fabs(sin(badn / 10.0 * M_PI)), 0, 0);
						} else {
							b = new Leaf((scrollw - BW[5]) * fabs(sin(badn / 10.0 * M_PI)),
								0 , 0, 0);
						}
						baddelay = 200;
					}
					break;
				}	
				case 14: { // Lizards
																					
					b = new Lizard(scrollw - BW[wave] - badn * 20, 0, 0, 0);
																
					baddelay = 160;	
					
					break;
				}									
			}
			if(b) {
				if(bads.add(b)) {
					badn++;						
				} else delete b;				
			}
			
			if(b2) {
				if(bads.add(b2)) {
					badn++;
				} else delete b2;				
			}
		}
		
		for(int si = 0; si < shots.n; si++) {
			Shot &s = *shots.e[si];
		
			if(s.t == 0) s.x += 3;
			if(s.t == 1) {
				s.x += s.u;
				s.y += s.v;
				s.v++;
			}
			if(s.t == 2) {
				s.x += s.u;
				s.y += s.v;				
			}
				
			if(s.y > scrollh - 20 || s.y < 0 ||
			   s.x > scrollw - 20 || s.x < 0) {				
			   
			   shots.rem(si); delete &s; si--; continue;			  
			   				
			}			
						
			bool hit = false;
			for(int bi = 0; bi < bads.n; bi++) {	
				Bad &b = *bads.e[bi];
				if(b.x < s.x + 20 &&
				   b.y < s.y + 20 &&
				   s.x < b.x + BW[b.t] &&
				   s.y < b.y + BH[b.t]) {
				   
				   b.l--;
				   
				   hit = true;
				   
				   if(b.l == 0) {				   				   	
				   	
				   	if(b.t < 16) {			   
						   sound[1] = 1;
						   								
						   for(int di2 = 0; di2 < (boss ? 2 : 1); di2++) {										
								for(int di = 0; di < 36; di++) {
									unsigned char c = 0;
									switch(b.t) {
										case 0: c = mRGB(di % 6, 0, 0); break;
										case 1: c = mRGB(0, 0, di % 6); break;
										case 2: c = mRGB(di % 6, di % 6, 0); break;
										case 3: c = mRGB(di % 6, di % 6, 0); break;
										case 4: c = mRGB(di % 6, di % 2, 0); break;
										case 5: c = mRGB(di % 6, di % 6, 0); break;
										case 6: c = mRGB(di % 6, 0, di % 6); break;
										case 7: c = mRGB(di % 6, 0, di % 6); break;
										case 8: c = mRGB(0, di % 6, di % 6); break;
										case 9: c = mRGB(1, 2, 2 + di % 4); break;
										case 10: c = mRGB(di % 4, 0, di % 2); break;
										case 11: c = mRGB((di/6) % 6, di % 6, 0); break;
										case 12: c = mRGB(di % 6, di % 6, di % 6); break;
									}
									Drop *d = new Drop(b.x + float(di) * (b.w() - 12) / 35.0,
										b.y + b.h() / 2 - 9 + di2 * 6,
										(di - 18) / 2.0, (di % 3) * -9 + (di - 18) * (di - 18) / 36.0, c);										
									if(!drops.add(d)) delete d;
								}								
							}
							
							int ts = 1 + b.t * 2;
							int getscore = 0;
							if((b.t & 3) == 3) {
								ts *= 30; // get 900, 2100, 3300, 4500 points
								getscore = ts;
							} else {	// multiple hits
								if(t <= doublehit + 20) {
									if(t <= triplehit + 20) {
										if(t <= megahit + 20) {
											getscore = (ts) * 8;
										} else {
											getscore = (ts) * 4;
											megahit = t;
										}
									} else {
										getscore = (ts) * 2;	
										triplehit = t;									
									}									
								} else {						
									getscore = (ts);
									doublehit = t;									
								}								
							}														
							score += getscore;
							
							if(score > nextlife) {
								dragonfly.l++;
								nextlife = 300 + nextlife * 2; // 100, 500, 1300, 2900, 6100
							}
							
							upgradescore -= getscore;
							if(upgradescore < 0) {	
								upgrade++;							
								upgradescore = 3000 * upgrade; // 100->dshot, 3000->sshot, 6000->hshot
								if(upgrade == 1) dshot = true;
								if(upgrade == 2) sshot = true;								
							}							
						}	
						
						bads.rem(bi);
						delete &b;
						bi--;
						continue;
					} else {
						Drop *d = new Drop(s.x, s.y, s.u, s.v, mRGB(3, 0, 0));																
						if(!drops.add(d)) delete d;
					}
										
				}
			}
			if(hit) { shots.rem(si); delete &s; si--; continue; }
			
		}
		
		for(int bi = 0; bi < bads.n; bi++) {
			Bad &b = *bads.e[bi];			
			
			if(b.move()) { bads.rem(bi); delete &b; bi--; continue; }
			
			if(!afterlife)						
			if(b.x < dragonfly.x + 110 && // 6 pixels off right
				b.y < dragonfly.y + 26 && // 6 pixels off below
				dragonfly.x + 10 < b.x + BW[b.t] && // 10 pixels off left
				dragonfly.y < b.y + BH[b.t]) { // 0 pixels off above
				
				sound[2] = 1;
				
				dragonfly.l--;
				if(dragonfly.l == 0) {
					gameover = true;				
				} else {					
					afterlife = 100;				
				}
				
			}
		}
		
		for(int di = 0; di < drops.n; di++) {
			Drop &d = *drops.e[di];
			d.x += d.u;
			d.y += d.v;
			d.v += 1;			
			
			if(d.y > scrollh - 12 || d.y < 0 ||
			   d.x > scrollw - 12 || d.x < 0) {				
			   
			   drops.rem(di); delete(&d); di--; continue;
			   				
			}
		}
		
		if(!boss) {
			scroll++;
			t++;
			if(scroll == scrollw) scroll = 0;			
		}				
						
		if(d & 1) dragonfly.y -= 3;
		if(d & 2) dragonfly.x -= 2;
		if(d & 4) dragonfly.y += 3;
		if(d & 8) dragonfly.x += 2;
		
		dragonfly.x += dragonfly.u;
		dragonfly.y += dragonfly.v;
		
		if(dragonfly.y < 0) dragonfly.y = 0;
		if(dragonfly.x < 0) dragonfly.x = 0;
		if(dragonfly.y > scrollh - 32) dragonfly.y = scrollh - 32;
		if(dragonfly.x > scrollw - 116) dragonfly.x = scrollw - 116; 
		
		dragonfly.u *= 0.95;
		dragonfly.v *= 0.95;
		
		if(d & 16) {
			if(shotdelay == 0) {
				Shot *s = new Shot(0, dragonfly.x + 116 - 20, dragonfly.y, 0, 0);
				if(!shots.add(s)) delete s;
							
				shotdelay = 20;
				sound[0] = 1;
			}
			if(dshot && shotdelay == 10) {
				Shot *s = new Shot(1, dragonfly.x, dragonfly.y, -2, -14);
				if(!shots.add(s)) delete s;
											
				sound[0] = 1;
			}
			if(sshot && shotdelay == 5) {
				Shot *s = new Shot(2, dragonfly.x + 116, dragonfly.y, 6, -3);
				if(!shots.add(s)) delete s;											
				sound[0] = 1;
			}
			if(sshot && shotdelay == 10) {
				Shot *s = new Shot(2, dragonfly.x + 116, dragonfly.y, 7, 0);
				if(!shots.add(s)) delete s;											
				sound[0] = 1;
			}
			if(sshot && shotdelay == 15) {
				Shot *s = new Shot(2, dragonfly.x + 116, dragonfly.y, 6, 3);
				if(!shots.add(s)) delete s;											
				sound[0] = 1;
			}
		}		
		
		if(d & 32) {
			if(cheat) {
				bads.del();
				wave++;
				t = int(scrollw) * wave * 5;
				wave--;
				baddelay = 50;			
				boss = false;
				cheat = false;		
				
				dshot = 1;		
				
			}
		} else cheat = true;		
				
	}
			
	void uploadline(Screen *screen) {
		for(int y = 0; y < scrollh; y++) {
			int red = (t / 640) % 10;
			if(red > 5) red = 10 - red;
			unsigned char c = 0;
			if(wave < 12) {
				c = mRGB(
					red,
					int(7 * y / scrollh),
					int(ceil(5.0 * fabs(sin(t * 2 * M_PI / scrollw)))));
			} else {
				int l = red * int(7 * y / scrollh) + int(ceil(5.0 * fabs(sin(t * 2 * M_PI / scrollw))));
				c = mRGB(l / 5, l / 5, l / 5);
			}
			int a = t / 40;
			
			if(wave == 0 || wave == 2 || wave == 4 || wave == 5 || wave == 6 ) { // grass
				int p = t % 40;
				if(y > scrollh - p * (a % 10) / 2 ) c = mRGB(0, 2, 0);
			} 
			if(wave == 1 || wave == 8 || wave == 9 || wave == 10) { // water
				int p = (t + 20) % 40;
				if(y > scrollh - 15 * sin(M_PI * p / 40.0) ) c = mRGB(0, 0, p / 10);
				p = t % 40;
				if(y > scrollh - 10 * sin(M_PI * p / 40.0) ) c = mRGB(0, p / 16, 3 + p / 20);
			} 
			if(wave == 12 || wave == 13 || wave == 14) {	
				int p = t % 40;		
				int f = ((a % 40) + p) / 16;
				if(y > scrollh - (a % 10) * 6 ) c = mRGB(f, f, f);
			}
			((char *)(screen->background->line[y]))[scroll] = c;				
		}		
	}
	
	void uploadgfx(Screen *screen) {				
		scroll = 0;
		for(int xp = 0; xp < screen->w; xp++) {								
			uploadline(screen);
			t++;
			scroll++;			
		}		
		t -= screen->w;				
		scroll = 0;
	}	
	
	void render(Screen *screen) {
		static int blink = 0;
		
		if(wave == 16) {
			screen->rect(0, screen->page * screen->h, screen->w - 1, screen->h - 1, mRGB(5, 6, 5));
									
			return;
		}
						
		blink++;
				
		screen->blit(scroll, 0, 0, 0, screen->w - scroll, screen->h);
		if(scroll) {
			screen->blit(0, 0, screen->w - scroll, 0, scroll, screen->h);
		}
				
		for(int si = 0; si < shots.n; si++) {
			Shot &s = *shots.e[si];		
			if(s.t == 0) circle(screen, s.x, screen->page * screen->h + s.y, 19, mRGB(0, 2, 5));
			if(s.t == 1) circle(screen, s.x, screen->page * screen->h + s.y, 17, mRGB(0, 6, 5));
			if(s.t == 2) {
				circle(screen, s.x, screen->page * screen->h + s.y, 19, mRGB(0, 6, 0), 6);
				circle(screen, s.x, screen->page * screen->h + s.y + 13, 19, mRGB(0, 6, 0), 6);
			}
		}
		
		for(int bi = 0; bi < bads.n; bi++) {
			Bad &b = *bads.e[bi];			
			b.draw(screen, screen->page * screen->h);
		}
		
		for(int di = 0; di < drops.n; di++) {
			Drop &d = *drops.e[di];		
			circle(screen, d.x, screen->page * screen->h + d.y, 11, d.c);
		}
		
		if(boss && bads.n) {
			int l = 0;
			for(int n = 0; n < bads.n && n < 3; n++) l += bads.e[n]->l;
			int m = (l + 9) / 10;
			if(m > 20) m = 20;
			for(int i = 0; i < m; i++) {
				unsigned char c;
				if( i < 10) c = mRGB(i / 2,5 - i / 2, 0);
				else c = mRGB(5, (i-10) / 2, (i-10) / 2);
				circle(screen, scrollw - i * 30 - 29 ,
					screen->page * screen->h + scrollh - 29, 28,
					c); 
			}
		}
			
		if(!afterlife || ((blink / 4) & 1)) {
			circle(screen, dragonfly.x, screen->page * screen->h + dragonfly.y, 25, mRGB(0, 3, 1));
			circle(screen, dragonfly.x + 26, screen->page * screen->h + dragonfly.y, 27, mRGB(0, 4, 2));		
			circle(screen, dragonfly.x + 26 + 28, screen->page * screen->h + dragonfly.y, 29, mRGB(0, 5, 3));
			circle(screen, dragonfly.x + 26 + 28 + 30, screen->page * screen->h + dragonfly.y, 31, mRGB(0, 6, 3));
		
			circle(screen, dragonfly.x + 26 + 28 + 30 + 9, screen->page * screen->h + dragonfly.y + 8, 17, mRGB(4, 5, 5));
			circle(screen, dragonfly.x + 26 + 28 + 30 + 15, screen->page * screen->h + dragonfly.y + 13, 9, mRGB(0, 0, 0));						
		}
		displaynum(screen, 0, screen->page * screen->h, score);
		
		for(int i = 0; i < dragonfly.l; i++) {
			displaydigit2(screen, int(scrollw - i * 30 - 29) , int(screen->page * screen->h), 10); 
		}
				
	}
};

Game *game;

void blah() {
	game = new DragonFlyGame();
}
