#include <allegro.h>
#include "wave.h"

/* define the same basic samples as the NES */
static SAMPLE *square[5];

static const Effect *thisfx;
static int fxTimer, inst0, inst1;

void GetSamples(void)
{
  int t;

//SAMPLE *create_sample(int bits, int stereo, int freq, int len);
  square[0] = create_sample(8, 0, 14080, 64);
  square[1] = create_sample(8, 0, 14080, 64);
  square[2] = create_sample(8, 0, 14080, 64);
  square[3] = create_sample(8, 0, 14080, 64);
  square[4] = create_sample(8, 0, 14080, 64);

  if(square[0]) // 1/8 pulsewidth squarewave
  {
    unsigned char *data = square[0]->data;

    for(t = 0; t < 8; t++)
      data[t] = 252;
    for(t = 8; t < 64; t++)
      data[t] = 3;
  }

  if(square[1]) // 1/4 pulsewidth squarewave
  {
    unsigned char *data = square[1]->data;

    for(t = 0; t < 16; t++)
      data[t] = 252;
    for(t = 16; t < 64; t++)
      data[t] = 3;
  }

  if(square[2]) // 1/2 pulsewidth squarewave
  {
    unsigned char *data = square[2]->data;

    for(t = 0; t < 32; t++)
      data[t] = 252;
    for(t = 32; t < 64; t++)
      data[t] = 3;
  }

  if(square[3]) // triangle wave
  {
    unsigned char *data = square[3]->data;

    for(t = 0; t < 64; t++)
      data[t] = data[63 - t] = t * 8;
  }

  if(square[4]) // sample-and-hold noise
  {
    unsigned char *data = square[4]->data;

    for(t = 0; t < 64; t++)
      data[t] = rand() & 0xff;
  }

}

void PlayEffect(const Effect *fx)
{
  fxTimer = 0;
  thisfx = fx;

  if(inst0)
    stop_sample(square[inst0 - 1]);
  if(inst1)
    stop_sample(square[inst1 - 1]);

  inst0 = inst1 = 0;
  PollEffect();
}

static int GetFreq(int midiNote)
{
  // Some compilers (DJGPP included) do not consistently support
  // pow() on FPU-less machines, so I had to create this power table.
  // It uses a 12-entry lookup table and fast shift instructions.

  static const unsigned int SoundNote_freq[12] =
    {2000, 2119, 2245, 2378, 2520, 2670, 2828, 2997, 3175, 3364, 3564, 3775};
  unsigned int freq;

  // Find pitch within this octave.
  freq = SoundNote_freq[(midiNote + 3) % 12];

  // If we have a low note, move it down an octave at a time.
  while(midiNote < 69)
  {
    freq >>= 1;
    midiNote += 12;
  }

  // If we have a high note, move it up an octave at a time.
  while(midiNote >= 81)
  {
    freq <<= 1;
    midiNote -= 12;
  }

  return freq;
}

void PollEffect(void)
{
  int i;

  static const int waveVol = 144;

  if(thisfx == NULL)
    return;

  if(fxTimer == 0)
  {
    if(inst0)
      stop_sample(square[inst0 - 1]);
    if(inst1)
      stop_sample(square[inst1 - 1]);

    fxTimer = thisfx->length;
    if(fxTimer == 0)
    {
      thisfx = NULL;
      return;
    }
    i = thisfx->waveforms;
    inst0 = i >> 4;
    inst1 = i & 0x0f;

    if(inst0)
      play_sample(square[inst0 - 1], waveVol, 127,
                  GetFreq(thisfx->note1), TRUE);
    if(inst1)
      play_sample(square[inst1 - 1], waveVol, 127,
                  GetFreq(thisfx->note2), TRUE);
    thisfx++;
  }
  fxTimer--;
}
