/*

    i.c:  Background eyecandy for Grand Unified Whack A Mole Engine
    Copyright  2000 Damian Yerrick

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    mailto:guwame@pineight.8m.com
      http://come.to/yerrick

*/

#include <allegro.h>

#define FX_WIDTH 256
#define FX_HEIGHT 192

static void blur(BITMAP *src, BITMAP *dst)
{
  int x, y;

  for(y = 0; y < FX_HEIGHT; y++)
  {
    unsigned char *upline = src->line[(y != 0) ? (y - 1) : FX_HEIGHT - 1];
    unsigned char *downline = src->line[(y != FX_HEIGHT - 1) ? (y + 1) : 0];

    for(x = 0; x < FX_WIDTH; x++)
    {
      unsigned i = (unsigned int)(upline[x]) + (unsigned int)(downline[x]);
      i += src->line[y][(x != 0) ? (x - 1) : FX_WIDTH - 1];
      i += src->line[y][(x != FX_WIDTH - 1) ? (x + 1) : 0];
      dst->line[y][x] = i >> 2;
    }
  }
}

static void qix(BITMAP *drawon)
{
  static fixed x[2] = {0, 0}, y[2] = {0, 0};
  static fixed xvel[2] = {-1, -1}, yvel[2] = {-1, -1};

  int i;

  for(i = 0; i < 2; i++)
  {
    x[i] += xvel[i];

    if(x[i] < 0)
      xvel[i] = ((rand() % 256) + 128) << 9;
    if(x[i] > FX_WIDTH << 16)
      xvel[i] = -((rand() % 256) + 128) << 9;

    y[i] += yvel[i];

    if(y[i] < 0)
      yvel[i] = ((rand() % 256) + 128) << 9;
    if(y[i] > FX_HEIGHT << 16)
      yvel[i] = -((rand() % 256) + 128) << 9;
  }

  line(drawon, x[0] >> 16, y[0] >> 16, x[1] >> 16, y[1] >> 16, 255);
}

static void stars(BITMAP *drawon)
{
  int i;

  for(i = 0; i < 128; i++)
  {
    putpixel(drawon, rand() % FX_WIDTH, rand() % FX_HEIGHT, 255);
  }
}

static void rotoblit2(BITMAP *src, BITMAP *dst, int originX, int originY)
{
  /* compensate for Allegro's quantization of rotation origins */
  originX += rand() & 0x1f;
  originY += rand() & 0x1f;

  clear(dst);
  pivot_sprite(dst, src,
               originX, originY,
               originX, originY, 0x10000);
}

void transform(BITMAP *src, BITMAP *dst, int originX, int originY)
{
  rotoblit2(src, dst, originX, originY);
  stars(dst);
  qix(dst);
  blur(dst, src);
}
