/**************************************\
* DOSARENA.H                           *
* DOSArena types and global variables  *
* and functions                        *
* Copr. 1999 Damian Yerrick            *
\**************************************/

/* Notice

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along
with this program (version 2 is in the file COPYING); if not, write to the
Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached by
  usps:Damian Yerrick, 730 Runnion Ave, Fort Wayne, IN 46808-3744, USA
mailto:d_yerrick@hotmail.com
  http://members.tripod.com/d_yerrick/

DOSArena is a trademark of Damian Yerrick. All other trademarks belong to
their respective owners.

*/

#ifndef _DOSARENA_H
#define _DOSARENA_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>
#include "allegdlg.h"

#if defined(ALLEGRO_DOS)
#define SHORT_PLATFORM_STR "DOS"
#elif defined(ALLEGRO_LINUX)
#define SHORT_PLATFORM_STR "Linux"
#elif defined(ALLEGRO_WINDOWS)
#define SHORT_PLATFORM_STR "Win"
#endif




// Structures ////////////////////////////////////////////////////////////////
typedef struct Cheat
{
  char flag;
  char name[31];
  char line1[32], line2[32];
} Cheat;


// Globals ///////////////////////////////////////////////////////////////////
extern FONT *chicago;
extern FONT *small;
extern RGB *pal;
extern BITMAP *icons;
extern DATAFILE *dosarena_dat, *music_dat;
extern int mouseButtons;
extern int digiPresent, midiPresent, joyPresent;
extern int digiVol, midiVol, scanlines;
extern int gLaptopControl, jukeboxMode;
extern char skinFolder[];
extern char progFolder[];

extern Cheat gCheatCodes[];


// little routine functions that are nice to have around /////////////////////
short GetKey(void);
void Credits(const char *q);
void ReadText(const char *buffer);
int DA_Pause(void);
int ReadKPad(int which);
int ReadJPad(int n);
void MakeRepeats(char *repeatTime, short j, short autoDelay, short autoRate);
void Options(void); // outside access to the option screen
DATAFILE *load_skinned_datafile(const char *filename);


// Datafile/resource management routines /////////////////////////////////////

// A resource is the term used in Mac OS for its version of Allegro's datafile
// objects.
void *GetResource(DATAFILE *dat, const char *name);


// High score management /////////////////////////////////////////////////////

enum {
  SCORE_TET,
  SCORE_TET_RACE,
  SCORE_INSANE_PUZZLE,
  SCORE_INSANE_ACTION,
  SCORE_INSANE_TA,
  SCORE_ZEUS,
  SCORE_KA,
  SCORE_ABKEY,
  nGames
};

typedef struct HighScore
{
  unsigned short score[4];
  char           name[40];
} HighScore; // 48 bytes

void ShowHighScores(unsigned short gameID);
void AddHighScore(unsigned short gameID, HighScore *entry);
char IsHighScore(unsigned short gameID, HighScore *entry);
unsigned short GetCheats(unsigned short gameID);
void SetCheats(unsigned short gameID, unsigned short cheats);
void GameOver1P(short gameType, HighScore *entry);


// Sound support /////////////////////////////////////////////////////////////

#define SIZE_midiQ 256

typedef struct MIDIEvent
{
  unsigned int  when;
  unsigned char length;
  unsigned char data[7];
} MIDIEvent;

typedef struct SoundRec
{
  unsigned char note;
  unsigned char duration;
} SoundRec;

void InitPlayEvent(int tempo);
short PlayEvent(MIDIEvent *event);
void Note(unsigned char channel, unsigned char noteNo, unsigned char vol,
          unsigned int when, unsigned int length);
void remove_event(void);
void InitMIDI(short tempo, short nPatches, const unsigned char *patchMap);
unsigned long GetNow(void);
void SendSound(const SoundRec *);
void DisguiseRemoveSound(void);

#endif























