/**************************************\
* arenamai.c                           *
* free*arena core and menu system      *
* Copr. 1999 Damian Yerrick            *
\**************************************/

#define DA_VERSION "freepuzzlearena 1.10"

/* Notice

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful and fun, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the License for more details.

You should have received a copy of the License along with this program,
in the file COPYING; if not, write to the Free Software Foundation, Inc. /
59 Temple Place - Suite 330 / Boston, MA  02111-1307 / USA
or view the License online at http://www.gnu.org/copyleft/gpl.html

The author can be reached by
  usps:Damian Yerrick / Box 398 / 5500 Wabash Avenue / Terre Haute, IN 47803
  mailto:dosarena@pineight.8m.com
    http://come.to/yerrick

freepuzzlearena and DOSArena are trademarks of Damian Yerrick.
All other trademarks belong to their respective owners.

*/
// The waves, on the other hand...

#define alleg_3d_unused
#define alleg_flic_unused
#include "dosarena.h"
#include "time.h"

void Copying(void);
void Jukebox(void);
void SetKeys(void);
void ShowAllHighScores(void);

    // DJGPP version (DOSArena) only:
   //  To make the EXE smaller, link in only certain features of Allegro.
  // GNU GCC for Linux version (xarena) only:
 //  We only need X window support. DGA screws up the mouse pointer.
// But include all the wave, MIDI, and joystick drivers.

#ifdef ALLEGRO_DJGPP
BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_8
END_COLOR_DEPTH_LIST
#endif

// global variables //////////////////////////////////////////////////////////
FONT *chicago, *small, *impact, *old8x8;
RGB *pal;
BITMAP *icons;                 
BITMAP *logo;
DATAFILE *dosarena_dat, *music_dat = NULL;
int mouseButtons;
int digiPresent = 1, midiPresent = 1, joyPresent = 1;
int gLaptopControl = 1;
int jukeboxMode = -1;

char skinFolder[256] = "";
char progFolder[256] = "";

#define NUM_gCheatCodes 4
Cheat gCheatCodes[NUM_gCheatCodes] =
{
  {0, "I THINK THEREFORE IMAC", "If you like Macs, shouldn't", "you be playing MacArena?"},
  {0, "JUNKIE", "Rapid fire in Insane", "(hold the Control key)"},
  {0, "CHEATER", "Stop trying to cheat, Sam!", "You know there are no codes!"},
  {0, "DEBUG", "Don't talk to me;", "call 1-800-TERMINIX"}
};

// global code ///////////////////////////////////////////////////////////////

short GetKey(void)
{
  short n = readkey();
  if(n & 0xff)
    return (n & 0xff);
  else
    return n;
}

void *GetResource(DATAFILE *dat, const char *name)
{
  short i;

  if(dat == NULL)
    return NULL;
  for(i=0; dat[i].type != DAT_END; i++)
    if(stricmp(get_datafile_property(dat+i, DAT_ID('N','A','M','E')),
	       name) == 0)
      return dat[i].dat;
  return NULL;
}

/* DA_Pause() **************************
 * Displays pause screen; returns 0 to resume or 1 to quit.
 */
int DA_Pause(void)
{
  int r;

  do {
    r = alert3(SHORT_PLATFORM_STR"Arena: Game Paused",
               "Press Esc to resume",
               "or Ctrl+Q to quit",
               "Resume", "Quit", "&Options",
               27, 17, 'o');
    if(r == 3)
    {
      BITMAP *saveScrn = create_bitmap(VIRTUAL_W, VIRTUAL_H);
      PALETTE pal;

      if(saveScrn)
      {
        get_palette(pal);
        blit(screen, saveScrn, 0, 0, 0, 0, VIRTUAL_W, VIRTUAL_H);
        Options();
        blit(saveScrn, screen, 0, 0, 0, 0, VIRTUAL_W, VIRTUAL_H);
        set_palette(pal);
        destroy_bitmap(saveScrn);
      }
    }
  } while(r == 3);
  text_mode(16);
  return (r == 2);
}

// display credits
void Credits(const char *q)
{
  char str1[256];
  unsigned char strPtr = 0, scrollLoc = 0;
  int lastClock;
  unsigned char clockTc;
  int usingImpact = 11;

  FONT *theFont = GetResource(dosarena_dat, "impact_pcx");
  if(theFont == NULL)
  {
    theFont = chicago;
    usingImpact = 11;
  }

//  clear(screen);
  set_palette(pal);
  lastClock = retrace_count;
  text_mode(-1);
  while(*q != 0 && !keypressed())
  {
    strPtr = 0;
    // get the next line of text
    while((*q != 0) && (*q != '\n') && strPtr < 255)
      str1[strPtr++] = *q++;

    str1[strPtr] = 0;
    q++;

    while(scrollLoc < 16)
    {
      textout(screen, theFont, str1,
              8, SCREEN_H - 1 - scrollLoc,
              (str1[0] == ' ') ? 14 : usingImpact);
      do {
	clockTc = retrace_count - lastClock;
      } while(clockTc < 4);
      clockTc /= 4;
      blit(screen, screen, 0, clockTc, 0, 0, 320, SCREEN_H - clockTc);
      rectfill(screen, 0, SCREEN_H - clockTc, 319, SCREEN_H - 1, 16);
      scrollLoc += clockTc;
      lastClock += clockTc * 4;
    }
    scrollLoc -= 16;
  }

  readkey();
}

int ReadJPad(int n)
{
  static char polled[4] = {0, 0, 0, 0};
  int i, out = 0;

  if(!joyPresent)
    return 0;
  if(n >= num_joysticks || n < 0)
    return 0;

  // If necessary, read the joysticks.
  if(!polled[n])
  {
    poll_joystick();
    for(i = 0; i < 4; i++)
      polled[i] = 1;
  }

  if(joy[n].stick[0].axis[1].d1) // up
    out |= 0x80;
  if(joy[n].stick[0].axis[1].d2) // down
    out |= 0x40;
  if(joy[n].stick[0].axis[0].d1) // left
    out |= 0x20;
  if(joy[n].stick[0].axis[0].d2) // right
    out |= 0x10;
  if(joy[n].button[0].b)
    out |= 0x08;
  if(joy[n].button[1].b)
    out |= 0x04;
  if(joy[n].num_buttons > 2 && joy[n].button[2].b)
    out |= 0x02;
  if(joy[n].num_buttons > 3 && joy[n].button[3].b)
    out |= 0x01;

  // Mark this joystick as "needs to be read next time."
  polled[n] = 0;
  return out;
}

/* MakeRepeats() ***********************
 * Autorepeats digital pad motion.  After autoDelay/70 of a second, it repeats
 * a key 70/autoRate times a second.
 */
void MakeRepeats(char *repeatTime, short j, short autoDelay, short autoRate)
{
  short i;

  for(i = 7; i >= 0; i--)
  {
    if(j & 0x01)
    {
      repeatTime[i]++;
      if(repeatTime[i] >= autoDelay)
        repeatTime[i] -= autoRate;
    }
    else
    {
      repeatTime[i] = 0;
    }
    j >>= 1;
  }
}

void GameOver1P(short gameType, HighScore *entry)
{
  // fade the tiles out for drama

  fade_out(2);
  clear(screen);
  set_palette(pal);

  // ask for the player's name if he or she has the high score
  clear_keybuf();
  AddHighScore(gameType, entry);
  ShowHighScores(gameType);
  textout_centre(screen, small, "Press a key", 160, 88, 4);

  // clean up
  readkey();
  fade_out(4);

}

DATAFILE *load_skinned_datafile(const char *filename)
{
  char fullPath[256] = "";
  DATAFILE *rval;

  /* first try in the skin folder */
  replace_filename(fullPath, skinFolder, (char *)filename, 255);
  rval = load_datafile(fullPath);
  if(rval)
    return rval;

  /* then try in the program's folder */
  replace_filename(fullPath, progFolder, (char *)filename, 255);
  rval = load_datafile(fullPath);
  if(rval)
    return rval;

  /* then try in $(pwd) */
  return load_datafile(filename);
}



// local crap ////////////////////////////////////////////////////////////////

typedef struct Game
{
  char name[44];
  void (*code)(void);
} Game;

int oneGame = -1, scanlines = 200;

static void Exit2DOS(void)
{
  if(digiPresent)
  {
    SAMPLE *bye = GetResource(dosarena_dat, "bye_wav");
    if(bye != NULL)
      play_sample(bye, 240, 128, 1000, 0);
  }

  rectfill(screen, 0, 0, 319, 23, 15);
  fade_out(1);
  DisguiseRemoveSound();
  unload_datafile(dosarena_dat);
  exit(0);
}

void ResetPitchBends(void);
/*
static void allegro_reinit(void)
{
  allegro_init();
  install_timer();
  ifmouse install_mouse();
  if(digiPresent || midiPresent)
    if(install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) < 0)
      digiPresent = midiPresent = 0;
  if(midiPresent)
    ResetPitchBends();
}
*/

static void NotMade(void)
{
  clear(screen);
  textout(screen, chicago, "Haven't made this game yet.", 0, 0, 15);
  readkey();
}

static int UpdateVolumes(DIALOG *d, int unused1)
{
  digiVol = d[2].d2 << 2;
  midiVol = d[3].d2 << 2;

  set_volume(digiVol, midiVol);

  return D_O_K;
}

/* Options() ***************************
 * Set options for the sound card.  Enter cheat codes here.
 */
static int OpenKeys(DIALOG *unused1)
{
  show_mouse(NULL);
  SetKeys();
  show_mouse(screen);
  return D_REDRAW;
}

static int OpenJukebox(DIALOG *unused1)
{
  show_mouse(NULL);
  Jukebox();
  show_mouse(screen);
  return D_REDRAW;
}

static int NoJoy(DIALOG *unused1)
{
  joyPresent = 0;
  return D_O_K;
}

int Calibrate(DIALOG *unused1)
{
  int scrnY = 0;
  int x[2] = {140, 180};
  int y[2] = {100, 100};
  int lastClock = 0;
  const char *msg;
  int i = 0;

  if(joyPresent == 0)
    return D_REDRAW;
  show_mouse(NULL);
  clear(screen);
  text_mode(0);
  for(i = 0; i < num_joysticks; i++)
  {
    while (joy[i].flags & JOYFLAG_CALIBRATE)
    {
      msg = calibrate_joystick_name(i);
      textout(screen, font, msg, 0, scrnY, 15);
      scrnY += 8;
      textout(screen, font, "and press a key.", 0, scrnY, 15);
      scrnY += 8;

      if((readkey() & 0xFF) == 27)
        return D_REDRAW;

      if(calibrate_joystick(i) != 0)
      {
        textout(screen, font, "Error calibrating joystick!", 0, scrnY, 15);
        readkey();
        return D_REDRAW;
      }

      if(scrnY >= 192)
      {
        scrnY = 0;
        clear(screen);
      }
    }
  }

  scrnY = 0;
  clear(screen);

  textout(screen, font, joystick_driver->name, 0, scrnY, 15);
  scrnY += 8;
  textout(screen, font, "is calibrated. Try it and press a key.", 0, scrnY, 15);
  scrnY += 8;

  while(!keypressed())
  {
    int i = 0;

    while(lastClock == retrace_count)
      ;
    lastClock = retrace_count;
    poll_joystick();

    for(i = 0; i < num_joysticks; i++)
    {
      if(joy[i].button[0].b == 0)
        putpixel(screen, x[i], y[i], 0);

      x[i] += joy[i].stick[0].axis[0].pos/40;
      y[i] += joy[i].stick[0].axis[1].pos/40;

      if(x[i] <   0) x[i] =   0;
      if(x[i] > 319) x[i] = 319;
      if(y[i] <  16) y[i] =  16;
      if(y[i] > 143) y[i] = 143;

      putpixel(screen, x[i], y[i], 15);
    }

/* MkoPad/Flightstick Pro

    textprintf(screen, font, 0, 144, 15,
               "gas pedal=%3d  S1D1=%3d  S1D2=%3d",
               joy[0].stick[2].axis[0].pos,
               joy[0].stick[1].axis[1].d1,
               joy[0].stick[1].axis[1].d2);
*/
  }
  show_mouse(screen);
  readkey();

  return D_REDRAW;
}

static int OptionsWaveTest(int msg, DIALOG *d, int c)
{
  static int lastBeat = -1;

  if(lastBeat != midi_pos)
  {
    lastBeat = midi_pos;
    if((lastBeat & 7) == 5)
      play_sample(d->dp, 240, 128, 1000, 0);
  }
  yield_timeslice();
  return D_O_K;
}

void Options(void)
{
  short i;
  char cheatCode[32] = "";

  DIALOG dlg[] =
  {
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_shadow_box_proc, 0,    0,    320,  200,  16,   15,   0,    0,       0,    0,    NULL },
   { d_button_proc,     244,  186,  48,   12,   1,    14,   13,   D_EXIT,  0,    0,    "OK"},
   { d_slider_proc,     64,   64,   96,   8,    16,   15,   'w',  0,       63,   0,    NULL, UpdateVolumes, dlg},
   { d_slider_proc,     64,   76,   96,   8,    16,   15,   'm',  0,       63,   0,    NULL, UpdateVolumes, dlg},
   { d_edit_proc,       64,   160,  256,  8,    30,   8,    0,    0, sizeof(cheatCode)-1, 0, cheatCode },
   { DY_action_proc,    32,   186,  64,   12,   1,    14,   'j',  D_EXIT,  0,    0,    "&Jukebox", OpenJukebox},
   { DY_action_proc,    104,  186,  72,   12,   1,    14,   'k',  D_EXIT,  0,    0,    "&Keyboard", OpenKeys},
   { DY_action_proc,    32,   170,  80,   12,   1,    14,   'l',  D_EXIT,  0,    0,    "Ca&librate", Calibrate},
   { DY_action_proc,    120,  170,  48,   12,   1,    14,   'n',  D_EXIT,  0,    0,    "&NoJoy", NoJoy},
   { DY_bitmap_proc,    8,    2,    96,   20,   0,    0,    0,    0,       0,    0,    logo },
   { d_text_proc,       112,  4,    64,   16,   16,   15,   0,    0,       0,    0,    "Options", chicago},
   { d_text_proc,       4,    64,   60,   8,    16,   15,   0,    0,       0,    0,    "&Wave volume", small},
   { d_text_proc,       4,    76,   60,   8,    16,   15,   0,    0,       0,    0,    "&MIDI volume", small},
   { d_text_proc,       4,    160,  60,   8,    16,   15,   0,    0,       0,    0,    "Cheat code", small},
   { OptionsWaveTest,   0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL },
   { d_text_proc,       4,    148,  312,  8,    16,   15,   0,    0,       0,    0,    skinFolder, small},
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
  };

  set_palette(pal);

  dlg[14].dp = GetResource(dosarena_dat, "hey_wav");
  dlg[2].d2 = digiVol >> 2;
  dlg[3].d2 = midiVol >> 2;

  centre_dialog(dlg);  // those stupid brits spell weird
  popup_dialog(dlg, 1);

  for(i = 0; i < NUM_gCheatCodes; i++)
  {
    if(!stricmp(gCheatCodes[i].name, cheatCode))
    {
      gCheatCodes[i].flag = 1;
      alert("Enabled cheat code", gCheatCodes[i].line1, gCheatCodes[i].line2,
            "OK", NULL, 13, 0);
    }
  }
}

static void CoprScreen(void)
{
  static RGB white = {63, 63, 63},
             lgrey = {42, 42, 42},
             black = { 0,  0,  0};

  BITMAP *pin8 = GetResource(dosarena_dat, "pineight_pcx");
  SAMPLE *wav = GetResource(dosarena_dat, "curafair_wav");
  long now = 2;
  int curClock;

  stop_midi();

  // setup first sound

  curClock = retrace_count + 40;

  // display copyright message
  set_color(  2, &black);
  set_color(255, &lgrey);
  play_sample(wav, 255, 127, 1000, FALSE);
  for(now = 0; now < 2; now++)
  {
    if(now != 0)
    {
      fade_out_range(16, 0, 254);
      rectfill(screen, 0, 176, 319, 199, 2);
    }
    text_mode(-1);
    textout(screen, small, "Copr. 1999-2000 Damian Yerrick. "SHORT_PLATFORM_STR"Arena comes with ABSOLUTELY NO WARRANTY.  This is", 1, 176, 255);
    textout(screen, small, "free software, and you are welcome to redistribute it under the terms and conditions of", 1, 184, 255);
    textout(screen, small, "of the GNU General Public License, version 2 or later; choose \"License\" for details.", 1, 192, 255);
    text_mode(0);
  }

  // fill in sky and grass
  rectfill(screen, 0, 0, 319, 119, 11);
  rectfill(screen, 0, 120, 319, 175, 2);
  // display hidden picture
  if(pin8 != NULL)
    draw_sprite(screen, pin8, (320 - pin8->w) / 2, (200 - pin8->h) / 2);
  while(curClock - retrace_count > 0)
    ;
  set_color(255, &white);
  fade_in_range(pal, 10, 0, 254);
  rest(500);
  text_mode(-1);
  textout_centre(screen, chicago, "Press a key", 160, 0, 4);
  readkey();
  fade_out(4); // set black palette
}

static void RollCredits(void)
{
  static char dosCredits[] = {
SHORT_PLATFORM_STR"Arena\n"
" Volume 1: Action Puzzles\n\n"
"Inspired by\n"
" Insane Game for TI-8x calculators by\n"
"  Martin Hock and Bill Nagel\n"
" Mario Teaches Typing for Macintosh\n"
" Alexey Pazhitnov's Tetris\n"
" Inner Child Productions's Hampsterdance\n"
" Nintendo's Dr. Mario\n"
" Compile's PuyoPuyo aka Avalanche\n"
" Viacom New Media's Zoop(TM)\n"
"Program\n"
" Damian Yerrick\n"
"Art\n"
" Sam Seabold\n"
" Damian Yerrick\n"
" Read your theme's README for more info\n"
"Music\n"
" Frederic Chopin\n"
" Portions copr. Europress Software Ltd.\n"
" Andy Morel\n"
" Peter I. Tchaikovsky\n"
" Damian Yerrick\n"
" Read your theme's README for more info\n"
"Operating system\n"
" GNU/Linux by Richard Stallman and\n"
"  Linus Torvalds\n"
" MS-DOS by Microsoft Corp.\n"
" (Microsoft Seeks Domination of Society)\n"
"Tools\n"
" GNU C++ Compiler\n"
"  http://gcc.gnu.org/\n"
" DJGPP: GNU C++ for DOS\n"
"  http://www.delorie.com/djgpp/\n"
" Allegro 3.9.32 by Shawn Hargreaves\n"
"  http://www.talula.demon.co.uk/allegro/\n"
"Testers\n"
" Too many to mention here.\n"
"\nAll trademarks used herein are the\n"
" property of their respective owners.\n"
"\nPress a key\n"
};
  Credits(dosCredits);
  CoprScreen();
}


/* Many platforms don't have printf() so I'll have to implement
 * a terminal emulator.
 */
static int ScrollTerminal(void)
{
  blit(screen, screen, 0, 8, 0, 0, SCREEN_W, SCREEN_H - 8);
  rectfill(screen, 0, SCREEN_H - 8, SCREEN_W - 1, SCREEN_H - 1, 16);
  return 192;
}

static void termputs(const char *str)
{
  textout(screen, font, (char *)str, 0, ScrollTerminal(), 7);
}

static void EnvInfo(void)
{
  if(cpu_family < 4)
  {
    termputs(SHORT_PLATFORM_STR"Arena likes a 486 or faster CPU;");
    termputs("expect slow performance when");
  }
  textprintf(screen, font, 0, ScrollTerminal(), 7,
    "Running on a %d86 processor under", cpu_family);

  switch(os_type)
  {
    case OSTYPE_UNKNOWN:
      termputs("real DOS");
      break;
    case OSTYPE_WIN3:
      termputs("Microsoft Windows 3.1");
      break;
    case OSTYPE_WIN95:
      termputs("Microsoft Windows 95");
      break;
    case OSTYPE_WIN98:
      termputs("Microsoft Windows 98");
      break;
    case OSTYPE_WINNT:
#ifdef ALLEGRO_DOS
      termputs("screwy DOS emulation in Windows NT");
#else
      termputs("Microsoft Windows NT");
#endif
      break;
    case OSTYPE_OS2:
      termputs("old-school OS/2");
      break;
    case OSTYPE_WARP:
      termputs("OS/2 Warp 3 or later");
      break;
    case OSTYPE_DOSEMU:
      termputs("DOS emulation in Linux");
      break;
    case OSTYPE_OPENDOS:
      termputs("Lineo's DR-DOS");
      break;
#ifdef OSTYPE_MACOS
    case OSTYPE_MACOS:
      termputs("Mac OS");
      break;
#endif
#ifdef OSTYPE_BEOS
    case OSTYPE_BEOS:
      termputs("BeOS");
      break;
#endif
    case OSTYPE_LINUX:
      termputs("a Linux-based GNU system");
      break;
#ifdef OSTYPE_SOLARIS
    case OSTYPE_SOLARIS:
      termputs("Sun's Unix clone Solaris");
      break;
#endif
    case OSTYPE_UNIX:
      termputs("an unknown flavor of *nix");
      break;
    default:
      termputs("some weird operating system");
      break;
  }
}

void ReadScores(void);
void ReadKeys(void);
static short init_everything(int argc, char **argv)
{
  BITMAP *bmp;
  int arg = 0;

  allegro_init();
  install_timer();
  install_keyboard();

  while(++arg < argc)
  {
    if(argv[arg][0] == '-')
    {
      switch(argv[arg][1])
      {
      case 'T':
      case 't':
        scanlines = 240;
        break;
      case 'G':
      case 'g':
        oneGame = atoi(argv[2] + 1);
        break;
      default:
        break;
      }
    }
    else
      strncpy(skinFolder, argv[arg], sizeof(skinFolder) - 1);
  }

//  if(set_gfx_mode(GFX_AUTODETECT, 320, scanlines, 0, 0) < 0)
//    if(set_gfx_mode(GFX_AUTODETECT, 320, (scanlines == 240) ? 200 : 240, 0, 0) < 0)
  if(set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0) < 0)
  {
    allegro_message("Could not open a 320x200 or 320x240 window.\n"
#ifdef ALLEGRO_DOS
"You need a VGA compatible display adapter.\n"
#endif
#ifdef ALLEGRO_WINDOWS
"Is your DirectX set up correctly?\n"
#endif
#ifdef ALLEGRO_UNIX
"You might want to try running this from X.\n"
#endif
);
    exit(127);
  }
  set_window_title(SHORT_PLATFORM_STR"Arena by Damian Yerrick");
  rectfill(screen, 0, 0, SCREEN_W - 1, SCREEN_H - 1, 0);

  bmp = create_bitmap(160, 16);
  if(bmp)
  {
    clear_to_color(bmp, 16);
    textout(bmp, font, SHORT_PLATFORM_STR"Arena", 0, 0, 15);
    textout(bmp, font, DA_VERSION, 0, 8, 15);
    stretch_blit(bmp, screen,
                 0,   0, 160, 16,
                 0, 160, 320, 32);
    destroy_bitmap(bmp);
  }

  EnvInfo();
  srand(time(NULL));

  termputs("Loading...");

/*
  get_executable_name(skinFolder, 255);
*/
  get_executable_name(progFolder, 255);

  dosarena_dat = load_skinned_datafile("dosarena.dat");

  if(dosarena_dat == NULL)
  {
    termputs("could not load dosarena.dat;");
    termputs("please reinstall "SHORT_PLATFORM_STR"Arena.");
    return 126;
  }

  // If possible, change Allegro's 8x8 font to Chicago 8 for added consistency
  old8x8 = font;
  font = GetResource(dosarena_dat, "chicago8_fnt");
  if(font == NULL)
    font = old8x8;

  chicago = GetResource(dosarena_dat, "chicago_fnt");
  small = GetResource(dosarena_dat, "tunnfont_pcx");
  pal = GetResource(dosarena_dat, "pcpal");
  icons = GetResource(dosarena_dat, "icons");
  logo = GetResource(dosarena_dat, SHORT_PLATFORM_STR);
  if(logo == NULL)
    logo = GetResource(dosarena_dat, "logo_pcx");


  if(chicago == NULL || small == NULL || pal == NULL || icons == NULL ||
     logo == NULL)
  {
    termputs("dosarena.dat is missing something;");
    termputs("please reinstall "SHORT_PLATFORM_STR"Arena.");
    return 126;
  }                  

  impact = GetResource(dosarena_dat, "impact_pcx");
  if(impact == NULL)
    impact = chicago;

  // look for a sound configuration file
#ifdef ALLEGRO_DOS
  if(file_exists("allegro.cfg", 0, NULL) == 0)
  {
    textout(screen, small, "Allegro's DOS sound card detection may be unstable. If "SHORT_PLATFORM_STR"Arena", 0, ScrollTerminal(), 12);
    textout(screen, small, "crashes during sound card detection, get Allegro Setup from", 0, ScrollTerminal(), 12);
    textout(screen, small, "http://come.to/yerrick", 0, ScrollTerminal(), 9);
  }
#endif

  termputs("Looking for a joystick");
  if(install_joystick(JOY_TYPE_AUTODETECT))
  {
    joyPresent = 0;
    termputs("None found");
  }
  else
  {
    joyPresent = num_joysticks;
    textprintf(screen, font, 0, ScrollTerminal(), 7,
      "%d joysticks found", num_joysticks);
  }

  termputs("Starting mouse driver");
  mouseButtons = install_mouse();

  if(mouseButtons < 1)
  {
    textout(screen, font, SHORT_PLATFORM_STR"Arena needs a mouse.  Plug it in and", 0, ScrollTerminal(), 12);
    textout(screen, font, "run MOUSE.EXE before starting "SHORT_PLATFORM_STR"Arena", 0, ScrollTerminal(), 12);
    return 126;
  }

  termputs("and sound drivers");
  install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  ResetPitchBends();
  music_dat = load_skinned_datafile("music.dat");

  termputs("Loading high scores");
  ReadScores();

  ReadKeys();
  if(oneGame < 0)
  {
    /* I don't use "Press ANY key to continue" because the standard AT
     * keyboard has no key marked ANY.  It does, however, have an A.
     */
    termputs("[ PRESS A KEY ]");
    readkey();
  }

  clear(screen);
  return 0;
}

#include "gamelist.h"
static char *GetGameList(int index, int *list_size)
{
  if(index < 0)
  {
    index = 0;
    while(gameNames[index].name[0])
      index++;
    *list_size = index;
    return NULL;
  }
  else
    return gameNames[index].name;
}


int da_menu(void)
{
  int nGames = 0, gamePick = 0;
  MIDI *dostheme;

  DIALOG dlg[] =
  {
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
   { d_clear_proc,      0,    0,    0,    0,    16,   15,   0,    0,       0,    0,    NULL },
   { d_button_proc,     240,  96,   48,   12,   16,   15,   13,   D_EXIT,  0,    0,    "Go"},
   { d_button_proc,     240,  112,  48,   12,   16,   15,   27,   D_EXIT,  0,    0,    "Exit"},
   { d_list_proc,       32,   32,   192,  126,  14,   1,    0,    D_EXIT,  0,    0,    GetGameList },
   { DY_bitmap_proc,    8,    2,    96,   20,   0,    0,    0,    0,       0,    0,    NULL },
   { d_text_proc,       112,  4,    128,  16,   16,   15,   0,    0,       0,    0,    "Pick a game"},
   { d_text_proc,       64,   176,  128,  16,   16,   15,   0,    0,       0,    0,    "Use arrows to move, then press Enter to play or Esc to quit."},
   { DY_idle_proc,      0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL },
   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
  };

  dostheme = GetResource(music_dat, "dostheme_mid");

  // count games
  while(gameNames[nGames].name[0])
    nGames++;

  dlg[4].dp = logo;
  dlg[5].dp2 = chicago;
  dlg[6].dp2 = small;

  while(gamePick < nGames)
  {
    if(midiPresent && dostheme != NULL)
      play_midi(dostheme, TRUE);

    clear(screen);
    set_palette(pal);

    // pick a game
    if(oneGame >= 0 && oneGame < nGames)
    {
      gameNames[oneGame].code();
      gamePick = nGames;
    }
    else
    {
      gamePick = do_dialog(dlg, 3);

      if(gamePick == 1 || gamePick == 3)
        gamePick = dlg[3].d1;
      else
        gamePick = nGames;
      text_mode(16);

      // play the game
      if(oneGame >= 0 && oneGame < nGames)
        gamePick = oneGame;
      gameNames[gamePick].code();
    }
  }
  return 0;
}


int main(int argc, char **argv)
{
  int inited = init_everything(argc, argv);
  if(inited != 0)
  {
    termputs("[ PRESS A KEY ]");
    readkey();
    return inited;
  }

  CoprScreen();
  da_menu();

  return 0;
}
END_OF_MAIN();

