#include <allegro.h>
#include <stdio.h>
#include <string.h> // memmove
#include <math.h>

#include "main.h"
#include "log.h"
#include "run.h"
#include "menu.h"
#include "pal.h"
#include "edit.h"
#include "game.h"
#include "load.h"
#include "map.h"

SETUPDATA setupdata;

enum {M_NULL,M_EXIT,M_START,M_OPTIONS,M_NAME,M_EDIT,
	M_CONT,M_USER,M_HIGH,M_TEXT,M_BACK,M_MUSIC,
	M_KEYS,M_KEYLEFT,M_KEYUP,M_KEYRIGHT,M_KEYDOWN,M_KEYUSE,
	M_DONE};

static struct menu {
	int id;
	char *str;
} *menu;

struct menu menu_main[]={
		{M_START,"New Game"},
		{M_CONT,"Continue Game"},
		{M_USER,"User Levels"},
		{M_HIGH,"Highscores"},
		{M_NAME,setupdata.name},
		{M_EDIT,"Map Editor"},
		{M_OPTIONS,"Options"},
		{M_EXIT,"Exit"},{M_NULL, NULL}
};

struct menu menu_highscores[]={
		{M_TEXT,setupdata.highscores[0]},
		{M_TEXT,setupdata.highscores[1]},
		{M_TEXT,setupdata.highscores[2]},
		{M_TEXT,setupdata.highscores[3]},
		{M_TEXT,setupdata.highscores[4]},
		{M_TEXT,setupdata.highscores[5]},
		{M_TEXT,setupdata.highscores[6]},
		{M_TEXT,setupdata.highscores[7]},
		{M_TEXT,setupdata.highscores[8]},
		{M_TEXT,setupdata.highscores[9]},
		{M_BACK,"Back"},
		{M_NULL, NULL}
};

static char musicvolstr[100];

struct menu menu_options[]={
	{M_KEYS,"Keyboard Controls"},
	{M_MUSIC,musicvolstr},
	{M_BACK,"Back"},
	{M_NULL, NULL}
};

struct menu menu_keys[]={
	{M_KEYLEFT,"Left-up"},
	{M_KEYRIGHT,"Right-down"},
	{M_KEYUP,"Up-right"},
	{M_KEYDOWN,"Down-left"},
	{M_KEYUSE,"Light bomb"},
	{M_DONE,"Done"},
	{M_NULL, NULL}
};

static void menuitemsize(int m,int *sx,int *sy,int *sw,int *sh) {
	int y=0,w,h,mh=0,n;
	h=text_height(truefont);
	for(n=0;menu[n].id!=M_NULL;n++) {
		mh+=h;
		if(n<m) y+=h;
	}
	w=text_length(truefont,menu[m].str);
	if(sx) *sx=SCREEN_W/2-w/2;
	if(sy) *sy=SCREEN_H/2-mh/2+y;
	if(sw) *sw=w;
	if(sh) *sh=h;
}

static int menunum() {
	int n;
	for(n=0;menu[n].id!=M_NULL;n++);
	return n;
}

static int editing,editpos;
static int oldmx,oldmy,oldmb,mx,my,mb;
static int highlight;
static int record,recordpos;

static void menuedit_delete() {
 if(editpos<(int)strlen(menu[editing].str)) {
  memmove(
	menu[editing].str+editpos,
	menu[editing].str+editpos+1,
  strlen(menu[editing].str)-editpos);
 }
}

static void menuedit_insert(int ch) {
 if(strlen(menu[editing].str)>30) return;
 memmove(
  menu[editing].str+editpos+1,
  menu[editing].str+editpos,
 strlen(menu[editing].str)-editpos+1);
 menu[editing].str[editpos]=ch;
}

static void menuedit_goleft() {
 if(editpos>0) editpos--;
}

static void menuedit_goright() {
 if(editpos<(int)strlen(menu[editing].str)) editpos++;
}

void menu_savesetup() {
	FILE *file;
	file=fopen("init.dat","wb");
	if(file) {
		fwrite(&setupdata,sizeof setupdata,1,file);
		fclose(file);
	}
}

void menu_init() {
	mode=MODE_MENU;
	logmsg("Entering Menu Mode.\n");
	highlight=0;
	editing=-1;
	record=0;
	menu=menu_main;

	{
		FILE *file;
		file=fopen("init.dat","rb");
		if(file) {
			fread(&setupdata,sizeof setupdata,1,file);
			fclose(file);
		} else {
			int h;
			memset(&setupdata,0,sizeof setupdata);
			for(h=0;h<10;h++) {
				setupdata.highscorevals[h]=100-h*10;
				sprintf(setupdata.highscores[h],"%d. Donkey %d",h+1,
					setupdata.highscorevals[h]);
			}
			sprintf(setupdata.name,"unknown");
			setupdata.gamekeynums[GAMEKEY_LEFT]=KEY_LEFT;
			setupdata.gamekeynums[GAMEKEY_RIGHT]=KEY_RIGHT;
			setupdata.gamekeynums[GAMEKEY_UP]=KEY_UP;
			setupdata.gamekeynums[GAMEKEY_DOWN]=KEY_DOWN;
			setupdata.gamekeynums[GAMEKEY_USE]=KEY_RCONTROL;
			setupdata.musicvol=160;
			setupdata.lastcompleted=1;
		}
	}

	loadgfx();

	set_volume(255,setupdata.musicvol);

	oldmb=mouse_b;
	oldmx=mouse_x;
	oldmy=mouse_y;
}


void menu_process() {
	int x,y,w,h;
	int n;
	int hit=0;

	mx=mouse_x;
	my=mouse_y;
	mb=mouse_b;

	if(record) {
		int got=0;
		if(key[KEY_LCONTROL]) got=KEY_LCONTROL;
		if(key[KEY_RCONTROL]) got=KEY_RCONTROL;
		if(key[KEY_LSHIFT]) got=KEY_LSHIFT;
		if(key[KEY_RSHIFT]) got=KEY_RSHIFT;
		if(key[KEY_ALT]) got=KEY_ALT;
		if(key[KEY_MENU]) got=KEY_MENU;
		if(got) {
			record=0;
			setupdata.gamekeynums[recordpos]=got;
			pal_restore();
		}
	}

	while(keypressed()) {
		int k,ch;
		k=readkey();
		ch=k&255;
		k>>=8;

		if(k==KEY_ESC) {
			if(record) pal_restore();
			highlight=menunum()-1;
			hit=1;
		}

		if(record) {
			record=0;
			setupdata.gamekeynums[recordpos]=k;
			pal_restore();
			continue;
		}

		if(k==KEY_ENTER) {
			editing=-1;
			hit=1;
		}
		if(k==KEY_UP) {
			int num=menunum();
			int n;
			editing=-1;
			if(highlight==-1) highlight=menunum();
			for(n=0;n<num;n++) {
				highlight--;
				if(highlight<0) highlight+=num;
				if(menu[highlight].id!=-1) break;
			}
			if(n==num) highlight=-1;
		}
		if(k==KEY_DOWN) {
			int num=menunum();
			int n;
			editing=-1;
			for(n=0;n<num;n++) {
				highlight++;
				if(highlight>num-1) highlight-=num;
				if(menu[highlight].id!=-1) break;
			}
			if(n==num) highlight=-1;
		}

		if(highlight!=-1) {
			if(menu[highlight].id==M_MUSIC) {
				if(k==KEY_LEFT) setupdata.musicvol-=8;
				if(k==KEY_RIGHT) setupdata.musicvol+=8;
				if(setupdata.musicvol<0) setupdata.musicvol=0;
				if(setupdata.musicvol>255) setupdata.musicvol=255;
				set_volume(255,setupdata.musicvol);
			}
		}

		if(editing!=-1) {
			if(k==KEY_LEFT) {
				menuedit_goleft();
			}
			if(k==KEY_RIGHT) {
				menuedit_goright();
			}
			if(k==KEY_BACKSPACE) {
				if(editpos>0) {
					menuedit_goleft();
					menuedit_delete();
				}
			}
			if(k==KEY_DEL) {
				menuedit_delete();
			}
			if(k==KEY_END) {
				editpos=strlen(menu[editing].str);
			}
			if(k==KEY_HOME) {
				editpos=0;
			}
			if(ch>=' ') {
				menuedit_insert(ch);
				menuedit_goright();
			}
		}
	}
	if(mx!=oldmx || my!=oldmy || oldmb) {
		highlight=-1;
		for(n=0;menu[n].id!=M_NULL;n++) {
			menuitemsize(n,&x,&y,&w,&h);
			if(mx>=x&&mx<=x+w-1&&my>=y&&my<=y+h-1) {
				highlight=n;
				if(menu[n].id==-1) highlight=-1;
				break;
			}
		}
	}
	if((oldmb&1) && !(mb&1)) hit=1;
	if( highlight!=-1 && hit ) {
		int sel=highlight;
		highlight=-1;
		switch(menu[sel].id) {
			case M_EXIT: done(); return;
			case M_START:
				menu_end();
				game_init(1);
				game_process();
			break;
			case M_CONT:
				menu_end();
				game_init(setupdata.lastcompleted);
				game_process();
			break;
			case M_USER:
				menu_end();
				game_init(USER);
				game_process();
			break;
			case M_EDIT:
				menu_end();
				edit_init(0);
				edit_process();
			break;
			case M_NAME:
				editing=sel;
				editpos=0;
			break;
			case M_HIGH:
				menu=menu_highscores;
				editing=-1;
				highlight=10;
			break;
			case M_OPTIONS:
				menu=menu_options;
				editing=-1;
				highlight=0;
			break;
			case M_KEYS:
				menu=menu_keys;
				editing=-1;
				highlight=0;
			break;
			case M_MUSIC:

			break;

			case M_BACK:
				menu=menu_main;
				editing=-1;
				highlight=0;
			break;
			case M_DONE:
				menu=menu_options;
				editing=-1;
				highlight=0;
			break;
			case M_KEYLEFT:
				record=1;
				recordpos=GAMEKEY_LEFT;
				pal_dark();
			break;
			case M_KEYRIGHT:
				record=1;
				recordpos=GAMEKEY_RIGHT;
				pal_dark();
			break;
			case M_KEYUP:
				record=1;
				recordpos=GAMEKEY_UP;
				pal_dark();
			break;
			case M_KEYDOWN:
				record=1;
				recordpos=GAMEKEY_DOWN;
				pal_dark();
			break;
			case M_KEYUSE:
				record=1;
				recordpos=GAMEKEY_USE;
				pal_dark();
			break;

		}
	}
	oldmb=mb;
	oldmx=mx;
	oldmy=my;
}

void menu_grafix() {
	int x,y,w,h,m;

	clear_to_color(page,RGB555(0,0,0));

	for(m=0;menu[m].id!=M_NULL;m++) {
		FONT *f=truefont;
		char *str=menu[m].str;

		if(menu[m].id==M_MUSIC) {
			int bars=(setupdata.musicvol*15)/255;
			char barstr[20]="|||||||||||||||";
			barstr[bars+1]=0;
			sprintf(str,"Music Volume %s",barstr);
		}

		menuitemsize(m,&x,&y,&w,&h);
		if(highlight==m) {
			f=highfont;
		}

		text_mode(-1);
		if(editing==m) {
			char sstr[256];
			memcpy(sstr,str,editpos);
			sstr[editpos]='|';
			sstr[editpos+1]=str[editpos];
			if(editpos<(int)strlen(sstr)) strcpy(sstr+editpos+2,str+editpos+1);
			textprintf_centre(page,f,x+w/2,y,-1,sstr);
		} else {
			textprintf_centre(page,f,x+w/2,y,-1,str);
		}

	}
	ob_draw(bomb[0],page,mx,my-15);
}

void menu_end() {
	logmsg("Leaving Menu Mode.\n");
	menu_savesetup();
}
