#include <allegro.h>
#include <stdio.h>
#include <math.h>

#include "main.h"
#include "log.h"
#include "edit.h"
#include "game.h"
#include "menu.h"
#include "run.h"
#include "pal.h"
#include "tile.h"
#include "map.h"

#include "load.h"

static int oldmx,oldmy,oldmb,mx,my,mb;
static char selected;
static int levnum;
static char message[256];
static int messagetime=0;

void edit_init(int lev) {
	logmsg("Entering Editor Mode.\n");
	mode=MODE_EDIT;

	loadgfx();

	map_init();

	selected=0;
	levnum=lev;
	{  char str[256];
		sprintf(str,"maps\\lev%d.bmp",levnum);
		map=load_bitmap(str,NULL);
	}
	if(map==NULL) {
		map_create(64,64);
		rectfill(map,30,30,34,34,TILE_GRASS);
		putpixel(map,32,32,TILE_STARTG);
	}
	mapx=-SCREEN_W/2;
	mapy=map->h/2*TILEH*2-SCREEN_W/4;
}

void edit_process() {
	int k;
	int xm,ym;

	get_mouse_mickeys(&xm,&ym);

	oldmb=mb;
	oldmx=mx;
	oldmy=my;
	mx=mouse_x;
	my=mouse_y;
	mb=mouse_b;

	while(keypressed()) {
		k=readkey();
		k>>=8;
		if(k==KEY_ESC) {
			edit_end();
			menu_init();
			return;
		}
		if(k==KEY_F1) {
			edit_end();
			game_init(-levnum);
			return;
		}
		if(k==KEY_F2) {
			char str[256];
			sprintf(str,"maps\\lev%d.bmp",levnum);
			save_bitmap(str,map,NULL);
			messagetime=ticks+FPS*1;
			sprintf(message,"Map %d has been saved.",levnum);
		}
		if(k==KEY_F3||k==KEY_F4) {
			char str[256];
			BITMAP *load;
			if(k==KEY_F4) sprintf(str,"maps\\lev0.bmp");
			else sprintf(str,"maps\\lev%d.bmp",levnum);

			load=load_bitmap(str,NULL);
			if(load) {
				destroy_bitmap(map);
				map=load;
				messagetime=ticks+FPS/2;
				sprintf(message,"Map %d has been loaded.",levnum);
				mapx=-SCREEN_W/2;
				mapy=map->h/2*TILEH*2-SCREEN_W/4;
			} else {
				messagetime=ticks+FPS/2;
				sprintf(message,"Could not load map %d.",levnum);
			}
		}
		if(k==KEY_F5||k==KEY_F6||k==KEY_F7) {
			int w=32,h=32;
			destroy_bitmap(map);
			if(k==KEY_F6) {w=h=64;}
			if(k==KEY_F7) {w=h=128;}
			map_create(w,h);
			rectfill(map,map->w/2-2,map->h/2-2,map->w/2+2,map->h/2+2,TILE_GRASS);
			putpixel(map,map->w/2,map->h/2,TILE_STARTG);
			mapx=-SCREEN_W/2;
			mapy=map->h/2*TILEH*2-SCREEN_W/4;
		}
		if(k==KEY_PLUS_PAD) {
			if(levnum==0) levnum=USER;
			else if(levnum<LEVMAX) levnum++;
			sprintf(message,"- Editing as level %d -",levnum);
			messagetime=ticks+FPS*1;
		}
		if(k==KEY_MINUS_PAD) {
			if(levnum>USER) levnum--; else levnum=USER;
			sprintf(message,"- Editing as level %d -",levnum);
			messagetime=ticks+FPS*1;
		}
		if(k==KEY_PGUP) {
			if(selected<tile_num-1) selected++;
		}
		if(k==KEY_PGDN) {
			if(selected>0) selected--;
		}
	}

	if(mb&2) {
		position_mouse(mx=oldmx,my=oldmy);
		mapx+=xm;
		mapy+=ym;
	}
	if(mb&1) {
		if(my<SCREEN_W/2) {
			int x,y;
			x=map_gettilex(mapx+mx,mapy+my);
			y=map_gettiley(mapx+mx,mapy+my);
			map_puttile(x,y,selected);
		} else {
			int x,y,w;
			w=SCREEN_W/(TILEW*2),
			x=mx/(TILEW*2),
			y=(my-SCREEN_W/2)/(TILEH*2);
			selected=y*w+x;
			if(selected<0) selected=0;
			if(selected>=tile_num) selected=tile_num-1;
		}
	}

}

void edit_grafix() {

	set_clip(page,0,0,SCREEN_W-1,SCREEN_W/2-1);
	rectfill(page,0,0,SCREEN_W-1,SCREEN_W/2-1,RGB555(0,0,0));
	map_draw(0,0,SCREEN_W-1,SCREEN_W/2-1);
	set_clip(page,0,0,SCREEN_W-1,SCREEN_H-1);

	rectfill(page,0,SCREEN_W/2,SCREEN_W-1,SCREEN_H-1,RGB555(2,1,0));

	text_mode(-1);
	textprintf_centre(page,highfont,SCREEN_W/2,SCREEN_W/2-text_height(highfont),
		RGB555(4,2,2),"Level=%d Tile=%d",levnum,selected);

	{  int n;
		int w=SCREEN_W/(TILEW*2);
		for(n=0;n<tile_num;n++) {
			tile_draw((n%w)*TILEW*2,
				SCREEN_W/2+(n/w)*TILEH*2,(char)n);
		}
	}

	{  int i;
		for(i=-2;i<=2;i++) {
			line(page,mx,my,mx+20+i*2,my+20-i*2,RGB555(0,4-abs(i),0));
		}
	}
	if(my<SCREEN_W/2) {
		int x,y;
		int xt,yt;
		x=map_gettilex(mapx+mx,mapy+my);
		y=map_gettiley(mapx+mx,mapy+my);
		xt=map_getpixelx(x,y);
		yt=map_getpixely(x,y);
		text_mode(-1);
		textprintf(page,font,0,SCREEN_H-text_height(font),
			(x>=0&&y>=0&&x<map->w&&y<map->h)?RGB555(2,4,2):RGB555(4,2,2),
			"Pos: %d %d",x,y);
	}

	if(messagetime>ticks) {
		text_mode(RGB555(2,0,0));
		textprintf_centre(page,font,SCREEN_W/2,SCREEN_H/2,RGB555(4,2,2),message);
	}

	text_mode(-1);

	textprintf(page,font,0,SCREEN_H-text_height(font)*4,RGB555(3,3,3),
		"[change level: + -] [change tile: page up down]");
	textprintf(page,font,0,SCREEN_H-text_height(font)*3,RGB555(3,3,3),
		"[playtest: F1] [save: F2] [load: F3] [load temp: F4]");
	textprintf(page,font,0,SCREEN_H-text_height(font)*2,RGB555(3,3,3),
		"[F5,F6,F7: create small, big, giant new map]");
	textprintf_right(page,font,SCREEN_W-1,SCREEN_H-text_height(font),
		RGB555(2,2,2),"fps=%d",fps);
}

void edit_end() {
	logmsg("Leaving Editor Mode.\n");
	save_bitmap("maps\\lev0.bmp",map,NULL);
	map_del();
}
