#include <stdlib.h>
#include <allegro.h>

#include "main.h"
#include "pal.h"
#include "tile.h"
#include "ob.h"
#include "load.h"

#include "log.h"

int tile_num;
BITMAP **tile;

static void blur(BITMAP *b,int col) {
	BITMAP *tmp;
	int tab[3][3]={
		{3, 14,  3},
		{14, 32, 14},
		{3, 14,  3}
	};
	int x,y,u,v;
	int light;
	tmp=create_bitmap(b->w,b->h);
	for(y=0;y<b->h;y++) {
		for(x=0;x<b->w;x++) {
			light=0;
			for(v=-1;v<=1;v++) {
				for(u=-1;u<=1;u++) {
					int xpos,ypos,c,w;
					xpos=(x+u);
					ypos=(y+v);
					w=tab[1+v][1+u];
					if(xpos<0) xpos+=b->w;
					if(xpos>=b->w) xpos-=b->w;
					if(ypos<0) ypos+=b->h;
					if(ypos>=b->h) ypos-=b->h;
					c=getpixel(b,xpos,ypos);
					c-=COL555(col,0);
					light+=c*w;
				}
			}
			putpixel(tmp,x,y,COL555(col,light/100));
		}
	}
	blit(tmp,b,0,0,0,0,b->w,b->h);
	destroy_bitmap(tmp);
}


static void noise(BITMAP *b,int col) {
	int x,y;
	for(y=0;y<b->h;y++) {
		for(x=0;x<b->w;x++) {
			putpixel(b,x,y,COL555(col,rand()%16));
		}
	}
}

static void darken(BITMAP *b,int col,int p) {
	int x,y;
	for(y=0;y<b->h;y++) {
		for(x=0;x<b->w;x++) {
			int c=getpixel(b,x,y)-COL555(col,0);
			putpixel(b,x,y,COL555(col,(c*p)/100));
		}
	}
}

static char tile_create(int col,int bl) {
	BITMAP *bmp;

	tile=realloc(tile,(tile_num+1)*sizeof(*tile));
	bmp=create_bitmap(TILEW*2,TILEH*2+32+8);
	clear_to_color(bmp,0);

	{  V3D_f **vtx;
		int n;
		BITMAP *tex;

		tex=create_bitmap(TILEW*2,TILEW*2);
		{
			int b;
			noise(tex,col);
			for(b=0;b<bl;b++) {
				blur(tex,col);
			}

		}


		vtx=alloca(sizeof *vtx);
		for(n=0;n<8;n++) {
			vtx[n]=alloca(sizeof **vtx);
			vtx[n]->c=0;
		}
		vtx[0]->x=0;
		vtx[0]->y=TILEH+32;
		vtx[0]->u=0;
		vtx[0]->v=0;
		vtx[1]->x=TILEW;
		vtx[1]->y=32;
		vtx[1]->u=TILEW*2;
		vtx[1]->v=0;
		vtx[2]->x=TILEW*2;
		vtx[2]->y=TILEH+32;
		vtx[2]->u=TILEW*2;
		vtx[2]->v=TILEW*2;
		vtx[3]->x=TILEW;
		vtx[3]->y=TILEH*2+32;
		vtx[3]->u=0;
		vtx[3]->v=TILEW*2;
		polygon3d_f(bmp,POLYTYPE_ATEX,tex,4,vtx);

		for(n=0;n<4;n++) {
			*vtx[4+n]=*vtx[n];
			vtx[4+n]->y+=8;
		}
		vtx[4]->u-=8;
		vtx[7]->u-=8;
		darken(tex,col,50);
		{  V3D_f *vtxl[]={vtx[0],vtx[3],vtx[7],vtx[4]};
			polygon3d_f(bmp,POLYTYPE_ATEX,tex,4,vtxl);
		}
		vtx[6]->v+=8;
		vtx[7]->u+=8;
		vtx[7]->v+=8;
		{  V3D_f *vtxr[]={vtx[3],vtx[2],vtx[6],vtx[7]};
			polygon3d_f(bmp,POLYTYPE_ATEX,tex,4,vtxr);
		}

		destroy_bitmap(tex);
	}

	tile[tile_num]=bmp;
	return tile_num++;
}

void tiles_init() {
	int t;

	logmsg("Creating tiles.\n");

	tile_create(0,1);
	tile_create(1,2);

	t=tile_create(1,2);
	ob_draw(bomb[0],tile[t],
		tile[t]->w/2-bomb[0]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[0]->an->bmp[0]->h/2+8);

	t=tile_create(1,2);
	ob_draw(bomb[1],tile[t],
		tile[t]->w/2-bomb[1]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[1]->an->bmp[0]->h/2+5);

	t=tile_create(1,2);
	ob_draw(bomb[2],tile[t],
		tile[t]->w/2-bomb[2]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[2]->an->bmp[0]->h/2);

	tile_create(6,5);
	tile_create(0,7);
	tile_create(5,1);
	t=tile_create(1,2);
	circle(tile[t],TILEW,32+TILEH,7,RGB555(4,0,0));

	t=tile_create(5,1);
	ob_draw(bomb[0],tile[t],
		tile[t]->w/2-bomb[0]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[0]->an->bmp[0]->h/2+8);

	t=tile_create(5,1);
	ob_draw(bomb[1],tile[t],
		tile[t]->w/2-bomb[1]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[1]->an->bmp[0]->h/2+5);

	t=tile_create(5,1);
	ob_draw(bomb[2],tile[t],
		tile[t]->w/2-bomb[2]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[2]->an->bmp[0]->h/2);

	t=tile_create(0,7);
	ob_draw(bomb[0],tile[t],
		tile[t]->w/2-bomb[0]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[0]->an->bmp[0]->h/2+8);

	t=tile_create(0,7);
	ob_draw(bomb[1],tile[t],
		tile[t]->w/2-bomb[1]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[1]->an->bmp[0]->h/2+5);

	t=tile_create(0,7);
	ob_draw(bomb[2],tile[t],
		tile[t]->w/2-bomb[2]->an->bmp[0]->w/2-2,
		tile[t]->h/2-bomb[2]->an->bmp[0]->h/2);

	t=tile_create(5,1);
	circle(tile[t],TILEW,32+TILEH,7,RGB555(4,0,0));
	t=tile_create(0,7);
	circle(tile[t],TILEW,32+TILEH,7,RGB555(4,0,0));
}

void tiles_del() {
	int n;
	for(n=0;n<tile_num;n++) {
		destroy_bitmap(tile[n]);
	}
	free(tile);
	tile_num=0;
	tile=NULL;
}

void tile_draw(int x,int y,char t) {
	if(t) draw_sprite(page,tile[(unsigned int)t],x,y-32);
}
