#include <allegro.h>

#include "run.h"
#include "game.h"
#include "menu.h"
#include "edit.h"
#include "log.h"

EXEC_MODE mode;

void init() {
	menu_init();
}

void process() {
	switch(mode) {
		case MODE_MENU: menu_process(); break;
		case MODE_GAME: game_process(); break;
		case MODE_EDIT: edit_process(); break;
		default: break;
	}
}

void grafix() {
	switch(mode) {
		case MODE_MENU: menu_grafix(); break;
		case MODE_GAME: game_grafix(); break;
		case MODE_EDIT: edit_grafix(); break;
		default: break;
	}
}

void done() {
	switch(mode) {
		case MODE_MENU: menu_end(); break;
		case MODE_GAME: game_end(); break;
		case MODE_EDIT: edit_end(); break;
		default: break;
	}
	logmsg("Initiating shutdown procedure.\n");
	exit(0);
}
