#include <allegro.h>

#include "pal.h"

static PALETTE pal={{0,0,0,0}};

void pal_create555() {
	int r,g,b,s;
	for(r=0;r<5;r++) {
		for(g=0;g<5;g++) {
			for(b=0;b<5;b++) {
				RGB rgb={(r*63)/4,(g*63)/4,(b*63)/4,0};
				pal[RGB555(r,g,b)]=rgb;
			}
		}
	}
	for(s=0;s<16;s++) {
		RGB rgb={(s*63)/15,(s*63)/15,(s*63)/15,0};
		pal[COL555(0,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={(s*60)/15,(s*55)/15,(s*50)/15,0};
		pal[COL555(1,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={0,0,(s*31)/15,0};
		pal[COL555(2,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={(s*40)/15,0,0,0};
		pal[COL555(3,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={(s*63)/15,(s*63)/15,0,0};
		pal[COL555(4,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={0,(s*63)/15,0,0};
		pal[COL555(5,s)]=rgb;
	}
	for(s=0;s<16;s++) {
		RGB rgb={(s*63)/15,32+(s*31)/15,32+(s*31)/15,0};
		pal[COL555(6,s)]=rgb;
	}
	set_palette(pal);
}

void pal_dark() {
	PALETTE dp;
	int n;
	for(n=COL555(0,0);n<256;n++) {
		RGB rgb=pal[n];
		rgb.r/=2;
		rgb.g/=2;
		rgb.b/=2;
		dp[n]=rgb;
	}
	set_palette_range(dp,COL555(0,0),255,1);
}

void pal_restore() {
	set_palette(pal);
}
