#include <allegro.h>
#include <math.h>

#include "main.h"
#include "ob.h"
#include "anim.h"

#include "log.h"
#include "progress.h"

OB *ob_new(int x,int y,ANIM *an) {
	OB *this;
	this=malloc(sizeof *this);
	this->x=x;
	this->y=y;
	this->z=0;
	this->dir=0;
	this->want=0;
	this->anim=0;
	this->an=an;
	this->t=0;

	return this;
}

void ob_del(OB *this) {
	free(this);
}

int ob_x(OB *this) {
	return (this->x)*2-(this->y)*2;
}
int ob_y(OB *this) {
	return (this->x)+(this->y)-(this->z);
}

void ob_draw(OB *this,BITMAP *bmp,int x,int y) {
	int d;
	int a;

	a=this->anim/64;
	if(a==3) a=1;

	d=(this->dir+OBDIRMUL/2)/OBDIRMUL;
	if(d>=OBDIR) d-=OBDIR;

	draw_sprite(bmp,this->an->bmp[a*OBDIR+d],
		ob_x(this)+x,ob_y(this)+y);
}
