#include <allegro.h>

#include "tile.h"

BITMAP *map;
int mapx,mapy;

int map_gettilex(int x,int y) {
	return ((x>>1)+y)>>TILEWB;
}
int map_gettiley(int x,int y) {
	return (y-(x>>1))>>TILEWB;
}
int map_getpixelx(int x,int y) {
	return (x-y)<<TILEWB;
}
int map_getpixely(int x,int y) {
	return (x+y)<<TILEHB;
}

char map_gettile(int x,int y) {
	if(x<0||y<0||x>=map->w||y>=map->h) return 0;
	return *((char *)map->line[y]+x);
}
void map_puttile(int x,int y,int t) {
	if(x<0||y<0||x>=map->w||y>=map->h) return;
	*((char *)map->line[y]+x)=t;
}

void map_init() {
	map=NULL;
	mapx=0;
	mapy=0;
}
void map_del() {
	destroy_bitmap(map);
	map=NULL;
}

void map_create(int w,int h) {
	int x,y;
	map=create_bitmap_ex(8,w,h);
	for(y=0;y<h;y++) {
		for(x=0;x<w;x++) {
			if(x==0||y==0||x==w-1||y==w-1) map_puttile(x,y,1);
			else map_puttile(x,y,0);
		}
	}
}

int map_scan(int *xp,int *yp,int *bombs) {
	int x,y,r=0;
	*bombs=0;
	for(y=0;y<map->h;y++) {
		for(x=0;x<map->w;x++) {
			char t;
			t=map_gettile(x,y);
			if(t==TILE_START) {
				map_puttile(x,y,TILE_STONE);
				*xp=x;
				*yp=y;
				r=1;
			}
			if(t==TILE_STARTG) {
				map_puttile(x,y,TILE_GRASS);
				*xp=x;
				*yp=y;
				r=1;
			}
			if(t==TILE_STARTM) {
				map_puttile(x,y,TILE_METAL);
				*xp=x;
				*yp=y;
				r=1;
			}
			if(t==TILE_BOMB1||t==TILE_BOMB2||t==TILE_BOMB3||
				t==TILE_BOMB1G||t==TILE_BOMB2G||t==TILE_BOMB3G||
				t==TILE_BOMB1M||t==TILE_BOMB2M||t==TILE_BOMB3M) {
				(*bombs)++;
			}
		}
	}
	return r;
}

void map_draw(int left,int top,int right,int bottom) {
	int xpix,ypix;
	int xline;
	int xmap,ymap;
	int xmapline,ymapline;
	xmap=map_gettilex(mapx,mapy);
	ymap=map_gettiley(mapx,mapy);
	xpix=map_getpixelx(xmap,ymap);
	ypix=map_getpixely(xmap,ymap);
	xpix-=mapx;
	ypix-=mapy;

	if(ypix>-TILEH) {
		ymap--;
		xpix+=TILEW;
		ypix-=TILEH;
	}

	xline=left+xpix-TILEW;
	ypix=top+ypix;
	xmapline=xmap;
	ymapline=ymap;
	while(ypix<=bottom+60) {
		xmap=xmapline;
		ymap=ymapline;
		xpix=xline;
		while(xpix<=right) {
			char t;
			t=map_gettile(xmap,ymap);
			tile_draw(xpix,ypix,t);
			xpix+=TILEW*2;
			xmap+=1;
			ymap-=1;
		}
		xline-=TILEW;
		ypix+=TILEH;
		ymapline+=1;
		if(xline<=left-TILEW*2) {
			xline+=TILEW*2;
			xmapline+=1;
			ymapline-=1;
		}
	}
}
