#include <allegro.h>
#include <time.h>   // time()
#include <stdlib.h> // rand()
#include <string.h> // strcmp()

#include "log.h"
#include "run.h"
#include "pal.h"
#include "main.h"

int frames;
int fps;
volatile int ticks;
void ticker(void){
	ticks++;
}
END_OF_FUNCTION(ticker);

BITMAP *page;
BITMAP *page1,*page2;

int main(int anr,char*arg[]){
	int gframes,gframetime;
	initlog();{
		time_t t;
		struct tm*tm;
		char ts[256];
		time(&t);
		tm=localtime(&t);
		strftime(ts,256,"%A, %B %d %Y, %I:%M:%S %p",tm);
		logmsg("Inserting new log entry.\n");
		logmsg("Local time is %s.\n",ts);
		logmsg("Random seed is %d.\n",t);
		srand(time(0));// create random numbers
		logmsg("First number is %d out of [0..%d].\n",rand(),RAND_MAX);
	}
	logmsg("Establishing uplink to main Allegro system.\n");
	allegro_init();
	logmsg("Setting color depth.\n");
	set_color_depth(8);// select color depth
	logmsg("Switching to graphics mode.\n");
	set_gfx_mode(GFX_AUTODETECT,640,480,0,0);// create grafix mode 640x480
	clear_to_color(screen,0);
	logmsg("Creating color palette.\n");
	pal_create555();
	logmsg("Initializing input devices.\n");
	install_keyboard();
	install_mouse();
	logmsg("Starting ticker.\n");
	LOCK_FUNCTION(ticker);
	LOCK_VARIABLE(ticks);
	install_timer();
	install_int_ex(ticker,BPS_TO_TIMER(FPS));// call ticker() FPS times per seconds
	logmsg("Setting up page flipping system.\n");
	if(anr>1&&strcmp(arg[1],"nopage")==0) {
		page1=page2=NULL;
	} else {
		page1=create_video_bitmap(SCREEN_W,SCREEN_H);
		page2=create_video_bitmap(SCREEN_W,SCREEN_H);
	}
	if(page1==NULL||page2==NULL) {
		logmsg("Can't use pageflipping.\n");
		logmsg("Creating double buffer instead.\n");
		page=create_bitmap(SCREEN_W,SCREEN_H);
	} else page=page2;
	logmsg("Checking communications interface.\n");
	install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL);
	logmsg("Initializing application.\n");
	init();
	logmsg("Launching application.\n");
	gframes=0;
	gframetime=0;
	frames=0;
	ticks=0;
	while(1){
		if(frames<=ticks){
			process();
			frames++;
		}
		else{
			grafix();
			if(page1&&page2) {
				show_video_bitmap(page);
				if(page==page1) page=page2; else page=page1;
			} else {
				blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
			}
			gframes++;
			if(ticks-gframetime>=FPS){
				fps=gframes;
				gframes=0;
				gframetime=ticks;
			}
		}
	}
	done();
	return 0;
}END_OF_MAIN();
