#include <allegro.h>

#include "main.h"
#include "ob.h"
#include "anim.h"
#include "tile.h"

#include "log.h"
#include "progress.h"

#include "load.h"

DATAFILE *dat=NULL;
FONT *truefont=NULL,*highfont=NULL;

MIDI *music;
SAMPLE *expl_wav;

BITMAP *gamebar=NULL;

ANIM *donkeyanim=NULL;
ANIM *bombanim[3]={NULL,NULL,NULL};
ANIM *particleanim=NULL;
ANIM *dustanim[2]={NULL,NULL};

OB *donkey=NULL;
OB *bomb[3]={NULL,NULL,NULL};
OB *particle[PARTICLENUM]={NULL};

void unloadgfx(void) {
	int n;
	logmsg("Unloading graphics.\n");
	ob_del(donkey);
	ob_del(bomb[0]);
	ob_del(bomb[1]);
	ob_del(bomb[2]);
	for(n=0;n<PARTICLENUM;n++)
		ob_del(particle[n]);

	anim_del(donkeyanim);
	anim_del(bombanim[0]);
	anim_del(bombanim[1]);
	anim_del(bombanim[2]);
	anim_del(particleanim);
	anim_del(dustanim[0]);
	anim_del(dustanim[1]);

	tiles_del();

	unload_datafile(dat);

}

void loadgfx() {
	static int once=0;
	if(once) return;
	once=1;
	logmsg("Generating graphics.\n");
	atexit(unloadgfx);

	dat=load_datafile("dat.dat");
	if(dat) {
		DATAFILE *sub;
		sub=find_datafile_object(dat,"truefont");
		truefont=(FONT *)(sub[0].dat);
		sub=find_datafile_object(dat,"highfont");
		highfont=(FONT *)(sub[0].dat);
		sub=find_datafile_object(dat,"xviila");
		music=(MIDI *)(sub[0].dat);
		play_midi(music,1);
		sub=find_datafile_object(dat,"expl");
		expl_wav=(SAMPLE *)(sub[0].dat);
		sub=find_datafile_object(dat,"gamebar");
		gamebar=(BITMAP *)(sub[0].dat);
	} else {
		truefont=font;
		highfont=font;
	}

	textprintf_centre(screen,highfont,SCREEN_W/2,SCREEN_W/4,-1,
		"Raytracing Graphics");
	textprintf_centre(screen,highfont,SCREEN_W/2,SCREEN_W/4+40,-1,
		"please be patient");

	textprintf_centre(screen,highfont,
		SCREEN_W/2,SCREEN_H-text_height(truefont)*2,-1,
		"Code by Elias Pschernig");

	textprintf_centre(screen,highfont,
		SCREEN_W/2,SCREEN_H-text_height(truefont),-1,
		"Music donated by X-Viila");

	progress_total=51;
	progress=0;
	progress_l=0;
	progress_t=0;
	progress_r=39;
	progress_b=SCREEN_H-1;
	progress_bar();

	if(donkeyanim==NULL)
	donkeyanim=anim_new(
		//bitmap size
		"140w 140h"
		"{"
		//body
		" 0 x 0 y 5 z 1c20rb"
		//tail
		"{0 x24-y 9-z 1c 4rb"
		" 0 x23-y 1-z 1c 4rb"
		" 0 x22-y 7 z 1c 4rb}"
		//feet
		"{15-x15-y15-z 1c 5rb"
		"15-x15-y 5-z 1c 6rb}"

		"{15 x15-y15-z 1c 5rb"
		"15 x15-y 5-z 1c 6rb}"

		"{15-x15 y15-z 1c 5rb"
		"15-x15 y 5-z 1c 6rb}"

		"{15 x15 y15-z 1c 5rb"
		"15 x15 y 5-z 1c 6rb}"
		//head
		" 0 x30 y  5z 1c15rb"
		//ears
		"{10-x30 y 40z 1c 6rb"
		" 9-x30 y 28z 1c 6rb"
		" 8-x30 y 16z 1c 6rb}"

		"{10 x30 y 40z 1c 6rb"
		" 9 x30 y 28z 1c 6rb"
		" 8 x30 y 16z 1c 6rb}"

		//nose
		" 0 x55 y  5z 1c11rb"
		" 5 x63 y  5z 3c 3rb"
		" 5-x63 y  5z 3c 3rb"
		//eyes
		" 8 x44 y 10z 0c 7rb"
		" 8-x44 y 10z 0c 7rb"
		" 9 x48 y 10z 2c 4rb"
		" 9-x48 y 10z 2c 4rb"
		"}"
		//camera angle
		"20-T"
		//animation: 48 frames
		"48["
			"0:16%16Z"
			"1:16/8 XO"
			"2:16/32 XO"
			"3:16/32 XO"
			"4:16/32-XO"
			"5:16/32-XO"
			"6:16/8 XO"
			"7:16/8 XO"
	"]"
	);

	if(bombanim[0]==NULL)
	bombanim[0]=anim_new(
		"32w64h"
		"3c12rb"
		"1x13z1c3rb"
		"2x18z1c3rb"
		"4x23z0c3rb"
	);
	if(bombanim[1]==NULL)
	bombanim[1]=anim_new(
		"64w128h"
		"3c18rb"
		"1x19z1c3rb"
		"2x24z1c3rb"
		"4x29z0c3rb"
	);
	if(bombanim[2]==NULL)
	bombanim[2]=anim_new(
		"64w128h"
		"3c22rb"
		"20x5-y10z1c3rb"
		"25x6-y11z1c3rb"
		"30x8-y13z0c3rb"
	);

	if(particleanim==NULL)
	particleanim=anim_new(
		"8w8h"
		"4cr4rb"
	);

	if(dustanim[0]==NULL)
	dustanim[0]=anim_new(
		"64w64h"
		"0x0y0z0c20rb"
	);
	if(dustanim[1]==NULL)
	dustanim[1]=anim_new(
		"64w64h"
		"0x0y0z1c25rb"
	);

	if(donkey==NULL)
	donkey=ob_new(0,0,donkeyanim);
	if(bomb[0]==NULL)
	bomb[0]=ob_new(0,0,bombanim[0]);
	if(bomb[1]==NULL)
	bomb[1]=ob_new(0,0,bombanim[1]);
	if(bomb[2]==NULL)
	bomb[2]=ob_new(0,0,bombanim[2]);
	if(particle[0]==NULL)
	{  int n;
		for(n=0;n<PARTICLENUM;n++) {
			particle[n]=ob_new(0,0,particleanim);
		}
	}

	tiles_init();
}
